/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstructorCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConstructorCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1734#2,3:62\n1734#2,3:65\n*S KotlinDebug\n*F\n+ 1 FirConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConstructorCallChecker\n*L\n38#1:62,3\n41#1:65,3\n*E\n"})
public final class FirConstructorCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirConstructorCallChecker INSTANCE = new FirConstructorCallChecker();

    private FirConstructorCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirConstructorSymbol firConstructorSymbol = FirReferenceUtilsKt.toResolvedConstructorSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol constructorSymbol = firConstructorSymbol;
        ConeKotlinType coneType = constructorSymbol.getResolvedReturnTypeRef().getConeType();
        if (Intrinsics.areEqual((Object)constructorSymbol.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) && ConeTypeUtilsKt.contains(coneType, (Function1<? super ConeKotlinType, Boolean>)((Function1)FirConstructorCallChecker::check$lambda$0))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCONSTRUCTOR_OR_SUPERTYPE_ON_TYPEALIAS_WITH_TYPE_PROJECTION(), (DiagnosticContext)context, null, 8, null);
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(coneType, context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationClass = firRegularClassSymbol;
        if (declarationClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block13: {
                $this$all$iv = context.getCallsOrAssignments();
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirStatement call2 = (FirStatement)element$iv;
                        boolean bl2 = false;
                        if (!(call2 instanceof FirAnnotation)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (bl) {
                boolean bl3;
                block14: {
                    $this$all$iv = context.getContainingDeclarations();
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            FirDeclaration klass = (FirDeclaration)element$iv;
                            boolean bl4 = false;
                            if (!(klass instanceof FirRegularClass) || ((FirRegularClass)klass).getClassKind() != ClassKind.ANNOTATION_CLASS) continue;
                            bl3 = false;
                            break block14;
                        }
                        bl3 = true;
                    }
                }
                if (bl3 && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InstantiationOfAnnotationClasses)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_CONSTRUCTOR_CALL(), (DiagnosticContext)context, null, 8, null);
                }
            }
        }
        if (declarationClass.getClassKind() == ClassKind.ENUM_CLASS) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getENUM_CLASS_CONSTRUCTOR_CALL(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private static final boolean check$lambda$0(ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ConeCapturedType;
    }
}

