/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityBatchUpdate;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityChangeType;
import org.jetbrains.exposed.dao.EntityClass;
import org.jetbrains.exposed.dao.EntityHookKt;
import org.jetbrains.exposed.dao.EntityLifecycleInterceptorKt;
import org.jetbrains.exposed.dao.ImmutableCachedEntityClass;
import org.jetbrains.exposed.dao.ImmutableEntityClass;
import org.jetbrains.exposed.dao.LinkedIdentityHashSet;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.LazySizedCollection;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 Z2\u00020\u0001:\u0002Z[B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010,\u001a\u00020 2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\tH\u0000\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020 2\b\b\u0002\u00100\u001a\u00020\rJ\u0006\u00101\u001a\u00020 JO\u00102\u001a\u0004\u0018\u0001H3\"\u000e\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H405\"\u000e\b\u0001\u00103*\b\u0012\u0004\u0012\u0002H40\t2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H3072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H40&\u00a2\u0006\u0002\u00109J@\u0010:\u001a\b\u0012\u0004\u0012\u0002H30;\"\u000e\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H405\"\u000e\b\u0001\u00103*\b\u0012\u0004\u0012\u0002H40\t2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H307J\u0019\u0010<\u001a\u00020 2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\tH\u0000\u00a2\u0006\u0002\b=J\u0006\u00100\u001a\u00020 J\u0018\u00100\u001a\u00020 2\u0010\u0010>\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070?J\u0019\u0010@\u001a\u00020 2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0000\u00a2\u0006\u0002\bBJ(\u0010C\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u000e\u00106\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000307H\u0002J$\u0010C\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002JR\u0010D\u001a\b\u0012\u0004\u0012\u0002HE0'\"\b\b\u0000\u00104*\u00020\u0001\"\u000e\b\u0001\u0010E*\b\u0012\u0004\u0012\u0002H40\t2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030&2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030%2\u0012\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HE0'0IJ4\u0010J\u001a\n\u0012\u0004\u0012\u0002HE\u0018\u00010'\"\f\b\u0000\u0010E*\u0006\u0012\u0002\b\u00030\t2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030&2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030%J\u0019\u0010K\u001a\u00020\r2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\tH\u0000\u00a2\u0006\u0002\bLJA\u0010M\u001a\u00020 \"\u000e\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H405\"\u000e\b\u0001\u00103*\b\u0012\u0004\u0012\u0002H40\t2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H40\u00072\u0006\u0010N\u001a\u0002H3\u00a2\u0006\u0002\u0010OJ#\u0010P\u001a\u00020 2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020Q0;2\u0006\u0010R\u001a\u00020\rH\u0000\u00a2\u0006\u0002\bSJG\u0010T\u001a\u00020 \"\u000e\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H405\"\u000e\b\u0001\u00103*\b\u0012\u0004\u0012\u0002H40\t2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H3072\u0006\u0010N\u001a\u0002H3\u00a2\u0006\u0002\u0010UJG\u0010V\u001a\u00020 \"\u000e\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H405\"\u000e\b\u0001\u00103*\b\u0012\u0004\u0012\u0002H40\t2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H3072\u0006\u0010N\u001a\u0002H3\u00a2\u0006\u0002\u0010UJ\u0012\u0010W\u001a\u00020 2\n\u0010N\u001a\u0006\u0012\u0002\b\u00030\tJG\u0010W\u001a\u00020 \"\u000e\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H405\"\u000e\b\u0001\u00103*\b\u0012\u0004\u0012\u0002H40\t2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H3072\u0006\u0010N\u001a\u0002H3\u00a2\u0006\u0002\u0010UJ\u0014\u0010X\u001a\u00020 2\n\u0010Y\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002R1\u0010\u0005\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0010\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00110\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR*\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR:\u0010\u001c\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020 0\u001f0\u001e0\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R`\u0010#\u001aN\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0\b0$j&\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0\b`(X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010+\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00110\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lorg/jetbrains/exposed/dao/EntityCache;", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(Lorg/jetbrains/exposed/sql/Transaction;)V", "data", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/exposed/dao/id/IdTable;", "", "Lorg/jetbrains/exposed/dao/Entity;", "getData", "()Ljava/util/LinkedHashMap;", "flushingEntities", "", "initializingEntities", "Lorg/jetbrains/exposed/dao/LinkedIdentityHashSet;", "inserts", "", "getInserts$exposed_dao", "value", "", "maxEntitiesToStore", "getMaxEntitiesToStore$annotations", "()V", "getMaxEntitiesToStore", "()I", "setMaxEntitiesToStore", "(I)V", "pendingInitializationLambdas", "Ljava/util/IdentityHashMap;", "", "Lkotlin/Function1;", "", "getPendingInitializationLambdas$exposed_dao", "()Ljava/util/IdentityHashMap;", "referrers", "Ljava/util/HashMap;", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/dao/id/EntityID;", "Lorg/jetbrains/exposed/sql/SizedIterable;", "Lkotlin/collections/HashMap;", "getReferrers$exposed_dao", "()Ljava/util/HashMap;", "updates", "addNotInitializedEntityToQueue", "entity", "addNotInitializedEntityToQueue$exposed_dao", "clear", "flush", "clearReferrersCache", "find", "T", "ID", "", "f", "Lorg/jetbrains/exposed/dao/EntityClass;", "id", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/dao/id/EntityID;)Lorg/jetbrains/exposed/dao/Entity;", "findAll", "", "finishEntityInitialization", "finishEntityInitialization$exposed_dao", "tables", "", "flushInserts", "table", "flushInserts$exposed_dao", "getMap", "getOrPutReferrers", "R", "sourceId", "key", "refs", "Lkotlin/Function0;", "getReferrers", "isEntityInInitializationState", "isEntityInInitializationState$exposed_dao", "remove", "o", "(Lorg/jetbrains/exposed/dao/id/IdTable;Lorg/jetbrains/exposed/dao/Entity;)V", "removeTablesReferrers", "Lorg/jetbrains/exposed/sql/Table;", "isInsert", "removeTablesReferrers$exposed_dao", "scheduleInsert", "(Lorg/jetbrains/exposed/dao/EntityClass;Lorg/jetbrains/exposed/dao/Entity;)V", "scheduleUpdate", "store", "updateEntities", "idTable", "Companion", "LimitedHashMap", "exposed-dao"})
public final class EntityCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Transaction transaction;
    private boolean flushingEntities;
    @NotNull
    private LinkedIdentityHashSet<Entity<?>> initializingEntities;
    @NotNull
    private final IdentityHashMap<Entity<?>, List<Function1<Entity<?>, Unit>>> pendingInitializationLambdas;
    @NotNull
    private final LinkedHashMap<IdTable<?>, Map<Object, Entity<?>>> data;
    @NotNull
    private final LinkedHashMap<IdTable<?>, Set<Entity<?>>> inserts;
    @NotNull
    private final LinkedHashMap<IdTable<?>, Set<Entity<?>>> updates;
    @NotNull
    private final HashMap<Column<?>, Map<EntityID<?>, SizedIterable<?>>> referrers;
    private int maxEntitiesToStore;

    public EntityCache(@NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.transaction = transaction;
        this.initializingEntities = new LinkedIdentityHashSet();
        this.pendingInitializationLambdas = new IdentityHashMap();
        this.data = new LinkedHashMap();
        this.inserts = new LinkedHashMap();
        this.updates = new LinkedHashMap();
        this.referrers = new HashMap();
        this.maxEntitiesToStore = this.transaction.getDb().getConfig().getMaxEntitiesToStoreInCachePerEntity();
    }

    @NotNull
    public final IdentityHashMap<Entity<?>, List<Function1<Entity<?>, Unit>>> getPendingInitializationLambdas$exposed_dao() {
        return this.pendingInitializationLambdas;
    }

    @NotNull
    public final LinkedHashMap<IdTable<?>, Map<Object, Entity<?>>> getData() {
        return this.data;
    }

    @NotNull
    public final LinkedHashMap<IdTable<?>, Set<Entity<?>>> getInserts$exposed_dao() {
        return this.inserts;
    }

    @NotNull
    public final HashMap<Column<?>, Map<EntityID<?>, SizedIterable<?>>> getReferrers$exposed_dao() {
        return this.referrers;
    }

    public final int getMaxEntitiesToStore() {
        return this.maxEntitiesToStore;
    }

    public final void setMaxEntitiesToStore(int value) {
        int diff = value - this.maxEntitiesToStore;
        this.maxEntitiesToStore = value;
        if (diff < 0) {
            Collection<Map<Object, Entity<?>>> collection = this.data.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"data.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map map = (Map)element$iv;
                boolean bl = false;
                int sizeExceed = map.size() - value;
                if (sizeExceed <= 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
                Iterator iterator2 = map.entrySet().iterator();
                int n = 0;
                while (n < sizeExceed) {
                    int n2;
                    int it = n2 = n++;
                    boolean bl2 = false;
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    public static /* synthetic */ void getMaxEntitiesToStore$annotations() {
    }

    private final Map<Object, Entity<?>> getMap(EntityClass<?, ?> f) {
        return this.getMap(f.getTable());
    }

    private final Map<Object, Entity<?>> getMap(IdTable<?> table) {
        Object object;
        Map $this$getOrPut$iv = this.data;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(table);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LimitedHashMap();
            $this$getOrPut$iv.put(table, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Map)object;
    }

    @Nullable
    public final <R extends Entity<?>> SizedIterable<R> getReferrers(@NotNull EntityID<?> sourceId, @NotNull Column<?> key) {
        Intrinsics.checkNotNullParameter(sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Map<EntityID<?>, SizedIterable<?>> map = this.referrers.get(key);
        SizedIterable<?> sizedIterable = map == null ? null : map.get(sourceId);
        return sizedIterable instanceof SizedIterable ? sizedIterable : null;
    }

    @NotNull
    public final <ID, R extends Entity<ID>> SizedIterable<R> getOrPutReferrers(@NotNull EntityID<?> sourceId, @NotNull Column<?> key, @NotNull Function0<? extends SizedIterable<? extends R>> refs) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Map $this$getOrPut$iv = this.referrers;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new HashMap();
            $this$getOrPut$iv.put(key, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(sourceId);
        if (value$iv == null) {
            boolean bl = false;
            SizedIterable answer$iv = (SizedIterable)new LazySizedCollection((SizedIterable)refs.invoke());
            $this$getOrPut$iv.put(sourceId, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SizedIterable)object;
    }

    @Nullable
    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> T find(@NotNull EntityClass<ID, ? extends T> f, @NotNull EntityID<ID> id) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Entity entity = this.getMap(f).get(id.getValue());
        if (entity == null) {
            Entity entity2;
            Entity entity3;
            Set<Entity<?>> set = this.inserts.get(f.getTable());
            if (set == null) {
                entity3 = null;
            } else {
                Object v3;
                block7: {
                    Iterable $this$firstOrNull$iv = set;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getId(), id)) continue;
                        v3 = element$iv;
                        break block7;
                    }
                    v3 = null;
                }
                entity3 = v3;
            }
            Entity entity4 = entity3;
            Entity entity5 = entity2 = entity4 instanceof Entity ? entity4 : null;
            if (entity2 == null) {
                block8: {
                    Entity entity6;
                    Iterable $this$firstOrNull$iv = this.initializingEntities;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual(it.getKlass(), f) && Intrinsics.areEqual(it.getId(), id))) continue;
                        entity6 = (Entity)element$iv;
                        break block8;
                    }
                    entity6 = entity4 = null;
                }
                entity = entity4 instanceof Entity ? entity4 : null;
            } else {
                entity = entity2;
            }
        }
        return (T)entity;
    }

    @NotNull
    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> Collection<T> findAll(@NotNull EntityClass<ID, ? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return this.getMap(f).values();
    }

    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> void store(@NotNull EntityClass<ID, ? extends T> f, @NotNull T o) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Intrinsics.checkNotNullParameter(o, (String)"o");
        Map<Object, Entity<?>> map = this.getMap(f);
        Comparable comparable = o.getId().getValue();
        map.put(comparable, o);
    }

    public final void store(@NotNull Entity<?> o) {
        Intrinsics.checkNotNullParameter(o, (String)"o");
        Map<Object, Entity<?>> map = this.getMap(o.getKlass().getTable());
        Comparable comparable = o.getId().getValue();
        map.put(comparable, o);
    }

    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> void remove(@NotNull IdTable<ID> table, @NotNull T o) {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Intrinsics.checkNotNullParameter(o, (String)"o");
        this.getMap(table).remove(o.getId().getValue());
    }

    public final void addNotInitializedEntityToQueue$exposed_dao(@NotNull Entity<?> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        if (!this.initializingEntities.add(entity)) {
            boolean bl = false;
            String string = "Entity " + Reflection.getOrCreateKotlinClass(entity.getClass()).getSimpleName() + " already in initialization process";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void finishEntityInitialization$exposed_dao(@NotNull Entity<?> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((Iterable)this.initializingEntities), entity)) {
            boolean bl = false;
            String string = "Can't finish initialization for entity " + Reflection.getOrCreateKotlinClass(entity.getClass()).getSimpleName() + " - the initialization order is broken";
            throw new IllegalArgumentException(string.toString());
        }
        this.initializingEntities.remove(entity);
    }

    public final boolean isEntityInInitializationState$exposed_dao(@NotNull Entity<?> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return this.initializingEntities.contains(entity);
    }

    /*
     * WARNING - void declaration
     */
    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> void scheduleInsert(@NotNull EntityClass<ID, ? extends T> f, @NotNull T o) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Intrinsics.checkNotNullParameter(o, (String)"o");
        Map map = this.inserts;
        IdTable<ID> key$iv = f.getTable();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedIdentityHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(o);
    }

    /*
     * WARNING - void declaration
     */
    public final <ID extends Comparable<? super ID>, T extends Entity<ID>> void scheduleUpdate(@NotNull EntityClass<ID, ? extends T> f, @NotNull T o) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Intrinsics.checkNotNullParameter(o, (String)"o");
        Map map = this.updates;
        IdTable<ID> key$iv = f.getTable();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedIdentityHashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(o);
    }

    public final void flush() {
        Set<IdTable<?>> set;
        Collection collection;
        if (this.inserts.isEmpty() && this.updates.isEmpty()) {
            collection = CollectionsKt.emptyList();
        } else if (!((Map)this.inserts).isEmpty() && !((Map)this.updates).isEmpty()) {
            set = this.inserts.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"inserts.keys");
            Set<IdTable<?>> set2 = set;
            set = this.updates.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"updates.keys");
            collection = SetsKt.plus(set2, (Iterable)set);
        } else if (!((Map)this.inserts).isEmpty()) {
            set = this.inserts.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"inserts.keys");
            collection = set;
        } else {
            set = this.updates.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"updates.keys");
            collection = set;
        }
        Collection toFlush = collection;
        this.flush(toFlush);
    }

    private final void updateEntities(IdTable<?> idTable) {
        Set set = (Set)this.updates.remove(idTable);
        if (set != null) {
            Set set2;
            Set it = set2 = set;
            boolean bl = false;
            Set set3 = !((Collection)it).isEmpty() ? set2 : null;
            if (set3 != null) {
                it = set3;
                boolean bl2 = false;
                HashSet<Entity> updatedEntities = new HashSet<Entity>();
                EntityBatchUpdate batch = new EntityBatchUpdate(((Entity)CollectionsKt.first((Iterable)it)).getKlass());
                for (Entity entity : it) {
                    if (!entity.flush(batch)) continue;
                    if (!(!(entity.getKlass() instanceof ImmutableEntityClass))) {
                        boolean $i$a$-check-EntityCache$updateEntities$2$22 = false;
                        String $i$a$-check-EntityCache$updateEntities$2$22 = "Update on immutable entity " + entity.getClass().getSimpleName() + ' ' + entity.getId();
                        throw new IllegalStateException($i$a$-check-EntityCache$updateEntities$2$22.toString());
                    }
                    updatedEntities.add(entity);
                }
                EntityLifecycleInterceptorKt.executeAsPartOfEntityLifecycle((Function0)new Function0<Integer>(batch, this){
                    final /* synthetic */ EntityBatchUpdate $batch;
                    final /* synthetic */ EntityCache this$0;
                    {
                        this.$batch = $batch;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        return this.$batch.execute(EntityCache.access$getTransaction$p(this.this$0));
                    }
                });
                Iterable $this$forEach$iv = updatedEntities;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Entity it2 = (Entity)element$iv;
                    boolean bl3 = false;
                    EntityHookKt.registerChange(this.transaction, it2.getKlass(), it2.getId(), EntityChangeType.Updated);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(@NotNull Iterable<? extends IdTable<?>> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        if (this.flushingEntities) {
            return;
        }
        try {
            Object element$iv$iv;
            Iterator $this$filterIsInstanceTo$iv$iv;
            this.flushingEntities = true;
            Set<IdTable<?>> set = this.inserts.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"inserts.keys");
            Set<IdTable<?>> insertedTables = set;
            Iterable $this$filterIsInstance$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable)insertedTables);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof IdTable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List updateBeforeInsert = (List)destination$iv$iv;
            Iterable $this$forEach$iv = updateBeforeInsert;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdTable p0 = (IdTable)element$iv;
                boolean bl = false;
                this.updateEntities(p0);
            }
            $this$filterIsInstance$iv = SchemaUtils.INSTANCE.sortTablesByReferences(tables);
            $i$f$filterIsInstance = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
            while (bl.hasNext()) {
                element$iv$iv = bl.next();
                if (!(element$iv$iv instanceof IdTable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdTable p0 = (IdTable)element$iv;
                boolean bl2 = false;
                this.flushInserts$exposed_dao(p0);
            }
            List updateTheRestTables = CollectionsKt.minus(tables, (Iterable)updateBeforeInsert);
            for (IdTable t : updateTheRestTables) {
                this.updateEntities(t);
            }
            if (!((Collection)insertedTables).isEmpty()) {
                this.removeTablesReferrers$exposed_dao((Collection<? extends Table>)insertedTables, true);
            }
        }
        finally {
            this.flushingEntities = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeTablesReferrers$exposed_dao(@NotNull Collection<? extends Table> tables, boolean isInsert) {
        void $this$filterTo$iv$iv;
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Set insertedTablesSet = CollectionsKt.toSet((Iterable)tables);
        Iterable iterable = tables;
        Collection collection = new HashSet();
        boolean $i$f$flatMapTo232 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapNotNullTo$iv$iv;
            Table it = (Table)element$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = it.getColumns();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Column it$iv$iv;
                Column column;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Column it2 = (Column)element$iv$iv;
                boolean bl3 = false;
                Column it3 = column = it2;
                boolean bl4 = false;
                if ((it3.getReferee() != null ? column : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet columnsToInvalidate = (HashSet)destination$iv;
        Set<Column<?>> $this$forEach$iv = columnsToInvalidate;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            Column it = (Column)t;
            boolean bl = false;
            this.getReferrers$exposed_dao().remove(it);
        }
        $this$forEach$iv = this.referrers.keySet();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"referrers.keys");
        Iterable $this$filter$iv = $this$forEach$iv;
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo232 = $this$filter$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            Column refColumn = (Column)element$iv$iv;
            boolean bl6 = false;
            if (isInsert) {
                bl = false;
            } else {
                Column column = refColumn.getReferee();
                if (CollectionsKt.contains((Iterable)insertedTablesSet, (Object)(column == null ? null : column.getTable()))) {
                    bl = true;
                } else {
                    boolean bl2;
                    block12: {
                        Iterable $this$any$iv = refColumn.getTable().getColumns();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Column it = (Column)element$iv;
                                boolean bl8 = false;
                                Column column2 = it.getReferee();
                                if (!CollectionsKt.contains((Iterable)tables, (Object)(column2 == null ? null : column2.getTable()))) continue;
                                bl2 = true;
                                break block12;
                            }
                            bl2 = false;
                        }
                    }
                    bl = bl2;
                }
            }
            if (!bl) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            Column it = (Column)t;
            boolean bl = false;
            this.getReferrers$exposed_dao().remove(it);
        }
    }

    public final void flushInserts$exposed_dao(@NotNull IdTable<?> table) {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Set set = (Set)this.inserts.remove(table);
        if (set != null) {
            Set it = set;
            boolean bl = false;
            Ref.ObjectRef toFlush = new Ref.ObjectRef();
            toFlush.element = CollectionsKt.toList((Iterable)it);
            do {
                Iterable $this$partition$iv = (Iterable)toFlush.element;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    boolean bl2;
                    block11: {
                        Entity it2 = (Entity)element$iv;
                        boolean bl3 = false;
                        Map $this$none$iv = it2.getWriteValues();
                        boolean $i$f$none = false;
                        if ($this$none$iv.isEmpty()) {
                            bl2 = true;
                        } else {
                            Iterator iterator2 = $this$none$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry element$iv2;
                                Map.Entry it3 = element$iv2 = iterator2.next();
                                boolean bl4 = false;
                                Column key = (Column)it3.getKey();
                                Object value = it3.getValue();
                                if (!(Intrinsics.areEqual((Object)key.getReferee(), (Object)table.getId()) && value instanceof EntityID && ((EntityID)value).get_value() == null)) continue;
                                bl2 = false;
                                break block11;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair partition = new Pair(first$iv, second$iv);
                toFlush.element = partition.getFirst();
                List ids2 = (List)EntityLifecycleInterceptorKt.executeAsPartOfEntityLifecycle((Function0)new Function0<List<? extends ResultRow>>(table, toFlush){
                    final /* synthetic */ IdTable<?> $table;
                    final /* synthetic */ Ref.ObjectRef<List<Entity<?>>> $toFlush;
                    {
                        this.$table = $table;
                        this.$toFlush = $toFlush;
                        super(0);
                    }

                    @NotNull
                    public final List<ResultRow> invoke() {
                        return QueriesKt.batchInsert$default((Table)((Table)this.$table), (Iterable)((Iterable)this.$toFlush.element), (boolean)false, (boolean)false, (Function2)flushInserts.1.ids.1.INSTANCE, (int)6, null);
                    }
                });
                for (Pair pair : CollectionsKt.zip((Iterable)((Iterable)toFlush.element), (Iterable)ids2)) {
                    Entity entry = (Entity)pair.component1();
                    ResultRow genValues = (ResultRow)pair.component2();
                    if (entry.getId().get_value() == null) {
                        EntityID id = (EntityID)genValues.get((Expression)table.getId());
                        entry.getId().set_value(id.get_value());
                        Map it2 = entry.getWriteValues();
                        Column bl3 = entry.getKlass().getTable().getId();
                        it2.put(bl3, id);
                    }
                    Iterable $this$forEach$iv = genValues.getFieldIndex().keySet();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Expression key = (Expression)element$iv;
                        boolean bl5 = false;
                        ((Map)entry.getWriteValues()).put((Column)key, genValues.get(key));
                    }
                    entry.storeWrittenValues();
                    this.store(entry);
                    EntityHookKt.registerChange(this.transaction, entry.getKlass(), entry.getId(), EntityChangeType.Created);
                    List<Function1<Entity<?>, Unit>> list = this.getPendingInitializationLambdas$exposed_dao().get(entry);
                    if (list == null) continue;
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Function1 it4 = (Function1)element$iv;
                        boolean bl6 = false;
                        it4.invoke((Object)entry);
                    }
                }
                toFlush.element = partition.getSecond();
            } while (!((Collection)toFlush.element).isEmpty());
        }
        EntityHookKt.alertSubscribers(this.transaction);
    }

    public final void clear(boolean flush2) {
        if (flush2) {
            this.flush();
        }
        this.data.clear();
        this.inserts.clear();
        this.updates.clear();
        this.clearReferrersCache();
    }

    public static /* synthetic */ void clear$default(EntityCache entityCache2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        entityCache2.clear(bl);
    }

    public final void clearReferrersCache() {
        this.referrers.clear();
    }

    public static final /* synthetic */ Transaction access$getTransaction$p(EntityCache $this) {
        return $this.transaction;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010'\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/dao/EntityCache$LimitedHashMap;", "K", "V", "Ljava/util/LinkedHashMap;", "(Lorg/jetbrains/exposed/dao/EntityCache;)V", "removeEldestEntry", "", "eldest", "", "exposed-dao"})
    private final class LimitedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        public LimitedHashMap() {
            Intrinsics.checkNotNullParameter((Object)EntityCache.this, (String)"this$0");
        }

        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
            return this.size() > EntityCache.this.getMaxEntitiesToStore();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/dao/EntityCache$Companion;", "", "()V", "invalidateGlobalCaches", "", "created", "", "Lorg/jetbrains/exposed/dao/Entity;", "exposed-dao"})
    public static final class Companion {
        private Companion() {
        }

        public final void invalidateGlobalCaches(@NotNull List<? extends Entity<?>> created) {
            Intrinsics.checkNotNullParameter(created, (String)"created");
            Sequence $this$forEach$iv = SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)created), (Function1)invalidateGlobalCaches.1.INSTANCE));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ImmutableCachedEntityClass it = (ImmutableCachedEntityClass)element$iv;
                boolean bl = false;
                it.expireCache();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

