/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class LiteralsFirstInComparisonsRule
extends AbstractJavaRule {
    private static final String[] COMPARISON_OPS = new String[]{".equals", ".equalsIgnoreCase", ".compareTo", ".compareToIgnoreCase", ".contentEquals"};

    public LiteralsFirstInComparisonsRule() {
        this.addRuleChainVisit(ASTPrimaryExpression.class);
    }

    @Override
    public Object visit(ASTPrimaryExpression expression, Object data) {
        if (this.violatesLiteralsFirstInComparisonsRule(expression)) {
            this.addViolation(data, (Node)expression);
        }
        return data;
    }

    private boolean violatesLiteralsFirstInComparisonsRule(ASTPrimaryExpression expression) {
        return !this.hasStringLiteralFirst(expression) && this.isNullableComparisonWithStringLiteral(expression);
    }

    private boolean hasStringLiteralFirst(ASTPrimaryExpression expression) {
        ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)expression.getFirstChildOfType(ASTPrimaryPrefix.class);
        ASTLiteral firstLiteral = (ASTLiteral)primaryPrefix.getFirstDescendantOfType(ASTLiteral.class);
        return firstLiteral != null && firstLiteral.isStringLiteral();
    }

    private boolean isNullableComparisonWithStringLiteral(ASTPrimaryExpression expression) {
        String opName = this.getOperationName(expression);
        ASTPrimarySuffix argsSuffix = this.getSuffixOfArguments(expression);
        return opName != null && argsSuffix != null && this.isStringLiteralComparison(opName, argsSuffix) && this.isNotWithinNullComparison(expression);
    }

    private String getOperationName(ASTPrimaryExpression primaryExpression) {
        return this.isMethodsChain(primaryExpression) ? this.getOperationNameBySuffix(primaryExpression) : this.getOperationNameByPrefix(primaryExpression);
    }

    private boolean isMethodsChain(ASTPrimaryExpression primaryExpression) {
        return primaryExpression.getNumChildren() > 2;
    }

    private String getOperationNameBySuffix(ASTPrimaryExpression primaryExpression) {
        ASTPrimarySuffix opAsSuffix = this.getPrimarySuffixAtIndexFromEnd(primaryExpression, 1);
        if (opAsSuffix != null) {
            String opName = opAsSuffix.getImage();
            return "." + opName;
        }
        return null;
    }

    private String getOperationNameByPrefix(ASTPrimaryExpression primaryExpression) {
        ASTPrimaryPrefix opAsPrefix = (ASTPrimaryPrefix)primaryExpression.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (opAsPrefix != null) {
            ASTName opName = (ASTName)opAsPrefix.getFirstChildOfType(ASTName.class);
            return opName != null ? opName.getImage() : null;
        }
        return null;
    }

    private ASTPrimarySuffix getSuffixOfArguments(ASTPrimaryExpression primaryExpression) {
        return this.getPrimarySuffixAtIndexFromEnd(primaryExpression, 0);
    }

    private ASTPrimarySuffix getPrimarySuffixAtIndexFromEnd(ASTPrimaryExpression primaryExpression, int indexFromEnd) {
        List primarySuffixes = primaryExpression.findChildrenOfType(ASTPrimarySuffix.class);
        if (!primarySuffixes.isEmpty()) {
            int suffixIndex = primarySuffixes.size() - 1 - indexFromEnd;
            return (ASTPrimarySuffix)primarySuffixes.get(suffixIndex);
        }
        return null;
    }

    private boolean isStringLiteralComparison(String opName, ASTPrimarySuffix argsSuffix) {
        return this.isComparisonOperation(opName) && this.isSingleStringLiteralArgument(argsSuffix);
    }

    private boolean isComparisonOperation(String op) {
        for (String comparisonOp : COMPARISON_OPS) {
            if (!op.endsWith(comparisonOp)) continue;
            return true;
        }
        return false;
    }

    private boolean isSingleStringLiteralArgument(ASTPrimarySuffix primarySuffix) {
        return this.isSingleArgumentSuffix(primarySuffix) && this.isStringLiteralFirstArgumentOfSuffix(primarySuffix);
    }

    private boolean isSingleArgumentSuffix(ASTPrimarySuffix primarySuffix) {
        return primarySuffix.getArgumentCount() == 1;
    }

    private boolean isStringLiteralFirstArgumentOfSuffix(ASTPrimarySuffix primarySuffix) {
        try {
            JavaNode firstLiteralArg = this.getFirstLiteralArgument(primarySuffix);
            JavaNode firstNameArg = this.getFirstNameArgument(primarySuffix);
            return this.isStringLiteral(firstLiteralArg) || this.isConstantString(firstNameArg);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private JavaNode getFirstLiteralArgument(ASTPrimarySuffix primarySuffix) {
        return (JavaNode)this.getArgumentPrimaryPrefix(primarySuffix).getFirstChildOfType(ASTLiteral.class);
    }

    private JavaNode getFirstNameArgument(ASTPrimarySuffix primarySuffix) {
        return (JavaNode)this.getArgumentPrimaryPrefix(primarySuffix).getFirstChildOfType(ASTName.class);
    }

    private JavaNode getArgumentPrimaryPrefix(ASTPrimarySuffix primarySuffix) {
        ASTArguments arguments = (ASTArguments)primarySuffix.getFirstChildOfType(ASTArguments.class);
        ASTArgumentList argumentList = (ASTArgumentList)arguments.getFirstChildOfType(ASTArgumentList.class);
        ASTExpression expression = (ASTExpression)argumentList.getFirstChildOfType(ASTExpression.class);
        ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class);
        return (JavaNode)primaryExpression.getFirstChildOfType(ASTPrimaryPrefix.class);
    }

    private boolean isStringLiteral(JavaNode node) {
        if (node instanceof ASTLiteral) {
            ASTLiteral literal = (ASTLiteral)node;
            return literal.isStringLiteral();
        }
        return false;
    }

    private boolean isConstantString(JavaNode node) {
        if (node instanceof ASTName) {
            ASTName name = (ASTName)node;
            ASTClassOrInterfaceBody classBody = (ASTClassOrInterfaceBody)name.getFirstParentOfType(ASTClassOrInterfaceBody.class);
            ASTClassOrInterfaceBodyDeclaration classOrInterfaceBodyDeclaration = (ASTClassOrInterfaceBodyDeclaration)classBody.getFirstChildOfType(ASTClassOrInterfaceBodyDeclaration.class);
            List fieldDeclarations = classOrInterfaceBodyDeclaration.findChildrenOfType(ASTFieldDeclaration.class);
            for (ASTFieldDeclaration fieldDeclaration : fieldDeclarations) {
                ASTVariableDeclarator declaration = (ASTVariableDeclarator)fieldDeclaration.getFirstChildOfType(ASTVariableDeclarator.class);
                if (!declaration.getName().equals(name.getImage()) || !String.class.equals(declaration.getType()) || !fieldDeclaration.isFinal() || !fieldDeclaration.isStatic()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotWithinNullComparison(ASTPrimaryExpression node) {
        return !this.isWithinNullComparison(node);
    }

    private boolean isWithinNullComparison(ASTPrimaryExpression node) {
        for (ASTExpression parentExpr : node.getParentsOfType(ASTExpression.class)) {
            if (!this.isNullComparison(parentExpr)) continue;
            return true;
        }
        return false;
    }

    private boolean isNullComparison(ASTExpression expression) {
        return this.isAndNotNullComparison(expression) || this.isOrNullComparison(expression);
    }

    private boolean isAndNotNullComparison(ASTExpression expression) {
        ASTConditionalAndExpression andExpression = (ASTConditionalAndExpression)expression.getFirstChildOfType(ASTConditionalAndExpression.class);
        return andExpression != null && this.hasEqualityExpressionWithNullLiteral(andExpression, "!=");
    }

    private boolean isOrNullComparison(ASTExpression expression) {
        ASTConditionalOrExpression orExpression = (ASTConditionalOrExpression)expression.getFirstChildOfType(ASTConditionalOrExpression.class);
        return orExpression != null && this.hasEqualityExpressionWithNullLiteral(orExpression, "==");
    }

    private boolean hasEqualityExpressionWithNullLiteral(JavaNode node, String equalityOp) {
        ASTEqualityExpression equalityExpression = (ASTEqualityExpression)node.getFirstDescendantOfType(ASTEqualityExpression.class);
        if (equalityExpression != null && equalityExpression.hasImageEqualTo(equalityOp)) {
            return equalityExpression.hasDescendantOfType(ASTNullLiteral.class);
        }
        return false;
    }
}

