/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.telemetry;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TelemetryData {
    private static final String EXCEPTION_STRING = "Exception";
    private static final String EXECUTION_TIME_STRING = "ExecutionTime";
    private static final String FEATURE_STRING = "Feature";
    private final Map<String, Long> measures = new HashMap<String, Long>();
    private final Map<String, String> properties = new HashMap<String, String>();

    public TelemetryData(String featureName) {
        this.properties.put(FEATURE_STRING, featureName);
        this.properties.put(EXCEPTION_STRING, "None");
        this.measures.put(EXECUTION_TIME_STRING, -1L);
    }

    public void addExecutionTime(long executionTime) {
        this.measures.put(EXECUTION_TIME_STRING, executionTime);
    }

    public void add(Throwable throwable) {
        this.properties.put(EXCEPTION_STRING, ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    public void add(String key, String value) {
        this.properties.put(key, value);
    }

    public void add(String key, long value) {
        this.measures.put(key, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, Long> getMeasures() {
        return this.measures;
    }
}

