/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.WithIdentifierClause;
import apex.jorje.data.soql.WithKeyValue;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import java.util.stream.Collectors;

public class WithIdentifierPrinter
implements Printer<WithIdentifierClause> {
    private static final WithKeyValue.MatchBlock<String> KEY_VALUE_MATCHER = new WithKeyValue.MatchBlock<String>(){

        @Override
        public String _case(WithKeyValue.StringKeyValue x) {
            return x.identifier.getValue() + "='" + x.value + "'";
        }

        @Override
        public String _case(WithKeyValue.NumberKeyValue x) {
            return x.identifier.getValue() + "=" + x.value;
        }

        @Override
        public String _case(WithKeyValue.BooleanKeyValue x) {
            return x.identifier.getValue() + "=" + x.value;
        }
    };
    private static final WithIdentifierClause.MatchBlock<String> WITH_IDENTIFIER_MATCHER = new WithIdentifierClause.MatchBlock<String>(){

        @Override
        public String _case(WithIdentifierClause.WithIdentifier x) {
            return x.identifier.getValue();
        }

        @Override
        public String _case(WithIdentifierClause.WithIdentifierTuple x) {
            String keyValues = x.keyValues.stream().map(keyValue -> (String)keyValue.match(KEY_VALUE_MATCHER)).collect(Collectors.joining(", ", " (", ")"));
            return x.identifier.getValue() + keyValues;
        }
    };
    private static final Printer<WithIdentifierClause> INSTANCE = new WithIdentifierPrinter();

    public static Printer<WithIdentifierClause> get() {
        return INSTANCE;
    }

    @Override
    public String print(WithIdentifierClause withIdentifier, PrintContext ctx) {
        return "WITH " + withIdentifier.match(WITH_IDENTIFIER_MATCHER);
    }
}

