/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.ArrayExpression;
import apex.jorje.semantic.ast.expression.SpecialAssignmentCalculator;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class ArrayStoreExpression
extends ArrayExpression {
    public ArrayStoreExpression(AstNode definingNode, Expr.ArrayExpr expr) {
        super(definingNode, expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.getInnerExpression().traverse(visitor, scope);
            this.getIndex().traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.getInnerExpression().validate(symbols, scope);
        this.getIndex().validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.getInnerExpression(), this.getIndex())) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!CollectionTypeInfoUtil.isList(this.getInnerExpression().getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.type", this.getInnerExpression().getType()));
        } else {
            this.setType(CollectionTypeInfoUtil.getElementType(this.getInnerExpression().getType()));
        }
        if (!this.getIndex().getType().equals(TypeInfos.INTEGER)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.list.index.type", TypeInfos.INTEGER, this.getIndex().getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        if (SpecialAssignmentCalculator.get().calculate(this)) {
            emitter.emit(Locations.NONE, 95);
        } else {
            this.getInnerExpression().emit(emitter);
            emitter.emit(Locations.NONE, 95);
            this.getIndex().emit(emitter);
        }
        emitter.emit(Locations.NONE, 95);
        emitter.emit(this.getLoc(), ListEmitMethods.SET_BYTECODE);
    }
}

