/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.diagnostics;

import apex.jorje.lsp.api.codeActions.QuickFixProvider;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.diagnostics.DiagnosticsUtil;
import apex.jorje.lsp.impl.utils.SourceFiles;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.services.exception.CompilationException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiagnosticsReporter
implements DocumentLifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsReporter.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final Provider<LanguageClient> languageClientProvider;
    private final Set<QuickFixProvider> quickFixProviders;

    @Inject
    public DiagnosticsReporter(Provider<LanguageClient> languageClientProvider, ApexCompilerService compilerService, ApexDocumentService documentService, Set<QuickFixProvider> quickFixProviders) {
        this.languageClientProvider = languageClientProvider;
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.quickFixProviders = quickFixProviders;
    }

    @Override
    public void handleDidOpen(DidOpenTextDocumentParams params) {
        this.publishDiagnostics(params.getTextDocument().getUri());
    }

    @Override
    public void handleDidChange(DidChangeTextDocumentParams params) {
        this.publishDiagnostics(params.getTextDocument().getUri());
    }

    @Override
    public void handleDidClose(DidCloseTextDocumentParams params) {
        DiagnosticsUtil.clearDiagnostics(this.languageClientProvider, params.getTextDocument().getUri());
    }

    @Override
    public void handleDidSave(DidSaveTextDocumentParams params) {
        this.publishDiagnostics(params.getTextDocument().getUri());
    }

    private void publishDiagnostics(String uri) {
        if (SourceFiles.isSoql(uri)) {
            return;
        }
        Optional<Document> document = this.documentService.retrieve(URI.create(uri));
        document.ifPresent(doc -> {
            CodeUnit codeUnit = this.compilerService.compile((Document)doc);
            ArrayList<CompilationException> exceptions = new ArrayList<CompilationException>();
            exceptions.addAll(codeUnit.getErrors().get());
            DiagnosticsUtil.publishDiagnostics(this.languageClientProvider, uri, exceptions);
        });
    }
}

