/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DatabaseEmitMethods;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class DmlMergeStatement
extends Statement {
    private static final DmlOperation OP = DmlOperation.MERGE;
    private final Location loc;
    private final Expression expression;
    private final Expression duplicateExpression;

    public DmlMergeStatement(AstNode definingNode, Stmnt.DmlMergeStmnt x) {
        super(definingNode);
        this.loc = x.loc;
        this.expression = AstNodes.get().create((AstNode)this, x.expr1);
        this.duplicateExpression = AstNodes.get().create((AstNode)this, x.expr2);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            this.duplicateExpression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        TypeInfo duplicateType;
        this.expression.validate(symbols, scope);
        this.duplicateExpression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.expression, this.duplicateExpression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!SObjectTypeInfoUtil.isConcreteSObject(this.expression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("merge.requires.concrete.type", this.expression.getType()));
            return;
        }
        if (!SObjectTypeInfoUtil.isDmlOperationAllowedStatically(this.getDefiningType(), DmlOperation.MERGE, this.expression.getType())) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("merge.not.supported", this.expression.getType()));
            return;
        }
        TypeInfo typeInfo = duplicateType = CollectionTypeInfoUtil.isList(this.duplicateExpression.getType()) ? CollectionTypeInfoUtil.getElementType(this.duplicateExpression.getType()) : this.duplicateExpression.getType();
        if (!Distance.get().canAssign(this.getDefiningType(), duplicateType, this.expression.getType()) && !Distance.get().canAssign(this.getDefiningType(), duplicateType, TypeInfos.ID)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.merge.duplicate.records"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.loc, true, false);
        this.expression.emit(emitter);
        this.duplicateExpression.emit(emitter);
        ProfilingType.DML.emit(emitter, this.loc, OP.getName(this.expression.getType()));
        emitter.emit(this.loc, CollectionTypeInfoUtil.isList(this.duplicateExpression.getType()) ? DatabaseEmitMethods.DML_MERGE_LIST : DatabaseEmitMethods.DML_MERGE);
        emitter.emit(this.loc, 87);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

