/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.QueryLiteral;
import apex.jorje.services.datetimes.DateTimeFormats;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;

public class QueryLiteralPrinter
implements Printer<QueryLiteral> {
    private static final QueryLiteral.MatchBlock<String> QUERY_LITERAL = new QueryLiteral.MatchBlock<String>(){

        @Override
        public String _case(QueryLiteral.QueryString x) {
            return "'" + x.literal + "'";
        }

        @Override
        public String _case(QueryLiteral.QueryNumber x) {
            return x.literal.toString();
        }

        @Override
        public String _case(QueryLiteral.QueryDate x) {
            return DateTimeFormats.PRINT_DATE.format(x.literal);
        }

        @Override
        public String _case(QueryLiteral.QueryDateTime x) {
            return DateTimeFormats.PRINT_DATE_TIME.format(x.literal);
        }

        @Override
        public String _case(QueryLiteral.QueryTime x) {
            return DateTimeFormats.PRINT_TIME.format(x.literal);
        }

        @Override
        public String _case(QueryLiteral.QueryTrue x) {
            return "TRUE";
        }

        @Override
        public String _case(QueryLiteral.QueryFalse x) {
            return "FALSE";
        }

        @Override
        public String _case(QueryLiteral.QueryNull x) {
            return "NULL";
        }

        @Override
        public String _case(QueryLiteral.QueryDateFormula x) {
            return x.dateFormula;
        }

        @Override
        public String _case(QueryLiteral.QueryMultiCurrency x) {
            return x.literal;
        }
    };
    private static final Printer<QueryLiteral> INSTANCE = new QueryLiteralPrinter();

    private QueryLiteralPrinter() {
    }

    public static Printer<QueryLiteral> get() {
        return INSTANCE;
    }

    @Override
    public String print(QueryLiteral x, PrintContext ctx) {
        return x.match(QUERY_LITERAL);
    }
}

