/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.ast.internal;

import java.util.Locale;

public final class ParsingExclusion {
    private static final String BEGIN_MARKER = "PMD-EXCLUDE-BEGIN";
    private static final int LEN_BEGIN_MARKER = "PMD-EXCLUDE-BEGIN".length();
    private final int beginLine;
    private final int endLine;
    private final String excludedSource;
    private final String reason;

    public ParsingExclusion(int beginLine, int endLine, String source) {
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.excludedSource = source;
        String sourceUpper = source.toUpperCase(Locale.ROOT);
        int i1 = sourceUpper.indexOf(BEGIN_MARKER);
        int i2 = sourceUpper.indexOf("\n");
        String reason = source.substring(i1 + LEN_BEGIN_MARKER, i2).trim();
        this.reason = reason.startsWith(":") ? reason.substring(2).trim() : null;
    }

    public String getExcludedSource() {
        return this.excludedSource;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public String getReason() {
        return this.reason;
    }
}

