/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class AccessorMethodGenerationRule
extends AbstractJavaRule {
    private List<String> cache = new ArrayList<String>();

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        SourceFileScope file = (SourceFileScope)node.getScope().getEnclosingScope(SourceFileScope.class);
        this.analyzeScope(file, data);
        return data;
    }

    private void analyzeScope(AbstractJavaScope file, Object data) {
        for (ClassNameDeclaration classDecl : file.getDeclarations(ClassNameDeclaration.class).keySet()) {
            ClassScope classScope = (ClassScope)classDecl.getScope();
            for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : classScope.getVariableDeclarations().entrySet()) {
                ASTFieldDeclaration field = (ASTFieldDeclaration)entry.getKey().getNode().getFirstParentOfType(ASTFieldDeclaration.class);
                this.analyzeMember(field, entry.getValue(), classScope, data);
            }
            for (Map.Entry<AbstractNameDeclaration, List<NameOccurrence>> entry : classScope.getMethodDeclarations().entrySet()) {
                ASTMethodDeclaration method = (ASTMethodDeclaration)((MethodNameDeclaration)entry.getKey()).getNode().getFirstParentOfType(ASTMethodDeclaration.class);
                this.analyzeMember(method, entry.getValue(), classScope, data);
            }
            this.analyzeScope(classScope, data);
        }
    }

    public void analyzeMember(AbstractJavaAccessNode node, List<NameOccurrence> occurrences, ClassScope classScope, Object data) {
        if (!node.isPrivate()) {
            return;
        }
        if (node.isFinal()) {
            for (ASTVariableDeclarator varDecl : node.findChildrenOfType(ASTVariableDeclarator.class)) {
                if (!varDecl.hasInitializer()) continue;
                ASTVariableInitializer varInit = varDecl.getInitializer();
                List initExpression = varInit.findDescendantsOfType(ASTExpression.class);
                boolean isConstantExpression = true;
                block1: for (ASTExpression exp : initExpression) {
                    List primaryExpressions = exp.findDescendantsOfType(ASTPrimaryExpression.class);
                    for (ASTPrimaryExpression expression : primaryExpressions) {
                        if (this.isCompileTimeConstant(expression)) continue;
                        isConstantExpression = false;
                        break block1;
                    }
                }
                if (!isConstantExpression) continue;
                this.cache.add(varDecl.getName());
                return;
            }
        }
        for (NameOccurrence no : occurrences) {
            ClassScope usedAtScope = (ClassScope)no.getLocation().getScope().getEnclosingScope(ClassScope.class);
            if (((Object)((Object)classScope)).equals((Object)usedAtScope)) continue;
            this.addViolation(data, (Node)no.getLocation());
        }
    }

    public boolean isCompileTimeConstant(ASTPrimaryExpression expressions) {
        List suffix = expressions.findDescendantsOfType(ASTPrimarySuffix.class);
        if (!suffix.isEmpty()) {
            return false;
        }
        List nameNodes = expressions.findDescendantsOfType(ASTName.class);
        List literalNodes = expressions.findDescendantsOfType(ASTLiteral.class);
        if (nameNodes.size() + literalNodes.size() < 2) {
            for (ASTName node : nameNodes) {
                if (this.cache.contains(node.getImage())) continue;
                return false;
            }
            return true;
        }
        List subExpressions = expressions.findDescendantsOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression exp : subExpressions) {
            if (this.isCompileTimeConstant(exp)) continue;
            return false;
        }
        return true;
    }

    public void end(RuleContext ctx) {
        this.cache.clear();
    }
}

