/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterator;

import apex.common.base.MoreStrings;
import apex.jorje.semantic.common.iterator.Pair;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.StreamSupport;

public class EqualPairIterator<T, U>
implements Iterator<Pair<T, U>> {
    private final Iterator<T> left;
    private final Iterator<U> right;

    private EqualPairIterator(Iterator<T> left, Iterator<U> right) {
        this.left = left;
        this.right = right;
    }

    public static <T, U> Iterable<Pair<T, U>> iterable(Iterable<T> left, Iterable<U> right) {
        return EqualPairIterator.iterable(left, Object::toString, right, Object::toString);
    }

    private static <T, U> Iterable<Pair<T, U>> iterable(Iterable<T> left, Function<Object, String> leftFormatter, Iterable<U> right, Function<Object, String> rightFormatter) {
        if (Iterables.size(left) != Iterables.size(right)) {
            String leftStr = StreamSupport.stream(left.spliterator(), false).map(leftFormatter::apply).collect(MoreStrings.ON_COMMA);
            String rightStr = StreamSupport.stream(right.spliterator(), false).map(rightFormatter::apply).collect(MoreStrings.ON_COMMA);
            assert (Iterables.size(left) == Iterables.size(right)) : "collections size do not match\nleft: " + leftStr + "\nright: " + rightStr;
        }
        return () -> new EqualPairIterator(left.iterator(), right.iterator());
    }

    @Override
    public boolean hasNext() {
        return this.left.hasNext() && this.right.hasNext();
    }

    @Override
    public Pair<T, U> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new Pair<T, U>(this.left.next(), this.right.next());
    }
}

