/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.common.iterable.LessStrings;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameProvider;
import com.google.common.base.Strings;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class TypeNameUtil {
    public static final Predicate<TypeInfo> HAS_PLACEHOLDER = type -> type instanceof ArgumentTypeInfo;
    private static final Pattern EXCEPTION = Pattern.compile(".*(?i)exception$");

    private TypeNameUtil() {
    }

    public static String createApexName(TypeNameProvider type, List<TypeInfo> argumentTypes) {
        return argumentTypes.isEmpty() ? type.getApexName() : (TypeInfoUtil.containsPlaceholders(argumentTypes) ? type.getApexName() : TypeNameUtil.createName(type, argumentTypes, TypeInfo.TO_APEX_NAME, new StringJoiner(",", "<", ">")));
    }

    public static String createBytecodeName(TypeNameProvider type, List<TypeInfo> argumentTypes) {
        return argumentTypes.isEmpty() ? type.getBytecodeName() : (TypeInfoUtil.containsPlaceholders(argumentTypes) ? type.getBytecodeName() : TypeNameUtil.createName(type, argumentTypes, TypeInfo.TO_BYTECODE_NAME, new StringJoiner("$$c", "$$l", "$$r")));
    }

    @SfdcCalled
    public static String createBytecodeName(String type, String ... argumentTypes) {
        return TypeNameUtil.createBytecodeName(type, MoreLists.asImmutableList(argumentTypes));
    }

    public static String createBytecodeName(String type, List<String> argumentTypes) {
        return argumentTypes.isEmpty() ? type : type + LessStrings.toString(argumentTypes, new StringJoiner("$$c", "$$l", "$$r"));
    }

    private static String createName(TypeNameProvider type, List<TypeInfo> argumentTypes, Function<TypeNameProvider, String> function, StringJoiner joiner) {
        String arguments = LessStrings.toString(argumentTypes, function, joiner);
        return function.apply(type) + arguments;
    }

    public static String createTypeSignature(String bytecodeName) {
        assert (!Strings.isNullOrEmpty(bytecodeName)) : "no bytecode name";
        return "L" + bytecodeName + ";";
    }

    public static String toNamespace(Namespace namespace, String typeName) {
        if (Strings.isNullOrEmpty(typeName)) {
            throw new IllegalArgumentException("typeName is null or empty");
        }
        return Namespace.isEmptyOrNull(namespace) ? typeName : namespace.toString() + "/" + typeName;
    }

    public static boolean isException(String name) {
        return EXCEPTION.matcher(name).matches();
    }
}

