/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeActions.quickFix;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;
import apex.jorje.services.exception.CompilationException;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;
import java.util.Objects;

public class QuickFixException
extends CompilationException {
    private static final long serialVersionUID = -7885828213823981944L;
    private final Location loc;
    private final String error;

    public QuickFixException(Location loc, String error) {
        this(loc, error, null);
    }

    public QuickFixException(Location loc, String error, Throwable cause) {
        super(PrinterUtil.get().getFactory().loc().print(loc, PrintContexts.empty()) + ": " + error, cause);
        this.loc = loc;
        this.error = error;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    @Override
    public String getError() {
        return this.error;
    }

    public int hashCode() {
        return ObjectHash.hash(this.loc, this.error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuickFixException that = (QuickFixException)o;
        return Objects.equals(this.loc, that.loc) && Objects.equals(this.error, that.error);
    }
}

