/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import java.util.List;
import java.util.Objects;

final class StaticLabelBind {
    private StaticLabelBind() {
    }

    static Variable bindToLabel(ValidationScope validationScope, AstNode node, TypeInfo referencingType, List<Identifier> names, Identifier lastName, int size) {
        String firstLower = names.get(0).getValue().toLowerCase();
        String secondLower = size > 1 ? names.get(1).getValue().toLowerCase() : null;
        return StaticLabelBind.bindToLabel(validationScope, node, referencingType, names, lastName, size, firstLower, secondLower);
    }

    static Variable bindToLabel(ValidationScope validationScope, AstNode node, TypeInfo referencingType, List<Identifier> names, Identifier lastName, int size, String firstLower, String secondLower) {
        if ((size == 1 || size == 2) && Objects.equals("label", firstLower)) {
            Namespace namespace = size == 1 ? Namespaces.EMPTY : Namespaces.parse(names.get(1).getValue());
            return StaticLabelBind.bindToLabel(validationScope, node, referencingType, namespace, lastName);
        }
        if ((size == 2 || size == 3) && Objects.equals("system", firstLower) && Objects.equals("label", secondLower)) {
            Namespace namespace = size == 2 ? Namespaces.EMPTY : Namespaces.parse(names.get(2).getValue());
            return StaticLabelBind.bindToLabel(validationScope, node, referencingType, namespace, lastName);
        }
        return null;
    }

    private static Variable bindToLabel(ValidationScope validationScope, AstNode node, TypeInfo referencingType, Namespace namespace, Identifier labelName) {
        TypeInfo labelTypeInfo = validationScope.getSymbols().getLabelTypeInfo(namespace);
        if (labelTypeInfo == null) {
            return null;
        }
        Variable variable = validationScope.getSymbols().lookupVariableInfo(referencingType, ReferenceType.LOAD, IdentifierContext.STATIC, labelTypeInfo, labelName);
        if (variable == null) {
            validationScope.getErrors().markInvalid(node, I18nSupport.getLabel("external.string.does.not.exist", labelName.getValue()));
        }
        return variable;
    }
}

