/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;

public class ASTAnnotation
extends AbstractJavaTypeNode {
    private static final List<String> UNUSED_RULES = Arrays.asList("UnusedPrivateField", "UnusedLocalVariable", "UnusedPrivateMethod", "UnusedFormalParameter", "UnusedAssignment");
    private static final List<String> SERIAL_RULES = Arrays.asList("BeanMembersShouldSerialize", "NonSerializableClass", "MissingSerialVersionUID");

    @Deprecated
    @InternalApi
    public ASTAnnotation(int id) {
        super(id);
    }

    @Deprecated
    @InternalApi
    public ASTAnnotation(JavaParser p, int id) {
        super(p, id);
    }

    public String getAnnotationName() {
        return ((JavaNode)this.getChild(0)).getChild(0).getImage();
    }

    public boolean suppresses(Rule rule) {
        if (this.getChild(0) instanceof ASTMarkerAnnotation) {
            return false;
        }
        if (this.isSuppressWarnings()) {
            for (ASTLiteral element : this.findDescendantsOfType(ASTLiteral.class)) {
                if (!element.hasImageEqualTo("\"PMD\"") && !element.hasImageEqualTo("\"PMD." + rule.getName() + "\"") && !element.hasImageEqualTo("\"all\"") && (!element.hasImageEqualTo("\"serial\"") || !SERIAL_RULES.contains(rule.getName())) && (!element.hasImageEqualTo("\"unused\"") || !UNUSED_RULES.contains(rule.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSuppressWarnings() {
        return "SuppressWarnings".equals(this.getAnnotationName()) || "java.lang.SuppressWarnings".equals(this.getAnnotationName());
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

