/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.lsp.impl.utils.TypeUsageSiteProcessor;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.List;
import java.util.ListIterator;

public class TypeUsageSiteUtil {
    public static void processTypeUsageSite(TypeRef typeRef, TypeInfo typeInfo, TypeUsageSiteProcessor processor) {
        if (typeRef != null && typeInfo != null) {
            List<TypeRef> typeArguments = typeRef.getTypeArguments();
            if (typeArguments.isEmpty()) {
                TypeUsageSiteUtil.processTypeUsageSite(typeRef.getNames(), typeInfo, processor);
            } else {
                ListIterator<TypeRef> argRefIter = typeArguments.listIterator();
                ListIterator<TypeInfo> argInfoIter = typeInfo.getTypeArguments().listIterator();
                while (argRefIter.hasNext() && argInfoIter.hasNext()) {
                    TypeUsageSiteUtil.processTypeUsageSite(argRefIter.next(), argInfoIter.next(), processor);
                }
            }
        }
    }

    public static void processTypeUsageSite(List<Identifier> names, TypeInfo apexType, TypeUsageSiteProcessor processor) {
        if (apexType != null) {
            String refName = apexType.getApexName();
            ListIterator<Identifier> namesIter = names.listIterator(names.size());
            for (TypeInfo currType = apexType; namesIter.hasPrevious() && currType != null; currType = currType.getEnclosingType()) {
                processor.processSite(refName, currType, namesIter.previous().getLoc());
                refName = TypeUsageSiteUtil.stripLastPart(refName);
            }
        }
    }

    private static String stripLastPart(String source) {
        return source.contains(".") ? source.substring(0, source.lastIndexOf(".")) : source;
    }
}

