<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/datastore/datastore_v3.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
  require_once 'google/appengine/api/api_base_pb.php';
  require_once 'google/appengine/datastore/action_pb.php';
  require_once 'google/appengine/datastore/entity_pb.php';
  require_once 'google/appengine/datastore/snapshot_pb.php';
}
namespace google\appengine_datastore_v3 {
  class InternalHeader extends \google\net\ProtocolMessage {
    public function getRequestingAppId() {
      if (!isset($this->requesting_app_id)) {
        return '';
      }
      return $this->requesting_app_id;
    }
    public function setRequestingAppId($val) {
      $this->requesting_app_id = $val;
      return $this;
    }
    public function clearRequestingAppId() {
      unset($this->requesting_app_id);
      return $this;
    }
    public function hasRequestingAppId() {
      return isset($this->requesting_app_id);
    }
    public function getApiSettings() {
      if (!isset($this->api_settings)) {
        return '';
      }
      return $this->api_settings;
    }
    public function setApiSettings($val) {
      $this->api_settings = $val;
      return $this;
    }
    public function clearApiSettings() {
      unset($this->api_settings);
      return $this;
    }
    public function hasApiSettings() {
      return isset($this->api_settings);
    }
    public function getRequestingProjectId() {
      if (!isset($this->requesting_project_id)) {
        return '';
      }
      return $this->requesting_project_id;
    }
    public function setRequestingProjectId($val) {
      $this->requesting_project_id = $val;
      return $this;
    }
    public function clearRequestingProjectId() {
      unset($this->requesting_project_id);
      return $this;
    }
    public function hasRequestingProjectId() {
      return isset($this->requesting_project_id);
    }
    public function getRequestingVersionId() {
      if (!isset($this->requesting_version_id)) {
        return '';
      }
      return $this->requesting_version_id;
    }
    public function setRequestingVersionId($val) {
      $this->requesting_version_id = $val;
      return $this;
    }
    public function clearRequestingVersionId() {
      unset($this->requesting_version_id);
      return $this;
    }
    public function hasRequestingVersionId() {
      return isset($this->requesting_version_id);
    }
    public function clear() {
      $this->clearRequestingAppId();
      $this->clearApiSettings();
      $this->clearRequestingProjectId();
      $this->clearRequestingVersionId();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->requesting_app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->requesting_app_id));
      }
      if (isset($this->api_settings)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->api_settings));
      }
      if (isset($this->requesting_project_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->requesting_project_id));
      }
      if (isset($this->requesting_version_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->requesting_version_id));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->requesting_app_id)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->requesting_app_id);
      }
      if (isset($this->api_settings)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->api_settings);
      }
      if (isset($this->requesting_project_id)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->requesting_project_id);
      }
      if (isset($this->requesting_version_id)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->requesting_version_id);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 18:
            $length = $d->getVarInt32();
            $this->setRequestingAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setApiSettings(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setRequestingProjectId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setRequestingVersionId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasRequestingAppId()) {
        $this->setRequestingAppId($x->getRequestingAppId());
      }
      if ($x->hasApiSettings()) {
        $this->setApiSettings($x->getApiSettings());
      }
      if ($x->hasRequestingProjectId()) {
        $this->setRequestingProjectId($x->getRequestingProjectId());
      }
      if ($x->hasRequestingVersionId()) {
        $this->setRequestingVersionId($x->getRequestingVersionId());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->requesting_app_id) !== isset($x->requesting_app_id)) return false;
      if (isset($this->requesting_app_id) && $this->requesting_app_id !== $x->requesting_app_id) return false;
      if (isset($this->api_settings) !== isset($x->api_settings)) return false;
      if (isset($this->api_settings) && $this->api_settings !== $x->api_settings) return false;
      if (isset($this->requesting_project_id) !== isset($x->requesting_project_id)) return false;
      if (isset($this->requesting_project_id) && $this->requesting_project_id !== $x->requesting_project_id) return false;
      if (isset($this->requesting_version_id) !== isset($x->requesting_version_id)) return false;
      if (isset($this->requesting_version_id) && $this->requesting_version_id !== $x->requesting_version_id) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->requesting_app_id)) {
        $res .= $prefix . "requesting_app_id: " . $this->debugFormatString($this->requesting_app_id) . "\n";
      }
      if (isset($this->api_settings)) {
        $res .= $prefix . "api_settings: " . $this->debugFormatString($this->api_settings) . "\n";
      }
      if (isset($this->requesting_project_id)) {
        $res .= $prefix . "requesting_project_id: " . $this->debugFormatString($this->requesting_project_id) . "\n";
      }
      if (isset($this->requesting_version_id)) {
        $res .= $prefix . "requesting_version_id: " . $this->debugFormatString($this->requesting_version_id) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class Transaction extends \google\net\ProtocolMessage {
    public function getHandle() {
      if (!isset($this->handle)) {
        return "0";
      }
      return $this->handle;
    }
    public function setHandle($val) {
      if (is_double($val)) {
        $this->handle = sprintf('%0.0F', $val);
      } else {
        $this->handle = $val;
      }
      return $this;
    }
    public function clearHandle() {
      unset($this->handle);
      return $this;
    }
    public function hasHandle() {
      return isset($this->handle);
    }
    public function getApp() {
      if (!isset($this->app)) {
        return '';
      }
      return $this->app;
    }
    public function setApp($val) {
      $this->app = $val;
      return $this;
    }
    public function clearApp() {
      unset($this->app);
      return $this;
    }
    public function hasApp() {
      return isset($this->app);
    }
    public function getMarkChanges() {
      if (!isset($this->mark_changes)) {
        return false;
      }
      return $this->mark_changes;
    }
    public function setMarkChanges($val) {
      $this->mark_changes = $val;
      return $this;
    }
    public function clearMarkChanges() {
      unset($this->mark_changes);
      return $this;
    }
    public function hasMarkChanges() {
      return isset($this->mark_changes);
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearHandle();
      $this->clearApp();
      $this->clearMarkChanges();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->handle)) {
        $res += 9;
      }
      if (isset($this->app)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app));
      }
      if (isset($this->mark_changes)) {
        $res += 2;
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->handle)) {
        $out->putVarInt32(9);
        $out->put64($this->handle);
      }
      if (isset($this->app)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->app);
      }
      if (isset($this->mark_changes)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->mark_changes);
      }
      if (isset($this->header)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 9:
            $this->setHandle($d->getFixed64());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setApp(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setMarkChanges($d->getBoolean());
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->handle)) return 'handle';
      if (!isset($this->app)) return 'app';
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasHandle()) {
        $this->setHandle($x->getHandle());
      }
      if ($x->hasApp()) {
        $this->setApp($x->getApp());
      }
      if ($x->hasMarkChanges()) {
        $this->setMarkChanges($x->getMarkChanges());
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->handle) !== isset($x->handle)) return false;
      if (isset($this->handle) && !$this->integerEquals($this->handle, $x->handle)) return false;
      if (isset($this->app) !== isset($x->app)) return false;
      if (isset($this->app) && $this->app !== $x->app) return false;
      if (isset($this->mark_changes) !== isset($x->mark_changes)) return false;
      if (isset($this->mark_changes) && $this->mark_changes !== $x->mark_changes) return false;
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->handle)) {
        $res .= $prefix . "handle: " . $this->debugFormatFixed64($this->handle) . "\n";
      }
      if (isset($this->app)) {
        $res .= $prefix . "app: " . $this->debugFormatString($this->app) . "\n";
      }
      if (isset($this->mark_changes)) {
        $res .= $prefix . "mark_changes: " . $this->debugFormatBool($this->mark_changes) . "\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\Query {
  class Hint {
    const ORDER_FIRST = 1;
    const ANCESTOR_FIRST = 2;
    const FILTER_FIRST = 3;
  }
}
namespace google\appengine_datastore_v3\Query\Filter {
  class Operator {
    const LESS_THAN = 1;
    const LESS_THAN_OR_EQUAL = 2;
    const GREATER_THAN = 3;
    const GREATER_THAN_OR_EQUAL = 4;
    const EQUAL = 5;
    const IN = 6;
    const EXISTS = 7;
    const CONTAINED_IN_REGION = 8;
  }
}
namespace google\appengine_datastore_v3\Query {
  class Filter extends \google\net\ProtocolMessage {
    private $property = array();
    public function getOp() {
      if (!isset($this->op)) {
        return 1;
      }
      return $this->op;
    }
    public function setOp($val) {
      $this->op = $val;
      return $this;
    }
    public function clearOp() {
      unset($this->op);
      return $this;
    }
    public function hasOp() {
      return isset($this->op);
    }
    public function getPropertySize() {
      return sizeof($this->property);
    }
    public function getPropertyList() {
      return $this->property;
    }
    public function mutableProperty($idx) {
      if (!isset($this->property[$idx])) {
        $val = new \storage_onestore_v3\Property();
        $this->property[$idx] = $val;
        return $val;
      }
      return $this->property[$idx];
    }
    public function getProperty($idx) {
      if (isset($this->property[$idx])) {
        return $this->property[$idx];
      }
      if ($idx >= end(array_keys($this->property))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Property();
    }
    public function addProperty() {
      $val = new \storage_onestore_v3\Property();
      $this->property[] = $val;
      return $val;
    }
    public function clearProperty() {
      $this->property = array();
    }
    public function getGeoRegion() {
      if (!isset($this->geo_region)) {
        return new \google\appengine_datastore_v3\GeoRegion();
      }
      return $this->geo_region;
    }
    public function mutableGeoRegion() {
      if (!isset($this->geo_region)) {
        $res = new \google\appengine_datastore_v3\GeoRegion();
        $this->geo_region = $res;
        return $res;
      }
      return $this->geo_region;
    }
    public function clearGeoRegion() {
      if (isset($this->geo_region)) {
        unset($this->geo_region);
      }
    }
    public function hasGeoRegion() {
      return isset($this->geo_region);
    }
    public function clear() {
      $this->clearOp();
      $this->clearProperty();
      $this->clearGeoRegion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->op)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->op);
      }
      $this->checkProtoArray($this->property);
      $res += 1 * sizeof($this->property);
      foreach ($this->property as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->geo_region)) {
        $res += 2;
        $res += $this->lengthString($this->geo_region->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->op)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->op);
      }
      $this->checkProtoArray($this->property);
      foreach ($this->property as $value) {
        $out->putVarInt32(114);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->geo_region)) {
        $out->putVarInt32(322);
        $out->putVarInt32($this->geo_region->byteSizePartial());
        $this->geo_region->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 36: return;
          case 48:
            $this->setOp($d->getVarInt32());
            break;
          case 114:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addProperty()->tryMerge($tmp);
            break;
          case 322:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableGeoRegion()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->op)) return 'op';
      foreach ($this->property as $value) {
        if (!$value->isInitialized()) return 'property';
      }
      if (isset($this->geo_region) && (!$this->geo_region->isInitialized())) return 'geo_region';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasOp()) {
        $this->setOp($x->getOp());
      }
      foreach ($x->getPropertyList() as $v) {
        $this->addProperty()->copyFrom($v);
      }
      if ($x->hasGeoRegion()) {
        $this->mutableGeoRegion()->mergeFrom($x->getGeoRegion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->op) !== isset($x->op)) return false;
      if (isset($this->op) && $this->op !== $x->op) return false;
      if (sizeof($this->property) !== sizeof($x->property)) return false;
      foreach (array_map(null, $this->property, $x->property) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->geo_region) !== isset($x->geo_region)) return false;
      if (isset($this->geo_region) && !$this->geo_region->equals($x->geo_region)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->op)) {
        $res .= $prefix . "op: " . ($this->op) . "\n";
      }
      foreach ($this->property as $value) {
        $res .= $prefix . "property <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->geo_region)) {
        $res .= $prefix . "geo_region <\n" . $this->geo_region->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\Query\Order {
  class Direction {
    const ASCENDING = 1;
    const DESCENDING = 2;
  }
}
namespace google\appengine_datastore_v3\Query {
  class Order extends \google\net\ProtocolMessage {
    public function getProperty() {
      if (!isset($this->property)) {
        return '';
      }
      return $this->property;
    }
    public function setProperty($val) {
      $this->property = $val;
      return $this;
    }
    public function clearProperty() {
      unset($this->property);
      return $this;
    }
    public function hasProperty() {
      return isset($this->property);
    }
    public function getDirection() {
      if (!isset($this->direction)) {
        return 1;
      }
      return $this->direction;
    }
    public function setDirection($val) {
      $this->direction = $val;
      return $this;
    }
    public function clearDirection() {
      unset($this->direction);
      return $this;
    }
    public function hasDirection() {
      return isset($this->direction);
    }
    public function clear() {
      $this->clearProperty();
      $this->clearDirection();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->property));
      }
      if (isset($this->direction)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->direction);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property)) {
        $out->putVarInt32(82);
        $out->putPrefixedString($this->property);
      }
      if (isset($this->direction)) {
        $out->putVarInt32(88);
        $out->putVarInt32($this->direction);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 76: return;
          case 82:
            $length = $d->getVarInt32();
            $this->setProperty(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 88:
            $this->setDirection($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->property)) return 'property';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasProperty()) {
        $this->setProperty($x->getProperty());
      }
      if ($x->hasDirection()) {
        $this->setDirection($x->getDirection());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property) !== isset($x->property)) return false;
      if (isset($this->property) && $this->property !== $x->property) return false;
      if (isset($this->direction) !== isset($x->direction)) return false;
      if (isset($this->direction) && $this->direction !== $x->direction) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property)) {
        $res .= $prefix . "property: " . $this->debugFormatString($this->property) . "\n";
      }
      if (isset($this->direction)) {
        $res .= $prefix . "direction: " . ($this->direction) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class Query extends \google\net\ProtocolMessage {
    private $filter = array();
    private $order = array();
    private $composite_index = array();
    private $property_name = array();
    private $group_by_property_name = array();
    private $safe_replica_name = array();
    public function getApp() {
      if (!isset($this->app)) {
        return '';
      }
      return $this->app;
    }
    public function setApp($val) {
      $this->app = $val;
      return $this;
    }
    public function clearApp() {
      unset($this->app);
      return $this;
    }
    public function hasApp() {
      return isset($this->app);
    }
    public function getKind() {
      if (!isset($this->kind)) {
        return '';
      }
      return $this->kind;
    }
    public function setKind($val) {
      $this->kind = $val;
      return $this;
    }
    public function clearKind() {
      unset($this->kind);
      return $this;
    }
    public function hasKind() {
      return isset($this->kind);
    }
    public function getFilterSize() {
      return sizeof($this->filter);
    }
    public function getFilterList() {
      return $this->filter;
    }
    public function mutableFilter($idx) {
      if (!isset($this->filter[$idx])) {
        $val = new \google\appengine_datastore_v3\Query\Filter();
        $this->filter[$idx] = $val;
        return $val;
      }
      return $this->filter[$idx];
    }
    public function getFilter($idx) {
      if (isset($this->filter[$idx])) {
        return $this->filter[$idx];
      }
      if ($idx >= end(array_keys($this->filter))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine_datastore_v3\Query\Filter();
    }
    public function addFilter() {
      $val = new \google\appengine_datastore_v3\Query\Filter();
      $this->filter[] = $val;
      return $val;
    }
    public function clearFilter() {
      $this->filter = array();
    }
    public function getSearchQuery() {
      if (!isset($this->search_query)) {
        return '';
      }
      return $this->search_query;
    }
    public function setSearchQuery($val) {
      $this->search_query = $val;
      return $this;
    }
    public function clearSearchQuery() {
      unset($this->search_query);
      return $this;
    }
    public function hasSearchQuery() {
      return isset($this->search_query);
    }
    public function getOrderSize() {
      return sizeof($this->order);
    }
    public function getOrderList() {
      return $this->order;
    }
    public function mutableOrder($idx) {
      if (!isset($this->order[$idx])) {
        $val = new \google\appengine_datastore_v3\Query\Order();
        $this->order[$idx] = $val;
        return $val;
      }
      return $this->order[$idx];
    }
    public function getOrder($idx) {
      if (isset($this->order[$idx])) {
        return $this->order[$idx];
      }
      if ($idx >= end(array_keys($this->order))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine_datastore_v3\Query\Order();
    }
    public function addOrder() {
      $val = new \google\appengine_datastore_v3\Query\Order();
      $this->order[] = $val;
      return $val;
    }
    public function clearOrder() {
      $this->order = array();
    }
    public function getOffset() {
      if (!isset($this->offset)) {
        return 0;
      }
      return $this->offset;
    }
    public function setOffset($val) {
      $this->offset = $val;
      return $this;
    }
    public function clearOffset() {
      unset($this->offset);
      return $this;
    }
    public function hasOffset() {
      return isset($this->offset);
    }
    public function getLimit() {
      if (!isset($this->limit)) {
        return 0;
      }
      return $this->limit;
    }
    public function setLimit($val) {
      $this->limit = $val;
      return $this;
    }
    public function clearLimit() {
      unset($this->limit);
      return $this;
    }
    public function hasLimit() {
      return isset($this->limit);
    }
    public function getAncestor() {
      if (!isset($this->ancestor)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->ancestor;
    }
    public function mutableAncestor() {
      if (!isset($this->ancestor)) {
        $res = new \storage_onestore_v3\Reference();
        $this->ancestor = $res;
        return $res;
      }
      return $this->ancestor;
    }
    public function clearAncestor() {
      if (isset($this->ancestor)) {
        unset($this->ancestor);
      }
    }
    public function hasAncestor() {
      return isset($this->ancestor);
    }
    public function getHint() {
      if (!isset($this->hint)) {
        return 1;
      }
      return $this->hint;
    }
    public function setHint($val) {
      $this->hint = $val;
      return $this;
    }
    public function clearHint() {
      unset($this->hint);
      return $this;
    }
    public function hasHint() {
      return isset($this->hint);
    }
    public function getCompositeIndexSize() {
      return sizeof($this->composite_index);
    }
    public function getCompositeIndexList() {
      return $this->composite_index;
    }
    public function mutableCompositeIndex($idx) {
      if (!isset($this->composite_index[$idx])) {
        $val = new \storage_onestore_v3\CompositeIndex();
        $this->composite_index[$idx] = $val;
        return $val;
      }
      return $this->composite_index[$idx];
    }
    public function getCompositeIndex($idx) {
      if (isset($this->composite_index[$idx])) {
        return $this->composite_index[$idx];
      }
      if ($idx >= end(array_keys($this->composite_index))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\CompositeIndex();
    }
    public function addCompositeIndex() {
      $val = new \storage_onestore_v3\CompositeIndex();
      $this->composite_index[] = $val;
      return $val;
    }
    public function clearCompositeIndex() {
      $this->composite_index = array();
    }
    public function getRequirePerfectPlan() {
      if (!isset($this->require_perfect_plan)) {
        return false;
      }
      return $this->require_perfect_plan;
    }
    public function setRequirePerfectPlan($val) {
      $this->require_perfect_plan = $val;
      return $this;
    }
    public function clearRequirePerfectPlan() {
      unset($this->require_perfect_plan);
      return $this;
    }
    public function hasRequirePerfectPlan() {
      return isset($this->require_perfect_plan);
    }
    public function getKeysOnly() {
      if (!isset($this->keys_only)) {
        return false;
      }
      return $this->keys_only;
    }
    public function setKeysOnly($val) {
      $this->keys_only = $val;
      return $this;
    }
    public function clearKeysOnly() {
      unset($this->keys_only);
      return $this;
    }
    public function hasKeysOnly() {
      return isset($this->keys_only);
    }
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return new \google\appengine_datastore_v3\Transaction();
      }
      return $this->transaction;
    }
    public function mutableTransaction() {
      if (!isset($this->transaction)) {
        $res = new \google\appengine_datastore_v3\Transaction();
        $this->transaction = $res;
        return $res;
      }
      return $this->transaction;
    }
    public function clearTransaction() {
      if (isset($this->transaction)) {
        unset($this->transaction);
      }
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function getCount() {
      if (!isset($this->count)) {
        return 0;
      }
      return $this->count;
    }
    public function setCount($val) {
      $this->count = $val;
      return $this;
    }
    public function clearCount() {
      unset($this->count);
      return $this;
    }
    public function hasCount() {
      return isset($this->count);
    }
    public function getDistinct() {
      if (!isset($this->distinct)) {
        return false;
      }
      return $this->distinct;
    }
    public function setDistinct($val) {
      $this->distinct = $val;
      return $this;
    }
    public function clearDistinct() {
      unset($this->distinct);
      return $this;
    }
    public function hasDistinct() {
      return isset($this->distinct);
    }
    public function getCompile() {
      if (!isset($this->compile)) {
        return false;
      }
      return $this->compile;
    }
    public function setCompile($val) {
      $this->compile = $val;
      return $this;
    }
    public function clearCompile() {
      unset($this->compile);
      return $this;
    }
    public function hasCompile() {
      return isset($this->compile);
    }
    public function getFailoverMs() {
      if (!isset($this->failover_ms)) {
        return "0";
      }
      return $this->failover_ms;
    }
    public function setFailoverMs($val) {
      if (is_double($val)) {
        $this->failover_ms = sprintf('%0.0F', $val);
      } else {
        $this->failover_ms = $val;
      }
      return $this;
    }
    public function clearFailoverMs() {
      unset($this->failover_ms);
      return $this;
    }
    public function hasFailoverMs() {
      return isset($this->failover_ms);
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function getCompiledCursor() {
      if (!isset($this->compiled_cursor)) {
        return new \google\appengine_datastore_v3\CompiledCursor();
      }
      return $this->compiled_cursor;
    }
    public function mutableCompiledCursor() {
      if (!isset($this->compiled_cursor)) {
        $res = new \google\appengine_datastore_v3\CompiledCursor();
        $this->compiled_cursor = $res;
        return $res;
      }
      return $this->compiled_cursor;
    }
    public function clearCompiledCursor() {
      if (isset($this->compiled_cursor)) {
        unset($this->compiled_cursor);
      }
    }
    public function hasCompiledCursor() {
      return isset($this->compiled_cursor);
    }
    public function getEndCompiledCursor() {
      if (!isset($this->end_compiled_cursor)) {
        return new \google\appengine_datastore_v3\CompiledCursor();
      }
      return $this->end_compiled_cursor;
    }
    public function mutableEndCompiledCursor() {
      if (!isset($this->end_compiled_cursor)) {
        $res = new \google\appengine_datastore_v3\CompiledCursor();
        $this->end_compiled_cursor = $res;
        return $res;
      }
      return $this->end_compiled_cursor;
    }
    public function clearEndCompiledCursor() {
      if (isset($this->end_compiled_cursor)) {
        unset($this->end_compiled_cursor);
      }
    }
    public function hasEndCompiledCursor() {
      return isset($this->end_compiled_cursor);
    }
    public function getStrong() {
      if (!isset($this->strong)) {
        return false;
      }
      return $this->strong;
    }
    public function setStrong($val) {
      $this->strong = $val;
      return $this;
    }
    public function clearStrong() {
      unset($this->strong);
      return $this;
    }
    public function hasStrong() {
      return isset($this->strong);
    }
    public function getPropertyNameSize() {
      return sizeof($this->property_name);
    }
    public function getPropertyNameList() {
      return $this->property_name;
    }
    public function getPropertyName($idx) {
      return $this->property_name[$idx];
    }
    public function setPropertyName($idx, $val) {
      $this->property_name[$idx] = $val;
      return $this;
    }
    public function addPropertyName($val) {
      $this->property_name[] = $val;
      return $this;
    }
    public function clearPropertyName() {
      $this->property_name = array();
    }
    public function getGroupByPropertyNameSize() {
      return sizeof($this->group_by_property_name);
    }
    public function getGroupByPropertyNameList() {
      return $this->group_by_property_name;
    }
    public function getGroupByPropertyName($idx) {
      return $this->group_by_property_name[$idx];
    }
    public function setGroupByPropertyName($idx, $val) {
      $this->group_by_property_name[$idx] = $val;
      return $this;
    }
    public function addGroupByPropertyName($val) {
      $this->group_by_property_name[] = $val;
      return $this;
    }
    public function clearGroupByPropertyName() {
      $this->group_by_property_name = array();
    }
    public function getMinSafeTimeSeconds() {
      if (!isset($this->min_safe_time_seconds)) {
        return "0";
      }
      return $this->min_safe_time_seconds;
    }
    public function setMinSafeTimeSeconds($val) {
      if (is_double($val)) {
        $this->min_safe_time_seconds = sprintf('%0.0F', $val);
      } else {
        $this->min_safe_time_seconds = $val;
      }
      return $this;
    }
    public function clearMinSafeTimeSeconds() {
      unset($this->min_safe_time_seconds);
      return $this;
    }
    public function hasMinSafeTimeSeconds() {
      return isset($this->min_safe_time_seconds);
    }
    public function getSafeReplicaNameSize() {
      return sizeof($this->safe_replica_name);
    }
    public function getSafeReplicaNameList() {
      return $this->safe_replica_name;
    }
    public function getSafeReplicaName($idx) {
      return $this->safe_replica_name[$idx];
    }
    public function setSafeReplicaName($idx, $val) {
      $this->safe_replica_name[$idx] = $val;
      return $this;
    }
    public function addSafeReplicaName($val) {
      $this->safe_replica_name[] = $val;
      return $this;
    }
    public function clearSafeReplicaName() {
      $this->safe_replica_name = array();
    }
    public function getPersistOffset() {
      if (!isset($this->persist_offset)) {
        return true;
      }
      return $this->persist_offset;
    }
    public function setPersistOffset($val) {
      $this->persist_offset = $val;
      return $this;
    }
    public function clearPersistOffset() {
      unset($this->persist_offset);
      return $this;
    }
    public function hasPersistOffset() {
      return isset($this->persist_offset);
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearApp();
      $this->clearKind();
      $this->clearFilter();
      $this->clearSearchQuery();
      $this->clearOrder();
      $this->clearOffset();
      $this->clearLimit();
      $this->clearAncestor();
      $this->clearHint();
      $this->clearCompositeIndex();
      $this->clearRequirePerfectPlan();
      $this->clearKeysOnly();
      $this->clearTransaction();
      $this->clearCount();
      $this->clearDistinct();
      $this->clearCompile();
      $this->clearFailoverMs();
      $this->clearNameSpace();
      $this->clearCompiledCursor();
      $this->clearEndCompiledCursor();
      $this->clearStrong();
      $this->clearPropertyName();
      $this->clearGroupByPropertyName();
      $this->clearMinSafeTimeSeconds();
      $this->clearSafeReplicaName();
      $this->clearPersistOffset();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app));
      }
      if (isset($this->kind)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->kind));
      }
      $this->checkProtoArray($this->filter);
      $res += 2 * sizeof($this->filter);
      foreach ($this->filter as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->search_query)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->search_query));
      }
      $this->checkProtoArray($this->order);
      $res += 2 * sizeof($this->order);
      foreach ($this->order as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->offset)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->offset);
      }
      if (isset($this->limit)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->limit);
      }
      if (isset($this->ancestor)) {
        $res += 2;
        $res += $this->lengthString($this->ancestor->byteSizePartial());
      }
      if (isset($this->hint)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->hint);
      }
      $this->checkProtoArray($this->composite_index);
      $res += 2 * sizeof($this->composite_index);
      foreach ($this->composite_index as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->require_perfect_plan)) {
        $res += 3;
      }
      if (isset($this->keys_only)) {
        $res += 3;
      }
      if (isset($this->transaction)) {
        $res += 2;
        $res += $this->lengthString($this->transaction->byteSizePartial());
      }
      if (isset($this->count)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->count);
      }
      if (isset($this->distinct)) {
        $res += 3;
      }
      if (isset($this->compile)) {
        $res += 3;
      }
      if (isset($this->failover_ms)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->failover_ms);
      }
      if (isset($this->name_space)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->name_space));
      }
      if (isset($this->compiled_cursor)) {
        $res += 2;
        $res += $this->lengthString($this->compiled_cursor->byteSizePartial());
      }
      if (isset($this->end_compiled_cursor)) {
        $res += 2;
        $res += $this->lengthString($this->end_compiled_cursor->byteSizePartial());
      }
      if (isset($this->strong)) {
        $res += 3;
      }
      $this->checkProtoArray($this->property_name);
      $res += 2 * sizeof($this->property_name);
      foreach ($this->property_name as $value) {
        $res += $this->lengthString(strlen($value));
      }
      $this->checkProtoArray($this->group_by_property_name);
      $res += 2 * sizeof($this->group_by_property_name);
      foreach ($this->group_by_property_name as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->min_safe_time_seconds)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->min_safe_time_seconds);
      }
      $this->checkProtoArray($this->safe_replica_name);
      $res += 2 * sizeof($this->safe_replica_name);
      foreach ($this->safe_replica_name as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->persist_offset)) {
        $res += 3;
      }
      if (isset($this->header)) {
        $res += 2;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app);
      }
      if (isset($this->kind)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->kind);
      }
      $this->checkProtoArray($this->filter);
      foreach ($this->filter as $value) {
        $out->putVarInt32(35);
        $value->outputPartial($out);
        $out->putVarInt32(36);
      }
      if (isset($this->search_query)) {
        $out->putVarInt32(66);
        $out->putPrefixedString($this->search_query);
      }
      $this->checkProtoArray($this->order);
      foreach ($this->order as $value) {
        $out->putVarInt32(75);
        $value->outputPartial($out);
        $out->putVarInt32(76);
      }
      if (isset($this->offset)) {
        $out->putVarInt32(96);
        $out->putVarInt32($this->offset);
      }
      if (isset($this->limit)) {
        $out->putVarInt32(128);
        $out->putVarInt32($this->limit);
      }
      if (isset($this->ancestor)) {
        $out->putVarInt32(138);
        $out->putVarInt32($this->ancestor->byteSizePartial());
        $this->ancestor->outputPartial($out);
      }
      if (isset($this->hint)) {
        $out->putVarInt32(144);
        $out->putVarInt32($this->hint);
      }
      $this->checkProtoArray($this->composite_index);
      foreach ($this->composite_index as $value) {
        $out->putVarInt32(154);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->require_perfect_plan)) {
        $out->putVarInt32(160);
        $out->putBoolean($this->require_perfect_plan);
      }
      if (isset($this->keys_only)) {
        $out->putVarInt32(168);
        $out->putBoolean($this->keys_only);
      }
      if (isset($this->transaction)) {
        $out->putVarInt32(178);
        $out->putVarInt32($this->transaction->byteSizePartial());
        $this->transaction->outputPartial($out);
      }
      if (isset($this->count)) {
        $out->putVarInt32(184);
        $out->putVarInt32($this->count);
      }
      if (isset($this->distinct)) {
        $out->putVarInt32(192);
        $out->putBoolean($this->distinct);
      }
      if (isset($this->compile)) {
        $out->putVarInt32(200);
        $out->putBoolean($this->compile);
      }
      if (isset($this->failover_ms)) {
        $out->putVarInt32(208);
        $out->putVarInt64($this->failover_ms);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(234);
        $out->putPrefixedString($this->name_space);
      }
      if (isset($this->compiled_cursor)) {
        $out->putVarInt32(242);
        $out->putVarInt32($this->compiled_cursor->byteSizePartial());
        $this->compiled_cursor->outputPartial($out);
      }
      if (isset($this->end_compiled_cursor)) {
        $out->putVarInt32(250);
        $out->putVarInt32($this->end_compiled_cursor->byteSizePartial());
        $this->end_compiled_cursor->outputPartial($out);
      }
      if (isset($this->strong)) {
        $out->putVarInt32(256);
        $out->putBoolean($this->strong);
      }
      $this->checkProtoArray($this->property_name);
      foreach ($this->property_name as $value) {
        $out->putVarInt32(266);
        $out->putPrefixedString($value);
      }
      $this->checkProtoArray($this->group_by_property_name);
      foreach ($this->group_by_property_name as $value) {
        $out->putVarInt32(274);
        $out->putPrefixedString($value);
      }
      if (isset($this->min_safe_time_seconds)) {
        $out->putVarInt32(280);
        $out->putVarInt64($this->min_safe_time_seconds);
      }
      $this->checkProtoArray($this->safe_replica_name);
      foreach ($this->safe_replica_name as $value) {
        $out->putVarInt32(290);
        $out->putPrefixedString($value);
      }
      if (isset($this->persist_offset)) {
        $out->putVarInt32(296);
        $out->putBoolean($this->persist_offset);
      }
      if (isset($this->header)) {
        $out->putVarInt32(314);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setApp(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setKind(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 35:
            $this->addFilter()->tryMerge($d);
            break;
          case 66:
            $length = $d->getVarInt32();
            $this->setSearchQuery(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 75:
            $this->addOrder()->tryMerge($d);
            break;
          case 96:
            $this->setOffset($d->getVarInt32());
            break;
          case 128:
            $this->setLimit($d->getVarInt32());
            break;
          case 138:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableAncestor()->tryMerge($tmp);
            break;
          case 144:
            $this->setHint($d->getVarInt32());
            break;
          case 154:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addCompositeIndex()->tryMerge($tmp);
            break;
          case 160:
            $this->setRequirePerfectPlan($d->getBoolean());
            break;
          case 168:
            $this->setKeysOnly($d->getBoolean());
            break;
          case 178:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableTransaction()->tryMerge($tmp);
            break;
          case 184:
            $this->setCount($d->getVarInt32());
            break;
          case 192:
            $this->setDistinct($d->getBoolean());
            break;
          case 200:
            $this->setCompile($d->getBoolean());
            break;
          case 208:
            $this->setFailoverMs($d->getVarInt64());
            break;
          case 234:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 242:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCompiledCursor()->tryMerge($tmp);
            break;
          case 250:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEndCompiledCursor()->tryMerge($tmp);
            break;
          case 256:
            $this->setStrong($d->getBoolean());
            break;
          case 266:
            $length = $d->getVarInt32();
            $this->addPropertyName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 274:
            $length = $d->getVarInt32();
            $this->addGroupByPropertyName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 280:
            $this->setMinSafeTimeSeconds($d->getVarInt64());
            break;
          case 290:
            $length = $d->getVarInt32();
            $this->addSafeReplicaName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 296:
            $this->setPersistOffset($d->getBoolean());
            break;
          case 314:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app)) return 'app';
      foreach ($this->filter as $value) {
        if (!$value->isInitialized()) return 'filter';
      }
      foreach ($this->order as $value) {
        if (!$value->isInitialized()) return 'order';
      }
      if (isset($this->ancestor) && (!$this->ancestor->isInitialized())) return 'ancestor';
      foreach ($this->composite_index as $value) {
        if (!$value->isInitialized()) return 'composite_index';
      }
      if (isset($this->transaction) && (!$this->transaction->isInitialized())) return 'transaction';
      if (isset($this->compiled_cursor) && (!$this->compiled_cursor->isInitialized())) return 'compiled_cursor';
      if (isset($this->end_compiled_cursor) && (!$this->end_compiled_cursor->isInitialized())) return 'end_compiled_cursor';
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasApp()) {
        $this->setApp($x->getApp());
      }
      if ($x->hasKind()) {
        $this->setKind($x->getKind());
      }
      foreach ($x->getFilterList() as $v) {
        $this->addFilter()->copyFrom($v);
      }
      if ($x->hasSearchQuery()) {
        $this->setSearchQuery($x->getSearchQuery());
      }
      foreach ($x->getOrderList() as $v) {
        $this->addOrder()->copyFrom($v);
      }
      if ($x->hasOffset()) {
        $this->setOffset($x->getOffset());
      }
      if ($x->hasLimit()) {
        $this->setLimit($x->getLimit());
      }
      if ($x->hasAncestor()) {
        $this->mutableAncestor()->mergeFrom($x->getAncestor());
      }
      if ($x->hasHint()) {
        $this->setHint($x->getHint());
      }
      foreach ($x->getCompositeIndexList() as $v) {
        $this->addCompositeIndex()->copyFrom($v);
      }
      if ($x->hasRequirePerfectPlan()) {
        $this->setRequirePerfectPlan($x->getRequirePerfectPlan());
      }
      if ($x->hasKeysOnly()) {
        $this->setKeysOnly($x->getKeysOnly());
      }
      if ($x->hasTransaction()) {
        $this->mutableTransaction()->mergeFrom($x->getTransaction());
      }
      if ($x->hasCount()) {
        $this->setCount($x->getCount());
      }
      if ($x->hasDistinct()) {
        $this->setDistinct($x->getDistinct());
      }
      if ($x->hasCompile()) {
        $this->setCompile($x->getCompile());
      }
      if ($x->hasFailoverMs()) {
        $this->setFailoverMs($x->getFailoverMs());
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
      if ($x->hasCompiledCursor()) {
        $this->mutableCompiledCursor()->mergeFrom($x->getCompiledCursor());
      }
      if ($x->hasEndCompiledCursor()) {
        $this->mutableEndCompiledCursor()->mergeFrom($x->getEndCompiledCursor());
      }
      if ($x->hasStrong()) {
        $this->setStrong($x->getStrong());
      }
      foreach ($x->getPropertyNameList() as $v) {
        $this->addPropertyName($v);
      }
      foreach ($x->getGroupByPropertyNameList() as $v) {
        $this->addGroupByPropertyName($v);
      }
      if ($x->hasMinSafeTimeSeconds()) {
        $this->setMinSafeTimeSeconds($x->getMinSafeTimeSeconds());
      }
      foreach ($x->getSafeReplicaNameList() as $v) {
        $this->addSafeReplicaName($v);
      }
      if ($x->hasPersistOffset()) {
        $this->setPersistOffset($x->getPersistOffset());
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app) !== isset($x->app)) return false;
      if (isset($this->app) && $this->app !== $x->app) return false;
      if (isset($this->kind) !== isset($x->kind)) return false;
      if (isset($this->kind) && $this->kind !== $x->kind) return false;
      if (sizeof($this->filter) !== sizeof($x->filter)) return false;
      foreach (array_map(null, $this->filter, $x->filter) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->search_query) !== isset($x->search_query)) return false;
      if (isset($this->search_query) && $this->search_query !== $x->search_query) return false;
      if (sizeof($this->order) !== sizeof($x->order)) return false;
      foreach (array_map(null, $this->order, $x->order) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->offset) !== isset($x->offset)) return false;
      if (isset($this->offset) && !$this->integerEquals($this->offset, $x->offset)) return false;
      if (isset($this->limit) !== isset($x->limit)) return false;
      if (isset($this->limit) && !$this->integerEquals($this->limit, $x->limit)) return false;
      if (isset($this->ancestor) !== isset($x->ancestor)) return false;
      if (isset($this->ancestor) && !$this->ancestor->equals($x->ancestor)) return false;
      if (isset($this->hint) !== isset($x->hint)) return false;
      if (isset($this->hint) && $this->hint !== $x->hint) return false;
      if (sizeof($this->composite_index) !== sizeof($x->composite_index)) return false;
      foreach (array_map(null, $this->composite_index, $x->composite_index) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->require_perfect_plan) !== isset($x->require_perfect_plan)) return false;
      if (isset($this->require_perfect_plan) && $this->require_perfect_plan !== $x->require_perfect_plan) return false;
      if (isset($this->keys_only) !== isset($x->keys_only)) return false;
      if (isset($this->keys_only) && $this->keys_only !== $x->keys_only) return false;
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && !$this->transaction->equals($x->transaction)) return false;
      if (isset($this->count) !== isset($x->count)) return false;
      if (isset($this->count) && !$this->integerEquals($this->count, $x->count)) return false;
      if (isset($this->distinct) !== isset($x->distinct)) return false;
      if (isset($this->distinct) && $this->distinct !== $x->distinct) return false;
      if (isset($this->compile) !== isset($x->compile)) return false;
      if (isset($this->compile) && $this->compile !== $x->compile) return false;
      if (isset($this->failover_ms) !== isset($x->failover_ms)) return false;
      if (isset($this->failover_ms) && !$this->integerEquals($this->failover_ms, $x->failover_ms)) return false;
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      if (isset($this->compiled_cursor) !== isset($x->compiled_cursor)) return false;
      if (isset($this->compiled_cursor) && !$this->compiled_cursor->equals($x->compiled_cursor)) return false;
      if (isset($this->end_compiled_cursor) !== isset($x->end_compiled_cursor)) return false;
      if (isset($this->end_compiled_cursor) && !$this->end_compiled_cursor->equals($x->end_compiled_cursor)) return false;
      if (isset($this->strong) !== isset($x->strong)) return false;
      if (isset($this->strong) && $this->strong !== $x->strong) return false;
      if (sizeof($this->property_name) !== sizeof($x->property_name)) return false;
      foreach (array_map(null, $this->property_name, $x->property_name) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (sizeof($this->group_by_property_name) !== sizeof($x->group_by_property_name)) return false;
      foreach (array_map(null, $this->group_by_property_name, $x->group_by_property_name) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->min_safe_time_seconds) !== isset($x->min_safe_time_seconds)) return false;
      if (isset($this->min_safe_time_seconds) && !$this->integerEquals($this->min_safe_time_seconds, $x->min_safe_time_seconds)) return false;
      if (sizeof($this->safe_replica_name) !== sizeof($x->safe_replica_name)) return false;
      foreach (array_map(null, $this->safe_replica_name, $x->safe_replica_name) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->persist_offset) !== isset($x->persist_offset)) return false;
      if (isset($this->persist_offset) && $this->persist_offset !== $x->persist_offset) return false;
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app)) {
        $res .= $prefix . "app: " . $this->debugFormatString($this->app) . "\n";
      }
      if (isset($this->kind)) {
        $res .= $prefix . "kind: " . $this->debugFormatString($this->kind) . "\n";
      }
      foreach ($this->filter as $value) {
        $res .= $prefix . "Filter {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->search_query)) {
        $res .= $prefix . "search_query: " . $this->debugFormatString($this->search_query) . "\n";
      }
      foreach ($this->order as $value) {
        $res .= $prefix . "Order {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->offset)) {
        $res .= $prefix . "offset: " . $this->debugFormatInt32($this->offset) . "\n";
      }
      if (isset($this->limit)) {
        $res .= $prefix . "limit: " . $this->debugFormatInt32($this->limit) . "\n";
      }
      if (isset($this->ancestor)) {
        $res .= $prefix . "ancestor <\n" . $this->ancestor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->hint)) {
        $res .= $prefix . "hint: " . ($this->hint) . "\n";
      }
      foreach ($this->composite_index as $value) {
        $res .= $prefix . "composite_index <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->require_perfect_plan)) {
        $res .= $prefix . "require_perfect_plan: " . $this->debugFormatBool($this->require_perfect_plan) . "\n";
      }
      if (isset($this->keys_only)) {
        $res .= $prefix . "keys_only: " . $this->debugFormatBool($this->keys_only) . "\n";
      }
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction <\n" . $this->transaction->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->count)) {
        $res .= $prefix . "count: " . $this->debugFormatInt32($this->count) . "\n";
      }
      if (isset($this->distinct)) {
        $res .= $prefix . "distinct: " . $this->debugFormatBool($this->distinct) . "\n";
      }
      if (isset($this->compile)) {
        $res .= $prefix . "compile: " . $this->debugFormatBool($this->compile) . "\n";
      }
      if (isset($this->failover_ms)) {
        $res .= $prefix . "failover_ms: " . $this->debugFormatInt64($this->failover_ms) . "\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      if (isset($this->compiled_cursor)) {
        $res .= $prefix . "compiled_cursor <\n" . $this->compiled_cursor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->end_compiled_cursor)) {
        $res .= $prefix . "end_compiled_cursor <\n" . $this->end_compiled_cursor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->strong)) {
        $res .= $prefix . "strong: " . $this->debugFormatBool($this->strong) . "\n";
      }
      foreach ($this->property_name as $value) {
        $res .= $prefix . "property_name: " . $this->debugFormatString($value) . "\n";
      }
      foreach ($this->group_by_property_name as $value) {
        $res .= $prefix . "group_by_property_name: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->min_safe_time_seconds)) {
        $res .= $prefix . "min_safe_time_seconds: " . $this->debugFormatInt64($this->min_safe_time_seconds) . "\n";
      }
      foreach ($this->safe_replica_name as $value) {
        $res .= $prefix . "safe_replica_name: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->persist_offset)) {
        $res .= $prefix . "persist_offset: " . $this->debugFormatBool($this->persist_offset) . "\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class RegionPoint extends \google\net\ProtocolMessage {
    public function getLatitude() {
      if (!isset($this->latitude)) {
        return 0.0;
      }
      return $this->latitude;
    }
    public function setLatitude($val) {
      $this->latitude = $val;
      return $this;
    }
    public function clearLatitude() {
      unset($this->latitude);
      return $this;
    }
    public function hasLatitude() {
      return isset($this->latitude);
    }
    public function getLongitude() {
      if (!isset($this->longitude)) {
        return 0.0;
      }
      return $this->longitude;
    }
    public function setLongitude($val) {
      $this->longitude = $val;
      return $this;
    }
    public function clearLongitude() {
      unset($this->longitude);
      return $this;
    }
    public function hasLongitude() {
      return isset($this->longitude);
    }
    public function clear() {
      $this->clearLatitude();
      $this->clearLongitude();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->latitude)) {
        $res += 9;
      }
      if (isset($this->longitude)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->latitude)) {
        $out->putVarInt32(9);
        $out->putDouble($this->latitude);
      }
      if (isset($this->longitude)) {
        $out->putVarInt32(17);
        $out->putDouble($this->longitude);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 9:
            $this->setLatitude($d->getDouble());
            break;
          case 17:
            $this->setLongitude($d->getDouble());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->latitude)) return 'latitude';
      if (!isset($this->longitude)) return 'longitude';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasLatitude()) {
        $this->setLatitude($x->getLatitude());
      }
      if ($x->hasLongitude()) {
        $this->setLongitude($x->getLongitude());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->latitude) !== isset($x->latitude)) return false;
      if (isset($this->latitude) && $this->latitude !== $x->latitude) return false;
      if (isset($this->longitude) !== isset($x->longitude)) return false;
      if (isset($this->longitude) && $this->longitude !== $x->longitude) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->latitude)) {
        $res .= $prefix . "latitude: " . $this->debugFormatDouble($this->latitude) . "\n";
      }
      if (isset($this->longitude)) {
        $res .= $prefix . "longitude: " . $this->debugFormatDouble($this->longitude) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class CircleRegion extends \google\net\ProtocolMessage {
    public function getCenter() {
      if (!isset($this->center)) {
        return new \google\appengine_datastore_v3\RegionPoint();
      }
      return $this->center;
    }
    public function mutableCenter() {
      if (!isset($this->center)) {
        $res = new \google\appengine_datastore_v3\RegionPoint();
        $this->center = $res;
        return $res;
      }
      return $this->center;
    }
    public function clearCenter() {
      if (isset($this->center)) {
        unset($this->center);
      }
    }
    public function hasCenter() {
      return isset($this->center);
    }
    public function getRadiusMeters() {
      if (!isset($this->radius_meters)) {
        return 0.0;
      }
      return $this->radius_meters;
    }
    public function setRadiusMeters($val) {
      $this->radius_meters = $val;
      return $this;
    }
    public function clearRadiusMeters() {
      unset($this->radius_meters);
      return $this;
    }
    public function hasRadiusMeters() {
      return isset($this->radius_meters);
    }
    public function clear() {
      $this->clearCenter();
      $this->clearRadiusMeters();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->center)) {
        $res += 1;
        $res += $this->lengthString($this->center->byteSizePartial());
      }
      if (isset($this->radius_meters)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->center)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->center->byteSizePartial());
        $this->center->outputPartial($out);
      }
      if (isset($this->radius_meters)) {
        $out->putVarInt32(17);
        $out->putDouble($this->radius_meters);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCenter()->tryMerge($tmp);
            break;
          case 17:
            $this->setRadiusMeters($d->getDouble());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->center)) || (!$this->center->isInitialized())) return 'center';
      if (!isset($this->radius_meters)) return 'radius_meters';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCenter()) {
        $this->mutableCenter()->mergeFrom($x->getCenter());
      }
      if ($x->hasRadiusMeters()) {
        $this->setRadiusMeters($x->getRadiusMeters());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->center) !== isset($x->center)) return false;
      if (isset($this->center) && !$this->center->equals($x->center)) return false;
      if (isset($this->radius_meters) !== isset($x->radius_meters)) return false;
      if (isset($this->radius_meters) && $this->radius_meters !== $x->radius_meters) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->center)) {
        $res .= $prefix . "center <\n" . $this->center->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->radius_meters)) {
        $res .= $prefix . "radius_meters: " . $this->debugFormatDouble($this->radius_meters) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class RectangleRegion extends \google\net\ProtocolMessage {
    public function getSouthwest() {
      if (!isset($this->southwest)) {
        return new \google\appengine_datastore_v3\RegionPoint();
      }
      return $this->southwest;
    }
    public function mutableSouthwest() {
      if (!isset($this->southwest)) {
        $res = new \google\appengine_datastore_v3\RegionPoint();
        $this->southwest = $res;
        return $res;
      }
      return $this->southwest;
    }
    public function clearSouthwest() {
      if (isset($this->southwest)) {
        unset($this->southwest);
      }
    }
    public function hasSouthwest() {
      return isset($this->southwest);
    }
    public function getNortheast() {
      if (!isset($this->northeast)) {
        return new \google\appengine_datastore_v3\RegionPoint();
      }
      return $this->northeast;
    }
    public function mutableNortheast() {
      if (!isset($this->northeast)) {
        $res = new \google\appengine_datastore_v3\RegionPoint();
        $this->northeast = $res;
        return $res;
      }
      return $this->northeast;
    }
    public function clearNortheast() {
      if (isset($this->northeast)) {
        unset($this->northeast);
      }
    }
    public function hasNortheast() {
      return isset($this->northeast);
    }
    public function clear() {
      $this->clearSouthwest();
      $this->clearNortheast();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->southwest)) {
        $res += 1;
        $res += $this->lengthString($this->southwest->byteSizePartial());
      }
      if (isset($this->northeast)) {
        $res += 1;
        $res += $this->lengthString($this->northeast->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->southwest)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->southwest->byteSizePartial());
        $this->southwest->outputPartial($out);
      }
      if (isset($this->northeast)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->northeast->byteSizePartial());
        $this->northeast->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableSouthwest()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableNortheast()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->southwest)) || (!$this->southwest->isInitialized())) return 'southwest';
      if ((!isset($this->northeast)) || (!$this->northeast->isInitialized())) return 'northeast';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasSouthwest()) {
        $this->mutableSouthwest()->mergeFrom($x->getSouthwest());
      }
      if ($x->hasNortheast()) {
        $this->mutableNortheast()->mergeFrom($x->getNortheast());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->southwest) !== isset($x->southwest)) return false;
      if (isset($this->southwest) && !$this->southwest->equals($x->southwest)) return false;
      if (isset($this->northeast) !== isset($x->northeast)) return false;
      if (isset($this->northeast) && !$this->northeast->equals($x->northeast)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->southwest)) {
        $res .= $prefix . "southwest <\n" . $this->southwest->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->northeast)) {
        $res .= $prefix . "northeast <\n" . $this->northeast->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class GeoRegion extends \google\net\ProtocolMessage {
    public function getCircle() {
      if (!isset($this->circle)) {
        return new \google\appengine_datastore_v3\CircleRegion();
      }
      return $this->circle;
    }
    public function mutableCircle() {
      if (!isset($this->circle)) {
        $res = new \google\appengine_datastore_v3\CircleRegion();
        $this->circle = $res;
        return $res;
      }
      return $this->circle;
    }
    public function clearCircle() {
      if (isset($this->circle)) {
        unset($this->circle);
      }
    }
    public function hasCircle() {
      return isset($this->circle);
    }
    public function getRectangle() {
      if (!isset($this->rectangle)) {
        return new \google\appengine_datastore_v3\RectangleRegion();
      }
      return $this->rectangle;
    }
    public function mutableRectangle() {
      if (!isset($this->rectangle)) {
        $res = new \google\appengine_datastore_v3\RectangleRegion();
        $this->rectangle = $res;
        return $res;
      }
      return $this->rectangle;
    }
    public function clearRectangle() {
      if (isset($this->rectangle)) {
        unset($this->rectangle);
      }
    }
    public function hasRectangle() {
      return isset($this->rectangle);
    }
    public function clear() {
      $this->clearCircle();
      $this->clearRectangle();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->circle)) {
        $res += 1;
        $res += $this->lengthString($this->circle->byteSizePartial());
      }
      if (isset($this->rectangle)) {
        $res += 1;
        $res += $this->lengthString($this->rectangle->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->circle)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->circle->byteSizePartial());
        $this->circle->outputPartial($out);
      }
      if (isset($this->rectangle)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->rectangle->byteSizePartial());
        $this->rectangle->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCircle()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableRectangle()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->circle) && (!$this->circle->isInitialized())) return 'circle';
      if (isset($this->rectangle) && (!$this->rectangle->isInitialized())) return 'rectangle';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCircle()) {
        $this->mutableCircle()->mergeFrom($x->getCircle());
      }
      if ($x->hasRectangle()) {
        $this->mutableRectangle()->mergeFrom($x->getRectangle());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->circle) !== isset($x->circle)) return false;
      if (isset($this->circle) && !$this->circle->equals($x->circle)) return false;
      if (isset($this->rectangle) !== isset($x->rectangle)) return false;
      if (isset($this->rectangle) && !$this->rectangle->equals($x->rectangle)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->circle)) {
        $res .= $prefix . "circle <\n" . $this->circle->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->rectangle)) {
        $res .= $prefix . "rectangle <\n" . $this->rectangle->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\CompiledQuery {
  class PrimaryScan extends \google\net\ProtocolMessage {
    private $start_postfix_value = array();
    private $end_postfix_value = array();
    public function getIndexName() {
      if (!isset($this->index_name)) {
        return '';
      }
      return $this->index_name;
    }
    public function setIndexName($val) {
      $this->index_name = $val;
      return $this;
    }
    public function clearIndexName() {
      unset($this->index_name);
      return $this;
    }
    public function hasIndexName() {
      return isset($this->index_name);
    }
    public function getStartKey() {
      if (!isset($this->start_key)) {
        return '';
      }
      return $this->start_key;
    }
    public function setStartKey($val) {
      $this->start_key = $val;
      return $this;
    }
    public function clearStartKey() {
      unset($this->start_key);
      return $this;
    }
    public function hasStartKey() {
      return isset($this->start_key);
    }
    public function getStartInclusive() {
      if (!isset($this->start_inclusive)) {
        return false;
      }
      return $this->start_inclusive;
    }
    public function setStartInclusive($val) {
      $this->start_inclusive = $val;
      return $this;
    }
    public function clearStartInclusive() {
      unset($this->start_inclusive);
      return $this;
    }
    public function hasStartInclusive() {
      return isset($this->start_inclusive);
    }
    public function getEndKey() {
      if (!isset($this->end_key)) {
        return '';
      }
      return $this->end_key;
    }
    public function setEndKey($val) {
      $this->end_key = $val;
      return $this;
    }
    public function clearEndKey() {
      unset($this->end_key);
      return $this;
    }
    public function hasEndKey() {
      return isset($this->end_key);
    }
    public function getEndInclusive() {
      if (!isset($this->end_inclusive)) {
        return false;
      }
      return $this->end_inclusive;
    }
    public function setEndInclusive($val) {
      $this->end_inclusive = $val;
      return $this;
    }
    public function clearEndInclusive() {
      unset($this->end_inclusive);
      return $this;
    }
    public function hasEndInclusive() {
      return isset($this->end_inclusive);
    }
    public function getEndUnappliedLogTimestampUs() {
      if (!isset($this->end_unapplied_log_timestamp_us)) {
        return "0";
      }
      return $this->end_unapplied_log_timestamp_us;
    }
    public function setEndUnappliedLogTimestampUs($val) {
      if (is_double($val)) {
        $this->end_unapplied_log_timestamp_us = sprintf('%0.0F', $val);
      } else {
        $this->end_unapplied_log_timestamp_us = $val;
      }
      return $this;
    }
    public function clearEndUnappliedLogTimestampUs() {
      unset($this->end_unapplied_log_timestamp_us);
      return $this;
    }
    public function hasEndUnappliedLogTimestampUs() {
      return isset($this->end_unapplied_log_timestamp_us);
    }
    public function getStartPostfixValueSize() {
      return sizeof($this->start_postfix_value);
    }
    public function getStartPostfixValueList() {
      return $this->start_postfix_value;
    }
    public function getStartPostfixValue($idx) {
      return $this->start_postfix_value[$idx];
    }
    public function setStartPostfixValue($idx, $val) {
      $this->start_postfix_value[$idx] = $val;
      return $this;
    }
    public function addStartPostfixValue($val) {
      $this->start_postfix_value[] = $val;
      return $this;
    }
    public function clearStartPostfixValue() {
      $this->start_postfix_value = array();
    }
    public function getEndPostfixValueSize() {
      return sizeof($this->end_postfix_value);
    }
    public function getEndPostfixValueList() {
      return $this->end_postfix_value;
    }
    public function getEndPostfixValue($idx) {
      return $this->end_postfix_value[$idx];
    }
    public function setEndPostfixValue($idx, $val) {
      $this->end_postfix_value[$idx] = $val;
      return $this;
    }
    public function addEndPostfixValue($val) {
      $this->end_postfix_value[] = $val;
      return $this;
    }
    public function clearEndPostfixValue() {
      $this->end_postfix_value = array();
    }
    public function clear() {
      $this->clearIndexName();
      $this->clearStartKey();
      $this->clearStartInclusive();
      $this->clearEndKey();
      $this->clearEndInclusive();
      $this->clearEndUnappliedLogTimestampUs();
      $this->clearStartPostfixValue();
      $this->clearEndPostfixValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->index_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->index_name));
      }
      if (isset($this->start_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->start_key));
      }
      if (isset($this->start_inclusive)) {
        $res += 2;
      }
      if (isset($this->end_key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->end_key));
      }
      if (isset($this->end_inclusive)) {
        $res += 2;
      }
      if (isset($this->end_unapplied_log_timestamp_us)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->end_unapplied_log_timestamp_us);
      }
      $this->checkProtoArray($this->start_postfix_value);
      $res += 2 * sizeof($this->start_postfix_value);
      foreach ($this->start_postfix_value as $value) {
        $res += $this->lengthString(strlen($value));
      }
      $this->checkProtoArray($this->end_postfix_value);
      $res += 2 * sizeof($this->end_postfix_value);
      foreach ($this->end_postfix_value as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->index_name)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->index_name);
      }
      if (isset($this->start_key)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->start_key);
      }
      if (isset($this->start_inclusive)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->start_inclusive);
      }
      if (isset($this->end_key)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->end_key);
      }
      if (isset($this->end_inclusive)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->end_inclusive);
      }
      if (isset($this->end_unapplied_log_timestamp_us)) {
        $out->putVarInt32(152);
        $out->putVarInt64($this->end_unapplied_log_timestamp_us);
      }
      $this->checkProtoArray($this->start_postfix_value);
      foreach ($this->start_postfix_value as $value) {
        $out->putVarInt32(178);
        $out->putPrefixedString($value);
      }
      $this->checkProtoArray($this->end_postfix_value);
      foreach ($this->end_postfix_value as $value) {
        $out->putVarInt32(186);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setIndexName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setStartKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 32:
            $this->setStartInclusive($d->getBoolean());
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setEndKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 48:
            $this->setEndInclusive($d->getBoolean());
            break;
          case 152:
            $this->setEndUnappliedLogTimestampUs($d->getVarInt64());
            break;
          case 178:
            $length = $d->getVarInt32();
            $this->addStartPostfixValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 186:
            $length = $d->getVarInt32();
            $this->addEndPostfixValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasIndexName()) {
        $this->setIndexName($x->getIndexName());
      }
      if ($x->hasStartKey()) {
        $this->setStartKey($x->getStartKey());
      }
      if ($x->hasStartInclusive()) {
        $this->setStartInclusive($x->getStartInclusive());
      }
      if ($x->hasEndKey()) {
        $this->setEndKey($x->getEndKey());
      }
      if ($x->hasEndInclusive()) {
        $this->setEndInclusive($x->getEndInclusive());
      }
      if ($x->hasEndUnappliedLogTimestampUs()) {
        $this->setEndUnappliedLogTimestampUs($x->getEndUnappliedLogTimestampUs());
      }
      foreach ($x->getStartPostfixValueList() as $v) {
        $this->addStartPostfixValue($v);
      }
      foreach ($x->getEndPostfixValueList() as $v) {
        $this->addEndPostfixValue($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->index_name) !== isset($x->index_name)) return false;
      if (isset($this->index_name) && $this->index_name !== $x->index_name) return false;
      if (isset($this->start_key) !== isset($x->start_key)) return false;
      if (isset($this->start_key) && $this->start_key !== $x->start_key) return false;
      if (isset($this->start_inclusive) !== isset($x->start_inclusive)) return false;
      if (isset($this->start_inclusive) && $this->start_inclusive !== $x->start_inclusive) return false;
      if (isset($this->end_key) !== isset($x->end_key)) return false;
      if (isset($this->end_key) && $this->end_key !== $x->end_key) return false;
      if (isset($this->end_inclusive) !== isset($x->end_inclusive)) return false;
      if (isset($this->end_inclusive) && $this->end_inclusive !== $x->end_inclusive) return false;
      if (isset($this->end_unapplied_log_timestamp_us) !== isset($x->end_unapplied_log_timestamp_us)) return false;
      if (isset($this->end_unapplied_log_timestamp_us) && !$this->integerEquals($this->end_unapplied_log_timestamp_us, $x->end_unapplied_log_timestamp_us)) return false;
      if (sizeof($this->start_postfix_value) !== sizeof($x->start_postfix_value)) return false;
      foreach (array_map(null, $this->start_postfix_value, $x->start_postfix_value) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (sizeof($this->end_postfix_value) !== sizeof($x->end_postfix_value)) return false;
      foreach (array_map(null, $this->end_postfix_value, $x->end_postfix_value) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->index_name)) {
        $res .= $prefix . "index_name: " . $this->debugFormatString($this->index_name) . "\n";
      }
      if (isset($this->start_key)) {
        $res .= $prefix . "start_key: " . $this->debugFormatString($this->start_key) . "\n";
      }
      if (isset($this->start_inclusive)) {
        $res .= $prefix . "start_inclusive: " . $this->debugFormatBool($this->start_inclusive) . "\n";
      }
      if (isset($this->end_key)) {
        $res .= $prefix . "end_key: " . $this->debugFormatString($this->end_key) . "\n";
      }
      if (isset($this->end_inclusive)) {
        $res .= $prefix . "end_inclusive: " . $this->debugFormatBool($this->end_inclusive) . "\n";
      }
      if (isset($this->end_unapplied_log_timestamp_us)) {
        $res .= $prefix . "end_unapplied_log_timestamp_us: " . $this->debugFormatInt64($this->end_unapplied_log_timestamp_us) . "\n";
      }
      foreach ($this->start_postfix_value as $value) {
        $res .= $prefix . "start_postfix_value: " . $this->debugFormatString($value) . "\n";
      }
      foreach ($this->end_postfix_value as $value) {
        $res .= $prefix . "end_postfix_value: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\CompiledQuery {
  class MergeJoinScan extends \google\net\ProtocolMessage {
    private $prefix_value = array();
    public function getIndexName() {
      if (!isset($this->index_name)) {
        return '';
      }
      return $this->index_name;
    }
    public function setIndexName($val) {
      $this->index_name = $val;
      return $this;
    }
    public function clearIndexName() {
      unset($this->index_name);
      return $this;
    }
    public function hasIndexName() {
      return isset($this->index_name);
    }
    public function getPrefixValueSize() {
      return sizeof($this->prefix_value);
    }
    public function getPrefixValueList() {
      return $this->prefix_value;
    }
    public function getPrefixValue($idx) {
      return $this->prefix_value[$idx];
    }
    public function setPrefixValue($idx, $val) {
      $this->prefix_value[$idx] = $val;
      return $this;
    }
    public function addPrefixValue($val) {
      $this->prefix_value[] = $val;
      return $this;
    }
    public function clearPrefixValue() {
      $this->prefix_value = array();
    }
    public function getValuePrefix() {
      if (!isset($this->value_prefix)) {
        return false;
      }
      return $this->value_prefix;
    }
    public function setValuePrefix($val) {
      $this->value_prefix = $val;
      return $this;
    }
    public function clearValuePrefix() {
      unset($this->value_prefix);
      return $this;
    }
    public function hasValuePrefix() {
      return isset($this->value_prefix);
    }
    public function clear() {
      $this->clearIndexName();
      $this->clearPrefixValue();
      $this->clearValuePrefix();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->index_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->index_name));
      }
      $this->checkProtoArray($this->prefix_value);
      $res += 1 * sizeof($this->prefix_value);
      foreach ($this->prefix_value as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->value_prefix)) {
        $res += 3;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->index_name)) {
        $out->putVarInt32(66);
        $out->putPrefixedString($this->index_name);
      }
      $this->checkProtoArray($this->prefix_value);
      foreach ($this->prefix_value as $value) {
        $out->putVarInt32(74);
        $out->putPrefixedString($value);
      }
      if (isset($this->value_prefix)) {
        $out->putVarInt32(160);
        $out->putBoolean($this->value_prefix);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 60: return;
          case 66:
            $length = $d->getVarInt32();
            $this->setIndexName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 74:
            $length = $d->getVarInt32();
            $this->addPrefixValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 160:
            $this->setValuePrefix($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->index_name)) return 'index_name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasIndexName()) {
        $this->setIndexName($x->getIndexName());
      }
      foreach ($x->getPrefixValueList() as $v) {
        $this->addPrefixValue($v);
      }
      if ($x->hasValuePrefix()) {
        $this->setValuePrefix($x->getValuePrefix());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->index_name) !== isset($x->index_name)) return false;
      if (isset($this->index_name) && $this->index_name !== $x->index_name) return false;
      if (sizeof($this->prefix_value) !== sizeof($x->prefix_value)) return false;
      foreach (array_map(null, $this->prefix_value, $x->prefix_value) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->value_prefix) !== isset($x->value_prefix)) return false;
      if (isset($this->value_prefix) && $this->value_prefix !== $x->value_prefix) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->index_name)) {
        $res .= $prefix . "index_name: " . $this->debugFormatString($this->index_name) . "\n";
      }
      foreach ($this->prefix_value as $value) {
        $res .= $prefix . "prefix_value: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->value_prefix)) {
        $res .= $prefix . "value_prefix: " . $this->debugFormatBool($this->value_prefix) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\CompiledQuery {
  class EntityFilter extends \google\net\ProtocolMessage {
    public function getDistinct() {
      if (!isset($this->distinct)) {
        return false;
      }
      return $this->distinct;
    }
    public function setDistinct($val) {
      $this->distinct = $val;
      return $this;
    }
    public function clearDistinct() {
      unset($this->distinct);
      return $this;
    }
    public function hasDistinct() {
      return isset($this->distinct);
    }
    public function getKind() {
      if (!isset($this->kind)) {
        return '';
      }
      return $this->kind;
    }
    public function setKind($val) {
      $this->kind = $val;
      return $this;
    }
    public function clearKind() {
      unset($this->kind);
      return $this;
    }
    public function hasKind() {
      return isset($this->kind);
    }
    public function getAncestor() {
      if (!isset($this->ancestor)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->ancestor;
    }
    public function mutableAncestor() {
      if (!isset($this->ancestor)) {
        $res = new \storage_onestore_v3\Reference();
        $this->ancestor = $res;
        return $res;
      }
      return $this->ancestor;
    }
    public function clearAncestor() {
      if (isset($this->ancestor)) {
        unset($this->ancestor);
      }
    }
    public function hasAncestor() {
      return isset($this->ancestor);
    }
    public function clear() {
      $this->clearDistinct();
      $this->clearKind();
      $this->clearAncestor();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->distinct)) {
        $res += 2;
      }
      if (isset($this->kind)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->kind));
      }
      if (isset($this->ancestor)) {
        $res += 2;
        $res += $this->lengthString($this->ancestor->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->distinct)) {
        $out->putVarInt32(112);
        $out->putBoolean($this->distinct);
      }
      if (isset($this->kind)) {
        $out->putVarInt32(138);
        $out->putPrefixedString($this->kind);
      }
      if (isset($this->ancestor)) {
        $out->putVarInt32(146);
        $out->putVarInt32($this->ancestor->byteSizePartial());
        $this->ancestor->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 108: return;
          case 112:
            $this->setDistinct($d->getBoolean());
            break;
          case 138:
            $length = $d->getVarInt32();
            $this->setKind(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 146:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableAncestor()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->ancestor) && (!$this->ancestor->isInitialized())) return 'ancestor';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasDistinct()) {
        $this->setDistinct($x->getDistinct());
      }
      if ($x->hasKind()) {
        $this->setKind($x->getKind());
      }
      if ($x->hasAncestor()) {
        $this->mutableAncestor()->mergeFrom($x->getAncestor());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->distinct) !== isset($x->distinct)) return false;
      if (isset($this->distinct) && $this->distinct !== $x->distinct) return false;
      if (isset($this->kind) !== isset($x->kind)) return false;
      if (isset($this->kind) && $this->kind !== $x->kind) return false;
      if (isset($this->ancestor) !== isset($x->ancestor)) return false;
      if (isset($this->ancestor) && !$this->ancestor->equals($x->ancestor)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->distinct)) {
        $res .= $prefix . "distinct: " . $this->debugFormatBool($this->distinct) . "\n";
      }
      if (isset($this->kind)) {
        $res .= $prefix . "kind: " . $this->debugFormatString($this->kind) . "\n";
      }
      if (isset($this->ancestor)) {
        $res .= $prefix . "ancestor <\n" . $this->ancestor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class CompiledQuery extends \google\net\ProtocolMessage {
    private $mergejoinscan = array();
    private $property_name = array();
    public function getPrimaryScan() {
      if (!isset($this->primaryscan)) {
        return new \google\appengine_datastore_v3\CompiledQuery\PrimaryScan();
      }
      return $this->primaryscan;
    }
    public function mutablePrimaryScan() {
      if (!isset($this->primaryscan)) {
        $res = new \google\appengine_datastore_v3\CompiledQuery\PrimaryScan();
        $this->primaryscan = $res;
        return $res;
      }
      return $this->primaryscan;
    }
    public function clearPrimaryScan() {
      if (isset($this->primaryscan)) {
        unset($this->primaryscan);
      }
    }
    public function hasPrimaryScan() {
      return isset($this->primaryscan);
    }
    public function getMergeJoinScanSize() {
      return sizeof($this->mergejoinscan);
    }
    public function getMergeJoinScanList() {
      return $this->mergejoinscan;
    }
    public function mutableMergeJoinScan($idx) {
      if (!isset($this->mergejoinscan[$idx])) {
        $val = new \google\appengine_datastore_v3\CompiledQuery\MergeJoinScan();
        $this->mergejoinscan[$idx] = $val;
        return $val;
      }
      return $this->mergejoinscan[$idx];
    }
    public function getMergeJoinScan($idx) {
      if (isset($this->mergejoinscan[$idx])) {
        return $this->mergejoinscan[$idx];
      }
      if ($idx >= end(array_keys($this->mergejoinscan))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine_datastore_v3\CompiledQuery\MergeJoinScan();
    }
    public function addMergeJoinScan() {
      $val = new \google\appengine_datastore_v3\CompiledQuery\MergeJoinScan();
      $this->mergejoinscan[] = $val;
      return $val;
    }
    public function clearMergeJoinScan() {
      $this->mergejoinscan = array();
    }
    public function getOffset() {
      if (!isset($this->offset)) {
        return 0;
      }
      return $this->offset;
    }
    public function setOffset($val) {
      $this->offset = $val;
      return $this;
    }
    public function clearOffset() {
      unset($this->offset);
      return $this;
    }
    public function hasOffset() {
      return isset($this->offset);
    }
    public function getLimit() {
      if (!isset($this->limit)) {
        return 0;
      }
      return $this->limit;
    }
    public function setLimit($val) {
      $this->limit = $val;
      return $this;
    }
    public function clearLimit() {
      unset($this->limit);
      return $this;
    }
    public function hasLimit() {
      return isset($this->limit);
    }
    public function getKeysOnly() {
      if (!isset($this->keys_only)) {
        return false;
      }
      return $this->keys_only;
    }
    public function setKeysOnly($val) {
      $this->keys_only = $val;
      return $this;
    }
    public function clearKeysOnly() {
      unset($this->keys_only);
      return $this;
    }
    public function hasKeysOnly() {
      return isset($this->keys_only);
    }
    public function getEntityFilter() {
      if (!isset($this->entityfilter)) {
        return new \google\appengine_datastore_v3\CompiledQuery\EntityFilter();
      }
      return $this->entityfilter;
    }
    public function mutableEntityFilter() {
      if (!isset($this->entityfilter)) {
        $res = new \google\appengine_datastore_v3\CompiledQuery\EntityFilter();
        $this->entityfilter = $res;
        return $res;
      }
      return $this->entityfilter;
    }
    public function clearEntityFilter() {
      if (isset($this->entityfilter)) {
        unset($this->entityfilter);
      }
    }
    public function hasEntityFilter() {
      return isset($this->entityfilter);
    }
    public function getIndexDef() {
      if (!isset($this->index_def)) {
        return new \storage_onestore_v3\Index();
      }
      return $this->index_def;
    }
    public function mutableIndexDef() {
      if (!isset($this->index_def)) {
        $res = new \storage_onestore_v3\Index();
        $this->index_def = $res;
        return $res;
      }
      return $this->index_def;
    }
    public function clearIndexDef() {
      if (isset($this->index_def)) {
        unset($this->index_def);
      }
    }
    public function hasIndexDef() {
      return isset($this->index_def);
    }
    public function getPropertyNameSize() {
      return sizeof($this->property_name);
    }
    public function getPropertyNameList() {
      return $this->property_name;
    }
    public function getPropertyName($idx) {
      return $this->property_name[$idx];
    }
    public function setPropertyName($idx, $val) {
      $this->property_name[$idx] = $val;
      return $this;
    }
    public function addPropertyName($val) {
      $this->property_name[] = $val;
      return $this;
    }
    public function clearPropertyName() {
      $this->property_name = array();
    }
    public function getDistinctInfixSize() {
      if (!isset($this->distinct_infix_size)) {
        return 0;
      }
      return $this->distinct_infix_size;
    }
    public function setDistinctInfixSize($val) {
      $this->distinct_infix_size = $val;
      return $this;
    }
    public function clearDistinctInfixSize() {
      unset($this->distinct_infix_size);
      return $this;
    }
    public function hasDistinctInfixSize() {
      return isset($this->distinct_infix_size);
    }
    public function getPlanLabel() {
      if (!isset($this->plan_label)) {
        return '';
      }
      return $this->plan_label;
    }
    public function setPlanLabel($val) {
      $this->plan_label = $val;
      return $this;
    }
    public function clearPlanLabel() {
      unset($this->plan_label);
      return $this;
    }
    public function hasPlanLabel() {
      return isset($this->plan_label);
    }
    public function clear() {
      $this->clearPrimaryScan();
      $this->clearMergeJoinScan();
      $this->clearOffset();
      $this->clearLimit();
      $this->clearKeysOnly();
      $this->clearEntityFilter();
      $this->clearIndexDef();
      $this->clearPropertyName();
      $this->clearDistinctInfixSize();
      $this->clearPlanLabel();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->primaryscan)) {
        $res += 2;
        $res += $this->primaryscan->byteSizePartial();
      }
      $this->checkProtoArray($this->mergejoinscan);
      $res += 2 * sizeof($this->mergejoinscan);
      foreach ($this->mergejoinscan as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->offset)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->offset);
      }
      if (isset($this->limit)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->limit);
      }
      if (isset($this->keys_only)) {
        $res += 2;
      }
      if (isset($this->entityfilter)) {
        $res += 2;
        $res += $this->entityfilter->byteSizePartial();
      }
      if (isset($this->index_def)) {
        $res += 2;
        $res += $this->lengthString($this->index_def->byteSizePartial());
      }
      $this->checkProtoArray($this->property_name);
      $res += 2 * sizeof($this->property_name);
      foreach ($this->property_name as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->distinct_infix_size)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->distinct_infix_size);
      }
      if (isset($this->plan_label)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->plan_label));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->primaryscan)) {
        $out->putVarInt32(11);
        $this->primaryscan->outputPartial($out);
        $out->putVarInt32(12);
      }
      $this->checkProtoArray($this->mergejoinscan);
      foreach ($this->mergejoinscan as $value) {
        $out->putVarInt32(59);
        $value->outputPartial($out);
        $out->putVarInt32(60);
      }
      if (isset($this->offset)) {
        $out->putVarInt32(80);
        $out->putVarInt32($this->offset);
      }
      if (isset($this->limit)) {
        $out->putVarInt32(88);
        $out->putVarInt32($this->limit);
      }
      if (isset($this->keys_only)) {
        $out->putVarInt32(96);
        $out->putBoolean($this->keys_only);
      }
      if (isset($this->entityfilter)) {
        $out->putVarInt32(107);
        $this->entityfilter->outputPartial($out);
        $out->putVarInt32(108);
      }
      if (isset($this->index_def)) {
        $out->putVarInt32(170);
        $out->putVarInt32($this->index_def->byteSizePartial());
        $this->index_def->outputPartial($out);
      }
      $this->checkProtoArray($this->property_name);
      foreach ($this->property_name as $value) {
        $out->putVarInt32(194);
        $out->putPrefixedString($value);
      }
      if (isset($this->distinct_infix_size)) {
        $out->putVarInt32(200);
        $out->putVarInt32($this->distinct_infix_size);
      }
      if (isset($this->plan_label)) {
        $out->putVarInt32(210);
        $out->putPrefixedString($this->plan_label);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->mutablePrimaryScan()->tryMerge($d);
            break;
          case 59:
            $this->addMergeJoinScan()->tryMerge($d);
            break;
          case 80:
            $this->setOffset($d->getVarInt32());
            break;
          case 88:
            $this->setLimit($d->getVarInt32());
            break;
          case 96:
            $this->setKeysOnly($d->getBoolean());
            break;
          case 107:
            $this->mutableEntityFilter()->tryMerge($d);
            break;
          case 170:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableIndexDef()->tryMerge($tmp);
            break;
          case 194:
            $length = $d->getVarInt32();
            $this->addPropertyName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 200:
            $this->setDistinctInfixSize($d->getVarInt32());
            break;
          case 210:
            $length = $d->getVarInt32();
            $this->setPlanLabel(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->primaryscan)) || (!$this->primaryscan->isInitialized())) return 'primaryscan';
      foreach ($this->mergejoinscan as $value) {
        if (!$value->isInitialized()) return 'mergejoinscan';
      }
      if (!isset($this->keys_only)) return 'keys_only';
      if (isset($this->entityfilter) && (!$this->entityfilter->isInitialized())) return 'entityfilter';
      if (isset($this->index_def) && (!$this->index_def->isInitialized())) return 'index_def';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasPrimaryScan()) {
        $this->mutablePrimaryScan()->mergeFrom($x->getPrimaryScan());
      }
      foreach ($x->getMergeJoinScanList() as $v) {
        $this->addMergeJoinScan()->copyFrom($v);
      }
      if ($x->hasOffset()) {
        $this->setOffset($x->getOffset());
      }
      if ($x->hasLimit()) {
        $this->setLimit($x->getLimit());
      }
      if ($x->hasKeysOnly()) {
        $this->setKeysOnly($x->getKeysOnly());
      }
      if ($x->hasEntityFilter()) {
        $this->mutableEntityFilter()->mergeFrom($x->getEntityFilter());
      }
      if ($x->hasIndexDef()) {
        $this->mutableIndexDef()->mergeFrom($x->getIndexDef());
      }
      foreach ($x->getPropertyNameList() as $v) {
        $this->addPropertyName($v);
      }
      if ($x->hasDistinctInfixSize()) {
        $this->setDistinctInfixSize($x->getDistinctInfixSize());
      }
      if ($x->hasPlanLabel()) {
        $this->setPlanLabel($x->getPlanLabel());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->primaryscan) !== isset($x->primaryscan)) return false;
      if (isset($this->primaryscan) && !$this->primaryscan->equals($x->primaryscan)) return false;
      if (sizeof($this->mergejoinscan) !== sizeof($x->mergejoinscan)) return false;
      foreach (array_map(null, $this->mergejoinscan, $x->mergejoinscan) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->offset) !== isset($x->offset)) return false;
      if (isset($this->offset) && !$this->integerEquals($this->offset, $x->offset)) return false;
      if (isset($this->limit) !== isset($x->limit)) return false;
      if (isset($this->limit) && !$this->integerEquals($this->limit, $x->limit)) return false;
      if (isset($this->keys_only) !== isset($x->keys_only)) return false;
      if (isset($this->keys_only) && $this->keys_only !== $x->keys_only) return false;
      if (isset($this->entityfilter) !== isset($x->entityfilter)) return false;
      if (isset($this->entityfilter) && !$this->entityfilter->equals($x->entityfilter)) return false;
      if (isset($this->index_def) !== isset($x->index_def)) return false;
      if (isset($this->index_def) && !$this->index_def->equals($x->index_def)) return false;
      if (sizeof($this->property_name) !== sizeof($x->property_name)) return false;
      foreach (array_map(null, $this->property_name, $x->property_name) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->distinct_infix_size) !== isset($x->distinct_infix_size)) return false;
      if (isset($this->distinct_infix_size) && !$this->integerEquals($this->distinct_infix_size, $x->distinct_infix_size)) return false;
      if (isset($this->plan_label) !== isset($x->plan_label)) return false;
      if (isset($this->plan_label) && $this->plan_label !== $x->plan_label) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->primaryscan)) {
        $res .= $prefix . "PrimaryScan {\n" . $this->primaryscan->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      foreach ($this->mergejoinscan as $value) {
        $res .= $prefix . "MergeJoinScan {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->offset)) {
        $res .= $prefix . "offset: " . $this->debugFormatInt32($this->offset) . "\n";
      }
      if (isset($this->limit)) {
        $res .= $prefix . "limit: " . $this->debugFormatInt32($this->limit) . "\n";
      }
      if (isset($this->keys_only)) {
        $res .= $prefix . "keys_only: " . $this->debugFormatBool($this->keys_only) . "\n";
      }
      if (isset($this->entityfilter)) {
        $res .= $prefix . "EntityFilter {\n" . $this->entityfilter->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->index_def)) {
        $res .= $prefix . "index_def <\n" . $this->index_def->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->property_name as $value) {
        $res .= $prefix . "property_name: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->distinct_infix_size)) {
        $res .= $prefix . "distinct_infix_size: " . $this->debugFormatInt32($this->distinct_infix_size) . "\n";
      }
      if (isset($this->plan_label)) {
        $res .= $prefix . "plan_label: " . $this->debugFormatString($this->plan_label) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\CompiledCursor\Position {
  class IndexValue extends \google\net\ProtocolMessage {
    public function getProperty() {
      if (!isset($this->property)) {
        return '';
      }
      return $this->property;
    }
    public function setProperty($val) {
      $this->property = $val;
      return $this;
    }
    public function clearProperty() {
      unset($this->property);
      return $this;
    }
    public function hasProperty() {
      return isset($this->property);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return new \storage_onestore_v3\PropertyValue();
      }
      return $this->value;
    }
    public function mutableValue() {
      if (!isset($this->value)) {
        $res = new \storage_onestore_v3\PropertyValue();
        $this->value = $res;
        return $res;
      }
      return $this->value;
    }
    public function clearValue() {
      if (isset($this->value)) {
        unset($this->value);
      }
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearProperty();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->property));
      }
      if (isset($this->value)) {
        $res += 2;
        $res += $this->lengthString($this->value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property)) {
        $out->putVarInt32(242);
        $out->putPrefixedString($this->property);
      }
      if (isset($this->value)) {
        $out->putVarInt32(250);
        $out->putVarInt32($this->value->byteSizePartial());
        $this->value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 236: return;
          case 242:
            $length = $d->getVarInt32();
            $this->setProperty(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 250:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableValue()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->value)) || (!$this->value->isInitialized())) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasProperty()) {
        $this->setProperty($x->getProperty());
      }
      if ($x->hasValue()) {
        $this->mutableValue()->mergeFrom($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property) !== isset($x->property)) return false;
      if (isset($this->property) && $this->property !== $x->property) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && !$this->value->equals($x->value)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property)) {
        $res .= $prefix . "property: " . $this->debugFormatString($this->property) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value <\n" . $this->value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\CompiledCursor {
  class Position extends \google\net\ProtocolMessage {
    private $indexvalue = array();
    public function getStartKey() {
      if (!isset($this->start_key)) {
        return '';
      }
      return $this->start_key;
    }
    public function setStartKey($val) {
      $this->start_key = $val;
      return $this;
    }
    public function clearStartKey() {
      unset($this->start_key);
      return $this;
    }
    public function hasStartKey() {
      return isset($this->start_key);
    }
    public function getStartInclusive() {
      if (!isset($this->start_inclusive)) {
        return true;
      }
      return $this->start_inclusive;
    }
    public function setStartInclusive($val) {
      $this->start_inclusive = $val;
      return $this;
    }
    public function clearStartInclusive() {
      unset($this->start_inclusive);
      return $this;
    }
    public function hasStartInclusive() {
      return isset($this->start_inclusive);
    }
    public function getIndexValueSize() {
      return sizeof($this->indexvalue);
    }
    public function getIndexValueList() {
      return $this->indexvalue;
    }
    public function mutableIndexValue($idx) {
      if (!isset($this->indexvalue[$idx])) {
        $val = new \google\appengine_datastore_v3\CompiledCursor\Position\IndexValue();
        $this->indexvalue[$idx] = $val;
        return $val;
      }
      return $this->indexvalue[$idx];
    }
    public function getIndexValue($idx) {
      if (isset($this->indexvalue[$idx])) {
        return $this->indexvalue[$idx];
      }
      if ($idx >= end(array_keys($this->indexvalue))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine_datastore_v3\CompiledCursor\Position\IndexValue();
    }
    public function addIndexValue() {
      $val = new \google\appengine_datastore_v3\CompiledCursor\Position\IndexValue();
      $this->indexvalue[] = $val;
      return $val;
    }
    public function clearIndexValue() {
      $this->indexvalue = array();
    }
    public function getKey() {
      if (!isset($this->key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getBeforeAscending() {
      if (!isset($this->before_ascending)) {
        return false;
      }
      return $this->before_ascending;
    }
    public function setBeforeAscending($val) {
      $this->before_ascending = $val;
      return $this;
    }
    public function clearBeforeAscending() {
      unset($this->before_ascending);
      return $this;
    }
    public function hasBeforeAscending() {
      return isset($this->before_ascending);
    }
    public function clear() {
      $this->clearStartKey();
      $this->clearStartInclusive();
      $this->clearIndexValue();
      $this->clearKey();
      $this->clearBeforeAscending();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->start_key)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->start_key));
      }
      if (isset($this->start_inclusive)) {
        $res += 3;
      }
      $this->checkProtoArray($this->indexvalue);
      $res += 4 * sizeof($this->indexvalue);
      foreach ($this->indexvalue as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->key)) {
        $res += 2;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      if (isset($this->before_ascending)) {
        $res += 3;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->start_key)) {
        $out->putVarInt32(218);
        $out->putPrefixedString($this->start_key);
      }
      if (isset($this->start_inclusive)) {
        $out->putVarInt32(224);
        $out->putBoolean($this->start_inclusive);
      }
      $this->checkProtoArray($this->indexvalue);
      foreach ($this->indexvalue as $value) {
        $out->putVarInt32(235);
        $value->outputPartial($out);
        $out->putVarInt32(236);
      }
      if (isset($this->key)) {
        $out->putVarInt32(258);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
      if (isset($this->before_ascending)) {
        $out->putVarInt32(264);
        $out->putBoolean($this->before_ascending);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 20: return;
          case 218:
            $length = $d->getVarInt32();
            $this->setStartKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 224:
            $this->setStartInclusive($d->getBoolean());
            break;
          case 235:
            $this->addIndexValue()->tryMerge($d);
            break;
          case 258:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 264:
            $this->setBeforeAscending($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->indexvalue as $value) {
        if (!$value->isInitialized()) return 'indexvalue';
      }
      if (isset($this->key) && (!$this->key->isInitialized())) return 'key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasStartKey()) {
        $this->setStartKey($x->getStartKey());
      }
      if ($x->hasStartInclusive()) {
        $this->setStartInclusive($x->getStartInclusive());
      }
      foreach ($x->getIndexValueList() as $v) {
        $this->addIndexValue()->copyFrom($v);
      }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
      if ($x->hasBeforeAscending()) {
        $this->setBeforeAscending($x->getBeforeAscending());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->start_key) !== isset($x->start_key)) return false;
      if (isset($this->start_key) && $this->start_key !== $x->start_key) return false;
      if (isset($this->start_inclusive) !== isset($x->start_inclusive)) return false;
      if (isset($this->start_inclusive) && $this->start_inclusive !== $x->start_inclusive) return false;
      if (sizeof($this->indexvalue) !== sizeof($x->indexvalue)) return false;
      foreach (array_map(null, $this->indexvalue, $x->indexvalue) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      if (isset($this->before_ascending) !== isset($x->before_ascending)) return false;
      if (isset($this->before_ascending) && $this->before_ascending !== $x->before_ascending) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->start_key)) {
        $res .= $prefix . "start_key: " . $this->debugFormatString($this->start_key) . "\n";
      }
      if (isset($this->start_inclusive)) {
        $res .= $prefix . "start_inclusive: " . $this->debugFormatBool($this->start_inclusive) . "\n";
      }
      foreach ($this->indexvalue as $value) {
        $res .= $prefix . "IndexValue {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->before_ascending)) {
        $res .= $prefix . "before_ascending: " . $this->debugFormatBool($this->before_ascending) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class CompiledCursor extends \google\net\ProtocolMessage {
    public function getPostfixPosition() {
      if (!isset($this->postfix_position)) {
        return new \storage_onestore_v3\IndexPostfix();
      }
      return $this->postfix_position;
    }
    public function mutablePostfixPosition() {
      if (!isset($this->postfix_position)) {
        $res = new \storage_onestore_v3\IndexPostfix();
        $this->postfix_position = $res;
        return $res;
      }
      return $this->postfix_position;
    }
    public function clearPostfixPosition() {
      if (isset($this->postfix_position)) {
        unset($this->postfix_position);
      }
    }
    public function hasPostfixPosition() {
      return isset($this->postfix_position);
    }
    public function getPosition() {
      if (!isset($this->position)) {
        return new \google\appengine_datastore_v3\CompiledCursor\Position();
      }
      return $this->position;
    }
    public function mutablePosition() {
      if (!isset($this->position)) {
        $res = new \google\appengine_datastore_v3\CompiledCursor\Position();
        $this->position = $res;
        return $res;
      }
      return $this->position;
    }
    public function clearPosition() {
      if (isset($this->position)) {
        unset($this->position);
      }
    }
    public function hasPosition() {
      return isset($this->position);
    }
    public function getAbsolutePosition() {
      if (!isset($this->absolute_position)) {
        return new \storage_onestore_v3\IndexPosition();
      }
      return $this->absolute_position;
    }
    public function mutableAbsolutePosition() {
      if (!isset($this->absolute_position)) {
        $res = new \storage_onestore_v3\IndexPosition();
        $this->absolute_position = $res;
        return $res;
      }
      return $this->absolute_position;
    }
    public function clearAbsolutePosition() {
      if (isset($this->absolute_position)) {
        unset($this->absolute_position);
      }
    }
    public function hasAbsolutePosition() {
      return isset($this->absolute_position);
    }
    public function clear() {
      $this->clearPostfixPosition();
      $this->clearPosition();
      $this->clearAbsolutePosition();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->postfix_position)) {
        $res += 1;
        $res += $this->lengthString($this->postfix_position->byteSizePartial());
      }
      if (isset($this->position)) {
        $res += 2;
        $res += $this->position->byteSizePartial();
      }
      if (isset($this->absolute_position)) {
        $res += 1;
        $res += $this->lengthString($this->absolute_position->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->postfix_position)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->postfix_position->byteSizePartial());
        $this->postfix_position->outputPartial($out);
      }
      if (isset($this->position)) {
        $out->putVarInt32(19);
        $this->position->outputPartial($out);
        $out->putVarInt32(20);
      }
      if (isset($this->absolute_position)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->absolute_position->byteSizePartial());
        $this->absolute_position->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePostfixPosition()->tryMerge($tmp);
            break;
          case 19:
            $this->mutablePosition()->tryMerge($d);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableAbsolutePosition()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->postfix_position) && (!$this->postfix_position->isInitialized())) return 'postfix_position';
      if (isset($this->position) && (!$this->position->isInitialized())) return 'position';
      if (isset($this->absolute_position) && (!$this->absolute_position->isInitialized())) return 'absolute_position';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasPostfixPosition()) {
        $this->mutablePostfixPosition()->mergeFrom($x->getPostfixPosition());
      }
      if ($x->hasPosition()) {
        $this->mutablePosition()->mergeFrom($x->getPosition());
      }
      if ($x->hasAbsolutePosition()) {
        $this->mutableAbsolutePosition()->mergeFrom($x->getAbsolutePosition());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->postfix_position) !== isset($x->postfix_position)) return false;
      if (isset($this->postfix_position) && !$this->postfix_position->equals($x->postfix_position)) return false;
      if (isset($this->position) !== isset($x->position)) return false;
      if (isset($this->position) && !$this->position->equals($x->position)) return false;
      if (isset($this->absolute_position) !== isset($x->absolute_position)) return false;
      if (isset($this->absolute_position) && !$this->absolute_position->equals($x->absolute_position)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->postfix_position)) {
        $res .= $prefix . "postfix_position <\n" . $this->postfix_position->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->position)) {
        $res .= $prefix . "Position {\n" . $this->position->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->absolute_position)) {
        $res .= $prefix . "absolute_position <\n" . $this->absolute_position->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class Cursor extends \google\net\ProtocolMessage {
    public function getCursor() {
      if (!isset($this->cursor)) {
        return "0";
      }
      return $this->cursor;
    }
    public function setCursor($val) {
      if (is_double($val)) {
        $this->cursor = sprintf('%0.0F', $val);
      } else {
        $this->cursor = $val;
      }
      return $this;
    }
    public function clearCursor() {
      unset($this->cursor);
      return $this;
    }
    public function hasCursor() {
      return isset($this->cursor);
    }
    public function getApp() {
      if (!isset($this->app)) {
        return '';
      }
      return $this->app;
    }
    public function setApp($val) {
      $this->app = $val;
      return $this;
    }
    public function clearApp() {
      unset($this->app);
      return $this;
    }
    public function hasApp() {
      return isset($this->app);
    }
    public function clear() {
      $this->clearCursor();
      $this->clearApp();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->cursor)) {
        $res += 9;
      }
      if (isset($this->app)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->cursor)) {
        $out->putVarInt32(9);
        $out->put64($this->cursor);
      }
      if (isset($this->app)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->app);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 9:
            $this->setCursor($d->getFixed64());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setApp(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->cursor)) return 'cursor';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCursor()) {
        $this->setCursor($x->getCursor());
      }
      if ($x->hasApp()) {
        $this->setApp($x->getApp());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->cursor) !== isset($x->cursor)) return false;
      if (isset($this->cursor) && !$this->integerEquals($this->cursor, $x->cursor)) return false;
      if (isset($this->app) !== isset($x->app)) return false;
      if (isset($this->app) && $this->app !== $x->app) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->cursor)) {
        $res .= $prefix . "cursor: " . $this->debugFormatFixed64($this->cursor) . "\n";
      }
      if (isset($this->app)) {
        $res .= $prefix . "app: " . $this->debugFormatString($this->app) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\Error {
  class ErrorCode {
    const BAD_REQUEST = 1;
    const CONCURRENT_TRANSACTION = 2;
    const INTERNAL_ERROR = 3;
    const NEED_INDEX = 4;
    const TIMEOUT = 5;
    const PERMISSION_DENIED = 6;
    const BIGTABLE_ERROR = 7;
    const COMMITTED_BUT_STILL_APPLYING = 8;
    const CAPABILITY_DISABLED = 9;
    const TRY_ALTERNATE_BACKEND = 10;
    const SAFE_TIME_TOO_OLD = 11;
    const RESOURCE_EXHAUSTED = 12;
  }
}
namespace google\appengine_datastore_v3 {
  class Error extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\Cost {
  class CommitCost extends \google\net\ProtocolMessage {
    public function getRequestedEntityPuts() {
      if (!isset($this->requested_entity_puts)) {
        return 0;
      }
      return $this->requested_entity_puts;
    }
    public function setRequestedEntityPuts($val) {
      $this->requested_entity_puts = $val;
      return $this;
    }
    public function clearRequestedEntityPuts() {
      unset($this->requested_entity_puts);
      return $this;
    }
    public function hasRequestedEntityPuts() {
      return isset($this->requested_entity_puts);
    }
    public function getRequestedEntityDeletes() {
      if (!isset($this->requested_entity_deletes)) {
        return 0;
      }
      return $this->requested_entity_deletes;
    }
    public function setRequestedEntityDeletes($val) {
      $this->requested_entity_deletes = $val;
      return $this;
    }
    public function clearRequestedEntityDeletes() {
      unset($this->requested_entity_deletes);
      return $this;
    }
    public function hasRequestedEntityDeletes() {
      return isset($this->requested_entity_deletes);
    }
    public function clear() {
      $this->clearRequestedEntityPuts();
      $this->clearRequestedEntityDeletes();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->requested_entity_puts)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->requested_entity_puts);
      }
      if (isset($this->requested_entity_deletes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->requested_entity_deletes);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->requested_entity_puts)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->requested_entity_puts);
      }
      if (isset($this->requested_entity_deletes)) {
        $out->putVarInt32(56);
        $out->putVarInt32($this->requested_entity_deletes);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 44: return;
          case 48:
            $this->setRequestedEntityPuts($d->getVarInt32());
            break;
          case 56:
            $this->setRequestedEntityDeletes($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasRequestedEntityPuts()) {
        $this->setRequestedEntityPuts($x->getRequestedEntityPuts());
      }
      if ($x->hasRequestedEntityDeletes()) {
        $this->setRequestedEntityDeletes($x->getRequestedEntityDeletes());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->requested_entity_puts) !== isset($x->requested_entity_puts)) return false;
      if (isset($this->requested_entity_puts) && !$this->integerEquals($this->requested_entity_puts, $x->requested_entity_puts)) return false;
      if (isset($this->requested_entity_deletes) !== isset($x->requested_entity_deletes)) return false;
      if (isset($this->requested_entity_deletes) && !$this->integerEquals($this->requested_entity_deletes, $x->requested_entity_deletes)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->requested_entity_puts)) {
        $res .= $prefix . "requested_entity_puts: " . $this->debugFormatInt32($this->requested_entity_puts) . "\n";
      }
      if (isset($this->requested_entity_deletes)) {
        $res .= $prefix . "requested_entity_deletes: " . $this->debugFormatInt32($this->requested_entity_deletes) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class Cost extends \google\net\ProtocolMessage {
    public function getIndexWrites() {
      if (!isset($this->index_writes)) {
        return 0;
      }
      return $this->index_writes;
    }
    public function setIndexWrites($val) {
      $this->index_writes = $val;
      return $this;
    }
    public function clearIndexWrites() {
      unset($this->index_writes);
      return $this;
    }
    public function hasIndexWrites() {
      return isset($this->index_writes);
    }
    public function getIndexWriteBytes() {
      if (!isset($this->index_write_bytes)) {
        return 0;
      }
      return $this->index_write_bytes;
    }
    public function setIndexWriteBytes($val) {
      $this->index_write_bytes = $val;
      return $this;
    }
    public function clearIndexWriteBytes() {
      unset($this->index_write_bytes);
      return $this;
    }
    public function hasIndexWriteBytes() {
      return isset($this->index_write_bytes);
    }
    public function getEntityWrites() {
      if (!isset($this->entity_writes)) {
        return 0;
      }
      return $this->entity_writes;
    }
    public function setEntityWrites($val) {
      $this->entity_writes = $val;
      return $this;
    }
    public function clearEntityWrites() {
      unset($this->entity_writes);
      return $this;
    }
    public function hasEntityWrites() {
      return isset($this->entity_writes);
    }
    public function getEntityWriteBytes() {
      if (!isset($this->entity_write_bytes)) {
        return 0;
      }
      return $this->entity_write_bytes;
    }
    public function setEntityWriteBytes($val) {
      $this->entity_write_bytes = $val;
      return $this;
    }
    public function clearEntityWriteBytes() {
      unset($this->entity_write_bytes);
      return $this;
    }
    public function hasEntityWriteBytes() {
      return isset($this->entity_write_bytes);
    }
    public function getCommitCost() {
      if (!isset($this->commitcost)) {
        return new \google\appengine_datastore_v3\Cost\CommitCost();
      }
      return $this->commitcost;
    }
    public function mutableCommitCost() {
      if (!isset($this->commitcost)) {
        $res = new \google\appengine_datastore_v3\Cost\CommitCost();
        $this->commitcost = $res;
        return $res;
      }
      return $this->commitcost;
    }
    public function clearCommitCost() {
      if (isset($this->commitcost)) {
        unset($this->commitcost);
      }
    }
    public function hasCommitCost() {
      return isset($this->commitcost);
    }
    public function getApproximateStorageDelta() {
      if (!isset($this->approximate_storage_delta)) {
        return 0;
      }
      return $this->approximate_storage_delta;
    }
    public function setApproximateStorageDelta($val) {
      $this->approximate_storage_delta = $val;
      return $this;
    }
    public function clearApproximateStorageDelta() {
      unset($this->approximate_storage_delta);
      return $this;
    }
    public function hasApproximateStorageDelta() {
      return isset($this->approximate_storage_delta);
    }
    public function getIdSequenceUpdates() {
      if (!isset($this->id_sequence_updates)) {
        return 0;
      }
      return $this->id_sequence_updates;
    }
    public function setIdSequenceUpdates($val) {
      $this->id_sequence_updates = $val;
      return $this;
    }
    public function clearIdSequenceUpdates() {
      unset($this->id_sequence_updates);
      return $this;
    }
    public function hasIdSequenceUpdates() {
      return isset($this->id_sequence_updates);
    }
    public function clear() {
      $this->clearIndexWrites();
      $this->clearIndexWriteBytes();
      $this->clearEntityWrites();
      $this->clearEntityWriteBytes();
      $this->clearCommitCost();
      $this->clearApproximateStorageDelta();
      $this->clearIdSequenceUpdates();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->index_writes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->index_writes);
      }
      if (isset($this->index_write_bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->index_write_bytes);
      }
      if (isset($this->entity_writes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->entity_writes);
      }
      if (isset($this->entity_write_bytes)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->entity_write_bytes);
      }
      if (isset($this->commitcost)) {
        $res += 2;
        $res += $this->commitcost->byteSizePartial();
      }
      if (isset($this->approximate_storage_delta)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->approximate_storage_delta);
      }
      if (isset($this->id_sequence_updates)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->id_sequence_updates);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->index_writes)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->index_writes);
      }
      if (isset($this->index_write_bytes)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->index_write_bytes);
      }
      if (isset($this->entity_writes)) {
        $out->putVarInt32(24);
        $out->putVarInt32($this->entity_writes);
      }
      if (isset($this->entity_write_bytes)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->entity_write_bytes);
      }
      if (isset($this->commitcost)) {
        $out->putVarInt32(43);
        $this->commitcost->outputPartial($out);
        $out->putVarInt32(44);
      }
      if (isset($this->approximate_storage_delta)) {
        $out->putVarInt32(64);
        $out->putVarInt32($this->approximate_storage_delta);
      }
      if (isset($this->id_sequence_updates)) {
        $out->putVarInt32(72);
        $out->putVarInt32($this->id_sequence_updates);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setIndexWrites($d->getVarInt32());
            break;
          case 16:
            $this->setIndexWriteBytes($d->getVarInt32());
            break;
          case 24:
            $this->setEntityWrites($d->getVarInt32());
            break;
          case 32:
            $this->setEntityWriteBytes($d->getVarInt32());
            break;
          case 43:
            $this->mutableCommitCost()->tryMerge($d);
            break;
          case 64:
            $this->setApproximateStorageDelta($d->getVarInt32());
            break;
          case 72:
            $this->setIdSequenceUpdates($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->commitcost) && (!$this->commitcost->isInitialized())) return 'commitcost';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasIndexWrites()) {
        $this->setIndexWrites($x->getIndexWrites());
      }
      if ($x->hasIndexWriteBytes()) {
        $this->setIndexWriteBytes($x->getIndexWriteBytes());
      }
      if ($x->hasEntityWrites()) {
        $this->setEntityWrites($x->getEntityWrites());
      }
      if ($x->hasEntityWriteBytes()) {
        $this->setEntityWriteBytes($x->getEntityWriteBytes());
      }
      if ($x->hasCommitCost()) {
        $this->mutableCommitCost()->mergeFrom($x->getCommitCost());
      }
      if ($x->hasApproximateStorageDelta()) {
        $this->setApproximateStorageDelta($x->getApproximateStorageDelta());
      }
      if ($x->hasIdSequenceUpdates()) {
        $this->setIdSequenceUpdates($x->getIdSequenceUpdates());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->index_writes) !== isset($x->index_writes)) return false;
      if (isset($this->index_writes) && !$this->integerEquals($this->index_writes, $x->index_writes)) return false;
      if (isset($this->index_write_bytes) !== isset($x->index_write_bytes)) return false;
      if (isset($this->index_write_bytes) && !$this->integerEquals($this->index_write_bytes, $x->index_write_bytes)) return false;
      if (isset($this->entity_writes) !== isset($x->entity_writes)) return false;
      if (isset($this->entity_writes) && !$this->integerEquals($this->entity_writes, $x->entity_writes)) return false;
      if (isset($this->entity_write_bytes) !== isset($x->entity_write_bytes)) return false;
      if (isset($this->entity_write_bytes) && !$this->integerEquals($this->entity_write_bytes, $x->entity_write_bytes)) return false;
      if (isset($this->commitcost) !== isset($x->commitcost)) return false;
      if (isset($this->commitcost) && !$this->commitcost->equals($x->commitcost)) return false;
      if (isset($this->approximate_storage_delta) !== isset($x->approximate_storage_delta)) return false;
      if (isset($this->approximate_storage_delta) && !$this->integerEquals($this->approximate_storage_delta, $x->approximate_storage_delta)) return false;
      if (isset($this->id_sequence_updates) !== isset($x->id_sequence_updates)) return false;
      if (isset($this->id_sequence_updates) && !$this->integerEquals($this->id_sequence_updates, $x->id_sequence_updates)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->index_writes)) {
        $res .= $prefix . "index_writes: " . $this->debugFormatInt32($this->index_writes) . "\n";
      }
      if (isset($this->index_write_bytes)) {
        $res .= $prefix . "index_write_bytes: " . $this->debugFormatInt32($this->index_write_bytes) . "\n";
      }
      if (isset($this->entity_writes)) {
        $res .= $prefix . "entity_writes: " . $this->debugFormatInt32($this->entity_writes) . "\n";
      }
      if (isset($this->entity_write_bytes)) {
        $res .= $prefix . "entity_write_bytes: " . $this->debugFormatInt32($this->entity_write_bytes) . "\n";
      }
      if (isset($this->commitcost)) {
        $res .= $prefix . "CommitCost {\n" . $this->commitcost->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->approximate_storage_delta)) {
        $res .= $prefix . "approximate_storage_delta: " . $this->debugFormatInt32($this->approximate_storage_delta) . "\n";
      }
      if (isset($this->id_sequence_updates)) {
        $res .= $prefix . "id_sequence_updates: " . $this->debugFormatInt32($this->id_sequence_updates) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class GetRequest extends \google\net\ProtocolMessage {
    private $key = array();
    public function getKeySize() {
      return sizeof($this->key);
    }
    public function getKeyList() {
      return $this->key;
    }
    public function mutableKey($idx) {
      if (!isset($this->key[$idx])) {
        $val = new \storage_onestore_v3\Reference();
        $this->key[$idx] = $val;
        return $val;
      }
      return $this->key[$idx];
    }
    public function getKey($idx) {
      if (isset($this->key[$idx])) {
        return $this->key[$idx];
      }
      if ($idx >= end(array_keys($this->key))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Reference();
    }
    public function addKey() {
      $val = new \storage_onestore_v3\Reference();
      $this->key[] = $val;
      return $val;
    }
    public function clearKey() {
      $this->key = array();
    }
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return new \google\appengine_datastore_v3\Transaction();
      }
      return $this->transaction;
    }
    public function mutableTransaction() {
      if (!isset($this->transaction)) {
        $res = new \google\appengine_datastore_v3\Transaction();
        $this->transaction = $res;
        return $res;
      }
      return $this->transaction;
    }
    public function clearTransaction() {
      if (isset($this->transaction)) {
        unset($this->transaction);
      }
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function getFailoverMs() {
      if (!isset($this->failover_ms)) {
        return "0";
      }
      return $this->failover_ms;
    }
    public function setFailoverMs($val) {
      if (is_double($val)) {
        $this->failover_ms = sprintf('%0.0F', $val);
      } else {
        $this->failover_ms = $val;
      }
      return $this;
    }
    public function clearFailoverMs() {
      unset($this->failover_ms);
      return $this;
    }
    public function hasFailoverMs() {
      return isset($this->failover_ms);
    }
    public function getStrong() {
      if (!isset($this->strong)) {
        return false;
      }
      return $this->strong;
    }
    public function setStrong($val) {
      $this->strong = $val;
      return $this;
    }
    public function clearStrong() {
      unset($this->strong);
      return $this;
    }
    public function hasStrong() {
      return isset($this->strong);
    }
    public function getAllowDeferred() {
      if (!isset($this->allow_deferred)) {
        return false;
      }
      return $this->allow_deferred;
    }
    public function setAllowDeferred($val) {
      $this->allow_deferred = $val;
      return $this;
    }
    public function clearAllowDeferred() {
      unset($this->allow_deferred);
      return $this;
    }
    public function hasAllowDeferred() {
      return isset($this->allow_deferred);
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearKey();
      $this->clearTransaction();
      $this->clearFailoverMs();
      $this->clearStrong();
      $this->clearAllowDeferred();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->key);
      $res += 1 * sizeof($this->key);
      foreach ($this->key as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString($this->transaction->byteSizePartial());
      }
      if (isset($this->failover_ms)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->failover_ms);
      }
      if (isset($this->strong)) {
        $res += 2;
      }
      if (isset($this->allow_deferred)) {
        $res += 2;
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->key);
      foreach ($this->key as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->transaction)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->transaction->byteSizePartial());
        $this->transaction->outputPartial($out);
      }
      if (isset($this->failover_ms)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->failover_ms);
      }
      if (isset($this->strong)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->strong);
      }
      if (isset($this->allow_deferred)) {
        $out->putVarInt32(40);
        $out->putBoolean($this->allow_deferred);
      }
      if (isset($this->header)) {
        $out->putVarInt32(50);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addKey()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableTransaction()->tryMerge($tmp);
            break;
          case 24:
            $this->setFailoverMs($d->getVarInt64());
            break;
          case 32:
            $this->setStrong($d->getBoolean());
            break;
          case 40:
            $this->setAllowDeferred($d->getBoolean());
            break;
          case 50:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->key as $value) {
        if (!$value->isInitialized()) return 'key';
      }
      if (isset($this->transaction) && (!$this->transaction->isInitialized())) return 'transaction';
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getKeyList() as $v) {
        $this->addKey()->copyFrom($v);
      }
      if ($x->hasTransaction()) {
        $this->mutableTransaction()->mergeFrom($x->getTransaction());
      }
      if ($x->hasFailoverMs()) {
        $this->setFailoverMs($x->getFailoverMs());
      }
      if ($x->hasStrong()) {
        $this->setStrong($x->getStrong());
      }
      if ($x->hasAllowDeferred()) {
        $this->setAllowDeferred($x->getAllowDeferred());
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->key) !== sizeof($x->key)) return false;
      foreach (array_map(null, $this->key, $x->key) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && !$this->transaction->equals($x->transaction)) return false;
      if (isset($this->failover_ms) !== isset($x->failover_ms)) return false;
      if (isset($this->failover_ms) && !$this->integerEquals($this->failover_ms, $x->failover_ms)) return false;
      if (isset($this->strong) !== isset($x->strong)) return false;
      if (isset($this->strong) && $this->strong !== $x->strong) return false;
      if (isset($this->allow_deferred) !== isset($x->allow_deferred)) return false;
      if (isset($this->allow_deferred) && $this->allow_deferred !== $x->allow_deferred) return false;
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->key as $value) {
        $res .= $prefix . "key <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction <\n" . $this->transaction->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->failover_ms)) {
        $res .= $prefix . "failover_ms: " . $this->debugFormatInt64($this->failover_ms) . "\n";
      }
      if (isset($this->strong)) {
        $res .= $prefix . "strong: " . $this->debugFormatBool($this->strong) . "\n";
      }
      if (isset($this->allow_deferred)) {
        $res .= $prefix . "allow_deferred: " . $this->debugFormatBool($this->allow_deferred) . "\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\GetResponse {
  class Entity extends \google\net\ProtocolMessage {
    public function getEntity() {
      if (!isset($this->entity)) {
        return new \storage_onestore_v3\EntityProto();
      }
      return $this->entity;
    }
    public function mutableEntity() {
      if (!isset($this->entity)) {
        $res = new \storage_onestore_v3\EntityProto();
        $this->entity = $res;
        return $res;
      }
      return $this->entity;
    }
    public function clearEntity() {
      if (isset($this->entity)) {
        unset($this->entity);
      }
    }
    public function hasEntity() {
      return isset($this->entity);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return "0";
      }
      return $this->version;
    }
    public function setVersion($val) {
      if (is_double($val)) {
        $this->version = sprintf('%0.0F', $val);
      } else {
        $this->version = $val;
      }
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function getKey() {
      if (!isset($this->key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function clear() {
      $this->clearEntity();
      $this->clearVersion();
      $this->clearKey();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->entity)) {
        $res += 1;
        $res += $this->lengthString($this->entity->byteSizePartial());
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->version);
      }
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->entity)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->entity->byteSizePartial());
        $this->entity->outputPartial($out);
      }
      if (isset($this->version)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->version);
      }
      if (isset($this->key)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEntity()->tryMerge($tmp);
            break;
          case 24:
            $this->setVersion($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->entity) && (!$this->entity->isInitialized())) return 'entity';
      if (isset($this->key) && (!$this->key->isInitialized())) return 'key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasEntity()) {
        $this->mutableEntity()->mergeFrom($x->getEntity());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->entity) !== isset($x->entity)) return false;
      if (isset($this->entity) && !$this->entity->equals($x->entity)) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && !$this->integerEquals($this->version, $x->version)) return false;
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->entity)) {
        $res .= $prefix . "entity <\n" . $this->entity->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatInt64($this->version) . "\n";
      }
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class GetResponse extends \google\net\ProtocolMessage {
    private $entity = array();
    private $deferred = array();
    public function getEntitySize() {
      return sizeof($this->entity);
    }
    public function getEntityList() {
      return $this->entity;
    }
    public function mutableEntity($idx) {
      if (!isset($this->entity[$idx])) {
        $val = new \google\appengine_datastore_v3\GetResponse\Entity();
        $this->entity[$idx] = $val;
        return $val;
      }
      return $this->entity[$idx];
    }
    public function getEntity($idx) {
      if (isset($this->entity[$idx])) {
        return $this->entity[$idx];
      }
      if ($idx >= end(array_keys($this->entity))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine_datastore_v3\GetResponse\Entity();
    }
    public function addEntity() {
      $val = new \google\appengine_datastore_v3\GetResponse\Entity();
      $this->entity[] = $val;
      return $val;
    }
    public function clearEntity() {
      $this->entity = array();
    }
    public function getDeferredSize() {
      return sizeof($this->deferred);
    }
    public function getDeferredList() {
      return $this->deferred;
    }
    public function mutableDeferred($idx) {
      if (!isset($this->deferred[$idx])) {
        $val = new \storage_onestore_v3\Reference();
        $this->deferred[$idx] = $val;
        return $val;
      }
      return $this->deferred[$idx];
    }
    public function getDeferred($idx) {
      if (isset($this->deferred[$idx])) {
        return $this->deferred[$idx];
      }
      if ($idx >= end(array_keys($this->deferred))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Reference();
    }
    public function addDeferred() {
      $val = new \storage_onestore_v3\Reference();
      $this->deferred[] = $val;
      return $val;
    }
    public function clearDeferred() {
      $this->deferred = array();
    }
    public function getInOrder() {
      if (!isset($this->in_order)) {
        return true;
      }
      return $this->in_order;
    }
    public function setInOrder($val) {
      $this->in_order = $val;
      return $this;
    }
    public function clearInOrder() {
      unset($this->in_order);
      return $this;
    }
    public function hasInOrder() {
      return isset($this->in_order);
    }
    public function clear() {
      $this->clearEntity();
      $this->clearDeferred();
      $this->clearInOrder();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->entity);
      $res += 2 * sizeof($this->entity);
      foreach ($this->entity as $value) {
        $res += $value->byteSizePartial();
      }
      $this->checkProtoArray($this->deferred);
      $res += 1 * sizeof($this->deferred);
      foreach ($this->deferred as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->in_order)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->entity);
      foreach ($this->entity as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
      $this->checkProtoArray($this->deferred);
      foreach ($this->deferred as $value) {
        $out->putVarInt32(42);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->in_order)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->in_order);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addEntity()->tryMerge($d);
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addDeferred()->tryMerge($tmp);
            break;
          case 48:
            $this->setInOrder($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->entity as $value) {
        if (!$value->isInitialized()) return 'entity';
      }
      foreach ($this->deferred as $value) {
        if (!$value->isInitialized()) return 'deferred';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getEntityList() as $v) {
        $this->addEntity()->copyFrom($v);
      }
      foreach ($x->getDeferredList() as $v) {
        $this->addDeferred()->copyFrom($v);
      }
      if ($x->hasInOrder()) {
        $this->setInOrder($x->getInOrder());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->entity) !== sizeof($x->entity)) return false;
      foreach (array_map(null, $this->entity, $x->entity) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->deferred) !== sizeof($x->deferred)) return false;
      foreach (array_map(null, $this->deferred, $x->deferred) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->in_order) !== isset($x->in_order)) return false;
      if (isset($this->in_order) && $this->in_order !== $x->in_order) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->entity as $value) {
        $res .= $prefix . "Entity {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      foreach ($this->deferred as $value) {
        $res .= $prefix . "deferred <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->in_order)) {
        $res .= $prefix . "in_order: " . $this->debugFormatBool($this->in_order) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\PutRequest {
  class AutoIdPolicy {
    const CURRENT = 0;
    const SEQUENTIAL = 1;
  }
}
namespace google\appengine_datastore_v3 {
  class PutRequest extends \google\net\ProtocolMessage {
    private $entity = array();
    private $composite_index = array();
    private $snapshot = array();
    public function getEntitySize() {
      return sizeof($this->entity);
    }
    public function getEntityList() {
      return $this->entity;
    }
    public function mutableEntity($idx) {
      if (!isset($this->entity[$idx])) {
        $val = new \storage_onestore_v3\EntityProto();
        $this->entity[$idx] = $val;
        return $val;
      }
      return $this->entity[$idx];
    }
    public function getEntity($idx) {
      if (isset($this->entity[$idx])) {
        return $this->entity[$idx];
      }
      if ($idx >= end(array_keys($this->entity))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\EntityProto();
    }
    public function addEntity() {
      $val = new \storage_onestore_v3\EntityProto();
      $this->entity[] = $val;
      return $val;
    }
    public function clearEntity() {
      $this->entity = array();
    }
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return new \google\appengine_datastore_v3\Transaction();
      }
      return $this->transaction;
    }
    public function mutableTransaction() {
      if (!isset($this->transaction)) {
        $res = new \google\appengine_datastore_v3\Transaction();
        $this->transaction = $res;
        return $res;
      }
      return $this->transaction;
    }
    public function clearTransaction() {
      if (isset($this->transaction)) {
        unset($this->transaction);
      }
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function getCompositeIndexSize() {
      return sizeof($this->composite_index);
    }
    public function getCompositeIndexList() {
      return $this->composite_index;
    }
    public function mutableCompositeIndex($idx) {
      if (!isset($this->composite_index[$idx])) {
        $val = new \storage_onestore_v3\CompositeIndex();
        $this->composite_index[$idx] = $val;
        return $val;
      }
      return $this->composite_index[$idx];
    }
    public function getCompositeIndex($idx) {
      if (isset($this->composite_index[$idx])) {
        return $this->composite_index[$idx];
      }
      if ($idx >= end(array_keys($this->composite_index))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\CompositeIndex();
    }
    public function addCompositeIndex() {
      $val = new \storage_onestore_v3\CompositeIndex();
      $this->composite_index[] = $val;
      return $val;
    }
    public function clearCompositeIndex() {
      $this->composite_index = array();
    }
    public function getTrusted() {
      if (!isset($this->trusted)) {
        return false;
      }
      return $this->trusted;
    }
    public function setTrusted($val) {
      $this->trusted = $val;
      return $this;
    }
    public function clearTrusted() {
      unset($this->trusted);
      return $this;
    }
    public function hasTrusted() {
      return isset($this->trusted);
    }
    public function getForce() {
      if (!isset($this->force)) {
        return false;
      }
      return $this->force;
    }
    public function setForce($val) {
      $this->force = $val;
      return $this;
    }
    public function clearForce() {
      unset($this->force);
      return $this;
    }
    public function hasForce() {
      return isset($this->force);
    }
    public function getMarkChanges() {
      if (!isset($this->mark_changes)) {
        return false;
      }
      return $this->mark_changes;
    }
    public function setMarkChanges($val) {
      $this->mark_changes = $val;
      return $this;
    }
    public function clearMarkChanges() {
      unset($this->mark_changes);
      return $this;
    }
    public function hasMarkChanges() {
      return isset($this->mark_changes);
    }
    public function getSnapshotSize() {
      return sizeof($this->snapshot);
    }
    public function getSnapshotList() {
      return $this->snapshot;
    }
    public function mutableSnapshot($idx) {
      if (!isset($this->snapshot[$idx])) {
        $val = new \storage_onestore_v3\Snapshot();
        $this->snapshot[$idx] = $val;
        return $val;
      }
      return $this->snapshot[$idx];
    }
    public function getSnapshot($idx) {
      if (isset($this->snapshot[$idx])) {
        return $this->snapshot[$idx];
      }
      if ($idx >= end(array_keys($this->snapshot))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Snapshot();
    }
    public function addSnapshot() {
      $val = new \storage_onestore_v3\Snapshot();
      $this->snapshot[] = $val;
      return $val;
    }
    public function clearSnapshot() {
      $this->snapshot = array();
    }
    public function getAutoIdPolicy() {
      if (!isset($this->auto_id_policy)) {
        return 0;
      }
      return $this->auto_id_policy;
    }
    public function setAutoIdPolicy($val) {
      $this->auto_id_policy = $val;
      return $this;
    }
    public function clearAutoIdPolicy() {
      unset($this->auto_id_policy);
      return $this;
    }
    public function hasAutoIdPolicy() {
      return isset($this->auto_id_policy);
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearEntity();
      $this->clearTransaction();
      $this->clearCompositeIndex();
      $this->clearTrusted();
      $this->clearForce();
      $this->clearMarkChanges();
      $this->clearSnapshot();
      $this->clearAutoIdPolicy();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->entity);
      $res += 1 * sizeof($this->entity);
      foreach ($this->entity as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString($this->transaction->byteSizePartial());
      }
      $this->checkProtoArray($this->composite_index);
      $res += 1 * sizeof($this->composite_index);
      foreach ($this->composite_index as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->trusted)) {
        $res += 2;
      }
      if (isset($this->force)) {
        $res += 2;
      }
      if (isset($this->mark_changes)) {
        $res += 2;
      }
      $this->checkProtoArray($this->snapshot);
      $res += 1 * sizeof($this->snapshot);
      foreach ($this->snapshot as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->auto_id_policy)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->auto_id_policy);
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->entity);
      foreach ($this->entity as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->transaction)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->transaction->byteSizePartial());
        $this->transaction->outputPartial($out);
      }
      $this->checkProtoArray($this->composite_index);
      foreach ($this->composite_index as $value) {
        $out->putVarInt32(26);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->trusted)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->trusted);
      }
      if (isset($this->force)) {
        $out->putVarInt32(56);
        $out->putBoolean($this->force);
      }
      if (isset($this->mark_changes)) {
        $out->putVarInt32(64);
        $out->putBoolean($this->mark_changes);
      }
      $this->checkProtoArray($this->snapshot);
      foreach ($this->snapshot as $value) {
        $out->putVarInt32(74);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->auto_id_policy)) {
        $out->putVarInt32(80);
        $out->putVarInt32($this->auto_id_policy);
      }
      if (isset($this->header)) {
        $out->putVarInt32(90);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addEntity()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableTransaction()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addCompositeIndex()->tryMerge($tmp);
            break;
          case 32:
            $this->setTrusted($d->getBoolean());
            break;
          case 56:
            $this->setForce($d->getBoolean());
            break;
          case 64:
            $this->setMarkChanges($d->getBoolean());
            break;
          case 74:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addSnapshot()->tryMerge($tmp);
            break;
          case 80:
            $this->setAutoIdPolicy($d->getVarInt32());
            break;
          case 90:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->entity as $value) {
        if (!$value->isInitialized()) return 'entity';
      }
      if (isset($this->transaction) && (!$this->transaction->isInitialized())) return 'transaction';
      foreach ($this->composite_index as $value) {
        if (!$value->isInitialized()) return 'composite_index';
      }
      foreach ($this->snapshot as $value) {
        if (!$value->isInitialized()) return 'snapshot';
      }
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getEntityList() as $v) {
        $this->addEntity()->copyFrom($v);
      }
      if ($x->hasTransaction()) {
        $this->mutableTransaction()->mergeFrom($x->getTransaction());
      }
      foreach ($x->getCompositeIndexList() as $v) {
        $this->addCompositeIndex()->copyFrom($v);
      }
      if ($x->hasTrusted()) {
        $this->setTrusted($x->getTrusted());
      }
      if ($x->hasForce()) {
        $this->setForce($x->getForce());
      }
      if ($x->hasMarkChanges()) {
        $this->setMarkChanges($x->getMarkChanges());
      }
      foreach ($x->getSnapshotList() as $v) {
        $this->addSnapshot()->copyFrom($v);
      }
      if ($x->hasAutoIdPolicy()) {
        $this->setAutoIdPolicy($x->getAutoIdPolicy());
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->entity) !== sizeof($x->entity)) return false;
      foreach (array_map(null, $this->entity, $x->entity) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && !$this->transaction->equals($x->transaction)) return false;
      if (sizeof($this->composite_index) !== sizeof($x->composite_index)) return false;
      foreach (array_map(null, $this->composite_index, $x->composite_index) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->trusted) !== isset($x->trusted)) return false;
      if (isset($this->trusted) && $this->trusted !== $x->trusted) return false;
      if (isset($this->force) !== isset($x->force)) return false;
      if (isset($this->force) && $this->force !== $x->force) return false;
      if (isset($this->mark_changes) !== isset($x->mark_changes)) return false;
      if (isset($this->mark_changes) && $this->mark_changes !== $x->mark_changes) return false;
      if (sizeof($this->snapshot) !== sizeof($x->snapshot)) return false;
      foreach (array_map(null, $this->snapshot, $x->snapshot) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->auto_id_policy) !== isset($x->auto_id_policy)) return false;
      if (isset($this->auto_id_policy) && $this->auto_id_policy !== $x->auto_id_policy) return false;
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->entity as $value) {
        $res .= $prefix . "entity <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction <\n" . $this->transaction->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->composite_index as $value) {
        $res .= $prefix . "composite_index <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->trusted)) {
        $res .= $prefix . "trusted: " . $this->debugFormatBool($this->trusted) . "\n";
      }
      if (isset($this->force)) {
        $res .= $prefix . "force: " . $this->debugFormatBool($this->force) . "\n";
      }
      if (isset($this->mark_changes)) {
        $res .= $prefix . "mark_changes: " . $this->debugFormatBool($this->mark_changes) . "\n";
      }
      foreach ($this->snapshot as $value) {
        $res .= $prefix . "snapshot <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->auto_id_policy)) {
        $res .= $prefix . "auto_id_policy: " . ($this->auto_id_policy) . "\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class PutResponse extends \google\net\ProtocolMessage {
    private $key = array();
    private $version = array();
    public function getKeySize() {
      return sizeof($this->key);
    }
    public function getKeyList() {
      return $this->key;
    }
    public function mutableKey($idx) {
      if (!isset($this->key[$idx])) {
        $val = new \storage_onestore_v3\Reference();
        $this->key[$idx] = $val;
        return $val;
      }
      return $this->key[$idx];
    }
    public function getKey($idx) {
      if (isset($this->key[$idx])) {
        return $this->key[$idx];
      }
      if ($idx >= end(array_keys($this->key))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Reference();
    }
    public function addKey() {
      $val = new \storage_onestore_v3\Reference();
      $this->key[] = $val;
      return $val;
    }
    public function clearKey() {
      $this->key = array();
    }
    public function getCost() {
      if (!isset($this->cost)) {
        return new \google\appengine_datastore_v3\Cost();
      }
      return $this->cost;
    }
    public function mutableCost() {
      if (!isset($this->cost)) {
        $res = new \google\appengine_datastore_v3\Cost();
        $this->cost = $res;
        return $res;
      }
      return $this->cost;
    }
    public function clearCost() {
      if (isset($this->cost)) {
        unset($this->cost);
      }
    }
    public function hasCost() {
      return isset($this->cost);
    }
    public function getVersionSize() {
      return sizeof($this->version);
    }
    public function getVersionList() {
      return $this->version;
    }
    public function getVersion($idx) {
      return $this->version[$idx];
    }
    public function setVersion($idx, $val) {
      if (is_double($val)) {
        $this->version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->version[$idx] = $val;
      }
      return $this;
    }
    public function addVersion($val) {
      if (is_double($val)) {
        $this->version[] = sprintf('%0.0F', $val);
      } else {
        $this->version[] = $val;
      }
      return $this;
    }
    public function clearVersion() {
      $this->version = array();
    }
    public function clear() {
      $this->clearKey();
      $this->clearCost();
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->key);
      $res += 1 * sizeof($this->key);
      foreach ($this->key as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->cost)) {
        $res += 1;
        $res += $this->lengthString($this->cost->byteSizePartial());
      }
      $this->checkProtoArray($this->version);
      $res += 1 * sizeof($this->version);
      foreach ($this->version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->key);
      foreach ($this->key as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->cost)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->cost->byteSizePartial());
        $this->cost->outputPartial($out);
      }
      $this->checkProtoArray($this->version);
      foreach ($this->version as $value) {
        $out->putVarInt32(24);
        $out->putVarInt64($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addKey()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCost()->tryMerge($tmp);
            break;
          case 24:
            $this->addVersion($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->key as $value) {
        if (!$value->isInitialized()) return 'key';
      }
      if (isset($this->cost) && (!$this->cost->isInitialized())) return 'cost';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getKeyList() as $v) {
        $this->addKey()->copyFrom($v);
      }
      if ($x->hasCost()) {
        $this->mutableCost()->mergeFrom($x->getCost());
      }
      foreach ($x->getVersionList() as $v) {
        $this->addVersion($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->key) !== sizeof($x->key)) return false;
      foreach (array_map(null, $this->key, $x->key) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->cost) !== isset($x->cost)) return false;
      if (isset($this->cost) && !$this->cost->equals($x->cost)) return false;
      if (sizeof($this->version) !== sizeof($x->version)) return false;
      foreach (array_map(null, $this->version, $x->version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->key as $value) {
        $res .= $prefix . "key <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->cost)) {
        $res .= $prefix . "cost <\n" . $this->cost->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->version as $value) {
        $res .= $prefix . "version: " . $this->debugFormatInt64($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class TouchRequest extends \google\net\ProtocolMessage {
    private $key = array();
    private $composite_index = array();
    private $snapshot = array();
    public function getKeySize() {
      return sizeof($this->key);
    }
    public function getKeyList() {
      return $this->key;
    }
    public function mutableKey($idx) {
      if (!isset($this->key[$idx])) {
        $val = new \storage_onestore_v3\Reference();
        $this->key[$idx] = $val;
        return $val;
      }
      return $this->key[$idx];
    }
    public function getKey($idx) {
      if (isset($this->key[$idx])) {
        return $this->key[$idx];
      }
      if ($idx >= end(array_keys($this->key))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Reference();
    }
    public function addKey() {
      $val = new \storage_onestore_v3\Reference();
      $this->key[] = $val;
      return $val;
    }
    public function clearKey() {
      $this->key = array();
    }
    public function getCompositeIndexSize() {
      return sizeof($this->composite_index);
    }
    public function getCompositeIndexList() {
      return $this->composite_index;
    }
    public function mutableCompositeIndex($idx) {
      if (!isset($this->composite_index[$idx])) {
        $val = new \storage_onestore_v3\CompositeIndex();
        $this->composite_index[$idx] = $val;
        return $val;
      }
      return $this->composite_index[$idx];
    }
    public function getCompositeIndex($idx) {
      if (isset($this->composite_index[$idx])) {
        return $this->composite_index[$idx];
      }
      if ($idx >= end(array_keys($this->composite_index))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\CompositeIndex();
    }
    public function addCompositeIndex() {
      $val = new \storage_onestore_v3\CompositeIndex();
      $this->composite_index[] = $val;
      return $val;
    }
    public function clearCompositeIndex() {
      $this->composite_index = array();
    }
    public function getForce() {
      if (!isset($this->force)) {
        return false;
      }
      return $this->force;
    }
    public function setForce($val) {
      $this->force = $val;
      return $this;
    }
    public function clearForce() {
      unset($this->force);
      return $this;
    }
    public function hasForce() {
      return isset($this->force);
    }
    public function getSnapshotSize() {
      return sizeof($this->snapshot);
    }
    public function getSnapshotList() {
      return $this->snapshot;
    }
    public function mutableSnapshot($idx) {
      if (!isset($this->snapshot[$idx])) {
        $val = new \storage_onestore_v3\Snapshot();
        $this->snapshot[$idx] = $val;
        return $val;
      }
      return $this->snapshot[$idx];
    }
    public function getSnapshot($idx) {
      if (isset($this->snapshot[$idx])) {
        return $this->snapshot[$idx];
      }
      if ($idx >= end(array_keys($this->snapshot))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Snapshot();
    }
    public function addSnapshot() {
      $val = new \storage_onestore_v3\Snapshot();
      $this->snapshot[] = $val;
      return $val;
    }
    public function clearSnapshot() {
      $this->snapshot = array();
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearKey();
      $this->clearCompositeIndex();
      $this->clearForce();
      $this->clearSnapshot();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->key);
      $res += 1 * sizeof($this->key);
      foreach ($this->key as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->composite_index);
      $res += 1 * sizeof($this->composite_index);
      foreach ($this->composite_index as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->force)) {
        $res += 2;
      }
      $this->checkProtoArray($this->snapshot);
      $res += 1 * sizeof($this->snapshot);
      foreach ($this->snapshot as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->key);
      foreach ($this->key as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->composite_index);
      foreach ($this->composite_index as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->force)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->force);
      }
      $this->checkProtoArray($this->snapshot);
      foreach ($this->snapshot as $value) {
        $out->putVarInt32(74);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->header)) {
        $out->putVarInt32(82);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addKey()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addCompositeIndex()->tryMerge($tmp);
            break;
          case 24:
            $this->setForce($d->getBoolean());
            break;
          case 74:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addSnapshot()->tryMerge($tmp);
            break;
          case 82:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->key as $value) {
        if (!$value->isInitialized()) return 'key';
      }
      foreach ($this->composite_index as $value) {
        if (!$value->isInitialized()) return 'composite_index';
      }
      foreach ($this->snapshot as $value) {
        if (!$value->isInitialized()) return 'snapshot';
      }
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getKeyList() as $v) {
        $this->addKey()->copyFrom($v);
      }
      foreach ($x->getCompositeIndexList() as $v) {
        $this->addCompositeIndex()->copyFrom($v);
      }
      if ($x->hasForce()) {
        $this->setForce($x->getForce());
      }
      foreach ($x->getSnapshotList() as $v) {
        $this->addSnapshot()->copyFrom($v);
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->key) !== sizeof($x->key)) return false;
      foreach (array_map(null, $this->key, $x->key) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->composite_index) !== sizeof($x->composite_index)) return false;
      foreach (array_map(null, $this->composite_index, $x->composite_index) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->force) !== isset($x->force)) return false;
      if (isset($this->force) && $this->force !== $x->force) return false;
      if (sizeof($this->snapshot) !== sizeof($x->snapshot)) return false;
      foreach (array_map(null, $this->snapshot, $x->snapshot) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->key as $value) {
        $res .= $prefix . "key <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->composite_index as $value) {
        $res .= $prefix . "composite_index <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->force)) {
        $res .= $prefix . "force: " . $this->debugFormatBool($this->force) . "\n";
      }
      foreach ($this->snapshot as $value) {
        $res .= $prefix . "snapshot <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class TouchResponse extends \google\net\ProtocolMessage {
    public function getCost() {
      if (!isset($this->cost)) {
        return new \google\appengine_datastore_v3\Cost();
      }
      return $this->cost;
    }
    public function mutableCost() {
      if (!isset($this->cost)) {
        $res = new \google\appengine_datastore_v3\Cost();
        $this->cost = $res;
        return $res;
      }
      return $this->cost;
    }
    public function clearCost() {
      if (isset($this->cost)) {
        unset($this->cost);
      }
    }
    public function hasCost() {
      return isset($this->cost);
    }
    public function clear() {
      $this->clearCost();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->cost)) {
        $res += 1;
        $res += $this->lengthString($this->cost->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->cost)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->cost->byteSizePartial());
        $this->cost->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCost()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->cost) && (!$this->cost->isInitialized())) return 'cost';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCost()) {
        $this->mutableCost()->mergeFrom($x->getCost());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->cost) !== isset($x->cost)) return false;
      if (isset($this->cost) && !$this->cost->equals($x->cost)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->cost)) {
        $res .= $prefix . "cost <\n" . $this->cost->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class DeleteRequest extends \google\net\ProtocolMessage {
    private $key = array();
    private $snapshot = array();
    private $composite_index = array();
    public function getTrusted() {
      if (!isset($this->trusted)) {
        return false;
      }
      return $this->trusted;
    }
    public function setTrusted($val) {
      $this->trusted = $val;
      return $this;
    }
    public function clearTrusted() {
      unset($this->trusted);
      return $this;
    }
    public function hasTrusted() {
      return isset($this->trusted);
    }
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return new \google\appengine_datastore_v3\Transaction();
      }
      return $this->transaction;
    }
    public function mutableTransaction() {
      if (!isset($this->transaction)) {
        $res = new \google\appengine_datastore_v3\Transaction();
        $this->transaction = $res;
        return $res;
      }
      return $this->transaction;
    }
    public function clearTransaction() {
      if (isset($this->transaction)) {
        unset($this->transaction);
      }
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function getKeySize() {
      return sizeof($this->key);
    }
    public function getKeyList() {
      return $this->key;
    }
    public function mutableKey($idx) {
      if (!isset($this->key[$idx])) {
        $val = new \storage_onestore_v3\Reference();
        $this->key[$idx] = $val;
        return $val;
      }
      return $this->key[$idx];
    }
    public function getKey($idx) {
      if (isset($this->key[$idx])) {
        return $this->key[$idx];
      }
      if ($idx >= end(array_keys($this->key))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Reference();
    }
    public function addKey() {
      $val = new \storage_onestore_v3\Reference();
      $this->key[] = $val;
      return $val;
    }
    public function clearKey() {
      $this->key = array();
    }
    public function getForce() {
      if (!isset($this->force)) {
        return false;
      }
      return $this->force;
    }
    public function setForce($val) {
      $this->force = $val;
      return $this;
    }
    public function clearForce() {
      unset($this->force);
      return $this;
    }
    public function hasForce() {
      return isset($this->force);
    }
    public function getMarkChanges() {
      if (!isset($this->mark_changes)) {
        return false;
      }
      return $this->mark_changes;
    }
    public function setMarkChanges($val) {
      $this->mark_changes = $val;
      return $this;
    }
    public function clearMarkChanges() {
      unset($this->mark_changes);
      return $this;
    }
    public function hasMarkChanges() {
      return isset($this->mark_changes);
    }
    public function getSnapshotSize() {
      return sizeof($this->snapshot);
    }
    public function getSnapshotList() {
      return $this->snapshot;
    }
    public function mutableSnapshot($idx) {
      if (!isset($this->snapshot[$idx])) {
        $val = new \storage_onestore_v3\Snapshot();
        $this->snapshot[$idx] = $val;
        return $val;
      }
      return $this->snapshot[$idx];
    }
    public function getSnapshot($idx) {
      if (isset($this->snapshot[$idx])) {
        return $this->snapshot[$idx];
      }
      if ($idx >= end(array_keys($this->snapshot))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Snapshot();
    }
    public function addSnapshot() {
      $val = new \storage_onestore_v3\Snapshot();
      $this->snapshot[] = $val;
      return $val;
    }
    public function clearSnapshot() {
      $this->snapshot = array();
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function getCompositeIndexSize() {
      return sizeof($this->composite_index);
    }
    public function getCompositeIndexList() {
      return $this->composite_index;
    }
    public function mutableCompositeIndex($idx) {
      if (!isset($this->composite_index[$idx])) {
        $val = new \storage_onestore_v3\CompositeIndex();
        $this->composite_index[$idx] = $val;
        return $val;
      }
      return $this->composite_index[$idx];
    }
    public function getCompositeIndex($idx) {
      if (isset($this->composite_index[$idx])) {
        return $this->composite_index[$idx];
      }
      if ($idx >= end(array_keys($this->composite_index))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\CompositeIndex();
    }
    public function addCompositeIndex() {
      $val = new \storage_onestore_v3\CompositeIndex();
      $this->composite_index[] = $val;
      return $val;
    }
    public function clearCompositeIndex() {
      $this->composite_index = array();
    }
    public function clear() {
      $this->clearTrusted();
      $this->clearTransaction();
      $this->clearKey();
      $this->clearForce();
      $this->clearMarkChanges();
      $this->clearSnapshot();
      $this->clearHeader();
      $this->clearCompositeIndex();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->trusted)) {
        $res += 2;
      }
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString($this->transaction->byteSizePartial());
      }
      $this->checkProtoArray($this->key);
      $res += 1 * sizeof($this->key);
      foreach ($this->key as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->force)) {
        $res += 2;
      }
      if (isset($this->mark_changes)) {
        $res += 2;
      }
      $this->checkProtoArray($this->snapshot);
      $res += 1 * sizeof($this->snapshot);
      foreach ($this->snapshot as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      $this->checkProtoArray($this->composite_index);
      $res += 1 * sizeof($this->composite_index);
      foreach ($this->composite_index as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->trusted)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->trusted);
      }
      if (isset($this->transaction)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->transaction->byteSizePartial());
        $this->transaction->outputPartial($out);
      }
      $this->checkProtoArray($this->key);
      foreach ($this->key as $value) {
        $out->putVarInt32(50);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->force)) {
        $out->putVarInt32(56);
        $out->putBoolean($this->force);
      }
      if (isset($this->mark_changes)) {
        $out->putVarInt32(64);
        $out->putBoolean($this->mark_changes);
      }
      $this->checkProtoArray($this->snapshot);
      foreach ($this->snapshot as $value) {
        $out->putVarInt32(74);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->header)) {
        $out->putVarInt32(82);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
      $this->checkProtoArray($this->composite_index);
      foreach ($this->composite_index as $value) {
        $out->putVarInt32(90);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 32:
            $this->setTrusted($d->getBoolean());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableTransaction()->tryMerge($tmp);
            break;
          case 50:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addKey()->tryMerge($tmp);
            break;
          case 56:
            $this->setForce($d->getBoolean());
            break;
          case 64:
            $this->setMarkChanges($d->getBoolean());
            break;
          case 74:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addSnapshot()->tryMerge($tmp);
            break;
          case 82:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 90:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addCompositeIndex()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->transaction) && (!$this->transaction->isInitialized())) return 'transaction';
      foreach ($this->key as $value) {
        if (!$value->isInitialized()) return 'key';
      }
      foreach ($this->snapshot as $value) {
        if (!$value->isInitialized()) return 'snapshot';
      }
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      foreach ($this->composite_index as $value) {
        if (!$value->isInitialized()) return 'composite_index';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTrusted()) {
        $this->setTrusted($x->getTrusted());
      }
      if ($x->hasTransaction()) {
        $this->mutableTransaction()->mergeFrom($x->getTransaction());
      }
      foreach ($x->getKeyList() as $v) {
        $this->addKey()->copyFrom($v);
      }
      if ($x->hasForce()) {
        $this->setForce($x->getForce());
      }
      if ($x->hasMarkChanges()) {
        $this->setMarkChanges($x->getMarkChanges());
      }
      foreach ($x->getSnapshotList() as $v) {
        $this->addSnapshot()->copyFrom($v);
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
      foreach ($x->getCompositeIndexList() as $v) {
        $this->addCompositeIndex()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->trusted) !== isset($x->trusted)) return false;
      if (isset($this->trusted) && $this->trusted !== $x->trusted) return false;
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && !$this->transaction->equals($x->transaction)) return false;
      if (sizeof($this->key) !== sizeof($x->key)) return false;
      foreach (array_map(null, $this->key, $x->key) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->force) !== isset($x->force)) return false;
      if (isset($this->force) && $this->force !== $x->force) return false;
      if (isset($this->mark_changes) !== isset($x->mark_changes)) return false;
      if (isset($this->mark_changes) && $this->mark_changes !== $x->mark_changes) return false;
      if (sizeof($this->snapshot) !== sizeof($x->snapshot)) return false;
      foreach (array_map(null, $this->snapshot, $x->snapshot) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      if (sizeof($this->composite_index) !== sizeof($x->composite_index)) return false;
      foreach (array_map(null, $this->composite_index, $x->composite_index) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->trusted)) {
        $res .= $prefix . "trusted: " . $this->debugFormatBool($this->trusted) . "\n";
      }
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction <\n" . $this->transaction->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->key as $value) {
        $res .= $prefix . "key <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->force)) {
        $res .= $prefix . "force: " . $this->debugFormatBool($this->force) . "\n";
      }
      if (isset($this->mark_changes)) {
        $res .= $prefix . "mark_changes: " . $this->debugFormatBool($this->mark_changes) . "\n";
      }
      foreach ($this->snapshot as $value) {
        $res .= $prefix . "snapshot <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->composite_index as $value) {
        $res .= $prefix . "composite_index <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class DeleteResponse extends \google\net\ProtocolMessage {
    private $version = array();
    public function getCost() {
      if (!isset($this->cost)) {
        return new \google\appengine_datastore_v3\Cost();
      }
      return $this->cost;
    }
    public function mutableCost() {
      if (!isset($this->cost)) {
        $res = new \google\appengine_datastore_v3\Cost();
        $this->cost = $res;
        return $res;
      }
      return $this->cost;
    }
    public function clearCost() {
      if (isset($this->cost)) {
        unset($this->cost);
      }
    }
    public function hasCost() {
      return isset($this->cost);
    }
    public function getVersionSize() {
      return sizeof($this->version);
    }
    public function getVersionList() {
      return $this->version;
    }
    public function getVersion($idx) {
      return $this->version[$idx];
    }
    public function setVersion($idx, $val) {
      if (is_double($val)) {
        $this->version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->version[$idx] = $val;
      }
      return $this;
    }
    public function addVersion($val) {
      if (is_double($val)) {
        $this->version[] = sprintf('%0.0F', $val);
      } else {
        $this->version[] = $val;
      }
      return $this;
    }
    public function clearVersion() {
      $this->version = array();
    }
    public function clear() {
      $this->clearCost();
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->cost)) {
        $res += 1;
        $res += $this->lengthString($this->cost->byteSizePartial());
      }
      $this->checkProtoArray($this->version);
      $res += 1 * sizeof($this->version);
      foreach ($this->version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->cost)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->cost->byteSizePartial());
        $this->cost->outputPartial($out);
      }
      $this->checkProtoArray($this->version);
      foreach ($this->version as $value) {
        $out->putVarInt32(24);
        $out->putVarInt64($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCost()->tryMerge($tmp);
            break;
          case 24:
            $this->addVersion($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->cost) && (!$this->cost->isInitialized())) return 'cost';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCost()) {
        $this->mutableCost()->mergeFrom($x->getCost());
      }
      foreach ($x->getVersionList() as $v) {
        $this->addVersion($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->cost) !== isset($x->cost)) return false;
      if (isset($this->cost) && !$this->cost->equals($x->cost)) return false;
      if (sizeof($this->version) !== sizeof($x->version)) return false;
      foreach (array_map(null, $this->version, $x->version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->cost)) {
        $res .= $prefix . "cost <\n" . $this->cost->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->version as $value) {
        $res .= $prefix . "version: " . $this->debugFormatInt64($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class NextRequest extends \google\net\ProtocolMessage {
    public function getCursor() {
      if (!isset($this->cursor)) {
        return new \google\appengine_datastore_v3\Cursor();
      }
      return $this->cursor;
    }
    public function mutableCursor() {
      if (!isset($this->cursor)) {
        $res = new \google\appengine_datastore_v3\Cursor();
        $this->cursor = $res;
        return $res;
      }
      return $this->cursor;
    }
    public function clearCursor() {
      if (isset($this->cursor)) {
        unset($this->cursor);
      }
    }
    public function hasCursor() {
      return isset($this->cursor);
    }
    public function getCount() {
      if (!isset($this->count)) {
        return 0;
      }
      return $this->count;
    }
    public function setCount($val) {
      $this->count = $val;
      return $this;
    }
    public function clearCount() {
      unset($this->count);
      return $this;
    }
    public function hasCount() {
      return isset($this->count);
    }
    public function getCompile() {
      if (!isset($this->compile)) {
        return false;
      }
      return $this->compile;
    }
    public function setCompile($val) {
      $this->compile = $val;
      return $this;
    }
    public function clearCompile() {
      unset($this->compile);
      return $this;
    }
    public function hasCompile() {
      return isset($this->compile);
    }
    public function getOffset() {
      if (!isset($this->offset)) {
        return 0;
      }
      return $this->offset;
    }
    public function setOffset($val) {
      $this->offset = $val;
      return $this;
    }
    public function clearOffset() {
      unset($this->offset);
      return $this;
    }
    public function hasOffset() {
      return isset($this->offset);
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearCursor();
      $this->clearCount();
      $this->clearCompile();
      $this->clearOffset();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->cursor)) {
        $res += 1;
        $res += $this->lengthString($this->cursor->byteSizePartial());
      }
      if (isset($this->count)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->count);
      }
      if (isset($this->compile)) {
        $res += 2;
      }
      if (isset($this->offset)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->offset);
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->cursor)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->cursor->byteSizePartial());
        $this->cursor->outputPartial($out);
      }
      if (isset($this->count)) {
        $out->putVarInt32(16);
        $out->putVarInt32($this->count);
      }
      if (isset($this->compile)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->compile);
      }
      if (isset($this->offset)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->offset);
      }
      if (isset($this->header)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCursor()->tryMerge($tmp);
            break;
          case 16:
            $this->setCount($d->getVarInt32());
            break;
          case 24:
            $this->setCompile($d->getBoolean());
            break;
          case 32:
            $this->setOffset($d->getVarInt32());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->cursor)) || (!$this->cursor->isInitialized())) return 'cursor';
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCursor()) {
        $this->mutableCursor()->mergeFrom($x->getCursor());
      }
      if ($x->hasCount()) {
        $this->setCount($x->getCount());
      }
      if ($x->hasCompile()) {
        $this->setCompile($x->getCompile());
      }
      if ($x->hasOffset()) {
        $this->setOffset($x->getOffset());
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->cursor) !== isset($x->cursor)) return false;
      if (isset($this->cursor) && !$this->cursor->equals($x->cursor)) return false;
      if (isset($this->count) !== isset($x->count)) return false;
      if (isset($this->count) && !$this->integerEquals($this->count, $x->count)) return false;
      if (isset($this->compile) !== isset($x->compile)) return false;
      if (isset($this->compile) && $this->compile !== $x->compile) return false;
      if (isset($this->offset) !== isset($x->offset)) return false;
      if (isset($this->offset) && !$this->integerEquals($this->offset, $x->offset)) return false;
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->cursor)) {
        $res .= $prefix . "cursor <\n" . $this->cursor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->count)) {
        $res .= $prefix . "count: " . $this->debugFormatInt32($this->count) . "\n";
      }
      if (isset($this->compile)) {
        $res .= $prefix . "compile: " . $this->debugFormatBool($this->compile) . "\n";
      }
      if (isset($this->offset)) {
        $res .= $prefix . "offset: " . $this->debugFormatInt32($this->offset) . "\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class QueryResult extends \google\net\ProtocolMessage {
    private $result = array();
    private $index = array();
    private $version = array();
    private $result_compiled_cursor = array();
    public function getCursor() {
      if (!isset($this->cursor)) {
        return new \google\appengine_datastore_v3\Cursor();
      }
      return $this->cursor;
    }
    public function mutableCursor() {
      if (!isset($this->cursor)) {
        $res = new \google\appengine_datastore_v3\Cursor();
        $this->cursor = $res;
        return $res;
      }
      return $this->cursor;
    }
    public function clearCursor() {
      if (isset($this->cursor)) {
        unset($this->cursor);
      }
    }
    public function hasCursor() {
      return isset($this->cursor);
    }
    public function getResultSize() {
      return sizeof($this->result);
    }
    public function getResultList() {
      return $this->result;
    }
    public function mutableResult($idx) {
      if (!isset($this->result[$idx])) {
        $val = new \storage_onestore_v3\EntityProto();
        $this->result[$idx] = $val;
        return $val;
      }
      return $this->result[$idx];
    }
    public function getResult($idx) {
      if (isset($this->result[$idx])) {
        return $this->result[$idx];
      }
      if ($idx >= end(array_keys($this->result))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\EntityProto();
    }
    public function addResult() {
      $val = new \storage_onestore_v3\EntityProto();
      $this->result[] = $val;
      return $val;
    }
    public function clearResult() {
      $this->result = array();
    }
    public function getMoreResults() {
      if (!isset($this->more_results)) {
        return false;
      }
      return $this->more_results;
    }
    public function setMoreResults($val) {
      $this->more_results = $val;
      return $this;
    }
    public function clearMoreResults() {
      unset($this->more_results);
      return $this;
    }
    public function hasMoreResults() {
      return isset($this->more_results);
    }
    public function getKeysOnly() {
      if (!isset($this->keys_only)) {
        return false;
      }
      return $this->keys_only;
    }
    public function setKeysOnly($val) {
      $this->keys_only = $val;
      return $this;
    }
    public function clearKeysOnly() {
      unset($this->keys_only);
      return $this;
    }
    public function hasKeysOnly() {
      return isset($this->keys_only);
    }
    public function getCompiledQuery() {
      if (!isset($this->compiled_query)) {
        return new \google\appengine_datastore_v3\CompiledQuery();
      }
      return $this->compiled_query;
    }
    public function mutableCompiledQuery() {
      if (!isset($this->compiled_query)) {
        $res = new \google\appengine_datastore_v3\CompiledQuery();
        $this->compiled_query = $res;
        return $res;
      }
      return $this->compiled_query;
    }
    public function clearCompiledQuery() {
      if (isset($this->compiled_query)) {
        unset($this->compiled_query);
      }
    }
    public function hasCompiledQuery() {
      return isset($this->compiled_query);
    }
    public function getCompiledCursor() {
      if (!isset($this->compiled_cursor)) {
        return new \google\appengine_datastore_v3\CompiledCursor();
      }
      return $this->compiled_cursor;
    }
    public function mutableCompiledCursor() {
      if (!isset($this->compiled_cursor)) {
        $res = new \google\appengine_datastore_v3\CompiledCursor();
        $this->compiled_cursor = $res;
        return $res;
      }
      return $this->compiled_cursor;
    }
    public function clearCompiledCursor() {
      if (isset($this->compiled_cursor)) {
        unset($this->compiled_cursor);
      }
    }
    public function hasCompiledCursor() {
      return isset($this->compiled_cursor);
    }
    public function getSkippedResults() {
      if (!isset($this->skipped_results)) {
        return 0;
      }
      return $this->skipped_results;
    }
    public function setSkippedResults($val) {
      $this->skipped_results = $val;
      return $this;
    }
    public function clearSkippedResults() {
      unset($this->skipped_results);
      return $this;
    }
    public function hasSkippedResults() {
      return isset($this->skipped_results);
    }
    public function getIndexSize() {
      return sizeof($this->index);
    }
    public function getIndexList() {
      return $this->index;
    }
    public function mutableIndex($idx) {
      if (!isset($this->index[$idx])) {
        $val = new \storage_onestore_v3\CompositeIndex();
        $this->index[$idx] = $val;
        return $val;
      }
      return $this->index[$idx];
    }
    public function getIndex($idx) {
      if (isset($this->index[$idx])) {
        return $this->index[$idx];
      }
      if ($idx >= end(array_keys($this->index))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\CompositeIndex();
    }
    public function addIndex() {
      $val = new \storage_onestore_v3\CompositeIndex();
      $this->index[] = $val;
      return $val;
    }
    public function clearIndex() {
      $this->index = array();
    }
    public function getIndexOnly() {
      if (!isset($this->index_only)) {
        return false;
      }
      return $this->index_only;
    }
    public function setIndexOnly($val) {
      $this->index_only = $val;
      return $this;
    }
    public function clearIndexOnly() {
      unset($this->index_only);
      return $this;
    }
    public function hasIndexOnly() {
      return isset($this->index_only);
    }
    public function getSmallOps() {
      if (!isset($this->small_ops)) {
        return false;
      }
      return $this->small_ops;
    }
    public function setSmallOps($val) {
      $this->small_ops = $val;
      return $this;
    }
    public function clearSmallOps() {
      unset($this->small_ops);
      return $this;
    }
    public function hasSmallOps() {
      return isset($this->small_ops);
    }
    public function getVersionSize() {
      return sizeof($this->version);
    }
    public function getVersionList() {
      return $this->version;
    }
    public function getVersion($idx) {
      return $this->version[$idx];
    }
    public function setVersion($idx, $val) {
      if (is_double($val)) {
        $this->version[$idx] = sprintf('%0.0F', $val);
      } else {
        $this->version[$idx] = $val;
      }
      return $this;
    }
    public function addVersion($val) {
      if (is_double($val)) {
        $this->version[] = sprintf('%0.0F', $val);
      } else {
        $this->version[] = $val;
      }
      return $this;
    }
    public function clearVersion() {
      $this->version = array();
    }
    public function getResultCompiledCursorSize() {
      return sizeof($this->result_compiled_cursor);
    }
    public function getResultCompiledCursorList() {
      return $this->result_compiled_cursor;
    }
    public function mutableResultCompiledCursor($idx) {
      if (!isset($this->result_compiled_cursor[$idx])) {
        $val = new \google\appengine_datastore_v3\CompiledCursor();
        $this->result_compiled_cursor[$idx] = $val;
        return $val;
      }
      return $this->result_compiled_cursor[$idx];
    }
    public function getResultCompiledCursor($idx) {
      if (isset($this->result_compiled_cursor[$idx])) {
        return $this->result_compiled_cursor[$idx];
      }
      if ($idx >= end(array_keys($this->result_compiled_cursor))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine_datastore_v3\CompiledCursor();
    }
    public function addResultCompiledCursor() {
      $val = new \google\appengine_datastore_v3\CompiledCursor();
      $this->result_compiled_cursor[] = $val;
      return $val;
    }
    public function clearResultCompiledCursor() {
      $this->result_compiled_cursor = array();
    }
    public function getSkippedResultsCompiledCursor() {
      if (!isset($this->skipped_results_compiled_cursor)) {
        return new \google\appengine_datastore_v3\CompiledCursor();
      }
      return $this->skipped_results_compiled_cursor;
    }
    public function mutableSkippedResultsCompiledCursor() {
      if (!isset($this->skipped_results_compiled_cursor)) {
        $res = new \google\appengine_datastore_v3\CompiledCursor();
        $this->skipped_results_compiled_cursor = $res;
        return $res;
      }
      return $this->skipped_results_compiled_cursor;
    }
    public function clearSkippedResultsCompiledCursor() {
      if (isset($this->skipped_results_compiled_cursor)) {
        unset($this->skipped_results_compiled_cursor);
      }
    }
    public function hasSkippedResultsCompiledCursor() {
      return isset($this->skipped_results_compiled_cursor);
    }
    public function clear() {
      $this->clearCursor();
      $this->clearResult();
      $this->clearMoreResults();
      $this->clearKeysOnly();
      $this->clearCompiledQuery();
      $this->clearCompiledCursor();
      $this->clearSkippedResults();
      $this->clearIndex();
      $this->clearIndexOnly();
      $this->clearSmallOps();
      $this->clearVersion();
      $this->clearResultCompiledCursor();
      $this->clearSkippedResultsCompiledCursor();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->cursor)) {
        $res += 1;
        $res += $this->lengthString($this->cursor->byteSizePartial());
      }
      $this->checkProtoArray($this->result);
      $res += 1 * sizeof($this->result);
      foreach ($this->result as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->more_results)) {
        $res += 2;
      }
      if (isset($this->keys_only)) {
        $res += 2;
      }
      if (isset($this->compiled_query)) {
        $res += 1;
        $res += $this->lengthString($this->compiled_query->byteSizePartial());
      }
      if (isset($this->compiled_cursor)) {
        $res += 1;
        $res += $this->lengthString($this->compiled_cursor->byteSizePartial());
      }
      if (isset($this->skipped_results)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->skipped_results);
      }
      $this->checkProtoArray($this->index);
      $res += 1 * sizeof($this->index);
      foreach ($this->index as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->index_only)) {
        $res += 2;
      }
      if (isset($this->small_ops)) {
        $res += 2;
      }
      $this->checkProtoArray($this->version);
      $res += 1 * sizeof($this->version);
      foreach ($this->version as $value) {
        $res += $this->lengthVarInt64($value);
      }
      $this->checkProtoArray($this->result_compiled_cursor);
      $res += 1 * sizeof($this->result_compiled_cursor);
      foreach ($this->result_compiled_cursor as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->skipped_results_compiled_cursor)) {
        $res += 1;
        $res += $this->lengthString($this->skipped_results_compiled_cursor->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->cursor)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->cursor->byteSizePartial());
        $this->cursor->outputPartial($out);
      }
      $this->checkProtoArray($this->result);
      foreach ($this->result as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->more_results)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->more_results);
      }
      if (isset($this->keys_only)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->keys_only);
      }
      if (isset($this->compiled_query)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->compiled_query->byteSizePartial());
        $this->compiled_query->outputPartial($out);
      }
      if (isset($this->compiled_cursor)) {
        $out->putVarInt32(50);
        $out->putVarInt32($this->compiled_cursor->byteSizePartial());
        $this->compiled_cursor->outputPartial($out);
      }
      if (isset($this->skipped_results)) {
        $out->putVarInt32(56);
        $out->putVarInt32($this->skipped_results);
      }
      $this->checkProtoArray($this->index);
      foreach ($this->index as $value) {
        $out->putVarInt32(66);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->index_only)) {
        $out->putVarInt32(72);
        $out->putBoolean($this->index_only);
      }
      if (isset($this->small_ops)) {
        $out->putVarInt32(80);
        $out->putBoolean($this->small_ops);
      }
      $this->checkProtoArray($this->version);
      foreach ($this->version as $value) {
        $out->putVarInt32(88);
        $out->putVarInt64($value);
      }
      $this->checkProtoArray($this->result_compiled_cursor);
      foreach ($this->result_compiled_cursor as $value) {
        $out->putVarInt32(98);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->skipped_results_compiled_cursor)) {
        $out->putVarInt32(106);
        $out->putVarInt32($this->skipped_results_compiled_cursor->byteSizePartial());
        $this->skipped_results_compiled_cursor->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCursor()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addResult()->tryMerge($tmp);
            break;
          case 24:
            $this->setMoreResults($d->getBoolean());
            break;
          case 32:
            $this->setKeysOnly($d->getBoolean());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCompiledQuery()->tryMerge($tmp);
            break;
          case 50:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCompiledCursor()->tryMerge($tmp);
            break;
          case 56:
            $this->setSkippedResults($d->getVarInt32());
            break;
          case 66:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addIndex()->tryMerge($tmp);
            break;
          case 72:
            $this->setIndexOnly($d->getBoolean());
            break;
          case 80:
            $this->setSmallOps($d->getBoolean());
            break;
          case 88:
            $this->addVersion($d->getVarInt64());
            break;
          case 98:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addResultCompiledCursor()->tryMerge($tmp);
            break;
          case 106:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableSkippedResultsCompiledCursor()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->cursor) && (!$this->cursor->isInitialized())) return 'cursor';
      foreach ($this->result as $value) {
        if (!$value->isInitialized()) return 'result';
      }
      if (!isset($this->more_results)) return 'more_results';
      if (isset($this->compiled_query) && (!$this->compiled_query->isInitialized())) return 'compiled_query';
      if (isset($this->compiled_cursor) && (!$this->compiled_cursor->isInitialized())) return 'compiled_cursor';
      foreach ($this->index as $value) {
        if (!$value->isInitialized()) return 'index';
      }
      foreach ($this->result_compiled_cursor as $value) {
        if (!$value->isInitialized()) return 'result_compiled_cursor';
      }
      if (isset($this->skipped_results_compiled_cursor) && (!$this->skipped_results_compiled_cursor->isInitialized())) return 'skipped_results_compiled_cursor';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCursor()) {
        $this->mutableCursor()->mergeFrom($x->getCursor());
      }
      foreach ($x->getResultList() as $v) {
        $this->addResult()->copyFrom($v);
      }
      if ($x->hasMoreResults()) {
        $this->setMoreResults($x->getMoreResults());
      }
      if ($x->hasKeysOnly()) {
        $this->setKeysOnly($x->getKeysOnly());
      }
      if ($x->hasCompiledQuery()) {
        $this->mutableCompiledQuery()->mergeFrom($x->getCompiledQuery());
      }
      if ($x->hasCompiledCursor()) {
        $this->mutableCompiledCursor()->mergeFrom($x->getCompiledCursor());
      }
      if ($x->hasSkippedResults()) {
        $this->setSkippedResults($x->getSkippedResults());
      }
      foreach ($x->getIndexList() as $v) {
        $this->addIndex()->copyFrom($v);
      }
      if ($x->hasIndexOnly()) {
        $this->setIndexOnly($x->getIndexOnly());
      }
      if ($x->hasSmallOps()) {
        $this->setSmallOps($x->getSmallOps());
      }
      foreach ($x->getVersionList() as $v) {
        $this->addVersion($v);
      }
      foreach ($x->getResultCompiledCursorList() as $v) {
        $this->addResultCompiledCursor()->copyFrom($v);
      }
      if ($x->hasSkippedResultsCompiledCursor()) {
        $this->mutableSkippedResultsCompiledCursor()->mergeFrom($x->getSkippedResultsCompiledCursor());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->cursor) !== isset($x->cursor)) return false;
      if (isset($this->cursor) && !$this->cursor->equals($x->cursor)) return false;
      if (sizeof($this->result) !== sizeof($x->result)) return false;
      foreach (array_map(null, $this->result, $x->result) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->more_results) !== isset($x->more_results)) return false;
      if (isset($this->more_results) && $this->more_results !== $x->more_results) return false;
      if (isset($this->keys_only) !== isset($x->keys_only)) return false;
      if (isset($this->keys_only) && $this->keys_only !== $x->keys_only) return false;
      if (isset($this->compiled_query) !== isset($x->compiled_query)) return false;
      if (isset($this->compiled_query) && !$this->compiled_query->equals($x->compiled_query)) return false;
      if (isset($this->compiled_cursor) !== isset($x->compiled_cursor)) return false;
      if (isset($this->compiled_cursor) && !$this->compiled_cursor->equals($x->compiled_cursor)) return false;
      if (isset($this->skipped_results) !== isset($x->skipped_results)) return false;
      if (isset($this->skipped_results) && !$this->integerEquals($this->skipped_results, $x->skipped_results)) return false;
      if (sizeof($this->index) !== sizeof($x->index)) return false;
      foreach (array_map(null, $this->index, $x->index) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->index_only) !== isset($x->index_only)) return false;
      if (isset($this->index_only) && $this->index_only !== $x->index_only) return false;
      if (isset($this->small_ops) !== isset($x->small_ops)) return false;
      if (isset($this->small_ops) && $this->small_ops !== $x->small_ops) return false;
      if (sizeof($this->version) !== sizeof($x->version)) return false;
      foreach (array_map(null, $this->version, $x->version) as $v) {
        if (!$this->integerEquals($v[0], $v[1])) return false;
      }
      if (sizeof($this->result_compiled_cursor) !== sizeof($x->result_compiled_cursor)) return false;
      foreach (array_map(null, $this->result_compiled_cursor, $x->result_compiled_cursor) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->skipped_results_compiled_cursor) !== isset($x->skipped_results_compiled_cursor)) return false;
      if (isset($this->skipped_results_compiled_cursor) && !$this->skipped_results_compiled_cursor->equals($x->skipped_results_compiled_cursor)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->cursor)) {
        $res .= $prefix . "cursor <\n" . $this->cursor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->result as $value) {
        $res .= $prefix . "result <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->more_results)) {
        $res .= $prefix . "more_results: " . $this->debugFormatBool($this->more_results) . "\n";
      }
      if (isset($this->keys_only)) {
        $res .= $prefix . "keys_only: " . $this->debugFormatBool($this->keys_only) . "\n";
      }
      if (isset($this->compiled_query)) {
        $res .= $prefix . "compiled_query <\n" . $this->compiled_query->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->compiled_cursor)) {
        $res .= $prefix . "compiled_cursor <\n" . $this->compiled_cursor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->skipped_results)) {
        $res .= $prefix . "skipped_results: " . $this->debugFormatInt32($this->skipped_results) . "\n";
      }
      foreach ($this->index as $value) {
        $res .= $prefix . "index <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->index_only)) {
        $res .= $prefix . "index_only: " . $this->debugFormatBool($this->index_only) . "\n";
      }
      if (isset($this->small_ops)) {
        $res .= $prefix . "small_ops: " . $this->debugFormatBool($this->small_ops) . "\n";
      }
      foreach ($this->version as $value) {
        $res .= $prefix . "version: " . $this->debugFormatInt64($value) . "\n";
      }
      foreach ($this->result_compiled_cursor as $value) {
        $res .= $prefix . "result_compiled_cursor <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->skipped_results_compiled_cursor)) {
        $res .= $prefix . "skipped_results_compiled_cursor <\n" . $this->skipped_results_compiled_cursor->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class AllocateIdsRequest extends \google\net\ProtocolMessage {
    private $reserve = array();
    public function getModelKey() {
      if (!isset($this->model_key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->model_key;
    }
    public function mutableModelKey() {
      if (!isset($this->model_key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->model_key = $res;
        return $res;
      }
      return $this->model_key;
    }
    public function clearModelKey() {
      if (isset($this->model_key)) {
        unset($this->model_key);
      }
    }
    public function hasModelKey() {
      return isset($this->model_key);
    }
    public function getSize() {
      if (!isset($this->size)) {
        return "0";
      }
      return $this->size;
    }
    public function setSize($val) {
      if (is_double($val)) {
        $this->size = sprintf('%0.0F', $val);
      } else {
        $this->size = $val;
      }
      return $this;
    }
    public function clearSize() {
      unset($this->size);
      return $this;
    }
    public function hasSize() {
      return isset($this->size);
    }
    public function getMax() {
      if (!isset($this->max)) {
        return "0";
      }
      return $this->max;
    }
    public function setMax($val) {
      if (is_double($val)) {
        $this->max = sprintf('%0.0F', $val);
      } else {
        $this->max = $val;
      }
      return $this;
    }
    public function clearMax() {
      unset($this->max);
      return $this;
    }
    public function hasMax() {
      return isset($this->max);
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function getReserveSize() {
      return sizeof($this->reserve);
    }
    public function getReserveList() {
      return $this->reserve;
    }
    public function mutableReserve($idx) {
      if (!isset($this->reserve[$idx])) {
        $val = new \storage_onestore_v3\Reference();
        $this->reserve[$idx] = $val;
        return $val;
      }
      return $this->reserve[$idx];
    }
    public function getReserve($idx) {
      if (isset($this->reserve[$idx])) {
        return $this->reserve[$idx];
      }
      if ($idx >= end(array_keys($this->reserve))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Reference();
    }
    public function addReserve() {
      $val = new \storage_onestore_v3\Reference();
      $this->reserve[] = $val;
      return $val;
    }
    public function clearReserve() {
      $this->reserve = array();
    }
    public function getTrusted() {
      if (!isset($this->trusted)) {
        return false;
      }
      return $this->trusted;
    }
    public function setTrusted($val) {
      $this->trusted = $val;
      return $this;
    }
    public function clearTrusted() {
      unset($this->trusted);
      return $this;
    }
    public function hasTrusted() {
      return isset($this->trusted);
    }
    public function clear() {
      $this->clearModelKey();
      $this->clearSize();
      $this->clearMax();
      $this->clearHeader();
      $this->clearReserve();
      $this->clearTrusted();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->model_key)) {
        $res += 1;
        $res += $this->lengthString($this->model_key->byteSizePartial());
      }
      if (isset($this->size)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->size);
      }
      if (isset($this->max)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->max);
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      $this->checkProtoArray($this->reserve);
      $res += 1 * sizeof($this->reserve);
      foreach ($this->reserve as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->trusted)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->model_key)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->model_key->byteSizePartial());
        $this->model_key->outputPartial($out);
      }
      if (isset($this->size)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->size);
      }
      if (isset($this->max)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->max);
      }
      if (isset($this->header)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
      $this->checkProtoArray($this->reserve);
      foreach ($this->reserve as $value) {
        $out->putVarInt32(42);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->trusted)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->trusted);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableModelKey()->tryMerge($tmp);
            break;
          case 16:
            $this->setSize($d->getVarInt64());
            break;
          case 24:
            $this->setMax($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addReserve()->tryMerge($tmp);
            break;
          case 48:
            $this->setTrusted($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->model_key) && (!$this->model_key->isInitialized())) return 'model_key';
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      foreach ($this->reserve as $value) {
        if (!$value->isInitialized()) return 'reserve';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasModelKey()) {
        $this->mutableModelKey()->mergeFrom($x->getModelKey());
      }
      if ($x->hasSize()) {
        $this->setSize($x->getSize());
      }
      if ($x->hasMax()) {
        $this->setMax($x->getMax());
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
      foreach ($x->getReserveList() as $v) {
        $this->addReserve()->copyFrom($v);
      }
      if ($x->hasTrusted()) {
        $this->setTrusted($x->getTrusted());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->model_key) !== isset($x->model_key)) return false;
      if (isset($this->model_key) && !$this->model_key->equals($x->model_key)) return false;
      if (isset($this->size) !== isset($x->size)) return false;
      if (isset($this->size) && !$this->integerEquals($this->size, $x->size)) return false;
      if (isset($this->max) !== isset($x->max)) return false;
      if (isset($this->max) && !$this->integerEquals($this->max, $x->max)) return false;
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      if (sizeof($this->reserve) !== sizeof($x->reserve)) return false;
      foreach (array_map(null, $this->reserve, $x->reserve) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->trusted) !== isset($x->trusted)) return false;
      if (isset($this->trusted) && $this->trusted !== $x->trusted) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->model_key)) {
        $res .= $prefix . "model_key <\n" . $this->model_key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->size)) {
        $res .= $prefix . "size: " . $this->debugFormatInt64($this->size) . "\n";
      }
      if (isset($this->max)) {
        $res .= $prefix . "max: " . $this->debugFormatInt64($this->max) . "\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->reserve as $value) {
        $res .= $prefix . "reserve <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->trusted)) {
        $res .= $prefix . "trusted: " . $this->debugFormatBool($this->trusted) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class AllocateIdsResponse extends \google\net\ProtocolMessage {
    public function getStart() {
      if (!isset($this->start)) {
        return "0";
      }
      return $this->start;
    }
    public function setStart($val) {
      if (is_double($val)) {
        $this->start = sprintf('%0.0F', $val);
      } else {
        $this->start = $val;
      }
      return $this;
    }
    public function clearStart() {
      unset($this->start);
      return $this;
    }
    public function hasStart() {
      return isset($this->start);
    }
    public function getEnd() {
      if (!isset($this->end)) {
        return "0";
      }
      return $this->end;
    }
    public function setEnd($val) {
      if (is_double($val)) {
        $this->end = sprintf('%0.0F', $val);
      } else {
        $this->end = $val;
      }
      return $this;
    }
    public function clearEnd() {
      unset($this->end);
      return $this;
    }
    public function hasEnd() {
      return isset($this->end);
    }
    public function getCost() {
      if (!isset($this->cost)) {
        return new \google\appengine_datastore_v3\Cost();
      }
      return $this->cost;
    }
    public function mutableCost() {
      if (!isset($this->cost)) {
        $res = new \google\appengine_datastore_v3\Cost();
        $this->cost = $res;
        return $res;
      }
      return $this->cost;
    }
    public function clearCost() {
      if (isset($this->cost)) {
        unset($this->cost);
      }
    }
    public function hasCost() {
      return isset($this->cost);
    }
    public function clear() {
      $this->clearStart();
      $this->clearEnd();
      $this->clearCost();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->start)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->start);
      }
      if (isset($this->end)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->end);
      }
      if (isset($this->cost)) {
        $res += 1;
        $res += $this->lengthString($this->cost->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->start)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->start);
      }
      if (isset($this->end)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->end);
      }
      if (isset($this->cost)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->cost->byteSizePartial());
        $this->cost->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setStart($d->getVarInt64());
            break;
          case 16:
            $this->setEnd($d->getVarInt64());
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCost()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->start)) return 'start';
      if (!isset($this->end)) return 'end';
      if (isset($this->cost) && (!$this->cost->isInitialized())) return 'cost';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasStart()) {
        $this->setStart($x->getStart());
      }
      if ($x->hasEnd()) {
        $this->setEnd($x->getEnd());
      }
      if ($x->hasCost()) {
        $this->mutableCost()->mergeFrom($x->getCost());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->start) !== isset($x->start)) return false;
      if (isset($this->start) && !$this->integerEquals($this->start, $x->start)) return false;
      if (isset($this->end) !== isset($x->end)) return false;
      if (isset($this->end) && !$this->integerEquals($this->end, $x->end)) return false;
      if (isset($this->cost) !== isset($x->cost)) return false;
      if (isset($this->cost) && !$this->cost->equals($x->cost)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->start)) {
        $res .= $prefix . "start: " . $this->debugFormatInt64($this->start) . "\n";
      }
      if (isset($this->end)) {
        $res .= $prefix . "end: " . $this->debugFormatInt64($this->end) . "\n";
      }
      if (isset($this->cost)) {
        $res .= $prefix . "cost <\n" . $this->cost->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class CompositeIndices extends \google\net\ProtocolMessage {
    private $index = array();
    public function getIndexSize() {
      return sizeof($this->index);
    }
    public function getIndexList() {
      return $this->index;
    }
    public function mutableIndex($idx) {
      if (!isset($this->index[$idx])) {
        $val = new \storage_onestore_v3\CompositeIndex();
        $this->index[$idx] = $val;
        return $val;
      }
      return $this->index[$idx];
    }
    public function getIndex($idx) {
      if (isset($this->index[$idx])) {
        return $this->index[$idx];
      }
      if ($idx >= end(array_keys($this->index))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\CompositeIndex();
    }
    public function addIndex() {
      $val = new \storage_onestore_v3\CompositeIndex();
      $this->index[] = $val;
      return $val;
    }
    public function clearIndex() {
      $this->index = array();
    }
    public function clear() {
      $this->clearIndex();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->index);
      $res += 1 * sizeof($this->index);
      foreach ($this->index as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->index);
      foreach ($this->index as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addIndex()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->index as $value) {
        if (!$value->isInitialized()) return 'index';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getIndexList() as $v) {
        $this->addIndex()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->index) !== sizeof($x->index)) return false;
      foreach (array_map(null, $this->index, $x->index) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->index as $value) {
        $res .= $prefix . "index <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class AddActionsRequest extends \google\net\ProtocolMessage {
    private $action = array();
    public function getTransaction() {
      if (!isset($this->transaction)) {
        return new \google\appengine_datastore_v3\Transaction();
      }
      return $this->transaction;
    }
    public function mutableTransaction() {
      if (!isset($this->transaction)) {
        $res = new \google\appengine_datastore_v3\Transaction();
        $this->transaction = $res;
        return $res;
      }
      return $this->transaction;
    }
    public function clearTransaction() {
      if (isset($this->transaction)) {
        unset($this->transaction);
      }
    }
    public function hasTransaction() {
      return isset($this->transaction);
    }
    public function getActionSize() {
      return sizeof($this->action);
    }
    public function getActionList() {
      return $this->action;
    }
    public function mutableAction($idx) {
      if (!isset($this->action[$idx])) {
        $val = new \storage_onestore_v3\Action();
        $this->action[$idx] = $val;
        return $val;
      }
      return $this->action[$idx];
    }
    public function getAction($idx) {
      if (isset($this->action[$idx])) {
        return $this->action[$idx];
      }
      if ($idx >= end(array_keys($this->action))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Action();
    }
    public function addAction() {
      $val = new \storage_onestore_v3\Action();
      $this->action[] = $val;
      return $val;
    }
    public function clearAction() {
      $this->action = array();
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearTransaction();
      $this->clearAction();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->transaction)) {
        $res += 1;
        $res += $this->lengthString($this->transaction->byteSizePartial());
      }
      $this->checkProtoArray($this->action);
      $res += 1 * sizeof($this->action);
      foreach ($this->action as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->transaction)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->transaction->byteSizePartial());
        $this->transaction->outputPartial($out);
      }
      $this->checkProtoArray($this->action);
      foreach ($this->action as $value) {
        $out->putVarInt32(18);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->header)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableTransaction()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addAction()->tryMerge($tmp);
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->transaction)) || (!$this->transaction->isInitialized())) return 'transaction';
      foreach ($this->action as $value) {
        if (!$value->isInitialized()) return 'action';
      }
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasTransaction()) {
        $this->mutableTransaction()->mergeFrom($x->getTransaction());
      }
      foreach ($x->getActionList() as $v) {
        $this->addAction()->copyFrom($v);
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->transaction) !== isset($x->transaction)) return false;
      if (isset($this->transaction) && !$this->transaction->equals($x->transaction)) return false;
      if (sizeof($this->action) !== sizeof($x->action)) return false;
      foreach (array_map(null, $this->action, $x->action) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->transaction)) {
        $res .= $prefix . "transaction <\n" . $this->transaction->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->action as $value) {
        $res .= $prefix . "action <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class AddActionsResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class BeginTransactionRequest extends \google\net\ProtocolMessage {
    public function getApp() {
      if (!isset($this->app)) {
        return '';
      }
      return $this->app;
    }
    public function setApp($val) {
      $this->app = $val;
      return $this;
    }
    public function clearApp() {
      unset($this->app);
      return $this;
    }
    public function hasApp() {
      return isset($this->app);
    }
    public function getAllowMultipleEg() {
      if (!isset($this->allow_multiple_eg)) {
        return false;
      }
      return $this->allow_multiple_eg;
    }
    public function setAllowMultipleEg($val) {
      $this->allow_multiple_eg = $val;
      return $this;
    }
    public function clearAllowMultipleEg() {
      unset($this->allow_multiple_eg);
      return $this;
    }
    public function hasAllowMultipleEg() {
      return isset($this->allow_multiple_eg);
    }
    public function getHeader() {
      if (!isset($this->header)) {
        return new \google\appengine_datastore_v3\InternalHeader();
      }
      return $this->header;
    }
    public function mutableHeader() {
      if (!isset($this->header)) {
        $res = new \google\appengine_datastore_v3\InternalHeader();
        $this->header = $res;
        return $res;
      }
      return $this->header;
    }
    public function clearHeader() {
      if (isset($this->header)) {
        unset($this->header);
      }
    }
    public function hasHeader() {
      return isset($this->header);
    }
    public function clear() {
      $this->clearApp();
      $this->clearAllowMultipleEg();
      $this->clearHeader();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app));
      }
      if (isset($this->allow_multiple_eg)) {
        $res += 2;
      }
      if (isset($this->header)) {
        $res += 1;
        $res += $this->lengthString($this->header->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app);
      }
      if (isset($this->allow_multiple_eg)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->allow_multiple_eg);
      }
      if (isset($this->header)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->header->byteSizePartial());
        $this->header->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setApp(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setAllowMultipleEg($d->getBoolean());
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableHeader()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app)) return 'app';
      if (isset($this->header) && (!$this->header->isInitialized())) return 'header';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasApp()) {
        $this->setApp($x->getApp());
      }
      if ($x->hasAllowMultipleEg()) {
        $this->setAllowMultipleEg($x->getAllowMultipleEg());
      }
      if ($x->hasHeader()) {
        $this->mutableHeader()->mergeFrom($x->getHeader());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app) !== isset($x->app)) return false;
      if (isset($this->app) && $this->app !== $x->app) return false;
      if (isset($this->allow_multiple_eg) !== isset($x->allow_multiple_eg)) return false;
      if (isset($this->allow_multiple_eg) && $this->allow_multiple_eg !== $x->allow_multiple_eg) return false;
      if (isset($this->header) !== isset($x->header)) return false;
      if (isset($this->header) && !$this->header->equals($x->header)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app)) {
        $res .= $prefix . "app: " . $this->debugFormatString($this->app) . "\n";
      }
      if (isset($this->allow_multiple_eg)) {
        $res .= $prefix . "allow_multiple_eg: " . $this->debugFormatBool($this->allow_multiple_eg) . "\n";
      }
      if (isset($this->header)) {
        $res .= $prefix . "header <\n" . $this->header->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3\CommitResponse {
  class Version extends \google\net\ProtocolMessage {
    public function getRootEntityKey() {
      if (!isset($this->root_entity_key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->root_entity_key;
    }
    public function mutableRootEntityKey() {
      if (!isset($this->root_entity_key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->root_entity_key = $res;
        return $res;
      }
      return $this->root_entity_key;
    }
    public function clearRootEntityKey() {
      if (isset($this->root_entity_key)) {
        unset($this->root_entity_key);
      }
    }
    public function hasRootEntityKey() {
      return isset($this->root_entity_key);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return "0";
      }
      return $this->version;
    }
    public function setVersion($val) {
      if (is_double($val)) {
        $this->version = sprintf('%0.0F', $val);
      } else {
        $this->version = $val;
      }
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function clear() {
      $this->clearRootEntityKey();
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->root_entity_key)) {
        $res += 1;
        $res += $this->lengthString($this->root_entity_key->byteSizePartial());
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->version);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->root_entity_key)) {
        $out->putVarInt32(34);
        $out->putVarInt32($this->root_entity_key->byteSizePartial());
        $this->root_entity_key->outputPartial($out);
      }
      if (isset($this->version)) {
        $out->putVarInt32(40);
        $out->putVarInt64($this->version);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 28: return;
          case 34:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableRootEntityKey()->tryMerge($tmp);
            break;
          case 40:
            $this->setVersion($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->root_entity_key)) || (!$this->root_entity_key->isInitialized())) return 'root_entity_key';
      if (!isset($this->version)) return 'version';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasRootEntityKey()) {
        $this->mutableRootEntityKey()->mergeFrom($x->getRootEntityKey());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->root_entity_key) !== isset($x->root_entity_key)) return false;
      if (isset($this->root_entity_key) && !$this->root_entity_key->equals($x->root_entity_key)) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && !$this->integerEquals($this->version, $x->version)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->root_entity_key)) {
        $res .= $prefix . "root_entity_key <\n" . $this->root_entity_key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatInt64($this->version) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine_datastore_v3 {
  class CommitResponse extends \google\net\ProtocolMessage {
    private $version = array();
    public function getCost() {
      if (!isset($this->cost)) {
        return new \google\appengine_datastore_v3\Cost();
      }
      return $this->cost;
    }
    public function mutableCost() {
      if (!isset($this->cost)) {
        $res = new \google\appengine_datastore_v3\Cost();
        $this->cost = $res;
        return $res;
      }
      return $this->cost;
    }
    public function clearCost() {
      if (isset($this->cost)) {
        unset($this->cost);
      }
    }
    public function hasCost() {
      return isset($this->cost);
    }
    public function getVersionSize() {
      return sizeof($this->version);
    }
    public function getVersionList() {
      return $this->version;
    }
    public function mutableVersion($idx) {
      if (!isset($this->version[$idx])) {
        $val = new \google\appengine_datastore_v3\CommitResponse\Version();
        $this->version[$idx] = $val;
        return $val;
      }
      return $this->version[$idx];
    }
    public function getVersion($idx) {
      if (isset($this->version[$idx])) {
        return $this->version[$idx];
      }
      if ($idx >= end(array_keys($this->version))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \google\appengine_datastore_v3\CommitResponse\Version();
    }
    public function addVersion() {
      $val = new \google\appengine_datastore_v3\CommitResponse\Version();
      $this->version[] = $val;
      return $val;
    }
    public function clearVersion() {
      $this->version = array();
    }
    public function clear() {
      $this->clearCost();
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->cost)) {
        $res += 1;
        $res += $this->lengthString($this->cost->byteSizePartial());
      }
      $this->checkProtoArray($this->version);
      $res += 2 * sizeof($this->version);
      foreach ($this->version as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->cost)) {
        $out->putVarInt32(10);
        $out->putVarInt32($this->cost->byteSizePartial());
        $this->cost->outputPartial($out);
      }
      $this->checkProtoArray($this->version);
      foreach ($this->version as $value) {
        $out->putVarInt32(27);
        $value->outputPartial($out);
        $out->putVarInt32(28);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableCost()->tryMerge($tmp);
            break;
          case 27:
            $this->addVersion()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->cost) && (!$this->cost->isInitialized())) return 'cost';
      foreach ($this->version as $value) {
        if (!$value->isInitialized()) return 'version';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasCost()) {
        $this->mutableCost()->mergeFrom($x->getCost());
      }
      foreach ($x->getVersionList() as $v) {
        $this->addVersion()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->cost) !== isset($x->cost)) return false;
      if (isset($this->cost) && !$this->cost->equals($x->cost)) return false;
      if (sizeof($this->version) !== sizeof($x->version)) return false;
      foreach (array_map(null, $this->version, $x->version) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->cost)) {
        $res .= $prefix . "cost <\n" . $this->cost->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->version as $value) {
        $res .= $prefix . "Version {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
