/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.S3ServiceEventAdaptor;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.S3ServiceMulti;
import org.jets3t.service.utils.FileComparerResults;
import org.jets3t.service.utils.ServiceUtils;

public class FileComparer {
    private static final Log log = LogFactory.getLog((Class)FileComparer.class);

    protected static List buildIgnoreRegexpList(File directory) {
        ArrayList<Pattern> ignorePatternList = new ArrayList<Pattern>();
        if (directory == null || !directory.isDirectory()) {
            return ignorePatternList;
        }
        File jets3tIgnoreFile = new File(directory, ".jets3t-ignore");
        if (jets3tIgnoreFile.exists() && jets3tIgnoreFile.canRead()) {
            log.debug((Object)("Found ignore file: " + jets3tIgnoreFile.getPath()));
            try {
                String ignorePaths = ServiceUtils.readInputStreamToString(new FileInputStream(jets3tIgnoreFile));
                StringTokenizer st = new StringTokenizer(ignorePaths.trim(), "\n");
                while (st.hasMoreTokens()) {
                    String ignorePath;
                    String ignoreRegexp = ignorePath = st.nextToken();
                    ignoreRegexp = ignoreRegexp.replaceAll("\\.", "\\\\.");
                    ignoreRegexp = ignoreRegexp.replaceAll("\\*", ".*");
                    ignoreRegexp = ignoreRegexp.replaceAll("\\?", ".");
                    Pattern pattern = Pattern.compile(ignoreRegexp);
                    log.debug((Object)("Ignore path '" + ignorePath + "' has become the regexp: " + pattern.pattern()));
                    ignorePatternList.add(pattern);
                }
            }
            catch (IOException e) {
                log.error((Object)("Failed to read contents of ignore file '" + jets3tIgnoreFile.getPath() + "'"), (Throwable)e);
            }
        }
        if (Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("filecomparer.skip-upload-of-md5-files", false)) {
            Pattern pattern = Pattern.compile(".*\\.md5");
            log.debug((Object)("Skipping upload of pre-computed MD5 files with path '*.md5' using the regexp: " + pattern.pattern()));
            ignorePatternList.add(pattern);
        }
        return ignorePatternList;
    }

    protected static boolean isIgnored(List ignorePatternList, File file) {
        Iterator patternIter = ignorePatternList.iterator();
        while (patternIter.hasNext()) {
            Pattern pattern = (Pattern)patternIter.next();
            if (!pattern.matcher(file.getName()).matches()) continue;
            log.debug((Object)("Ignoring " + (file.isDirectory() ? "directory" : "file") + " matching pattern '" + pattern.pattern() + "': " + file.getName()));
            return true;
        }
        return false;
    }

    public static Map buildFileMap(File[] files, boolean includeDirectories) {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        List ignorePatternList = null;
        List ignorePatternListForCurrentDir = null;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getParentFile() == null) {
                if (ignorePatternListForCurrentDir == null) {
                    ignorePatternListForCurrentDir = FileComparer.buildIgnoreRegexpList(new File("."));
                }
                ignorePatternList = ignorePatternListForCurrentDir;
            } else {
                ignorePatternList = FileComparer.buildIgnoreRegexpList(files[i].getParentFile());
            }
            if (FileComparer.isIgnored(ignorePatternList, files[i])) continue;
            if (!files[i].isDirectory() || includeDirectories) {
                fileMap.put(files[i].getName(), files[i]);
            }
            if (!files[i].isDirectory()) continue;
            FileComparer.buildFileMapImpl(files[i], files[i].getName() + "/", fileMap, includeDirectories);
        }
        return fileMap;
    }

    public static Map buildFileMap(File rootDirectory, String fileKeyPrefix, boolean includeDirectories) {
        HashMap fileMap = new HashMap();
        List ignorePatternList = FileComparer.buildIgnoreRegexpList(rootDirectory);
        if (!FileComparer.isIgnored(ignorePatternList, rootDirectory)) {
            if (fileKeyPrefix == null || fileKeyPrefix.length() == 0) {
                fileKeyPrefix = "";
            } else if (!fileKeyPrefix.endsWith("/")) {
                fileKeyPrefix = fileKeyPrefix + "/";
            }
            FileComparer.buildFileMapImpl(rootDirectory, fileKeyPrefix, fileMap, includeDirectories);
        }
        return fileMap;
    }

    protected static void buildFileMapImpl(File directory, String fileKeyPrefix, Map fileMap, boolean includeDirectories) {
        List ignorePatternList = FileComparer.buildIgnoreRegexpList(directory);
        File[] children = directory.listFiles();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (FileComparer.isIgnored(ignorePatternList, children[i])) continue;
            if (!children[i].isDirectory() || includeDirectories) {
                fileMap.put(fileKeyPrefix + children[i].getName(), children[i]);
            }
            if (!children[i].isDirectory()) continue;
            FileComparer.buildFileMapImpl(children[i], fileKeyPrefix + children[i].getName() + "/", fileMap, includeDirectories);
        }
    }

    public static Map buildS3ObjectMap(S3Service s3Service, S3Bucket bucket, String targetPath, S3ServiceEventListener s3ServiceEventListener) throws S3ServiceException {
        String prefix = targetPath.length() > 0 ? targetPath : null;
        S3Object[] s3ObjectsIncomplete = s3Service.listObjects(bucket, prefix, null);
        return FileComparer.buildS3ObjectMap(s3Service, bucket, targetPath, s3ObjectsIncomplete, s3ServiceEventListener);
    }

    public static Map buildS3ObjectMap(S3Service s3Service, S3Bucket bucket, String targetPath, S3Object[] s3ObjectsIncomplete, S3ServiceEventListener s3ServiceEventListener) throws S3ServiceException {
        final ArrayList s3ObjectsCompleteList = new ArrayList(s3ObjectsIncomplete.length);
        final S3ServiceException[] s3ServiceExceptions = new S3ServiceException[1];
        S3ServiceMulti s3ServiceMulti = new S3ServiceMulti(s3Service, new S3ServiceEventAdaptor(){

            public void s3ServiceEventPerformed(GetObjectHeadsEvent event) {
                if (3 == event.getEventCode()) {
                    S3Object[] finishedObjects = event.getCompletedObjects();
                    if (finishedObjects.length > 0) {
                        s3ObjectsCompleteList.addAll(Arrays.asList(finishedObjects));
                    }
                } else if (0 == event.getEventCode()) {
                    s3ServiceExceptions[0] = new S3ServiceException("Failed to retrieve detailed information about all S3 objects", event.getErrorCause());
                }
            }
        });
        if (s3ServiceEventListener != null) {
            s3ServiceMulti.addServiceEventListener(s3ServiceEventListener);
        }
        s3ServiceMulti.getObjectsHeads(bucket, s3ObjectsIncomplete);
        if (s3ServiceExceptions[0] != null) {
            throw s3ServiceExceptions[0];
        }
        S3Object[] s3Objects = s3ObjectsCompleteList.toArray(new S3Object[s3ObjectsCompleteList.size()]);
        return FileComparer.populateS3ObjectMap(targetPath, s3Objects);
    }

    public static Map populateS3ObjectMap(String targetPath, S3Object[] s3Objects) {
        HashMap<String, S3Object> map = new HashMap<String, S3Object>();
        for (int i = 0; i < s3Objects.length; ++i) {
            String relativeKey = s3Objects[i].getKey();
            if (targetPath.length() > 0) {
                int slashIndex = (relativeKey = relativeKey.substring(targetPath.length())).indexOf("/");
                relativeKey = slashIndex >= 0 ? relativeKey.substring(slashIndex + 1, relativeKey.length()) : "";
            }
            if (relativeKey.length() <= 0) continue;
            map.put(relativeKey, s3Objects[i]);
        }
        return map;
    }

    public static FileComparerResults buildDiscrepancyLists(Map filesMap, Map s3ObjectsMap) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        return FileComparer.buildDiscrepancyLists(filesMap, s3ObjectsMap, null);
    }

    public static FileComparerResults buildDiscrepancyLists(Map filesMap, Map s3ObjectsMap, BytesProgressWatcher progressWatcher) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        ArrayList<String> onlyOnServerKeys = new ArrayList<String>();
        ArrayList<String> updatedOnServerKeys = new ArrayList<String>();
        ArrayList<String> updatedOnClientKeys = new ArrayList<String>();
        ArrayList<String> alreadySynchronisedKeys = new ArrayList<String>();
        ArrayList onlyOnClientKeys = new ArrayList();
        Iterator s3ObjectsMapIter = s3ObjectsMap.entrySet().iterator();
        while (s3ObjectsMapIter.hasNext()) {
            Map.Entry entry = s3ObjectsMapIter.next();
            String keyPath = (String)entry.getKey();
            S3Object s3Object = (S3Object)entry.getValue();
            if (keyPath.endsWith("/") && s3Object.getContentLength() == 0L && "binary/octet-stream".equals(s3Object.getContentType())) {
                boolean ignorePanicDirPlaceholders = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("filecomparer.ignore-panic-dir-placeholders", false);
                if (ignorePanicDirPlaceholders) {
                    log.debug((Object)("Ignoring object that looks like a directory placeholder created by Panic's Transmit application: " + keyPath));
                    alreadySynchronisedKeys.add(keyPath);
                    continue;
                }
                log.warn((Object)("Identified an object that looks like a directory placeholder created by Panic's Transmit application. If this object was indeed created by Transmit, it will not be handled properly unless the JetS3t property \"filecomparer.ignore-panic-dir-placeholders\" is set to true. " + s3Object));
            }
            if (filesMap.containsKey(keyPath)) {
                File file = (File)filesMap.get(keyPath);
                if (file.isDirectory()) {
                    alreadySynchronisedKeys.add(keyPath);
                    continue;
                }
                boolean useMd5Files = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("filecomparer.use-md5-files", false);
                boolean generateMd5Files = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("filecomparer.generate-md5-files", false);
                byte[] computedHash = null;
                File computedHashFile = new File(file.getPath() + ".md5");
                if (useMd5Files && computedHashFile.canRead() && computedHashFile.lastModified() > file.lastModified()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(computedHashFile));
                        computedHash = ServiceUtils.fromHex(br.readLine().split("\\s")[0]);
                        br.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Unable to read hash from computed MD5 file", (Throwable)e);
                    }
                }
                if (computedHash == null) {
                    InputStream hashInputStream = null;
                    hashInputStream = progressWatcher != null ? new ProgressMonitoredInputStream(new FileInputStream(file), progressWatcher) : new FileInputStream(file);
                    computedHash = ServiceUtils.computeMD5Hash(hashInputStream);
                }
                String fileHashAsBase64 = ServiceUtils.toBase64(computedHash);
                if (!(!generateMd5Files || file.getName().endsWith(".md5") || computedHashFile.exists() && computedHashFile.lastModified() >= file.lastModified())) {
                    try {
                        FileWriter fw = new FileWriter(computedHashFile);
                        fw.write(ServiceUtils.toHex(computedHash));
                        fw.close();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Unable to write computed MD5 hash to a file", (Throwable)e);
                    }
                }
                String objectHash = null;
                if (s3Object.containsMetadata("original-md5-hash")) {
                    objectHash = (String)s3Object.getMetadata("original-md5-hash");
                    log.debug((Object)("Object in S3 is encoded, using the object's original hash value for: " + s3Object.getKey()));
                } else {
                    objectHash = s3Object.getMd5HashAsBase64();
                }
                if (fileHashAsBase64.equals(objectHash)) {
                    alreadySynchronisedKeys.add(keyPath);
                    continue;
                }
                Date s3ObjectLastModified = null;
                String metadataLocalFileDate = (String)s3Object.getMetadata("jets3t-original-file-date-iso8601");
                if (metadataLocalFileDate == null) {
                    metadataLocalFileDate = (String)s3Object.getMetadata("jets3t-original-file-date-iso860");
                }
                if (metadataLocalFileDate == null) {
                    log.warn((Object)"Using S3 last modified date as file date. This is not reliable as the time according to S3 can differ from your local system time. Please use the metadata item jets3t-original-file-date-iso8601");
                    s3ObjectLastModified = s3Object.getLastModifiedDate();
                } else {
                    s3ObjectLastModified = ServiceUtils.parseIso8601Date(metadataLocalFileDate);
                }
                if (s3ObjectLastModified.getTime() > file.lastModified()) {
                    updatedOnServerKeys.add(keyPath);
                    continue;
                }
                if (s3ObjectLastModified.getTime() < file.lastModified()) {
                    updatedOnClientKeys.add(keyPath);
                    continue;
                }
                throw new IOException("Backed-up S3Object " + s3Object.getKey() + " and local file " + file.getName() + " have the same date but different hash values. " + "This shouldn't happen!");
            }
            onlyOnServerKeys.add(keyPath);
        }
        onlyOnClientKeys.addAll(filesMap.keySet());
        onlyOnClientKeys.removeAll(updatedOnClientKeys);
        onlyOnClientKeys.removeAll(alreadySynchronisedKeys);
        onlyOnClientKeys.removeAll(updatedOnServerKeys);
        return new FileComparerResults(onlyOnServerKeys, updatedOnServerKeys, updatedOnClientKeys, onlyOnClientKeys, alreadySynchronisedKeys);
    }
}

