/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.annotation;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.config.java.annotation.ImportXml;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportXmlHandler
implements ConfigurationPlugin<ImportXml> {
    ImportXmlHandler() {
    }

    @Override
    public void handle(ImportXml importXml, BeanDefinitionRegistry registry) {
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(registry);
        String[] locations = importXml.locations();
        Object defaultRelativeClass = AnnotationUtils.getDefaultValue((Annotation)importXml, (String)"relativeTo");
        Class<?> relativeClass = importXml.relativeTo();
        if (relativeClass != defaultRelativeClass) {
            int i = 0;
            while (i < locations.length) {
                locations[i] = String.format("%s/%s", ClassUtils.getPackageName(relativeClass).replace('.', '/'), locations[i]);
                ++i;
            }
        }
        reader.loadBeanDefinitions(locations);
    }
}

