/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassAdapter;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.MethodAdapter;
import org.springframework.asm.MethodVisitor;
import org.springframework.config.java.annotation.AutoBean;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.ExternalBean;
import org.springframework.config.java.annotation.ExternalValue;
import org.springframework.config.java.annotation.aop.ScopedProxy;
import org.springframework.config.java.internal.model.AutoBeanMethod;
import org.springframework.config.java.internal.model.BeanMethod;
import org.springframework.config.java.internal.model.ConfigurationClass;
import org.springframework.config.java.internal.model.ExternalBeanMethod;
import org.springframework.config.java.internal.model.ExternalValueMethod;
import org.springframework.config.java.internal.model.NonJavaConfigMethod;
import org.springframework.config.java.internal.parsing.asm.AsmUtils;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotation;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationUtils;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotationVisitor;
import org.springframework.config.java.model.ModelClass;
import org.springframework.config.java.model.ModelMethod;
import org.springframework.util.ClassUtils;

class ConfigurationClassMethodVisitor
extends MethodAdapter {
    private final ConfigurationClass configClass;
    private final String methodName;
    private final int modifiers;
    private final ModelClass returnType;
    private final boolean isConstructor;
    private final HashMap<String, ScopedProxy> scopedProxiesByMethodName = new HashMap();
    private boolean isJavaConfigMethod = false;
    private ModelMethod lastAddedMethod;
    private int lineNumber;

    public ConfigurationClassMethodVisitor(ConfigurationClass configClass, String methodName, String methodDescriptor, int modifiers) {
        super((MethodVisitor)AsmUtils.EMPTY_VISITOR);
        this.configClass = configClass;
        this.methodName = methodName;
        this.returnType = new ModelClass(AsmUtils.getReturnTypeFromMethodDescriptor(methodDescriptor));
        if (!"".equals(this.returnType.getName())) {
            String className = this.returnType.getName();
            ClassReader reader = AsmUtils.newClassReader(ClassUtils.convertClassNameToResourcePath((String)className));
            reader.accept((ClassVisitor)new ClassAdapter((ClassVisitor)AsmUtils.EMPTY_VISITOR){

                public void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
                    ConfigurationClassMethodVisitor.this.returnType.setInterface((arg1 & 0x200) == 512);
                }
            }, false);
        }
        this.modifiers = modifiers;
        this.isConstructor = methodName.equals("<init>");
    }

    public AnnotationVisitor visitAnnotation(String annoTypeDesc, boolean arg1) {
        String annoTypeName = AsmUtils.convertTypeDescriptorToClassName(annoTypeDesc);
        if (Bean.class.getName().equals(annoTypeName)) {
            this.isJavaConfigMethod = true;
            Bean mutableAnno = MutableAnnotationUtils.createMutableAnnotation(Bean.class);
            BeanMethod method = new BeanMethod(this.methodName, this.modifiers, mutableAnno);
            this.lastAddedMethod = method;
            this.configClass.add(method);
            return new MutableAnnotationVisitor((MutableAnnotation)((Object)mutableAnno));
        }
        if (ExternalBean.class.getName().equals(annoTypeName)) {
            this.isJavaConfigMethod = true;
            ExternalBean mutableAnno = MutableAnnotationUtils.createMutableAnnotation(ExternalBean.class);
            ExternalBeanMethod method = new ExternalBeanMethod(this.methodName, this.modifiers, mutableAnno);
            this.lastAddedMethod = method;
            this.configClass.add(method);
            return new MutableAnnotationVisitor((MutableAnnotation)((Object)mutableAnno));
        }
        if (ScopedProxy.class.getName().equals(annoTypeName)) {
            ScopedProxy mutableAnno = MutableAnnotationUtils.createMutableAnnotation(ScopedProxy.class);
            this.scopedProxiesByMethodName.put(this.methodName, mutableAnno);
            return new MutableAnnotationVisitor((MutableAnnotation)((Object)mutableAnno));
        }
        if (ExternalValue.class.getName().equals(annoTypeName)) {
            this.isJavaConfigMethod = true;
            ExternalValue mutableAnno = MutableAnnotationUtils.createMutableAnnotation(ExternalValue.class);
            ExternalValueMethod method = new ExternalValueMethod(this.methodName, this.modifiers, mutableAnno);
            this.lastAddedMethod = method;
            this.configClass.add(method);
            return new MutableAnnotationVisitor((MutableAnnotation)((Object)mutableAnno));
        }
        if (AutoBean.class.getName().equals(annoTypeName)) {
            this.isJavaConfigMethod = true;
            AutoBean mutableAnno = MutableAnnotationUtils.createMutableAnnotation(AutoBean.class);
            AutoBeanMethod method = new AutoBeanMethod(this.methodName, this.returnType, this.modifiers, mutableAnno);
            this.lastAddedMethod = method;
            this.configClass.add(method);
            return new MutableAnnotationVisitor((MutableAnnotation)((Object)mutableAnno));
        }
        return super.visitAnnotation(annoTypeDesc, arg1);
    }

    public void visitLineNumber(int lineNo, Label start) {
        this.lineNumber = lineNo;
    }

    public void visitEnd() {
        if (!this.isJavaConfigMethod && !this.isConstructor) {
            NonJavaConfigMethod method = new NonJavaConfigMethod(this.methodName, this.modifiers, new Annotation[0]);
            method.setLineNumber(this.lineNumber);
            this.lastAddedMethod = method;
            this.configClass.add(method);
        }
        if (this.lastAddedMethod != null) {
            this.lastAddedMethod.setLineNumber(this.lineNumber);
        }
        for (String methodName : this.scopedProxiesByMethodName.keySet()) {
            if (!this.configClass.hasMethod(methodName)) continue;
            this.configClass.getMethod(methodName).addAnnotation(this.scopedProxiesByMethodName.get(methodName));
        }
    }
}

