/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.plugin.context;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.config.java.plugin.context.MBeanExportDeclaration;
import org.springframework.config.java.plugin.context.MBeanServerBeanDefinitionParser;
import org.springframework.config.java.plugin.context.RegistrationPolicy;
import org.springframework.core.JdkVersion;
import org.springframework.util.StringUtils;

class MBeanExportBeanDefinitionParser {
    private static final String MBEAN_EXPORTER_BEAN_NAME = "mbeanExporter";

    MBeanExportBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parse(MBeanExportDeclaration declaration, BeanDefinitionRegistry registry) {
        String serverBeanName;
        String beanClassName = JdkVersion.isAtLeastJava15() ? "org.springframework.jmx.export.annotation.AnnotationMBeanExporter" : "org.springframework.jmx.export.MBeanExporter";
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)beanClassName);
        builder.setRole(2);
        String defaultDomain = declaration.getDefaultDomain();
        if (StringUtils.hasText((String)defaultDomain)) {
            builder.addPropertyValue("defaultDomain", (Object)defaultDomain);
        }
        if (StringUtils.hasText((String)(serverBeanName = declaration.getServerBeanName()))) {
            builder.addPropertyReference("server", serverBeanName);
        } else {
            AbstractBeanDefinition specialServer = MBeanServerBeanDefinitionParser.findServerForSpecialEnvironment();
            if (specialServer != null) {
                builder.addPropertyValue("server", (Object)specialServer);
            }
        }
        RegistrationPolicy policy = declaration.getRegistrationPolicy();
        builder.addPropertyValue("registrationBehavior", (Object)policy.getPolicyCode());
        registry.registerBeanDefinition(MBEAN_EXPORTER_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        return null;
    }
}

