/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;

public abstract class Converter {
    static final String SERIF = "Times New Roman";
    static final String SANS_SERIF = "Arial";

    public abstract String convert(File var1);

    boolean isHTML(File file) {
        return file.getName().toLowerCase().endsWith(".html") || file.getName().toLowerCase().endsWith(".htm");
    }

    boolean isRTF(File file) {
        return file.getName().toLowerCase().endsWith(".rtf");
    }

    String readToStr(File file, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
            char[] cArray = new char[4096];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n);
            }
            inputStreamReader.close();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError("\"" + file.getName() + "\" is too large!");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return stringBuffer.toString();
    }

    String replaceString(String string, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            int n2 = 0;
            stringBuffer.setLength(0);
            while ((n = string.indexOf(stringArray[i], n2)) >= 0) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append(stringArray2[i]);
                n2 = n + stringArray[i].length();
            }
            stringBuffer.append(string.substring(n2));
            string = stringBuffer.toString();
        }
        return string;
    }

    String replaceString(String string, String string2, String string3) {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    String prepareMetaTag(String string) {
        return string.replaceAll("(?i)charset=(?:iso-8859-1|windows-1252|windows-1258|us-ascii|x-user-defined)", "").replaceAll("(?i)<meta http-equiv=\"?Content-Type\"? content=\"text/html;\\s*\">\\n?", "").replaceAll("(?i)<head>", "<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
    }

    String htmlToANSI(String string) {
        String[] stringArray = new String[]{"&trade;", "&#8209;", "&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "&brvbar;", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "&sup2;", "&sup3;", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "&sup1;", "&ordm;", "&raquo;", "&frac14;", "&frac12;", "&frac34;", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "&ETH;", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "&times;", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "&Yacute;", "&THORN;", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "&eth;", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "&yacute;", "&thorn;", "&yuml;"};
        String[] stringArray2 = new String[]{"\u0099", "\u2011", "\u00a0", "\u00a1", "\u00a2", "\u00a3", "\u00a4", "\u00a5", "\u00a6", "\u00a7", "\u00a8", "\u00a9", "\u00aa", "\u00ab", "\u00ac", "\u00ad", "\u00ae", "\u00af", "\u00b0", "\u00b1", "\u00b2", "\u00b3", "\u00b4", "\u00b5", "\u00b6", "\u00b7", "\u00b8", "\u00b9", "\u00ba", "\u00bb", "\u00bc", "\u00bd", "\u00be", "\u00bf", "\u00c0", "\u00c1", "\u00c2", "\u00c3", "\u00c4", "\u00c5", "\u00c6", "\u00c7", "\u00c8", "\u00c9", "\u00ca", "\u00cb", "\u00cc", "\u00cd", "\u00ce", "\u00cf", "\u00d0", "\u00d1", "\u00d2", "\u00d3", "\u00d4", "\u00d5", "\u00d6", "\u00d7", "\u00d8", "\u00d9", "\u00da", "\u00db", "\u00dc", "\u00dd", "\u00de", "\u00df", "\u00e0", "\u00e1", "\u00e2", "\u00e3", "\u00e4", "\u00e5", "\u00e6", "\u00e7", "\u00e8", "\u00e9", "\u00ea", "\u00eb", "\u00ec", "\u00ed", "\u00ee", "\u00ef", "\u00f0", "\u00f1", "\u00f2", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00f7", "\u00f8", "\u00f9", "\u00fa", "\u00fb", "\u00fc", "\u00fd", "\u00fe", "\u00ff"};
        return this.replaceString(string, stringArray, stringArray2);
    }

    String convertNCR(String string) {
        int n = "&#".length();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3 = string.indexOf("&#", i);
            if (n3 == -1) {
                stringBuffer.append(string.substring(i));
                break;
            }
            stringBuffer.append(string.substring(i, n3));
            i = string.indexOf(";", n3);
            if (i == -1) {
                stringBuffer.append(string.substring(n3));
                break;
            }
            String string2 = string.substring(n3 + n, i);
            try {
                int n4 = 10;
                if (string2.trim().charAt(0) == 'x') {
                    n4 = 16;
                    string2 = string2.substring(1, string2.length());
                }
                stringBuffer.append((char)Integer.parseInt(string2, n4));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                stringBuffer.append('?');
            }
        }
        return stringBuffer.toString();
    }

    String rtfToANSI(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        string = this.replaceString(string, "\\'B7", "\\'b7");
        string = this.replaceString(string, "\\'b7\\tab", "&middot;\\tab");
        string = this.replaceString(string, "\\'A7", "\\'a7");
        string = this.replaceString(string, "\\'a7\\tab", "&sect;\\tab");
        int n2 = 0;
        String string2 = "\\'";
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            try {
                int n3 = Integer.parseInt(string.substring(n + 2, n + 4), 16);
                if (n3 <= 127) {
                    stringBuffer.append(string.substring(n, n + 4));
                } else {
                    stringBuffer.append((char)n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                stringBuffer.append(string.substring(n, n + 4));
            }
            n2 = n + 4;
        }
        stringBuffer.append(string.substring(n2));
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        try {
            string = new String(string.getBytes("ISO-8859-1"), string.startsWith("{\\rtf1\\mac") ? "MacRoman" : "Cp1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        n2 = 0;
        string2 = "\r\n";
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            if (string.charAt(n + 2) > '\u007f') {
                stringBuffer.append(string.charAt(n + 2));
                n2 = n + 3;
                continue;
            }
            stringBuffer.append(string2);
            n2 = n + 2;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    String convertToRTF(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\u" + c + '?');
        }
        string = this.replaceString(stringBuffer.toString(), "&middot;", "\\'B7");
        return this.replaceString(string, "&sect;", "\\'A7");
    }

    String compositeToPrecomposed(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFC);
    }

    String convertHTML(String string) {
        return this.replaceFont(this.prepareMetaTag(this.convertNCR(this.htmlToANSI(string))));
    }

    String convertRTF(String string) {
        return this.replaceFont(this.rtfToANSI(string));
    }

    String replaceFont(String string) {
        return string;
    }
}

