import QtQuick 2.8
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0

Item {
    id: turnsignal
    property bool turningRight: false

    Item {
        id: signalsTurnADAS
        anchors.centerIn: parent
        width: 800 * eosADAS.scaleFactor
        height: 35 * eosADAS.scaleFactor

        Image {
            id: signalsTurnADASAsset
            source: "assets/signalsTurnADAS.png"
        }

        Item {
            id: turnL
            visible: false
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            width: 40 * eosADAS.scaleFactor
            height: 40 * eosADAS.scaleFactor

            Item {
                id: leftSignal
                width: 40 * eosADAS.scaleFactor
                height: 40 * eosADAS.scaleFactor

                Image {
                    id: lSignal
                    anchors.fill: parent
                    opacity: 0.3
                    source: "assets/lSignal.png"
                    layer.enabled: true
                    layer.effect: ColorOverlayEffect {
                        id: colorOverlay
                        color: "#7e7e7e"
                    }
                }
            }
        }

        Item {
            id: turnR
            visible: false
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: parent.right
            width: 40 * eosADAS.scaleFactor
            height: 40 * eosADAS.scaleFactor

            Item {
                id: leftSignal1
                width: 40 * eosADAS.scaleFactor
                height: 40 * eosADAS.scaleFactor

                Image {
                    id: rSignal1
                    anchors.fill: parent
                    opacity: 0.3
                    source: "assets/rSignal.png"
                    layer.enabled: true
                    layer.effect: ColorOverlayEffect {
                        id: colorOverlay1
                        color: "#7e7e7e"
                    }
                }

                Image {
                    id: rSignal
                    anchors.fill: parent
                    opacity: 0
                    source: "assets/rSignal.png"
                }
            }
            anchors.bottomMargin: 0
            anchors.topMargin: 0
        }
    }

    Timeline {
        id: startupTimeline
        animations: [
            TimelineAnimation {
                id: startuptimelineAnim
                running: true
                duration: 5000
                loops: 1
                to: 1000
                from: 0
            }
        ]
        endFrame: 1000
        startFrame: 0
        enabled: true
    }

    Timeline {
        id: startUpAdas
        animations: [
            TimelineAnimation {
                id: timelineAnimationAdas
                running: turnsignal.turningRight
                duration: 1000
                loops: -1
                to: 200
                from: 0
            }
        ]
        endFrame: 200
        startFrame: 0
        enabled: turnsignal.turningRight

        KeyframeGroup {
            target: rSignal
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 100
            }

            Keyframe {
                value: 0
                frame: 200
            }
        }
    }
    states: [
        State {
            name: "Startup"

            PropertyChanges {
                target: rSignal
                visible: false
            }

            PropertyChanges {
                target: startupTimeline
                enabled: true
            }

            PropertyChanges {
                target: startuptimelineAnim
                running: true
            }

            PropertyChanges {
                target: turnL
                visible: false
            }

            PropertyChanges {
                target: turnR
                visible: false
            }
        },
        State {
            name: "Adas"

            PropertyChanges {
                target: rSignal
                opacity: 0
                visible: true
            }

            PropertyChanges {
                target: startupTimeline
                enabled: false
            }

            PropertyChanges {
                target: startuptimelineAnim
                running: false
            }

            PropertyChanges {
                target: timelineAnimationAdas
                running: true
            }

            PropertyChanges {
                target: turnL
                visible: true
            }

            PropertyChanges {
                target: turnR
                visible: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;autoSize:true;formeditorZoom:4;height:240;width:640}
}
##^##*/

