import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Helpers

Rectangle {
    id: debugBox
    property color colorBG: "#ca000000"
    property color colorText: "#ffffff"
    property View3D sView: view3D
    property int secondaryinfoSize: 24
    property int fpsSize: 32
    property int fps: sView.renderStats.fps
    property int frameTime: sView.renderStats.frameTime
    property int syncTime: sView.renderStats.syncTime
    property int renderTime: sView.renderStats.renderTime
    property int maxTime: sView.renderStats.maxFrameTime

    height: framerate.height + sync.height + render.height + max.height + 32
    color: "#00ffffff"
    border.color: "#00000000"

    Column {
        anchors.fill: parent
        anchors.leftMargin: 16
        anchors.topMargin: 16
        Text {
            id: framerate
            color: debugBox.colorText
            text: debugBox.fps + " FPS (" + debugBox.frameTime + " ms)"
            anchors.left: parent.left
            font.pixelSize: debugBox.fpsSize
            height: font.pixelSize * 1.5
        }

        Text {
            id: sync
            y: framerate.height
            color: debugBox.colorText
            text: "Sync: " + debugBox.syncTime + " ms"
            anchors.left: parent.left
            font.pixelSize: debugBox.secondaryinfoSize
            height: font.pixelSize * 1.5
        }

        Text {
            id: render
            y: sync.y + sync.height
            color: debugBox.colorText
            text: "Render: " + debugBox.renderTime + " ms"
            anchors.left: parent.left
            font.pixelSize: debugBox.secondaryinfoSize
            height: font.pixelSize * 1.5
        }

        Text {
            id: max
            y: render.y + render.height
            color: debugBox.colorText
            text: "Max: " + debugBox.maxTime + " ms"
            anchors.left: parent.left
            font.pixelSize: debugBox.secondaryinfoSize
            height: font.pixelSize * 1.5
        }
    }
}
