VARYING vec2 vTexCoord;
VARYING vec4 vColor;
VARYING vec3 vNormal;

float fresnel = 1.0;

void MAIN(){
	BASE_COLOR = vec4(0.0);
	
	fresnel = abs(dot(VIEW_VECTOR,VAR_WORLD_NORMAL));
}

void POST_PROCESS()
{	
	vec2 screenPos = gl_FragCoord.xy/textureSize(DEPTH_TEXTURE, 0);
	
	float depthSample = texture(DEPTH_TEXTURE, screenPos).x;
	
	vec3 fColor = baseColor.rgb;
	float a = baseColor.a*vColor.a;
	
	float depthFade = smoothstep(0.0,0.0025,abs(depthSample-gl_FragCoord.z));
	
	a *= pow(fresnel,5.0)*0.1;
	a += smoothstep(0.9975,1.0,fresnel)*brightness;
	a *= depthFade;
	COLOR_SUM = vec4(fColor*a,a);
}