VARYING vec2 vTexCoord;
VARYING vec4 vColor;

float fresnel = 1.0;

void MAIN(){
	BASE_COLOR = vec4(0.0);
	
	float fresnelBase = abs(dot(VAR_WORLD_NORMAL, VIEW_VECTOR));
	fresnel = smoothstep(0.0,1.0,fresnelBase);
	fresnel *= vColor.a;
	
}

void POST_PROCESS()
{	
	vec2 screenPos = gl_FragCoord.xy/textureSize(SCREEN_TEXTURE, 0);
	
	float depthSample = texture(DEPTH_TEXTURE, screenPos).x;
	
    vec4 sceneSample = texture(SCREEN_TEXTURE, screenPos);
	
	
	vec3 fColor = sceneSample.rgb;
	float a = baseColor.a;
	
	float depthFade = smoothstep(0.0,0.05,abs(depthSample-gl_FragCoord.z));
	depthFade *= smoothstep(0.50,1.0,gl_FragCoord.z);
	a *= depthFade;
	
	a *= (fresnel);
	a *= opacity;
	
	COLOR_SUM = vec4((fColor+baseColor.rgb*a)*a*a*a,a);
}