import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6

Rectangle {
    id: blower
    width: 110
    height: 110
    color: "#00ffffff"
    state: "both"

    property real statevalue: 1

    MouseArea {
        id: mouseArea
        anchors.fill: parent
    }

    Connections {
        id: connection
        target: mouseArea
        onClicked: connection.setState()
        function setState() {
            blower.statevalue += 1
            if (blower.statevalue == 4) {
                blower.statevalue = 1
            }
        }
    }

    Image {
        id: blowerboth
        x: 0
        y: 0
        source: "img/blowerboth.png"
        fillMode: Image.PreserveAspectFit
    }
    states: [
        State {
            name: "down"
            when: statevalue == 3
            PropertyChanges {
                target: blowerboth
                source: "img/blowerdown.png"
            }
        },
        State {
            name: "up"
            when: statevalue == 2
            PropertyChanges {
                target: blowerboth
                source: "img/blowerup.png"
            }
        },
        State {
            when: statevalue == 1
            name: "both"
        }
    ]
}
