import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6


Model {
    id: hood
    source: "asset_imports/Quick3DAssets/BakedCar2/meshes/hood.mesh"
    property bool isOpen: true
    z: 343.77222
    eulerRotation.x: -90
    DefaultMaterial {
        id: cubeMaterial6
        emissiveFactor: 0
        emissiveColor: "#ffffff"
        specularTint: "#000000"
        specularAmount: 0.4
        diffuseMap: element9
        diffuseColor: "#7b8f91"
        
        Texture {
            id: element9
            source: "hood.png"
        }
    }
    states: [
        State {
            name: "closed"
            when: !hood.isOpen

            PropertyChanges {
                target: hood
                eulerRotation.x: -90
            }
        },
        State {
            name: "open"
            when: hood.isOpen

            PropertyChanges {
                target: hood
                eulerRotation.z: 0
                eulerRotation.y: 0
                eulerRotation.x: -50
            }
        }
    ]
    transitions: Transition {
        NumberAnimation
        {
            properties: "eulerRotation.x"
            easing.type: Easing.InOutQuad
            duration: 500
        }

    }
    materials: cubeMaterial6
}


