/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the documentation of Qt for Python.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

//! [0]
shader = QGLShader(QGLShader.Vertex)
shader.compileSourceCode(code)

program = QGLShaderProgram(context)
program.addShader(shader)
program.link()

program.bind()
//! [0]

//! [1]
program.addShaderFromSourceCode(QGLShader.Vertex,
    "attribute highp vec4 vertex\n" \
    "attribute mediump mat4 matrix\n" \
    "void main(void)\n" \
    "{\n" \
    "   gl_Position = matrix * vertex\n" \
    "}")
program.addShaderFromSourceCode(QGLShader.Fragment,
    "uniform mediump vec4 color\n" \
    "void main(void)\n" \
    "{\n" \
    "   gl_FragColor = color\n" \
    "}")
program.link()
program.bind()

vertexLocation = program.attributeLocation("vertex")
matrixLocation = program.attributeLocation("matrix")
colorLocation = program.uniformLocation("color")
//! [1]

//! [2]
triangleVertices = (
    60.0f,  10.0f,  0.0f,
    110.0f, 110.0f, 0.0f,
    10.0f,  110.0f, 0.0f)

color = QColor(0, 255, 0, 255)

pmvMatrix = QMatrix4x4()
pmvMatrix.ortho(self.rect())

program.enableAttributeArray(vertexLocation)
program.setAttributeArray(vertexLocation, triangleVertices, 3)
program.setUniformValue(matrixLocation, pmvMatrix)
program.setUniformValue(colorLocation, color)

glDrawArrays(GL_TRIANGLES, 0, 3)

program.disableAttributeArray(vertexLocation)
//! [2]
