# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only


module_classes = {
    "Qt3DAnimation": [
        "QAbstractAnimation",
        "QAbstractAnimationClip",
        "QAbstractChannelMapping",
        "QAbstractClipAnimator",
        "QAbstractClipBlendNode",
        "QAdditiveClipBlend",
        "QAnimationAspect",
        "QAnimationCallback",
        "QAnimationClip",
        "QAnimationClipLoader",
        "QAnimationController",
        "QAnimationGroup",
        "QBlendedClipAnimator",
        "QClipAnimator",
        "QClock",
        "QKeyFrame",
        "QKeyframeAnimation",
        "QLerpClipBlend",
        "QMorphTarget",
        "QMorphingAnimation",
        "QSkeletonMapping",
        "QVertexBlendAnimation",
    ],
    "Qt3DCore": [
        "QAbstractAspect",
        "QAbstractSkeleton",
        "QArmature",
        "QAspectEngine",
        "QAspectJob",
        "QBackendNode",
        "QComponent",
        "QComponentAddedChange",
        "QComponentRemovedChange",
        "QDynamicPropertyUpdatedChange",
        "QEntity",
        "QJoint",
        "QNode",
        "QNodeCommand",
        "QNodeCreatedChangeBase",
        "QNodeDestroyedChange",
        "QNodeId",
        "QNodeIdTypePair",
        "QPropertyNodeAddedChange",
        "QPropertyNodeRemovedChange",
        "QPropertyUpdatedChange",
        "QPropertyUpdatedChangeBase",
        "QPropertyValueAddedChange",
        "QPropertyValueAddedChangeBase",
        "QPropertyValueRemovedChange",
        "QPropertyValueRemovedChangeBase",
        "QSceneChange",
        "QSkeleton",
        "QSkeletonLoader",
        "QStaticPropertyUpdatedChangeBase",
        "QStaticPropertyValueAddedChangeBase",
        "QStaticPropertyValueRemovedChangeBase",
        "QTransform",
    ],
    "Qt3DExtras": [
        "QAbstractCameraController",
        "QAbstractSpriteSheet",
        "QConeGeometry",
        "QConeMesh",
        "QCuboidGeometry",
        "QCuboidMesh",
        "QCylinderGeometry",
        "QCylinderMesh",
        "QDiffuseMapMaterial",
        "QDiffuseSpecularMapMaterial",
        "QDiffuseSpecularMaterial",
        "QExtrudedTextGeometry",
        "QExtrudedTextMesh",
        "QFirstPersonCameraController",
        "QForwardRenderer",
        "QGoochMaterial",
        "QMetalRoughMaterial",
        "QMorphPhongMaterial",
        "QNormalDiffuseMapAlphaMaterial",
        "QNormalDiffuseMapMaterial",
        "QNormalDiffuseSpecularMapMaterial",
        "QOrbitCameraController",
        "QPerVertexColorMaterial",
        "QPhongAlphaMaterial",
        "QPhongMaterial",
        "QPlaneGeometry",
        "QPlaneMesh",
        "QSkyboxEntity",
        "QSphereGeometry",
        "QSphereMesh",
        "QSpriteGrid",
        "QSpriteSheet",
        "QSpriteSheetItem",
        "QText2DEntity",
        "QTextureMaterial",
        "QTorusGeometry",
        "QTorusMesh",
        "Qt3DWindow",
    ],
    "Qt3DInput": [
        "QAbstractActionInput",
        "QAbstractAxisInput",
        "QAbstractPhysicalDevice",
        "QAction",
        "QActionInput",
        "QAnalogAxisInput",
        "QAxis",
        "QAxisAccumulator",
        "QAxisSetting",
        "QButtonAxisInput",
        "QInputAspect",
        "QInputChord",
        "QInputSequence",
        "QInputSettings",
        "QKeyEvent",
        "QKeyboardDevice",
        "QKeyboardHandler",
        "QLogicalDevice",
        "QMouseDevice",
        "QMouseEvent",
        "QMouseHandler",
        "QWheelEvent",
    ],
    "Qt3DLogic": ["QFrameAction", "QLogicAspect"],
    "Qt3DRender": [
        "QAbstractFunctor",
        "QAbstractLight",
        "QAbstractRayCaster",
        "QAbstractTexture",
        "QAbstractTextureImage",
        "QAlphaCoverage",
        "QAlphaTest",
        "QAttribute",
        "QBlendEquation",
        "QBlendEquationArguments",
        "QBlitFramebuffer",
        "QBuffer",
        "QBufferCapture",
        "QBufferDataGenerator",
        "QCamera",
        "QCameraLens",
        "QCameraSelector",
        "QClearBuffers",
        "QClipPlane",
        "QColorMask",
        "QComputeCommand",
        "QCullFace",
        "QDepthTest",
        "QDirectionalLight",
        "QDispatchCompute",
        "QDithering",
        "QEffect",
        "QEnvironmentLight",
        "QFilterKey",
        "QFrameGraphNode",
        "QFrameGraphNodeCreatedChangeBase",
        "QFrontFace",
        "QFrustumCulling",
        "QGeometry",
        "QGeometryFactory",
        "QGeometryRenderer",
        "QGraphicsApiFilter",
        "QLayer",
        "QLayerFilter",
        "QLevelOfDetail",
        "QLevelOfDetailBoundingSphere",
        "QLevelOfDetailSwitch",
        "QLineWidth",
        "QMaterial",
        "QMemoryBarrier",
        "QMesh",
        "QMultiSampleAntiAliasing",
        "QNoDepthMask",
        "QNoDraw",
        "QNoPicking",
        "QObjectPicker",
        "QPaintedTextureImage",
        "QParameter",
        "QPickEvent",
        "QPickLineEvent",
        "QPickPointEvent",
        "QPickTriangleEvent",
        "QPickingSettings",
        "QPointLight",
        "QPointSize",
        "QPolygonOffset",
        "QProximityFilter",
        "QRayCaster",
        "QRayCasterHit",
        "QRenderAspect",
        "QRenderCapabilities",
        "QRenderCapture",
        "QRenderCaptureReply",
        "QRenderPass",
        "QRenderPassFilter",
        "QRenderSettings",
        "QRenderState",
        "QRenderStateSet",
        "QRenderSurfaceSelector",
        "QRenderTarget",
        "QRenderTargetOutput",
        "QRenderTargetSelector",
        "QSceneLoader",
        "QScissorTest",
        "QScreenRayCaster",
        "QSeamlessCubemap",
        "QSetFence",
        "QShaderData",
        "QShaderImage",
        "QShaderProgram",
        "QShaderProgramBuilder",
        "QSharedGLTexture",
        "QSortPolicy",
        "QSpotLight",
        "QStencilMask",
        "QStencilOperation",
        "QStencilOperationArguments",
        "QStencilTest",
        "QStencilTestArguments",
        "QTechnique",
        "QTechniqueFilter",
        "QTexture1D",
        "QTexture1DArray",
        "QTexture2D",
        "QTexture2DArray",
        "QTexture2DMultisample",
        "QTexture2DMultisampleArray",
        "QTexture3D",
        "QTextureBuffer",
        "QTextureCubeMap",
        "QTextureCubeMapArray",
        "QTextureData",
        "QTextureGenerator",
        "QTextureImage",
        "QTextureImageData",
        "QTextureImageDataGenerator",
        "QTextureLoader",
        "QTextureRectangle",
        "QTextureWrapMode",
        "QViewport",
        "QWaitFence",
    ],
    "QtCharts": [
        "QAbstractAxis",
        "QAbstractBarSeries",
        "QAbstractSeries",
        "QAreaLegendMarker",
        "QAreaSeries",
        "QBarCategoryAxis",
        "QBarLegendMarker",
        "QBarModelMapper",
        "QBarSeries",
        "QBarSet",
        "QBoxPlotLegendMarker",
        "QBoxPlotModelMapper",
        "QBoxPlotSeries",
        "QBoxSet",
        "QCandlestickLegendMarker",
        "QCandlestickModelMapper",
        "QCandlestickSeries",
        "QCandlestickSet",
        "QCategoryAxis",
        "QChart",
        "QChartView",
        "QDateTimeAxis",
        "QHBarModelMapper",
        "QHBoxPlotModelMapper",
        "QHCandlestickModelMapper",
        "QHPieModelMapper",
        "QHXYModelMapper",
        "QHorizontalBarSeries",
        "QHorizontalPercentBarSeries",
        "QHorizontalStackedBarSeries",
        "QLegend",
        "QLegendMarker",
        "QLineSeries",
        "QLogValueAxis",
        "QPercentBarSeries",
        "QPieLegendMarker",
        "QPieModelMapper",
        "QPieSeries",
        "QPieSlice",
        "QPolarChart",
        "QScatterSeries",
        "QSplineSeries",
        "QStackedBarSeries",
        "QVBarModelMapper",
        "QVBoxPlotModelMapper",
        "QVCandlestickModelMapper",
        "QVPieModelMapper",
        "QVXYModelMapper",
        "QValueAxis",
        "QXYLegendMarker",
        "QXYModelMapper",
        "QXYSeries",
    ],
    "QtConcurrent": [
        "QFutureQString",
        "QFutureVoid",
        "QFutureWatcherQString",
        "QFutureWatcherVoid",
        "QtConcurrent",
    ],
    "QtCore": [
        "QAbstractAnimation",
        "QAbstractEventDispatcher",
        "QAbstractItemModel",
        "QAbstractListModel",
        "QAbstractNativeEventFilter",
        "QAbstractProxyModel",
        "QAbstractState",
        "QAbstractTableModel",
        "QAbstractTransition",
        "QAnimationGroup",
        "QBasicMutex",
        "QBasicTimer",
        "QBitArray",
        "QBuffer",
        "QByteArray",
        "QByteArrayMatcher",
        "QCalendar",
        "QCborArray",
        "QCborError",
        "QCborKnownTags",
        "QCborMap",
        "QCborParserError",
        "QCborSimpleType",
        "QCborStreamReader",
        "QCborStreamWriter",
        "QCborStringResultByteArray",
        "QCborStringResultString",
        "QCborValue",
        "QChildEvent",
        "QCollator",
        "QCollatorSortKey",
        "QCommandLineOption",
        "QCommandLineParser",
        "QConcatenateTablesProxyModel",
        "QCoreApplication",
        "QCryptographicHash",
        "QDataStream",
        "QDate",
        "QDateTime",
        "QDeadlineTimer",
        "QDir",
        "QDirIterator",
        "QDynamicPropertyChangeEvent",
        "QEasingCurve",
        "QElapsedTimer",
        "QEnum",
        "QEvent",
        "QEventLoop",
        "QEventTransition",
        "QFactoryInterface",
        "QFile",
        "QFileDevice",
        "QFileInfo",
        "QFileSelector",
        "QFileSystemWatcher",
        "QFinalState",
        "QFlag",
        "QFutureInterfaceBase",
        "QGenericArgument",
        "QGenericReturnArgument",
        "QHistoryState",
        "QIODevice",
        "QIdentityProxyModel",
        "QItemSelection",
        "QItemSelectionModel",
        "QItemSelectionRange",
        "QJsonArray",
        "QJsonDocument",
        "QJsonParseError",
        "QJsonValue",
        "QLibraryInfo",
        "QLine",
        "QLineF",
        "QLocale",
        "QLockFile",
        "QMargins",
        "QMarginsF",
        "QMessageAuthenticationCode",
        "QMessageLogContext",
        "QMetaClassInfo",
        "QMetaEnum",
        "QMetaMethod",
        "QMetaObject",
        "QMetaProperty",
        "QMimeData",
        "QMimeDatabase",
        "QMimeType",
        "QModelIndex",
        "QMutex",
        "QMutexLocker",
        "QObject",
        "QOperatingSystemVersion",
        "QParallelAnimationGroup",
        "QPauseAnimation",
        "QPersistentModelIndex",
        "QPluginLoader",
        "QPoint",
        "QPointF",
        "QProcess",
        "QProcessEnvironment",
        "QPropertyAnimation",
        "QRandomGenerator",
        "QRandomGenerator64",
        "QReadLocker",
        "QReadWriteLock",
        "QRect",
        "QRectF",
        "QRecursiveMutex",
        "QRegExp",
        "QRegularExpression",
        "QRegularExpressionMatch",
        "QRegularExpressionMatchIterator",
        "QResource",
        "QRunnable",
        "QSaveFile",
        "QSemaphore",
        "QSemaphoreReleaser",
        "QSequentialAnimationGroup",
        "QSettings",
        "QSignalBlocker",
        "QSignalMapper",
        "QSignalTransition",
        "QSize",
        "QSizeF",
        "QSocketDescriptor",
        "QSocketNotifier",
        "QSortFilterProxyModel",
        "QStandardPaths",
        "QState",
        "QStateMachine",
        "QStorageInfo",
        "QStringListModel",
        "QSysInfo",
        "QSystemSemaphore",
        "QT_TRANSLATE_NOOP",
        "QT_TRANSLATE_NOOP3",
        "QT_TRANSLATE_NOOP_UTF8",
        "QT_TR_NOOP",
        "QT_TR_NOOP_UTF8",
        "QTemporaryDir",
        "QTemporaryFile",
        "QTextBoundaryFinder",
        "QTextCodec",
        "QTextDecoder",
        "QTextEncoder",
        "QTextStream",
        "QTextStreamManipulator",
        "QThread",
        "QThreadPool",
        "QTime",
        "QTimeLine",
        "QTimeZone",
        "QTimer",
        "QTimerEvent",
        "QTranslator",
        "QTransposeProxyModel",
        "QUrl",
        "QUrlQuery",
        "QUuid",
        "QVariantAnimation",
        "QVersionNumber",
        "QWaitCondition",
        "QWriteLocker",
        "QXmlStreamAttribute",
        "QXmlStreamAttributes",
        "QXmlStreamEntityDeclaration",
        "QXmlStreamEntityResolver",
        "QXmlStreamNamespaceDeclaration",
        "QXmlStreamNotationDeclaration",
        "QXmlStreamReader",
        "QXmlStreamWriter",
        "Qt",
        "QtCriticalMsg",
        "QtDebugMsg",
        "QtFatalMsg",
        "QtInfoMsg",
        "QtMsgType",
        "QtSystemMsg",
        "QtWarningMsg",
    ],
    "QtDataVisualization": [
        "Q3DBars",
        "Q3DCamera",
        "Q3DInputHandler",
        "Q3DLight",
        "Q3DObject",
        "Q3DScatter",
        "Q3DScene",
        "Q3DSurface",
        "Q3DTheme",
        "QAbstract3DAxis",
        "QAbstract3DGraph",
        "QAbstract3DInputHandler",
        "QAbstract3DSeries",
        "QAbstractDataProxy",
        "QBar3DSeries",
        "QBarDataItem",
        "QBarDataProxy",
        "QCategory3DAxis",
        "QCustom3DItem",
        "QCustom3DLabel",
        "QCustom3DVolume",
        "QHeightMapSurfaceDataProxy",
        "QItemModelBarDataProxy",
        "QItemModelScatterDataProxy",
        "QItemModelSurfaceDataProxy",
        "QLogValue3DAxisFormatter",
        "QScatter3DSeries",
        "QScatterDataItem",
        "QScatterDataProxy",
        "QSurface3DSeries",
        "QSurfaceDataItem",
        "QSurfaceDataProxy",
        "QTouch3DInputHandler",
        "QValue3DAxis",
        "QValue3DAxisFormatter",
    ],
    "QtGui": [
        "QAbstractOpenGLFunctions",
        "QAbstractTextDocumentLayout",
        "QAccessible",
        "QAccessibleEditableTextInterface",
        "QAccessibleEvent",
        "QAccessibleInterface",
        "QAccessibleObject",
        "QAccessibleStateChangeEvent",
        "QAccessibleTableCellInterface",
        "QAccessibleTableModelChangeEvent",
        "QAccessibleTextCursorEvent",
        "QAccessibleTextInsertEvent",
        "QAccessibleTextInterface",
        "QAccessibleTextRemoveEvent",
        "QAccessibleTextSelectionEvent",
        "QAccessibleTextUpdateEvent",
        "QAccessibleValueChangeEvent",
        "QAccessibleValueInterface",
        "QActionEvent",
        "QBackingStore",
        "QBitmap",
        "QBrush",
        "QClipboard",
        "QCloseEvent",
        "QColor",
        "QColorConstants",
        "QColorSpace",
        "QConicalGradient",
        "QContextMenuEvent",
        "QCursor",
        "QDesktopServices",
        "QDoubleValidator",
        "QDrag",
        "QDragEnterEvent",
        "QDragLeaveEvent",
        "QDragMoveEvent",
        "QDropEvent",
        "QEnterEvent",
        "QExposeEvent",
        "QFileOpenEvent",
        "QFocusEvent",
        "QFont",
        "QFontDatabase",
        "QFontInfo",
        "QFontMetrics",
        "QFontMetricsF",
        "QGradient",
        "QGuiApplication",
        "QHelpEvent",
        "QHideEvent",
        "QHoverEvent",
        "QIcon",
        "QIconDragEvent",
        "QIconEngine",
        "QImage",
        "QImageIOHandler",
        "QImageReader",
        "QImageWriter",
        "QInputEvent",
        "QInputMethod",
        "QInputMethodEvent",
        "QInputMethodQueryEvent",
        "QIntValidator",
        "QKeyEvent",
        "QKeySequence",
        "QLinearGradient",
        "QMatrix",
        "QMatrix2x2",
        "QMatrix2x3",
        "QMatrix2x4",
        "QMatrix3x2",
        "QMatrix3x3",
        "QMatrix3x4",
        "QMatrix4x2",
        "QMatrix4x3",
        "QMatrix4x4",
        "QMouseEvent",
        "QMoveEvent",
        "QMovie",
        "QNativeGestureEvent",
        "QOffscreenSurface",
        "QOpenGLBuffer",
        "QOpenGLContext",
        "QOpenGLContextGroup",
        "QOpenGLDebugLogger",
        "QOpenGLDebugMessage",
        "QOpenGLExtraFunctions",
        "QOpenGLFramebufferObject",
        "QOpenGLFramebufferObjectFormat",
        "QOpenGLFunctions",
        "QOpenGLPixelTransferOptions",
        "QOpenGLShader",
        "QOpenGLShaderProgram",
        "QOpenGLTexture",
        "QOpenGLTextureBlitter",
        "QOpenGLTimeMonitor",
        "QOpenGLTimerQuery",
        "QOpenGLVersionProfile",
        "QOpenGLVertexArrayObject",
        "QOpenGLWindow",
        "QPageLayout",
        "QPageSize",
        "QPagedPaintDevice",
        "QPaintDevice",
        "QPaintDeviceWindow",
        "QPaintEngine",
        "QPaintEngineState",
        "QPaintEvent",
        "QPainter",
        "QPainterPath",
        "QPainterPathStroker",
        "QPalette",
        "QPdfWriter",
        "QPen",
        "QPicture",
        "QPictureIO",
        "QPixelFormat",
        "QPixmap",
        "QPixmapCache",
        "QPointingDeviceUniqueId",
        "QPolygon",
        "QPolygonF",
        "QPyTextObject",
        "QQuaternion",
        "QRadialGradient",
        "QRasterWindow",
        "QRawFont",
        "QRegExpValidator",
        "QRegion",
        "QRegularExpressionValidator",
        "QResizeEvent",
        "QScreen",
        "QScrollEvent",
        "QScrollPrepareEvent",
        "QSessionManager",
        "QShortcutEvent",
        "QShowEvent",
        "QStandardItem",
        "QStandardItemModel",
        "QStaticText",
        "QStatusTipEvent",
        "QStyleHints",
        "QSurface",
        "QSurfaceFormat",
        "QSyntaxHighlighter",
        "QTabletEvent",
        "QTextBlock",
        "QTextBlockFormat",
        "QTextBlockGroup",
        "QTextBlockUserData",
        "QTextCharFormat",
        "QTextCursor",
        "QTextDocument",
        "QTextDocumentFragment",
        "QTextDocumentWriter",
        "QTextFormat",
        "QTextFragment",
        "QTextFrame",
        "QTextFrameFormat",
        "QTextImageFormat",
        "QTextInlineObject",
        "QTextItem",
        "QTextLayout",
        "QTextLength",
        "QTextLine",
        "QTextList",
        "QTextListFormat",
        "QTextObject",
        "QTextObjectInterface",
        "QTextOption",
        "QTextTable",
        "QTextTableCell",
        "QTextTableCellFormat",
        "QTextTableFormat",
        "QToolBarChangeEvent",
        "QTouchDevice",
        "QTouchEvent",
        "QTransform",
        "QValidator",
        "QVector2D",
        "QVector3D",
        "QVector4D",
        "QWhatsThisClickedEvent",
        "QWheelEvent",
        "QWindow",
        "QWindowStateChangeEvent",
        "Qt",
    ],
    "QtHelp": [
        "QCompressedHelpInfo",
        "QHelpContentItem",
        "QHelpContentModel",
        "QHelpContentWidget",
        "QHelpEngine",
        "QHelpEngineCore",
        "QHelpFilterData",
        "QHelpFilterEngine",
        "QHelpFilterSettingsWidget",
        "QHelpIndexModel",
        "QHelpIndexWidget",
        "QHelpLink",
        "QHelpSearchEngine",
        "QHelpSearchQuery",
        "QHelpSearchQueryWidget",
        "QHelpSearchResult",
        "QHelpSearchResultWidget",
    ],
    "QtLocation": [
        "QGeoCodeReply",
        "QGeoCodingManager",
        "QGeoCodingManagerEngine",
        "QGeoManeuver",
        "QGeoRoute",
        "QGeoRouteReply",
        "QGeoRouteRequest",
        "QGeoRouteSegment",
        "QGeoRoutingManager",
        "QGeoRoutingManagerEngine",
        "QGeoServiceProvider",
        "QGeoServiceProviderFactory",
        "QGeoServiceProviderFactoryV2",
        "QPlace",
        "QPlaceAttribute",
        "QPlaceCategory",
        "QPlaceContactDetail",
        "QPlaceContent",
        "QPlaceContentReply",
        "QPlaceContentRequest",
        "QPlaceDetailsReply",
        "QPlaceEditorial",
        "QPlaceIcon",
        "QPlaceIdReply",
        "QPlaceImage",
        "QPlaceManager",
        "QPlaceManagerEngine",
        "QPlaceMatchReply",
        "QPlaceMatchRequest",
        "QPlaceProposedSearchResult",
        "QPlaceRatings",
        "QPlaceReply",
        "QPlaceResult",
        "QPlaceReview",
        "QPlaceSearchReply",
        "QPlaceSearchRequest",
        "QPlaceSearchResult",
        "QPlaceSearchSuggestionReply",
        "QPlaceSupplier",
        "QPlaceUser",
    ],
    "QtMultimedia": [
        "QAbstractAudioDeviceInfo",
        "QAbstractAudioInput",
        "QAbstractAudioOutput",
        "QAbstractVideoBuffer",
        "QAbstractVideoFilter",
        "QAbstractVideoSurface",
        "QAudio",
        "QAudioBuffer",
        "QAudioDecoder",
        "QAudioDecoderControl",
        "QAudioDeviceInfo",
        "QAudioEncoderSettings",
        "QAudioEncoderSettingsControl",
        "QAudioFormat",
        "QAudioInput",
        "QAudioInputSelectorControl",
        "QAudioOutput",
        "QAudioOutputSelectorControl",
        "QAudioProbe",
        "QAudioRecorder",
        "QAudioRoleControl",
        "QCamera",
        "QCameraCaptureBufferFormatControl",
        "QCameraCaptureDestinationControl",
        "QCameraControl",
        "QCameraExposure",
        "QCameraExposureControl",
        "QCameraFeedbackControl",
        "QCameraFlashControl",
        "QCameraFocus",
        "QCameraFocusControl",
        "QCameraFocusZone",
        "QCameraImageCapture",
        "QCameraImageCaptureControl",
        "QCameraImageProcessing",
        "QCameraImageProcessingControl",
        "QCameraInfo",
        "QCameraInfoControl",
        "QCameraLocksControl",
        "QCameraViewfinderSettings",
        "QCameraViewfinderSettingsControl",
        "QCameraViewfinderSettingsControl2",
        "QCameraZoomControl",
        "QCustomAudioRoleControl",
        "QImageEncoderControl",
        "QImageEncoderSettings",
        "QMediaAudioProbeControl",
        "QMediaAvailabilityControl",
        "QMediaBindableInterface",
        "QMediaContainerControl",
        "QMediaContent",
        "QMediaControl",
        "QMediaGaplessPlaybackControl",
        "QMediaNetworkAccessControl",
        "QMediaObject",
        "QMediaPlayer",
        "QMediaPlayerControl",
        "QMediaPlaylist",
        "QMediaRecorder",
        "QMediaRecorderControl",
        "QMediaResource",
        "QMediaService",
        "QMediaServiceCameraInfoInterface",
        "QMediaServiceDefaultDeviceInterface",
        "QMediaServiceFeaturesInterface",
        "QMediaServiceProviderHint",
        "QMediaServiceSupportedDevicesInterface",
        "QMediaServiceSupportedFormatsInterface",
        "QMediaStreamsControl",
        "QMediaTimeInterval",
        "QMediaTimeRange",
        "QMediaVideoProbeControl",
        "QMetaDataReaderControl",
        "QMetaDataWriterControl",
        "QMultimedia",
        "QRadioData",
        "QRadioDataControl",
        "QRadioTuner",
        "QRadioTunerControl",
        "QSound",
        "QSoundEffect",
        "QVideoDeviceSelectorControl",
        "QVideoEncoderSettings",
        "QVideoEncoderSettingsControl",
        "QVideoFilterRunnable",
        "QVideoFrame",
        "QVideoProbe",
        "QVideoRendererControl",
        "QVideoSurfaceFormat",
        "QVideoWindowControl",
    ],
    "QtMultimediaWidgets": [
        "QCameraViewfinder",
        "QGraphicsVideoItem",
        "QVideoWidget",
        "QVideoWidgetControl",
    ],
    "QtNetwork": [
        "QAbstractNetworkCache",
        "QAbstractSocket",
        "QAuthenticator",
        "QDnsDomainNameRecord",
        "QDnsHostAddressRecord",
        "QDnsLookup",
        "QDnsMailExchangeRecord",
        "QDnsServiceRecord",
        "QDnsTextRecord",
        "QDtls",
        "QDtlsError",
        "QHostAddress",
        "QHostInfo",
        "QHstsPolicy",
        "QHttpMultiPart",
        "QHttpPart",
        "QIPv6Address",
        "QLocalServer",
        "QLocalSocket",
        "QNetworkAccessManager",
        "QNetworkAddressEntry",
        "QNetworkCacheMetaData",
        "QNetworkConfiguration",
        "QNetworkConfigurationManager",
        "QNetworkCookie",
        "QNetworkCookieJar",
        "QNetworkDatagram",
        "QNetworkDiskCache",
        "QNetworkInterface",
        "QNetworkProxy",
        "QNetworkProxyFactory",
        "QNetworkProxyQuery",
        "QNetworkReply",
        "QNetworkRequest",
        "QNetworkSession",
        "QOcspCertificateStatus",
        "QOcspResponse",
        "QOcspRevocationReason",
        "QPasswordDigestor",
        "QSsl",
        "QSslCertificate",
        "QSslCertificateExtension",
        "QSslCipher",
        "QSslConfiguration",
        "QSslDiffieHellmanParameters",
        "QSslError",
        "QSslKey",
        "QSslPreSharedKeyAuthenticator",
        "QSslSocket",
        "QTcpServer",
        "QTcpSocket",
        "QUdpSocket",
    ],
    "QtOpenGL": [
        "QGL",
        "QGLBuffer",
        "QGLColormap",
        "QGLContext",
        "QGLFormat",
        "QGLFramebufferObject",
        "QGLFramebufferObjectFormat",
        "QGLPixelBuffer",
        "QGLShader",
        "QGLShaderProgram",
        "QGLWidget",
    ],
    "QtOpenGLFunctions": [
        "QOpenGLFunctions_1_0",
        "QOpenGLFunctions_1_1",
        "QOpenGLFunctions_1_2",
        "QOpenGLFunctions_1_3",
        "QOpenGLFunctions_1_4",
        "QOpenGLFunctions_1_5",
        "QOpenGLFunctions_2_0",
        "QOpenGLFunctions_2_1",
        "QOpenGLFunctions_3_0",
        "QOpenGLFunctions_3_1",
        "QOpenGLFunctions_3_2_Compatibility",
        "QOpenGLFunctions_3_2_Core",
        "QOpenGLFunctions_3_3_Compatibility",
        "QOpenGLFunctions_3_3_Core",
        "QOpenGLFunctions_4_0_Compatibility",
        "QOpenGLFunctions_4_0_Core",
        "QOpenGLFunctions_4_1_Compatibility",
        "QOpenGLFunctions_4_1_Core",
        "QOpenGLFunctions_4_2_Compatibility",
        "QOpenGLFunctions_4_2_Core",
        "QOpenGLFunctions_4_3_Compatibility",
        "QOpenGLFunctions_4_3_Core",
        "QOpenGLFunctions_4_4_Compatibility",
        "QOpenGLFunctions_4_4_Core",
        "QOpenGLFunctions_4_5_Compatibility",
        "QOpenGLFunctions_4_5_Core",
    ],
    "QtPositioning": [
        "QGeoAddress",
        "QGeoAreaMonitorInfo",
        "QGeoAreaMonitorSource",
        "QGeoCircle",
        "QGeoCoordinate",
        "QGeoLocation",
        "QGeoPath",
        "QGeoPolygon",
        "QGeoPositionInfo",
        "QGeoPositionInfoSource",
        "QGeoPositionInfoSourceFactory",
        "QGeoRectangle",
        "QGeoSatelliteInfo",
        "QGeoSatelliteInfoSource",
        "QGeoShape",
        "QNmeaPositionInfoSource",
    ],
    "QtPrintSupport": [
        "QAbstractPrintDialog",
        "QPageSetupDialog",
        "QPrintDialog",
        "QPrintEngine",
        "QPrintPreviewDialog",
        "QPrintPreviewWidget",
        "QPrinter",
        "QPrinterInfo",
    ],
    "QtQml": [
        "QJSEngine",
        "QJSValue",
        "QJSValueIterator",
        "QQmlAbstractUrlInterceptor",
        "QQmlApplicationEngine",
        "QQmlComponent",
        "QQmlContext",
        "QQmlDebuggingEnabler",
        "QQmlEngine",
        "QQmlError",
        "QQmlExpression",
        "QQmlExtensionInterface",
        "QQmlExtensionPlugin",
        "QQmlFile",
        "QQmlFileSelector",
        "QQmlImageProviderBase",
        "QQmlIncubationController",
        "QQmlIncubator",
        "QQmlListReference",
        "QQmlNetworkAccessManagerFactory",
        "QQmlParserStatus",
        "QQmlProperty",
        "QQmlPropertyMap",
        "QQmlPropertyValueSource",
        "QQmlScriptString",
        "QQmlTypesExtensionInterface",
        "QtQml",
    ],
    "QtQuick": [
        "QQuickAsyncImageProvider",
        "QQuickFramebufferObject",
        "QQuickImageProvider",
        "QQuickImageResponse",
        "QQuickItem",
        "QQuickItemGrabResult",
        "QQuickPaintedItem",
        "QQuickRenderControl",
        "QQuickTextDocument",
        "QQuickTextureFactory",
        "QQuickTransform",
        "QQuickView",
        "QQuickWindow",
        "QSGAbstractRenderer",
        "QSGBasicGeometryNode",
        "QSGClipNode",
        "QSGDynamicTexture",
        "QSGEngine",
        "QSGGeometry",
        "QSGGeometryNode",
        "QSGMaterialType",
        "QSGNode",
        "QSGOpacityNode",
        "QSGSimpleRectNode",
        "QSGSimpleTextureNode",
        "QSGTexture",
        "QSGTextureProvider",
        "QSGTransformNode",
        "QSharedPointer<QQuickItemGrabResult >",
    ],
    "QtQuickControls2": ["QQuickStyle"],
    "QtQuickWidgets": ["QQuickWidget"],
    "QtRemoteObjects": [
        "QAbstractItemModelReplica",
        "QRemoteObjectAbstractPersistedStore",
        "QRemoteObjectDynamicReplica",
        "QRemoteObjectHost",
        "QRemoteObjectHostBase",
        "QRemoteObjectNode",
        "QRemoteObjectPendingCall",
        "QRemoteObjectPendingCallWatcher",
        "QRemoteObjectRegistry",
        "QRemoteObjectRegistryHost",
        "QRemoteObjectReplica",
        "QRemoteObjectSettingsStore",
        "QRemoteObjectSourceLocationInfo",
    ],
    "QtScript": [
        "QScriptClass",
        "QScriptClassPropertyIterator",
        "QScriptContext",
        "QScriptContextInfo",
        "QScriptEngine",
        "QScriptEngineAgent",
        "QScriptExtensionInterface",
        "QScriptExtensionPlugin",
        "QScriptProgram",
        "QScriptString",
        "QScriptValue",
        "QScriptValueIterator",
        "QScriptable",
    ],
    "QtScriptTools": ["QScriptEngineDebugger"],
    "QtScxml": [
        "QScxmlCompiler",
        "QScxmlCppDataModel",
        "QScxmlDataModel",
        "QScxmlDynamicScxmlServiceFactory",
        "QScxmlEcmaScriptDataModel",
        "QScxmlError",
        "QScxmlEvent",
        "QScxmlExecutableContent",
        "QScxmlInvokableService",
        "QScxmlInvokableServiceFactory",
        "QScxmlNullDataModel",
        "QScxmlStateMachine",
        "QScxmlStaticScxmlServiceFactory",
        "QScxmlTableData",
    ],
    "QtSensors": [
        "QAccelerometer",
        "QAccelerometerFilter",
        "QAccelerometerReading",
        "QAltimeter",
        "QAltimeterFilter",
        "QAltimeterReading",
        "QAmbientLightFilter",
        "QAmbientLightReading",
        "QAmbientLightSensor",
        "QAmbientTemperatureFilter",
        "QAmbientTemperatureReading",
        "QAmbientTemperatureSensor",
        "QCompass",
        "QCompassFilter",
        "QCompassReading",
        "QDistanceFilter",
        "QDistanceReading",
        "QDistanceSensor",
        "QGyroscope",
        "QGyroscopeFilter",
        "QGyroscopeReading",
        "QHolsterFilter",
        "QHolsterReading",
        "QHolsterSensor",
        "QHumidityFilter",
        "QHumidityReading",
        "QHumiditySensor",
        "QIRProximityFilter",
        "QIRProximityReading",
        "QIRProximitySensor",
        "QLidFilter",
        "QLidReading",
        "QLidSensor",
        "QLightFilter",
        "QLightReading",
        "QLightSensor",
        "QMagnetometer",
        "QMagnetometerFilter",
        "QMagnetometerReading",
        "QOrientationFilter",
        "QOrientationReading",
        "QOrientationSensor",
        "QPressureFilter",
        "QPressureReading",
        "QPressureSensor",
        "QProximityFilter",
        "QProximityReading",
        "QProximitySensor",
        "QRotationFilter",
        "QRotationReading",
        "QRotationSensor",
        "QSensor",
        "QSensorBackend",
        "QSensorBackendFactory",
        "QSensorChangesInterface",
        "QSensorFilter",
        "QSensorGestureManager",
        "QSensorGesturePluginInterface",
        "QSensorGestureRecognizer",
        "QSensorManager",
        "QSensorPluginInterface",
        "QSensorReading",
        "QTapFilter",
        "QTapReading",
        "QTapSensor",
        "QTiltFilter",
        "QTiltReading",
        "QTiltSensor",
    ],
    "QtSerialPort": ["QSerialPort", "QSerialPortInfo"],
    "QtSql": [
        "QSql",
        "QSqlDatabase",
        "QSqlDriver",
        "QSqlDriverCreatorBase",
        "QSqlError",
        "QSqlField",
        "QSqlIndex",
        "QSqlQuery",
        "QSqlQueryModel",
        "QSqlRecord",
        "QSqlRelation",
        "QSqlRelationalDelegate",
        "QSqlRelationalTableModel",
        "QSqlResult",
        "QSqlTableModel",
    ],
    "QtSvg": ["QGraphicsSvgItem", "QSvgGenerator", "QSvgRenderer", "QSvgWidget"],
    "QtTest": ["QTest"],
    "QtTextToSpeech": ["QTextToSpeech", "QTextToSpeechEngine", "QVoice"],
    "QtUiTools": ["QUiLoader"],
    "QtWebChannel": ["QWebChannel", "QWebChannelAbstractTransport"],
    "QtWebEngine": [],
    "QtWebEngineCore": [
        "QWebEngineCookieStore",
        "QWebEngineHttpRequest",
        "QWebEngineUrlRequestInfo",
        "QWebEngineUrlRequestInterceptor",
        "QWebEngineUrlRequestJob",
        "QWebEngineUrlScheme",
        "QWebEngineUrlSchemeHandler",
    ],
    "QtWebEngineWidgets": [
        "QWebEngineCertificateError",
        "QWebEngineContextMenuData",
        "QWebEngineDownloadItem",
        "QWebEngineFullScreenRequest",
        "QWebEngineHistory",
        "QWebEngineHistoryItem",
        "QWebEnginePage",
        "QWebEngineProfile",
        "QWebEngineScript",
        "QWebEngineScriptCollection",
        "QWebEngineSettings",
        "QWebEngineView",
    ],
    "QtWebSockets": [
        "QMaskGenerator",
        "QWebSocket",
        "QWebSocketCorsAuthenticator",
        "QWebSocketProtocol",
        "QWebSocketServer",
    ],
    "QtWidgets": [
        "QAbstractButton",
        "QAbstractGraphicsShapeItem",
        "QAbstractItemDelegate",
        "QAbstractItemView",
        "QAbstractScrollArea",
        "QAbstractSlider",
        "QAbstractSpinBox",
        "QAccessibleWidget",
        "QAction",
        "QActionGroup",
        "QApplication",
        "QBoxLayout",
        "QButtonGroup",
        "QCalendarWidget",
        "QCheckBox",
        "QColorDialog",
        "QColormap",
        "QColumnView",
        "QComboBox",
        "QCommandLinkButton",
        "QCommonStyle",
        "QCompleter",
        "QDataWidgetMapper",
        "QDateEdit",
        "QDateTimeEdit",
        "QDesktopWidget",
        "QDial",
        "QDialog",
        "QDialogButtonBox",
        "QDirModel",
        "QDockWidget",
        "QDoubleSpinBox",
        "QErrorMessage",
        "QFileDialog",
        "QFileIconProvider",
        "QFileSystemModel",
        "QFocusFrame",
        "QFontComboBox",
        "QFontDialog",
        "QFormLayout",
        "QFrame",
        "QGesture",
        "QGestureEvent",
        "QGestureRecognizer",
        "QGraphicsAnchor",
        "QGraphicsAnchorLayout",
        "QGraphicsBlurEffect",
        "QGraphicsColorizeEffect",
        "QGraphicsDropShadowEffect",
        "QGraphicsEffect",
        "QGraphicsEllipseItem",
        "QGraphicsGridLayout",
        "QGraphicsItem",
        "QGraphicsItemAnimation",
        "QGraphicsItemGroup",
        "QGraphicsLayout",
        "QGraphicsLayoutItem",
        "QGraphicsLineItem",
        "QGraphicsLinearLayout",
        "QGraphicsObject",
        "QGraphicsOpacityEffect",
        "QGraphicsPathItem",
        "QGraphicsPixmapItem",
        "QGraphicsPolygonItem",
        "QGraphicsProxyWidget",
        "QGraphicsRectItem",
        "QGraphicsRotation",
        "QGraphicsScale",
        "QGraphicsScene",
        "QGraphicsSceneContextMenuEvent",
        "QGraphicsSceneDragDropEvent",
        "QGraphicsSceneEvent",
        "QGraphicsSceneHelpEvent",
        "QGraphicsSceneHoverEvent",
        "QGraphicsSceneMouseEvent",
        "QGraphicsSceneMoveEvent",
        "QGraphicsSceneResizeEvent",
        "QGraphicsSceneWheelEvent",
        "QGraphicsSimpleTextItem",
        "QGraphicsTextItem",
        "QGraphicsTransform",
        "QGraphicsView",
        "QGraphicsWidget",
        "QGridLayout",
        "QGroupBox",
        "QHBoxLayout",
        "QHeaderView",
        "QInputDialog",
        "QItemDelegate",
        "QItemEditorCreatorBase",
        "QItemEditorFactory",
        "QKeyEventTransition",
        "QKeySequenceEdit",
        "QLCDNumber",
        "QLabel",
        "QLayout",
        "QLayoutItem",
        "QLineEdit",
        "QListView",
        "QListWidget",
        "QListWidgetItem",
        "QMainWindow",
        "QMdiArea",
        "QMdiSubWindow",
        "QMenu",
        "QMenuBar",
        "QMessageBox",
        "QMouseEventTransition",
        "QOpenGLWidget",
        "QPanGesture",
        "QPinchGesture",
        "QPlainTextDocumentLayout",
        "QPlainTextEdit",
        "QProgressBar",
        "QProgressDialog",
        "QProxyStyle",
        "QPushButton",
        "QRadioButton",
        "QRubberBand",
        "QScrollArea",
        "QScrollBar",
        "QScroller",
        "QScrollerProperties",
        "QShortcut",
        "QSizeGrip",
        "QSizePolicy",
        "QSlider",
        "QSpacerItem",
        "QSpinBox",
        "QSplashScreen",
        "QSplitter",
        "QSplitterHandle",
        "QStackedLayout",
        "QStackedWidget",
        "QStatusBar",
        "QStyle",
        "QStyleFactory",
        "QStyleHintReturn",
        "QStyleHintReturnMask",
        "QStyleHintReturnVariant",
        "QStyleOption",
        "QStyleOptionButton",
        "QStyleOptionComboBox",
        "QStyleOptionComplex",
        "QStyleOptionDockWidget",
        "QStyleOptionFocusRect",
        "QStyleOptionFrame",
        "QStyleOptionGraphicsItem",
        "QStyleOptionGroupBox",
        "QStyleOptionHeader",
        "QStyleOptionMenuItem",
        "QStyleOptionProgressBar",
        "QStyleOptionRubberBand",
        "QStyleOptionSizeGrip",
        "QStyleOptionSlider",
        "QStyleOptionSpinBox",
        "QStyleOptionTab",
        "QStyleOptionTabBarBase",
        "QStyleOptionTabWidgetFrame",
        "QStyleOptionTitleBar",
        "QStyleOptionToolBar",
        "QStyleOptionToolBox",
        "QStyleOptionToolButton",
        "QStyleOptionViewItem",
        "QStylePainter",
        "QStyledItemDelegate",
        "QSwipeGesture",
        "QSystemTrayIcon",
        "QTabBar",
        "QTabWidget",
        "QTableView",
        "QTableWidget",
        "QTableWidgetItem",
        "QTableWidgetSelectionRange",
        "QTapAndHoldGesture",
        "QTapGesture",
        "QTextBrowser",
        "QTextEdit",
        "QTileRules",
        "QTimeEdit",
        "QToolBar",
        "QToolBox",
        "QToolButton",
        "QToolTip",
        "QTreeView",
        "QTreeWidget",
        "QTreeWidgetItem",
        "QTreeWidgetItemIterator",
        "QUndoCommand",
        "QUndoGroup",
        "QUndoStack",
        "QUndoView",
        "QVBoxLayout",
        "QWhatsThis",
        "QWidget",
        "QWidgetAction",
        "QWidgetItem",
        "QWizard",
        "QWizardPage",
    ],
    "QtX11Extras": ["QX11Info"],
    "QtXml": [
        "QDomAttr",
        "QDomCDATASection",
        "QDomCharacterData",
        "QDomComment",
        "QDomDocument",
        "QDomDocumentFragment",
        "QDomDocumentType",
        "QDomElement",
        "QDomEntity",
        "QDomEntityReference",
        "QDomImplementation",
        "QDomNamedNodeMap",
        "QDomNode",
        "QDomNodeList",
        "QDomNotation",
        "QDomProcessingInstruction",
        "QDomText",
        "QXmlAttributes",
        "QXmlContentHandler",
        "QXmlDTDHandler",
        "QXmlDeclHandler",
        "QXmlDefaultHandler",
        "QXmlEntityResolver",
        "QXmlErrorHandler",
        "QXmlInputSource",
        "QXmlLexicalHandler",
        "QXmlLocator",
        "QXmlNamespaceSupport",
        "QXmlParseException",
        "QXmlReader",
        "QXmlSimpleReader",
    ],
    "QtXmlPatterns": [
        "QAbstractMessageHandler",
        "QAbstractUriResolver",
        "QAbstractXmlNodeModel",
        "QAbstractXmlReceiver",
        "QSourceLocation",
        "QXmlFormatter",
        "QXmlItem",
        "QXmlName",
        "QXmlNamePool",
        "QXmlNodeModelIndex",
        "QXmlQuery",
        "QXmlResultItems",
        "QXmlSchema",
        "QXmlSchemaValidator",
        "QXmlSerializer",
    ],
}
