/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceConfigurationError;
import sun.net.ftp.FtpClient;
import sun.net.ftp.impl.DefaultFtpClientProvider;

public abstract class FtpClientProvider {
    private static final Object lock = new Object();
    private static FtpClientProvider provider = null;

    public abstract FtpClient createFtpClient();

    protected FtpClientProvider() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("ftpClientProvider"));
        }
    }

    private static boolean loadProviderFromProperty() {
        String string = System.getProperty("sun.net.ftpClientProvider");
        if (string == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(string, true, null);
            provider = (FtpClientProvider)clazz.newInstance();
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServiceConfigurationError(classNotFoundException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceConfigurationError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new ServiceConfigurationError(instantiationException.toString());
        }
        catch (SecurityException securityException) {
            throw new ServiceConfigurationError(securityException.toString());
        }
    }

    private static boolean loadProviderAsService() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FtpClientProvider provider() {
        Object object = lock;
        synchronized (object) {
            if (provider != null) {
                return provider;
            }
            return (FtpClientProvider)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (FtpClientProvider.loadProviderFromProperty()) {
                        return provider;
                    }
                    if (FtpClientProvider.loadProviderAsService()) {
                        return provider;
                    }
                    provider = (FtpClientProvider)new DefaultFtpClientProvider();
                    return provider;
                }
            });
        }
    }
}

