/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.CatchClause;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class TryStatement
extends AstNode {
    private static final List<CatchClause> NO_CATCHES = Collections.unmodifiableList(new ArrayList());
    private AstNode tryBlock;
    private List<CatchClause> catchClauses;
    private AstNode finallyBlock;
    private int finallyPosition = -1;

    public TryStatement() {
        this.type = 81;
    }

    public TryStatement(int n) {
        super(n);
        this.type = 81;
    }

    public TryStatement(int n, int n2) {
        super(n, n2);
        this.type = 81;
    }

    public AstNode getTryBlock() {
        return this.tryBlock;
    }

    public void setTryBlock(AstNode astNode) {
        this.assertNotNull(astNode);
        this.tryBlock = astNode;
        astNode.setParent(this);
    }

    public List<CatchClause> getCatchClauses() {
        return this.catchClauses != null ? this.catchClauses : NO_CATCHES;
    }

    public void setCatchClauses(List<CatchClause> list) {
        if (list == null) {
            this.catchClauses = null;
        } else {
            if (this.catchClauses != null) {
                this.catchClauses.clear();
            }
            for (CatchClause catchClause : list) {
                this.addCatchClause(catchClause);
            }
        }
    }

    public void addCatchClause(CatchClause catchClause) {
        this.assertNotNull(catchClause);
        if (this.catchClauses == null) {
            this.catchClauses = new ArrayList<CatchClause>();
        }
        this.catchClauses.add(catchClause);
        catchClause.setParent(this);
    }

    public AstNode getFinallyBlock() {
        return this.finallyBlock;
    }

    public void setFinallyBlock(AstNode astNode) {
        this.finallyBlock = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public int getFinallyPosition() {
        return this.finallyPosition;
    }

    public void setFinallyPosition(int n) {
        this.finallyPosition = n;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("try ");
        stringBuilder.append(this.tryBlock.toSource(n).trim());
        for (CatchClause catchClause : this.getCatchClauses()) {
            stringBuilder.append(catchClause.toSource(n));
        }
        if (this.finallyBlock != null) {
            stringBuilder.append(" finally ");
            stringBuilder.append(this.finallyBlock.toSource(n));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.tryBlock.visit(nodeVisitor);
            for (CatchClause catchClause : this.getCatchClauses()) {
                catchClause.visit(nodeVisitor);
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.visit(nodeVisitor);
            }
        }
    }
}

