/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class AESKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keySize = 16;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("AES key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n % 8 != 0 || !AESCrypt.isKeySizeValid(n / 8)) {
            throw new InvalidParameterException("Wrong keysize: must be equal to 128, 192 or 256");
        }
        this.keySize = n / 8;
        this.engineInit(secureRandom);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        SecretKeySpec secretKeySpec = null;
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        byte[] byArray = new byte[this.keySize];
        this.random.nextBytes(byArray);
        secretKeySpec = new SecretKeySpec(byArray, "AES");
        return secretKeySpec;
    }
}

