/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.events;

import com.oracle.jrockit.jfr.DurationEvent;
import com.oracle.jrockit.jfr.EventDefinition;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.RequestableEvent;
import com.oracle.jrockit.jfr.TimedEvent;
import java.net.URI;
import java.util.HashSet;
import oracle.jrockit.jfr.events.DataStructureDescriptor;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.ValueDescriptor;

@Deprecated
public class JavaEventDescriptor
extends DataStructureDescriptor
implements EventDescriptor {
    private final Class<? extends InstantEvent> eventClass;
    private final String name;
    private final String path;
    private final URI uri;
    private final String description;
    private final boolean timed;
    private final boolean requestable;
    private final boolean hasThread;
    private final boolean stacktrace;
    private final boolean hasStartTime;
    private final int id;

    public JavaEventDescriptor(Class<? extends InstantEvent> clazz, URI uRI, int n) throws InvalidEventDefinitionException, InvalidValueException {
        super(clazz);
        EventDefinition eventDefinition = clazz.getAnnotation(EventDefinition.class);
        if (eventDefinition == null) {
            throw new IllegalArgumentException("Missing " + EventDefinition.class.getName() + " annotation");
        }
        String string = eventDefinition.name();
        if (string.length() == 0) {
            string = clazz.getName();
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        this.id = n;
        this.eventClass = clazz;
        this.name = string;
        String string2 = eventDefinition.path();
        if (string2.length() == 0) {
            string2 = string;
        }
        this.path = string2;
        this.description = eventDefinition.description();
        this.requestable = RequestableEvent.class.isAssignableFrom(clazz);
        this.hasThread = eventDefinition.thread();
        this.stacktrace = eventDefinition.stacktrace();
        this.timed = TimedEvent.class.isAssignableFrom(clazz);
        this.hasStartTime = this.timed || DurationEvent.class.isAssignableFrom(clazz);
        this.uri = uRI.resolve(this.path);
    }

    public JavaEventDescriptor(int n, String string, String string2, String string3, URI uRI, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ValueDescriptor ... valueDescriptorArray) throws InvalidEventDefinitionException {
        super(valueDescriptorArray);
        this.name = string;
        this.path = string3 == null ? "" : string3;
        this.description = string2;
        this.timed = bl4;
        this.hasStartTime = bl;
        this.requestable = bl5;
        this.hasThread = bl2;
        this.stacktrace = bl3;
        this.id = n;
        this.eventClass = null;
        this.uri = uRI;
        this.checkRelations();
    }

    public JavaEventDescriptor(Class<? extends InstantEvent> clazz, URI uRI, int n, String string, String string2, String string3, boolean bl, boolean bl2, ValueDescriptor ... valueDescriptorArray) throws InvalidEventDefinitionException {
        super(valueDescriptorArray);
        this.name = string;
        this.path = string3 == null ? "" : string3;
        this.description = string2;
        this.timed = TimedEvent.class.isAssignableFrom(clazz);
        this.requestable = RequestableEvent.class.isAssignableFrom(clazz);
        this.hasStartTime = this.timed || DurationEvent.class.isAssignableFrom(clazz);
        this.hasThread = bl;
        this.stacktrace = bl2;
        this.id = n;
        this.eventClass = clazz;
        this.uri = uRI.resolve(this.path);
        this.checkRelations();
    }

    private void checkRelations() throws InvalidEventDefinitionException {
        HashSet<String> hashSet = new HashSet<String>();
        for (ValueDescriptor valueDescriptor : this.getValues()) {
            String string = valueDescriptor.getRelationKey();
            if (string != null && hashSet.contains(string)) {
                throw new InvalidEventDefinitionException("Duplicate relation key " + string + " in event");
            }
            hashSet.add(string);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean isTimed() {
        return this.timed;
    }

    @Override
    public boolean hasStartTime() {
        return this.hasStartTime;
    }

    @Override
    public boolean isRequestable() {
        return this.requestable;
    }

    @Override
    public boolean hasThread() {
        return this.hasThread;
    }

    @Override
    public boolean hasStackTrace() {
        return this.stacktrace;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public Class<? extends InstantEvent> getEventClass() {
        return this.eventClass;
    }

    void describe(StringBuilder stringBuilder) {
        if (this.timed) {
            stringBuilder.append("{ Timed event id=");
        } else if (this.requestable) {
            stringBuilder.append("{ Requestable event id=");
        } else {
            stringBuilder.append("{ Event id=");
        }
        stringBuilder.append(this.id).append(", name=").append(this.name);
        stringBuilder.append(", uri=").append(this.uri);
        if (this.eventClass != null) {
            stringBuilder.append(", class=").append(this.eventClass.getName());
        }
        if (this.hasThread) {
            stringBuilder.append(", thread");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.describe(stringBuilder);
        if (this.stacktrace) {
            stringBuilder.append(", stacktrace");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

