/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.AbstractAutoProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.util.StringTokenizer;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class SunAutoProxyHandler
extends AbstractAutoProxyHandler {
    public ProxyInfo[] getProxyInfo(URL uRL) throws ProxyUnavailableException {
        ProxyInfo[] proxyInfoArray;
        if (!Config.isJavaVersionAtLeast16()) {
            return this.fallbackGetProxyInfo(uRL);
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        try {
            scriptEngine.eval(this.autoProxyScript.toString());
            if (scriptEngine instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)scriptEngine);
                Object object = invocable.invokeFunction("FindProxyForURL", uRL.toString(), uRL.getHost());
                proxyInfoArray = this.extractAutoProxySetting((String)object);
            } else {
                Trace.netPrintln("JavaScript engine cannot invoke methods");
                proxyInfoArray = new ProxyInfo[]{new ProxyInfo(null)};
            }
        }
        catch (Exception exception) {
            Trace.netPrintException(exception);
            proxyInfoArray = this.fallbackGetProxyInfo(uRL);
        }
        return proxyInfoArray;
    }

    ProxyInfo[] fallbackGetProxyInfo(URL uRL) {
        try {
            String string = null;
            if (this.jsPacScript != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.jsPacScript, ";", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n = string2.indexOf("DIRECT");
                    int n2 = string2.indexOf("PROXY");
                    int n3 = string2.indexOf("SOCKS");
                    int n4 = this.positiveMin(n, this.positiveMin(n2, n3));
                    int n5 = string2.lastIndexOf("\"");
                    if (n4 == -1) continue;
                    string = n5 <= n4 ? string2.substring(n4) : string2.substring(n4, n5);
                    break;
                }
            }
            return this.extractAutoProxySetting(string);
        }
        catch (Throwable throwable) {
            Trace.msgNetPrintln("net.proxy.auto.result.error");
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    private int positiveMin(int n, int n2) {
        if (n < 0) {
            return n2;
        }
        if (n2 < 0) {
            return n;
        }
        if (n > n2) {
            return n2;
        }
        return n;
    }
}

