/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.core.controller;

import it.sogei.rcp.core.eclipse.RCPWorkbenchAdvisor;
import it.sogei.rcp.core.entity.ConfigurationItems;
import it.sogei.rcp.core.handlers.ConfigurationHandler;
import it.sogei.rcp.core.interfaces.IDesktopParameters;
import it.sogei.rcp.core.properties.Messages;
import it.sogei.rcp.core.util.RCPPlatformUIUtil;
import it.sogei.rcp.filesystemutil.WorkSpaceUtil;
import it.sogei.rcp.security.login.beans.UtentiBean;
import it.sogei.rcp.security.login.db.CreaSchemaDB;
import it.sogei.rcp.security.login.db.DesktopDB;
import it.sogei.rcp.ui.preferences.entities.PreferenceBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.util.PreferencesUtilRCP;
import it.sogei.rcp.util.RCPException;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import java.net.URL;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DesktopController {
    private static final String JAAS_CONFIG_FILE = "config/jaas.config";
    private ILoginContext secureContext;

    public Object start(IDesktopParameters oDesktopParameter) throws RCPException {
        LogUtil.log((Object)this, (int)1, (String)"desktop controller start");
        ConfigurationHandler ch = new ConfigurationHandler(oDesktopParameter.getFileConfig());
        ch.init();
        PreferencesUtilRCP.setInitialPreferenceValue((ScopeEnum)ScopeEnum.CONFIGURATION, (PreferenceBean)new PreferenceBean("it.sogei.rcp.security.login", "security", "passwordRequired"), (String)("" + ConfigurationItems.isPasswordRequired()));
        PreferencesUtilRCP.setInitialPreferenceValue((ScopeEnum)ScopeEnum.CONFIGURATION, (PreferenceBean)new PreferenceBean("it.sogei.rcp.security.login", "security", "multiUser"), (String)("" + ConfigurationItems.isMultiUser()));
        Bundle bundle = Platform.getBundle((String)"it.sogei.rcp.security.simple.login.nodb");
        if (bundle == null) {
            boolean dbCreated;
            try {
                dbCreated = DesktopDB.dbExists();
            }
            catch (SQLException sQLException) {
                dbCreated = false;
            }
            try {
                if (!dbCreated) {
                    CreaSchemaDB creaDB = new CreaSchemaDB();
                    try {
                        creaDB.execscript();
                        creaDB.query();
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                    LogUtil.log((Object)this, (int)1, (String)"dbCreated");
                }
                DesktopDB prodottoDb = new DesktopDB();
                UtentiBean[] user = prodottoDb.selectUsers();
                int numUtenti = user.length;
                if (ConfigurationItems.isMultiUser() || ConfigurationItems.isPasswordRequired() || numUtenti == 0) {
                    return this.secureStart();
                }
                String workspacePath = user[0].getPath();
                Location loc = Platform.getInstanceLocation();
                if (!loc.isSet()) {
                    WorkSpaceUtil wsUtil = new WorkSpaceUtil();
                    try {
                        wsUtil.CreateWorkspace(workspacePath);
                    }
                    catch (Exception e) {
                        throw new RCPException(e.getMessage(), e);
                    }
                }
                PreferencesUtilRCP.setInitialPreferenceValue((ScopeEnum)ScopeEnum.CONFIGURATION, (PreferenceBean)new PreferenceBean("it.sogei.utilities.log4j", "log", "wsCreated"), (String)"true");
                return this.unsecureStart();
            }
            catch (SQLException e) {
                LogUtil.log((Object)this, (int)4, (String)"sqlexception:", (Throwable)e);
                RCPPlatformUIUtil.openDialog(1, Display.getDefault().getActiveShell(), Messages.Commons_Error, Messages.DesktopController_ErrorOpenDBCheckInstance);
                return IApplication.EXIT_OK;
            }
        }
        String workspacePath = String.valueOf(System.getProperty("user.home")) + File.separator + "RCP_workspace";
        Location loc = Platform.getInstanceLocation();
        if (!loc.isSet()) {
            WorkSpaceUtil wsUtil = new WorkSpaceUtil();
            try {
                wsUtil.CreateWorkspace(workspacePath);
            }
            catch (Exception e) {
                throw new RCPException(e.getMessage(), e);
            }
        }
        PreferencesUtilRCP.setInitialPreferenceValue((ScopeEnum)ScopeEnum.CONFIGURATION, (PreferenceBean)new PreferenceBean("it.sogei.utilities.log4j", "log", "wsCreated"), (String)"true");
        return this.unsecureStart();
    }

    public Object unsecureStart() {
        Display display = PlatformUI.createDisplay();
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new RCPWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public Object secureStart() throws RCPException {
        Bundle bundle = Platform.getBundle((String)"it.sogei.rcp.security.login");
        BundleContext bundleContext = bundle.getBundleContext();
        URL configUrl = bundleContext.getBundle().getEntry(JAAS_CONFIG_FILE);
        this.secureContext = LoginContextFactory.createContext((String)"RCP", (URL)configUrl);
        Display display = PlatformUI.createDisplay();
        Integer result = null;
        try {
            try {
                this.secureContext.login();
                PreferencesUtilRCP.setInitialPreferenceValue((ScopeEnum)ScopeEnum.CONFIGURATION, (PreferenceBean)new PreferenceBean("it.sogei.utilities.log4j", "log", "wsCreated"), (String)"true");
                result = Subject.doAs(this.secureContext.getSubject(), this.getRunAction(display));
            }
            catch (LoginException e) {
                LogUtil.log((Object)this, (int)4, (String)"Error during login", (Throwable)e);
                display.dispose();
                try {
                    this.secureContext.logout();
                }
                catch (LoginException e2) {
                    throw new RCPException(e2.getMessage(), (Exception)e2);
                }
            }
            catch (Exception e) {
                LogUtil.log((Object)this, (int)4, (String)"Cannot start the application in a secure context", (Throwable)e);
                display.dispose();
                try {
                    this.secureContext.logout();
                }
                catch (LoginException e3) {
                    throw new RCPException(e3.getMessage(), (Exception)e3);
                }
            }
        }
        finally {
            display.dispose();
            try {
                this.secureContext.logout();
            }
            catch (LoginException e) {
                throw new RCPException(e.getMessage(), (Exception)e);
            }
        }
        return result;
    }

    private PrivilegedAction<Integer> getRunAction(final Display display) {
        return new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new RCPWorkbenchAdvisor());
                if (returnCode == 1) {
                    return IApplication.EXIT_RESTART;
                }
                return IApplication.EXIT_OK;
            }
        };
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

