/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Container;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DefaultLayoutStyle
extends LayoutStyle {
    private static final DefaultLayoutStyle INSTANCE = new DefaultLayoutStyle();

    public static LayoutStyle getInstance() {
        return INSTANCE;
    }

    @Override
    public int getPreferredGap(JComponent jComponent, JComponent jComponent2, LayoutStyle.ComponentPlacement componentPlacement, int n, Container container) {
        int n2;
        if (jComponent == null || jComponent2 == null || componentPlacement == null) {
            throw new NullPointerException();
        }
        this.checkPosition(n);
        if (componentPlacement == LayoutStyle.ComponentPlacement.INDENT && (n == 3 || n == 7) && (n2 = this.getIndent(jComponent, n)) > 0) {
            return n2;
        }
        return componentPlacement == LayoutStyle.ComponentPlacement.UNRELATED ? 12 : 6;
    }

    @Override
    public int getContainerGap(JComponent jComponent, int n, Container container) {
        if (jComponent == null) {
            throw new NullPointerException();
        }
        this.checkPosition(n);
        return 6;
    }

    protected boolean isLabelAndNonlabel(JComponent jComponent, JComponent jComponent2, int n) {
        if (n == 3 || n == 7) {
            boolean bl = jComponent instanceof JLabel;
            boolean bl2 = jComponent2 instanceof JLabel;
            return (bl || bl2) && bl != bl2;
        }
        return false;
    }

    protected int getButtonGap(JComponent jComponent, JComponent jComponent2, int n, int n2) {
        if ((n2 -= this.getButtonGap(jComponent, n)) > 0) {
            n2 -= this.getButtonGap(jComponent2, this.flipDirection(n));
        }
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    protected int getButtonGap(JComponent jComponent, int n, int n2) {
        return Math.max(n2 -= this.getButtonGap(jComponent, n), 0);
    }

    public int getButtonGap(JComponent jComponent, int n) {
        Border border;
        String string = jComponent.getUIClassID();
        if ((string == "CheckBoxUI" || string == "RadioButtonUI") && !((AbstractButton)jComponent).isBorderPainted() && (border = jComponent.getBorder()) instanceof UIResource) {
            return this.getInset(jComponent, n);
        }
        return 0;
    }

    private void checkPosition(int n) {
        if (n != 1 && n != 5 && n != 7 && n != 3) {
            throw new IllegalArgumentException();
        }
    }

    protected int flipDirection(int n) {
        switch (n) {
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        assert (false);
        return 0;
    }

    protected int getIndent(JComponent jComponent, int n) {
        String string = jComponent.getUIClassID();
        if (string == "CheckBoxUI" || string == "RadioButtonUI") {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            Insets insets = jComponent.getInsets();
            Icon icon = this.getIcon(abstractButton);
            int n2 = abstractButton.getIconTextGap();
            if (this.isLeftAligned(abstractButton, n)) {
                return insets.left + icon.getIconWidth() + n2;
            }
            if (this.isRightAligned(abstractButton, n)) {
                return insets.right + icon.getIconWidth() + n2;
            }
        }
        return 0;
    }

    private Icon getIcon(AbstractButton abstractButton) {
        Object object;
        Icon icon = abstractButton.getIcon();
        if (icon != null) {
            return icon;
        }
        String string = null;
        if (abstractButton instanceof JCheckBox) {
            string = "CheckBox.icon";
        } else if (abstractButton instanceof JRadioButton) {
            string = "RadioButton.icon";
        }
        if (string != null && (object = UIManager.get(string)) instanceof Icon) {
            return (Icon)object;
        }
        return null;
    }

    private boolean isLeftAligned(AbstractButton abstractButton, int n) {
        if (n == 7) {
            boolean bl = abstractButton.getComponentOrientation().isLeftToRight();
            int n2 = abstractButton.getHorizontalAlignment();
            return bl && (n2 == 2 || n2 == 10) || !bl && n2 == 11;
        }
        return false;
    }

    private boolean isRightAligned(AbstractButton abstractButton, int n) {
        if (n == 3) {
            boolean bl = abstractButton.getComponentOrientation().isLeftToRight();
            int n2 = abstractButton.getHorizontalAlignment();
            return bl && (n2 == 4 || n2 == 11) || !bl && n2 == 10;
        }
        return false;
    }

    private int getInset(JComponent jComponent, int n) {
        return this.getInset(jComponent.getInsets(), n);
    }

    private int getInset(Insets insets, int n) {
        if (insets == null) {
            return 0;
        }
        switch (n) {
            case 1: {
                return insets.top;
            }
            case 5: {
                return insets.bottom;
            }
            case 3: {
                return insets.right;
            }
            case 7: {
                return insets.left;
            }
        }
        assert (false);
        return 0;
    }
}

