/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerInputException;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.ObjectID;
import iaik.asn1.UNIString;
import iaik.asn1.UTCTime;
import iaik.asn1.UTF8String;
import iaik.asn1.c;
import iaik.utils.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;

public class DerInputStream
extends InputStream {
    InputStream b;
    DerInputStream d;
    int a;
    InputStream e;
    boolean f = false;
    int c;
    public static final int BMPString = 30;
    public static final int UNIString = 28;
    public static final int GeneralString = 27;
    public static final int VisibleString = 26;
    public static final int GeneralizedTime = 24;
    public static final int UTCTime = 23;
    public static final int IA5String = 22;
    public static final int T61String = 20;
    public static final int PrintableString = 19;
    public static final int NumericString = 18;
    public static final int SET = 17;
    public static final int SEQUENCE = 16;
    public static final int UTF8String = 12;
    public static final int ENUMERATED = 10;
    public static final int EXTERNAL = 8;
    public static final int OBJECT_DESCRIPTOR = 7;
    public static final int OBJECT_ID = 6;
    public static final int NULL = 5;
    public static final int OCTET_STRING = 4;
    public static final int BIT_STRING = 3;
    public static final int INTEGER = 2;
    public static final int BOOLEAN = 1;
    public static final int CONSTRUCTED = 32;
    public static final int PRIVATE = 192;
    public static final int CONTEXT_SPECIFIC = 128;
    public static final int APPLICATION = 64;
    public static final int UNIVERSAL = 0;

    static int a(DerInputStream derInputStream, boolean bl) throws IOException {
        return derInputStream.f(bl);
    }

    static void a(DerInputStream derInputStream, byte[] byArray, int n2) throws IOException {
        derInputStream.a(byArray, n2);
    }

    static InputStream a(DerInputStream derInputStream) {
        return derInputStream.b();
    }

    private void a(byte[] byArray, int n2) throws IOException {
        if (this.e instanceof PushbackInputStream) {
            ((PushbackInputStream)this.e).unread(byArray, 0, n2);
        } else {
            ((DerInputStream)this.e).a(byArray, n2);
        }
        if (this.c >= 0) {
            this.c += n2;
        }
    }

    private void a(int n2) throws IOException {
        if (this.e instanceof PushbackInputStream) {
            ((PushbackInputStream)this.e).unread(n2);
        } else {
            ((DerInputStream)this.e).a(n2);
        }
        if (this.c >= 0) {
            ++this.c;
        }
    }

    public int skipObjects(int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        while (n4 < n2 && (n3 = this.f(false)) > 0) {
            int n5 = this.a();
            if (n5 >= 0) {
                this.skip(n5);
            } else {
                DerInputStream derInputStream = new DerInputStream(this, n5, n3);
                derInputStream.skipObjects(-1);
            }
            ++n4;
        }
        return n4;
    }

    public long skip(long l2) throws IOException {
        if (this.c < 0) {
            return this.e.skip(l2);
        }
        int n2 = Math.min((int)l2, this.c);
        this.e.skip(n2);
        this.c -= n2;
        return n2;
    }

    public UTCTime readUTCTime() throws IOException {
        int n2 = this.f(false);
        if (n2 != 23) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read UTCTime tag!");
            }
            throw new DerInputException("Next ASN.1 object is no UTC TIME!");
        }
        UTCTime uTCTime = new UTCTime();
        uTCTime.decode(this.a(), this);
        return uTCTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int f(boolean bl) throws IOException {
        if (this.d != null && !this.d.f && this.d.c < 0) {
            this.d.readEOC();
        }
        if (this.f) {
            return -1;
        }
        int n2 = this.read();
        boolean bl2 = false;
        if (n2 == -1) {
            bl2 = true;
        } else if (n2 == 0) {
            if (this.c >= 0) throw new DerInputException("Found EOC 0 tag but no indefinite length encoding!");
            bl2 = true;
            n2 = -1;
            if (this.read() != 0) {
                throw new DerInputException("Indefinite length: second fin byte not 0!");
            }
        } else if ((n2 & 0x1F) == 31) {
            int n3;
            byte[] byArray = new byte[10];
            int n4 = 0;
            byArray[n4++] = (byte)n2;
            n2 = 0;
            do {
                n2 <<= 7;
                n3 = this.read();
                byArray[n4++] = (byte)n3;
                n2 |= n3 & 0x7F;
            } while ((n3 & 0x80) != 0);
            if (bl) {
                this.a(byArray, n4);
            }
        } else {
            if (bl) {
                this.a(n2);
            }
            n2 &= 0x1F;
        }
        if (bl2 && this.c != -2) {
            ((DerInputStream)this.e).c();
        }
        if (!bl2) return n2;
        this.f = true;
        return n2;
    }

    public String readString() throws IOException {
        int n2 = this.f(false);
        if (n2 == -1) {
            throw new EOFException("Unexpected EOF when trying to read String tag!");
        }
        byte[] byArray = new byte[this.a()];
        Util.fillArray(byArray, this);
        switch (n2) {
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 27: {
                return Util.toASCIIString(byArray);
            }
            case 28: {
                return iaik.asn1.UNIString.a(byArray);
            }
            case 30: {
                return new String(byArray, "UnicodeBig");
            }
            case 12: {
                try {
                    return iaik.asn1.UTF8String.getStringFromUTF8Encoding(byArray);
                }
                catch (CodingException codingException) {
                    throw new DerInputException(codingException.getMessage());
                }
            }
        }
        throw new DerInputException("Next ASN.1 object is no STRING type!");
    }

    public DerInputStream readSet() throws IOException {
        int n2 = this.f(false);
        if (n2 != 17) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read SET tag!");
            }
            throw new DerInputException("Next ASN.1 object is no SET!");
        }
        return new DerInputStream(this, this.a(), n2);
    }

    public DerInputStream readSequence() throws IOException {
        int n2 = this.f(false);
        if (n2 != 16) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read SEQUENCE tag!");
            }
            throw new DerInputException("Next ASN.1 object is no SEQUENCE!");
        }
        return new DerInputStream(this, this.a(), n2);
    }

    public byte[] readOctetStringByteArray() throws IOException {
        int n2 = this.f(false);
        if (n2 == -1) {
            return null;
        }
        if (n2 != 4) {
            throw new DerInputException("Next ASN.1 object is no OCTET_STRING!");
        }
        int n3 = this.a();
        if (n3 >= 0) {
            byte[] byArray = new byte[n3];
            Util.fillArray(byArray, this);
            return byArray;
        }
        throw new DerInputException("DER decode ERROR: indefinite length encoding not allowed for primitive octet strings!");
    }

    public InputStream readOctetString(boolean bl) throws IOException {
        InputStream inputStream;
        if (bl) {
            DerInputStream derInputStream = this;
            while ((inputStream = derInputStream.readOctetString()) instanceof DerInputStream) {
                derInputStream = (DerInputStream)inputStream;
            }
        } else {
            inputStream = this.readOctetString();
        }
        return inputStream;
    }

    public InputStream readOctetString() throws IOException {
        int n2;
        if (this.d != null && !this.d.f && this.d.c < 0) {
            this.d.readEOC();
        }
        if ((n2 = this.read()) == -1) {
            return null;
        }
        if ((n2 & 0x1F) != 4) {
            throw new DerInputException("Next ASN.1 object is no OCTET_STRING!");
        }
        int n3 = this.a();
        if ((n2 & 0x20) == 0) {
            if (n3 == -1) {
                throw new DerInputException("DER decode ERROR: indefinite length encoding not allowed for primitive octet strings!");
            }
            return new c(this, new DerInputStream(this, n3, n2), false);
        }
        if (this.b(false)) {
            return new DerInputStream(this, n3, n2);
        }
        return new c(this, new DerInputStream(this, n3, n2), true);
    }

    public ObjectID readObjectID() throws IOException {
        int n2 = this.f(false);
        if (n2 != 6) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read OID tag!");
            }
            throw new DerInputException("Next ASN.1 object is no OBJECT IDENTIFIER!");
        }
        ObjectID objectID = new ObjectID();
        objectID.decode(this.a(), this);
        return objectID;
    }

    public void readNull() throws IOException {
        int n2 = this.f(false);
        if (n2 != 5) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read NULL tag!");
            }
            throw new DerInputException("Next ASN.1 object is not NULL!");
        }
        this.a();
    }

    public BigInteger readInteger() throws IOException {
        int n2 = this.f(false);
        if (n2 != 2) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read INTEGER tag!");
            }
            throw new DerInputException("Next ASN.1 object is no INTEGER!");
        }
        byte[] byArray = new byte[this.a()];
        Util.fillArray(byArray, this);
        return new BigInteger(byArray);
    }

    public GeneralizedTime readGeneralizedTime() throws IOException {
        int n2 = this.f(false);
        if (n2 != 24) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read GeneralizedTime tag!");
            }
            throw new DerInputException("Next ASN.1 object is no GeneralizedTime!");
        }
        GeneralizedTime generalizedTime = new GeneralizedTime();
        generalizedTime.decode(this.a(), this);
        return generalizedTime;
    }

    public void readEOC() throws IOException {
        if (!this.f && this.c < 0) {
            int n2 = this.read();
            if (n2 == 0) {
                n2 = this.read();
                if (n2 == -1) {
                    throw new EOFException("Indefinite length: Missing second EOC byte!");
                }
                if (n2 != 0) {
                    throw new DerInputException("Indefinite length: second byte not 0!");
                }
            } else {
                if (n2 == -1) {
                    throw new EOFException("Indefinite length: Missing EOC octets!");
                }
                throw new DerInputException("Indefinite length encoding not closed by EOC!");
            }
            if (this.c != -2) {
                ((DerInputStream)this.e).c();
                this.f = true;
            }
        }
    }

    public int readContextSpecific(int n2) throws IOException {
        if (!this.c(true)) {
            throw new DerInputException("Next ASN.1 object is no CONTEXT SPECIFIC!");
        }
        if (this.b(true)) {
            n2 |= 0x20;
        }
        int n3 = this.f(false);
        this.a(n2);
        return n3;
    }

    public DerInputStream readContextSpecific() throws IOException {
        if (!this.c(true)) {
            throw new DerInputException("Next ASN.1 object is no CONTEXT SPECIFIC!");
        }
        int n2 = this.f(false);
        return new DerInputStream(this, this.a(), n2);
    }

    public DerInputStream readConstructed() throws IOException {
        if (!this.b(true)) {
            throw new DerInputException("Next ASN.1 object is not CONSTRUCTED!");
        }
        int n2 = this.f(false);
        return new DerInputStream(this, this.a(), n2);
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.f(false);
        if (n2 != 1) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read BOOLEAN tag!");
            }
            throw new DerInputException("Next ASN.1 object is no BOOLEAN!");
        }
        if (this.a() != 1) {
            throw new IOException("Boolean length not 1!");
        }
        return this.read() != 0;
    }

    public BIT_STRING readBitString() throws IOException {
        int n2 = this.f(false);
        if (n2 != 3) {
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF when trying to read BIT STRING tag!");
            }
            throw new DerInputException("Next ASN.1 object is no BIT_STRING!");
        }
        BIT_STRING bIT_STRING = new BIT_STRING();
        bIT_STRING.decode(this.a(), this);
        return bIT_STRING;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = -1;
        if (!this.f) {
            if (this.c < 0) {
                n4 = this.e.read(byArray, n2, n3);
            } else if (this.c > 0) {
                int n5 = Math.min(n3, this.c);
                this.c -= n5;
                int n6 = n5;
                while (n6 > 0) {
                    n4 = this.e.read(byArray, n2, n6);
                    if (n4 < 0) {
                        throw new EOFException();
                    }
                    n6 -= n4;
                    n2 += n4;
                }
                n4 = n5;
            }
        }
        return n4;
    }

    public int read(boolean bl) throws IOException {
        int n2 = this.read();
        if (bl && n2 != -1) {
            this.a(n2);
        }
        return n2;
    }

    public int read() throws IOException {
        int n2 = -1;
        if (!this.f) {
            if (this.c < 0) {
                n2 = this.e.read();
            } else if (this.c > 0) {
                --this.c;
                n2 = this.e.read();
            }
        }
        return n2;
    }

    private void c() throws IOException {
        if (this.f) {
            return;
        }
        if (this.c == -1) {
            int n2 = this.read();
            if (n2 > 0) {
                this.a(n2);
                return;
            }
            if (n2 == 0) {
                if (this.c < 0) {
                    int n3 = this.read();
                    this.f = true;
                    if (n3 != 0) {
                        if (n3 == -1) {
                            throw new EOFException("Indefinite length: Missing second EOC byte!");
                        }
                        throw new DerInputException("Indefinite length: second byte not 0!");
                    }
                } else {
                    throw new DerInputException("Found 0 tag but no indefinite length encoding!");
                }
            }
            if (this.e instanceof DerInputStream) {
                ((DerInputStream)this.e).c();
                return;
            }
        } else if (this.c == 0 && this.e instanceof DerInputStream) {
            ((DerInputStream)this.e).c();
        }
    }

    public int nextTag() throws IOException {
        return this.f(true);
    }

    private boolean e(boolean bl) throws IOException {
        int n2;
        if (this.d != null && !this.d.f && this.d.c < 0) {
            this.d.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 0;
    }

    public boolean nextIsUniversal() throws IOException {
        return this.e(false);
    }

    private boolean d(boolean bl) throws IOException {
        int n2;
        if (this.d != null && !this.d.f && this.d.c < 0) {
            this.d.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 192;
    }

    public boolean nextIsPrivate() throws IOException {
        return this.d(false);
    }

    private boolean c(boolean bl) throws IOException {
        int n2;
        if (this.d != null && !this.d.f && this.d.c < 0) {
            this.d.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 128;
    }

    public boolean nextIsContextSpecific() throws IOException {
        return this.c(false);
    }

    private boolean b(boolean bl) throws IOException {
        int n2;
        if (this.d != null && !this.d.f && this.d.c < 0) {
            this.d.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0x20) == 32;
    }

    public boolean nextIsConstructed() throws IOException {
        return this.b(false);
    }

    private boolean a(boolean bl) throws IOException {
        int n2;
        if (this.d != null && !this.d.f && this.d.c < 0) {
            this.d.readEOC();
        }
        if ((n2 = this.read(true)) == -1 && bl) {
            throw new EOFException();
        }
        return (n2 & 0xC0) == 64;
    }

    public boolean nextIsApplication() throws IOException {
        return this.a(false);
    }

    public int getTag() {
        return this.a;
    }

    private InputStream b() {
        return this.b;
    }

    private int a() throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException("Unexpected EOF while reading length field!");
        }
        if ((n2 &= 0xFF) < 128) {
            return n2;
        }
        if (n2 == 128) {
            return -1;
        }
        if ((n2 &= 0x7F) > 4) {
            throw new DerInputException("Length: Too large ASN.1 object: " + n2);
        }
        int n3 = 0;
        while (--n2 >= 0) {
            int n4 = this.read();
            if (n4 == -1) {
                throw new EOFException("Unexpected EOF while reading length field!");
            }
            n3 = n3 << 8 | n4 & 0xFF;
        }
        return n3;
    }

    public void close() throws IOException {
        this.e.close();
    }

    public int available() {
        if (this.f) {
            return 0;
        }
        return this.c;
    }

    public DerInputStream(InputStream inputStream) {
        this.c = -2;
        this.a = -2;
        this.b = this.e = new PushbackInputStream(inputStream, 32);
    }

    private DerInputStream(DerInputStream derInputStream, int n2, int n3) {
        this.e = derInputStream;
        this.c = n2;
        this.a = n3;
        derInputStream.d = this;
        this.b = derInputStream.b();
    }
}

