/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.java2d.HeadlessGraphicsEnvironment;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.GetPropertyAction;

public abstract class GraphicsEnvironment {
    private static GraphicsEnvironment localEnv;
    private static Boolean headless;
    private static Boolean defaultHeadless;

    protected GraphicsEnvironment() {
    }

    public static synchronized GraphicsEnvironment getLocalGraphicsEnvironment() {
        if (localEnv == null) {
            localEnv = GraphicsEnvironment.createGE();
        }
        return localEnv;
    }

    private static GraphicsEnvironment createGE() {
        GraphicsEnvironment graphicsEnvironment;
        String string = AccessController.doPrivileged(new GetPropertyAction("java.awt.graphicsenv", null));
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                clazz = Class.forName(string, true, classLoader);
            }
            graphicsEnvironment = (GraphicsEnvironment)clazz.newInstance();
            if (GraphicsEnvironment.isHeadless()) {
                graphicsEnvironment = new HeadlessGraphicsEnvironment(graphicsEnvironment);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Could not find class: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new Error("Could not instantiate Graphics Environment: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Could not access Graphics Environment: " + string);
        }
        return graphicsEnvironment;
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.getHeadlessProperty();
    }

    static String getHeadlessMessage() {
        if (headless == null) {
            GraphicsEnvironment.getHeadlessProperty();
        }
        return defaultHeadless != Boolean.TRUE ? null : "\nNo X11 DISPLAY variable was set, but this program performed an operation which requires it.";
    }

    private static boolean getHeadlessProperty() {
        if (headless == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("java.awt.headless");
                    if (string == null) {
                        if (System.getProperty("javaplugin.version") != null) {
                            headless = (defaultHeadless = Boolean.FALSE);
                        } else {
                            String string2 = System.getProperty("os.name");
                            headless = (defaultHeadless = ("Linux".equals(string2) || "SunOS".equals(string2)) && System.getenv("DISPLAY") == null);
                        }
                    } else if (string.equals("true")) {
                        headless = Boolean.TRUE;
                    } else {
                        headless = Boolean.FALSE;
                    }
                    return null;
                }
            });
        }
        return headless;
    }

    static void checkHeadless() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean isHeadlessInstance() {
        return GraphicsEnvironment.getHeadlessProperty();
    }

    public abstract GraphicsDevice[] getScreenDevices() throws HeadlessException;

    public abstract GraphicsDevice getDefaultScreenDevice() throws HeadlessException;

    public abstract Graphics2D createGraphics(BufferedImage var1);

    public abstract Font[] getAllFonts();

    public abstract String[] getAvailableFontFamilyNames();

    public abstract String[] getAvailableFontFamilyNames(Locale var1);

    public boolean registerFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font cannot be null.");
        }
        FontManager fontManager = FontManagerFactory.getInstance();
        return fontManager.registerFont(font);
    }

    public void preferLocaleFonts() {
        FontManager fontManager = FontManagerFactory.getInstance();
        fontManager.preferLocaleFonts();
    }

    public void preferProportionalFonts() {
        FontManager fontManager = FontManagerFactory.getInstance();
        fontManager.preferProportionalFonts();
    }

    public Point getCenterPoint() throws HeadlessException {
        Rectangle rectangle = SunGraphicsEnvironment.getUsableBounds(this.getDefaultScreenDevice());
        return new Point(rectangle.width / 2 + rectangle.x, rectangle.height / 2 + rectangle.y);
    }

    public Rectangle getMaximumWindowBounds() throws HeadlessException {
        return SunGraphicsEnvironment.getUsableBounds(this.getDefaultScreenDevice());
    }
}

