/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private static final Executor processReaperExecutor = AccessController.doPrivileged(new PrivilegedAction<Executor>(){

        @Override
        public Executor run() {
            return Executors.newCachedThreadPool(new ProcessReaperThreadFactory());
        }
    });

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(byte[] var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int[] var7, boolean var8) throws IOException;

    UNIXProcess(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, byte[] byArray4, final int[] nArray, boolean bl) throws IOException {
        this.pid = this.forkAndExec(byArray, byArray2, n, byArray3, n2, byArray4, nArray, bl);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    UNIXProcess.this.initStreams(nArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    static FileDescriptor newFileDescriptor(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, n);
        return fileDescriptor;
    }

    void initStreams(int[] nArray) throws IOException {
        this.stdin = nArray[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(nArray[0]);
        this.stdout = nArray[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(nArray[1]);
        this.stderr = nArray[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(nArray[2]);
        processReaperExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int n = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                UNIXProcess.this.processExited(n);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processExited(int n) {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            this.exitcode = n;
            this.hasExited = true;
            this.notifyAll();
        }
        if (this.stdout instanceof ProcessPipeInputStream) {
            ((ProcessPipeInputStream)this.stdout).processExited();
        }
        if (this.stderr instanceof ProcessPipeInputStream) {
            ((ProcessPipeInputStream)this.stderr).processExited();
        }
        if (this.stdin instanceof ProcessPipeOutputStream) {
            ((ProcessPipeOutputStream)this.stdin).processExited();
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            if (!this.hasExited) {
                UNIXProcess.destroyProcess(this.pid);
            }
        }
        try {
            this.stdin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stdout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stderr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void initIDs();

    static {
        UNIXProcess.initIDs();
    }

    static class ProcessPipeInputStream
    extends BufferedInputStream {
        ProcessPipeInputStream(int n) {
            super(new FileInputStream(UNIXProcess.newFileDescriptor(n)));
        }

        private static byte[] drainInputStream(InputStream inputStream) throws IOException {
            int n;
            if (inputStream == null) {
                return null;
            }
            int n2 = 0;
            byte[] byArray = null;
            while ((n = inputStream.available()) > 0) {
                byArray = byArray == null ? new byte[n] : Arrays.copyOf(byArray, n2 + n);
                n2 += inputStream.read(byArray, n2, n);
            }
            return byArray == null || n2 == byArray.length ? byArray : Arrays.copyOf(byArray, n2);
        }

        synchronized void processExited() {
            try {
                InputStream inputStream = this.in;
                if (inputStream != null) {
                    byte[] byArray = ProcessPipeInputStream.drainInputStream(inputStream);
                    inputStream.close();
                    InputStream inputStream2 = this.in = byArray == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(byArray);
                    if (this.buf == null) {
                        this.in = null;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class ProcessPipeOutputStream
    extends BufferedOutputStream {
        ProcessPipeOutputStream(int n) {
            super(new FileOutputStream(UNIXProcess.newFileDescriptor(n)));
        }

        synchronized void processExited() {
            OutputStream outputStream = this.out;
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = ProcessBuilder.NullOutputStream.INSTANCE;
            }
        }
    }

    private static class ProcessReaperThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup group = ProcessReaperThreadFactory.getRootThreadGroup();

        private ProcessReaperThreadFactory() {
        }

        private static ThreadGroup getRootThreadGroup() {
            return AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup.getParent() != null) {
                        threadGroup = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(group, runnable, "process reaper", 32768L);
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        }
    }
}

