/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.GeneratedClassLoader;
import sun.org.mozilla.javascript.internal.Script;
import sun.org.mozilla.javascript.internal.Scriptable;

public abstract class SecurityController {
    private static SecurityController global;

    static SecurityController global() {
        return global;
    }

    public static boolean hasGlobal() {
        return global != null;
    }

    public static void initGlobal(SecurityController securityController) {
        if (securityController == null) {
            throw new IllegalArgumentException();
        }
        if (global != null) {
            throw new SecurityException("Cannot overwrite already installed global SecurityController");
        }
        global = securityController;
    }

    public abstract GeneratedClassLoader createClassLoader(ClassLoader var1, Object var2);

    public static GeneratedClassLoader createLoader(ClassLoader classLoader, Object object) {
        GeneratedClassLoader generatedClassLoader;
        SecurityController securityController;
        Context context = Context.getContext();
        if (classLoader == null) {
            classLoader = context.getApplicationClassLoader();
        }
        if ((securityController = context.getSecurityController()) == null) {
            generatedClassLoader = context.createClassLoader(classLoader);
        } else {
            Object object2 = securityController.getDynamicSecurityDomain(object);
            generatedClassLoader = securityController.createClassLoader(classLoader, object2);
        }
        return generatedClassLoader;
    }

    public static Class<?> getStaticSecurityDomainClass() {
        SecurityController securityController = Context.getContext().getSecurityController();
        return securityController == null ? null : securityController.getStaticSecurityDomainClassInternal();
    }

    public Class<?> getStaticSecurityDomainClassInternal() {
        return null;
    }

    public abstract Object getDynamicSecurityDomain(Object var1);

    public Object callWithDomain(Object object, Context context, final Callable callable, Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        return this.execWithDomain(context, scriptable, new Script(){

            @Override
            public Object exec(Context context, Scriptable scriptable) {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        }, object);
    }

    public Object execWithDomain(Context context, Scriptable scriptable, Script script, Object object) {
        throw new IllegalStateException("callWithDomain should be overridden");
    }
}

