/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.HashMap;
import org.ietf.jgss.Oid;
import sun.security.action.PutAllAction;
import sun.security.jgss.wrapper.GSSLibStub;

public final class SunNativeProvider
extends Provider {
    private static final long serialVersionUID = -238911724858694204L;
    private static final String NAME = "SunNativeGSS";
    private static final String INFO = "Sun Native GSS provider";
    private static final String MF_CLASS = "sun.security.jgss.wrapper.NativeGSSFactory";
    private static final String LIB_PROP = "sun.security.jgss.lib";
    private static final String DEBUG_PROP = "sun.security.nativegss.debug";
    private static HashMap MECH_MAP;
    static final Provider INSTANCE;
    static boolean DEBUG;

    static void debug(String string) {
        if (DEBUG) {
            if (string == null) {
                throw new NullPointerException();
            }
            System.out.println("SunNativeGSS: " + string);
        }
    }

    public SunNativeProvider() {
        super(NAME, 1.0, INFO);
        if (MECH_MAP != null) {
            AccessController.doPrivileged(new PutAllAction(this, MECH_MAP));
        }
    }

    static {
        INSTANCE = new SunNativeProvider();
        MECH_MAP = AccessController.doPrivileged(new PrivilegedAction<HashMap>(){

            @Override
            public HashMap run() {
                DEBUG = Boolean.parseBoolean(System.getProperty(SunNativeProvider.DEBUG_PROP));
                try {
                    System.loadLibrary("j2gss");
                }
                catch (Error error) {
                    SunNativeProvider.debug("No j2gss library found!");
                    if (DEBUG) {
                        error.printStackTrace();
                    }
                    return null;
                }
                String[] stringArray = new String[]{};
                String string = System.getProperty(SunNativeProvider.LIB_PROP);
                if (string == null || string.trim().equals("")) {
                    String[] stringArray2 = System.getProperty("os.name");
                    if (stringArray2.startsWith("SunOS")) {
                        stringArray = new String[]{"libgss.so"};
                    } else if (stringArray2.startsWith("Linux")) {
                        stringArray = new String[]{"libgssapi.so", "libgssapi_krb5.so", "libgssapi_krb5.so.2"};
                    }
                } else {
                    stringArray = new String[]{string};
                }
                for (String string2 : stringArray) {
                    if (!GSSLibStub.init(string2)) continue;
                    SunNativeProvider.debug("Loaded GSS library: " + string2);
                    Oid[] oidArray = GSSLibStub.indicateMechs();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 0; i < oidArray.length; ++i) {
                        SunNativeProvider.debug("Native MF for " + oidArray[i]);
                        hashMap.put("GssApiMechanism." + oidArray[i], SunNativeProvider.MF_CLASS);
                    }
                    return hashMap;
                }
                return null;
            }
        });
    }
}

