/*
 * Decompiled with CFR 0.152.
 */
package demo.smime.ess;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Attributes;
import iaik.cms.CMSSignatureException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.smime.EncryptedContent;
import iaik.smime.SMimeBodyPart;
import iaik.smime.SMimeException;
import iaik.smime.SMimeMultipart;
import iaik.smime.SMimeUtil;
import iaik.smime.SignedContent;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.EntityIdentifier;
import iaik.smime.ess.MLData;
import iaik.smime.ess.MLExpansionHistory;
import iaik.smime.ess.MLReceiptPolicy;
import iaik.smime.ess.utils.ESSLayerException;
import iaik.smime.ess.utils.ESSLayers;
import iaik.smime.ess.utils.KeyDatabase;
import iaik.smime.ess.utils.KeyStoreDatabase;
import iaik.smime.ess.utils.MLA;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MLADemo {
    EntityIdentifier mlaID_;
    MLA mla_;
    KeyStoreDatabase keyStoreDatabase_;
    PrivateKey recipientPrivateKey_;
    X509Certificate[] recipientCertificates_;
    PrivateKey encryptionPrivateKeyOfE1_;
    X509Certificate[] encryptionCertificatesOfE1_;
    X509Certificate[] certificatesOfMLA_;
    PrivateKey encryptionPrivateKeyOfMLA_;
    X509Certificate[] encryptionCertificatesOfMLA_;
    PrivateKey signerPrivateKeyOfMLA_;
    X509Certificate[] signerCertificatesOfMLA_;
    PrivateKey signerPrivateKeyOfS3_;
    X509Certificate[] signerCertificatesOfS3_;
    PrivateKey signerPrivateKeyOfS2_;
    X509Certificate[] signerCertificatesOfS2_;
    PrivateKey signerPrivateKeyOfS1_;
    X509Certificate[] signerCertificatesOfS1_;
    String host_ = "mailhost";
    String recipientAddress_;
    String mlaAddress_;
    String senderAddress_ = "\"" + this.senderName_ + "\" <smimetest@iaik.at>";
    String recipientName_ = "IAIK Demo Recipient";
    String mlaName_ = "IAIK Demo ML Agent";
    String senderName_ = "IAIK Demo Sender";
    static final boolean a = false;

    public DataHandler verify(SignedContent signedContent, X509Certificate x509Certificate) throws ESSException, MessagingException, CMSSignatureException {
        X509Certificate x509Certificate2 = signedContent.verify();
        System.out.println("Signature ok from: " + x509Certificate2.getSubjectDN());
        if (!x509Certificate2.equals(x509Certificate)) {
            throw new ESSException("Error: message signed by wrong entity (" + x509Certificate2.getSubjectDN() + ").\nExpected " + x509Certificate.getSubjectDN());
        }
        return signedContent.getDataHandler();
    }

    public void test_S3_S2_S1_O(Session session, Multipart multipart, byte[] byArray, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("1. Creating signed message and send it to MLA...");
        Message message = this.createMessage(session, this.senderAddress_, this.mlaAddress_);
        message.setSubject("RFC2634, 4.2.1, 2) S3(S2(S1(Original Content)))");
        SignedContent signedContent = this.create_S3_S2_S1_O(multipart, multipart.getContentType(), bl, this.signerCertificatesOfS1_, this.signerPrivateKeyOfS1_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, null, bl, this.signerCertificatesOfS2_, this.signerPrivateKeyOfS2_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, null, bl, this.signerCertificatesOfS3_, this.signerPrivateKeyOfS3_, AlgorithmID.sha1, AlgorithmID.rsaEncryption, null);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        message.saveChanges();
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("2. MLA: Processing message...");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        signedContent = this.processMessageForMLA(message, bl, "S3_S2_S1_O");
        System.out.println("MLA: Sending signed message to new recipient.");
        message = this.createMessage(session, this.mlaAddress_, this.recipientAddress_);
        message.setSubject("RFC2634, 4.2.1, 2) MLA(S3(S2(S1(Original Content))))");
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("3. Final recipient: Parsing message received from MLA...");
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        Object object = message.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: received message is not signed!");
        }
        System.out.println("First layer of message is signed. Verifying signature.");
        DataHandler dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfMLA_[0]);
        System.out.println("Reading MLExpansionHistory attribute.");
        MLADemo.readMLExpansionHistory((SignedContent)object, 1);
        object = dataHandler.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: second layer of received message is not signed!");
        }
        System.out.println("Second layer of message is signed. Verifying signature.");
        dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfS3_[0]);
        object = dataHandler.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: third layer of received message is not signed!");
        }
        System.out.println("Third layer of message is signed. Verifying signature.");
        dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfS2_[0]);
        object = dataHandler.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: fourth layer of received message is not signed!");
        }
        System.out.println("Fourth layer of message is signed. Verifying signature.");
        dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfS1_[0]);
        if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])this.a(dataHandler))) {
            throw new Exception("Error: Original content changed!");
        }
        this.dumpContent(dataHandler);
    }

    public void test_S3_S2_E1_S1_O(Session session, Multipart multipart, byte[] byArray, boolean bl, boolean bl2) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("1. Creating double signed and encrypted/signed message and send it to MLA...");
        Message message = this.createMessage(session, this.senderAddress_, this.mlaAddress_);
        message.setSubject("RFC2634, 4.2.1, 5) S3(S2(E1(S1(Original Content))))");
        SignedContent signedContent = this.create_S3_S2_E1_S1_0(multipart, multipart.getContentType(), bl, this.signerCertificatesOfS1_, this.signerPrivateKeyOfS1_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, null, this.encryptionCertificatesOfMLA_[0], AlgorithmID.rsaEncryption, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone(), 192, bl, this.signerCertificatesOfS2_, this.signerPrivateKeyOfS2_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, null, bl, this.signerCertificatesOfS3_, this.signerPrivateKeyOfS3_, AlgorithmID.sha1, AlgorithmID.rsaEncryption, bl2 ? MLADemo.createMLExpansionHistory(this.signerCertificatesOfS3_[0], new Date(), null) : null);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        message.saveChanges();
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("2. MLA: Processing message...");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        signedContent = this.processMessageForMLA(message, bl, "S3_S2_E1_S1_0");
        System.out.println("MLA: Sending signed message to new recipient.");
        message = this.createMessage(session, this.mlaAddress_, this.recipientAddress_);
        message.setSubject("RFC2634, 4.2.1, 5) MLA(E1(S1(Original Content)))");
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("3. Final recipient: Parsing message received from MLA...");
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        Object object = message.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: received message is not signed!");
        }
        System.out.println("First layer of message is signed. Verifying signature.");
        DataHandler dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfMLA_[0]);
        System.out.println("Reading MLExpansionHistory attributes.");
        MLADemo.readMLExpansionHistory((SignedContent)object, bl2 ? 2 : 1);
        object = dataHandler.getContent();
        if (!(object instanceof EncryptedContent)) {
            throw new ESSException("Error: second layer of received message is not encrypted!");
        }
        System.out.println("Second layer of message is encrypted. Trying to decrypt.");
        dataHandler = this.decrypt((EncryptedContent)object, this.recipientPrivateKey_, this.recipientCertificates_[0]);
        object = dataHandler.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: second layer of received message is not signed!");
        }
        System.out.println("Third layer of message is signed. Verifying signature.");
        dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfS1_[0]);
        if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])this.a(dataHandler))) {
            throw new Exception("Error: Original content changed!");
        }
        this.dumpContent(dataHandler);
    }

    public void test_S2_E1_S1_O(Session session, Multipart multipart, byte[] byArray, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("1. Creating signed and encrypted/signed message and send it to MLA...");
        Message message = this.createMessage(session, this.senderAddress_, this.mlaAddress_);
        message.setSubject("RFC2634, 4.2.1, 4) S2(E1(S1(Original Content)))");
        SignedContent signedContent = this.create_S2_E1_S1_0(multipart, multipart.getContentType(), bl, this.signerCertificatesOfS1_, this.signerPrivateKeyOfS1_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, null, this.encryptionCertificatesOfMLA_[0], AlgorithmID.rsaEncryption, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone(), 192, bl, this.signerCertificatesOfS2_, this.signerPrivateKeyOfS2_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, MLADemo.createMLExpansionHistory(this.signerCertificatesOfS2_[0], new Date(), null));
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        message.saveChanges();
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("2. MLA: Processing message...");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        signedContent = this.processMessageForMLA(message, bl, "S2_E1_S1_0");
        System.out.println("MLA: Sending signed message to new recipient.");
        message = this.createMessage(session, this.mlaAddress_, this.recipientAddress_);
        message.setSubject("RFC2634, 4.2.1, 4) MLA(E1(S1(Original Content)))");
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("3. Final recipient: Parsing message received from MLA...");
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        Object object = message.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: received message is not signed!");
        }
        System.out.println("First layer of message is signed. Verifying signature.");
        DataHandler dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfMLA_[0]);
        System.out.println("Reading MLExpansionHistory attributes.");
        MLADemo.readMLExpansionHistory((SignedContent)object, 2);
        object = dataHandler.getContent();
        if (!(object instanceof EncryptedContent)) {
            throw new ESSException("Error: second layer of received message is not encrypted!");
        }
        System.out.println("Second layer of message is encrypted. Trying to decrypt.");
        dataHandler = this.decrypt((EncryptedContent)object, this.recipientPrivateKey_, this.recipientCertificates_[0]);
        object = dataHandler.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: second layer of received message is not signed!");
        }
        System.out.println("Third layer of message is signed. Verifying signature.");
        dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfS1_[0]);
        if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])this.a(dataHandler))) {
            throw new Exception("Error: Original content changed!");
        }
        this.dumpContent(dataHandler);
    }

    public void test_S1_O(Session session, Multipart multipart, byte[] byArray, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("1. Creating signed message and send it to MLA...");
        Message message = this.createMessage(session, this.senderAddress_, this.mlaAddress_);
        message.setSubject("RFC2634, 4.2.1, 1) S1(Original Content)");
        SignedContent signedContent = this.create_S1_O(multipart, multipart.getContentType(), bl, this.signerCertificatesOfS1_, this.signerPrivateKeyOfS1_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, null);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        message.saveChanges();
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("2. MLA: Processing message...");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        signedContent = this.processMessageForMLA(message, bl, "S1_O");
        System.out.println("MLA: Sending signed message to new recipient.");
        message = this.createMessage(session, this.mlaAddress_, this.recipientAddress_);
        message.setSubject("RFC2634, 4.2.1, 1) MLA(S1(Original Content)");
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("3. Final recipient: Parsing message received from MLA...");
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        Object object = message.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: received message is not signed!");
        }
        System.out.println("First layer of message is signed. Verifying signature.");
        DataHandler dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfMLA_[0]);
        System.out.println("Reading MLExpansionHistory attribute.");
        MLADemo.readMLExpansionHistory((SignedContent)object, 1);
        object = dataHandler.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: second layer of received message is not signed!");
        }
        System.out.println("Second layer of message is signed. Verifying signature.");
        dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfS1_[0]);
        if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])this.a(dataHandler))) {
            throw new Exception("Error: Original content changed!");
        }
        this.dumpContent(dataHandler);
    }

    public void test_E1_S1_O(Session session, Multipart multipart, byte[] byArray, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("1. Creating signed and encrypted message and send it to MLA...");
        Message message = this.createMessage(session, this.senderAddress_, this.mlaAddress_);
        message.setSubject("RFC2634, 4.2.1, 3) E1(S1(Original Content))");
        EncryptedContent encryptedContent = this.create_E1_S1_O(multipart, multipart.getContentType(), bl, this.signerCertificatesOfS1_, this.signerPrivateKeyOfS1_, AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, null, this.encryptionCertificatesOfMLA_[0], AlgorithmID.rsaEncryption, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone(), 192);
        message.setContent((Object)encryptedContent, encryptedContent.getContentType());
        encryptedContent.setHeaders((Part)message);
        message.saveChanges();
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("2. MLA: Processing message...");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        SignedContent signedContent = this.processMessageForMLA(message, bl, "E1_S1_O");
        System.out.println("MLA: Sending signed message to new recipient.");
        message = this.createMessage(session, this.mlaAddress_, this.recipientAddress_);
        message.setSubject("RFC2634, 4.2.1, 3) MLA(E1(S1(Original Content)))");
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        byteArrayOutputStream.reset();
        message.writeTo((OutputStream)byteArrayOutputStream);
        System.out.println("3. Final recipient: Parsing message received from MLA...");
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        message = new MimeMessage(null, (InputStream)byteArrayInputStream);
        Object object = message.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: received message is not signed!");
        }
        System.out.println("First layer of message is signed. Verifying signature.");
        DataHandler dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfMLA_[0]);
        System.out.println("Reading MLExpansionHistory attribute.");
        MLADemo.readMLExpansionHistory((SignedContent)object, 1);
        object = dataHandler.getContent();
        if (!(object instanceof EncryptedContent)) {
            throw new ESSException("Error: second layer of received message is not encrypted!");
        }
        System.out.println("Second layer of message is encrypted. Trying to decrypt.");
        dataHandler = this.decrypt((EncryptedContent)object, this.recipientPrivateKey_, this.recipientCertificates_[0]);
        object = dataHandler.getContent();
        if (!(object instanceof SignedContent)) {
            throw new ESSException("Error: second layer of received message is not signed!");
        }
        System.out.println("Third layer of message is signed. Verifying signature.");
        dataHandler = this.verify((SignedContent)object, this.signerCertificatesOfS1_[0]);
        if (!CryptoUtils.equalsBlock((byte[])byArray, (byte[])this.a(dataHandler))) {
            throw new Exception("Error: Original content changed!");
        }
        this.dumpContent(dataHandler);
    }

    public void start() {
        try {
            Session session = DemoUtil.getSession();
            SMimeBodyPart sMimeBodyPart = new SMimeBodyPart();
            sMimeBodyPart.setText("This is a test of the IAIK-CMS S/MIME ESS MLA implementation.\n");
            SMimeBodyPart sMimeBodyPart2 = new SMimeBodyPart();
            sMimeBodyPart2.setDataHandler(new DataHandler((DataSource)new FileDataSource("test.html")));
            sMimeBodyPart2.setFileName("test.html");
            SMimeMultipart sMimeMultipart = new SMimeMultipart();
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart);
            sMimeMultipart.addBodyPart((BodyPart)sMimeBodyPart2);
            boolean bl = true;
            System.out.println("Implicit demos");
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setContent((Multipart)sMimeMultipart);
            mimeMessage.saveChanges();
            byte[] byArray = this.a(mimeMessage.getDataHandler());
            System.out.println("Testing sample 4.2.1,1) from RFC 2634: S1(O) ==> S2(S1(O))");
            this.test_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,2) from RFC 2634: S3(S2(S1(O))) ==> S4(S3(S2(S1(O))))");
            this.test_S3_S2_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,3) from RFC 2634: E1(S1(O)) ==> S2(E1(S1(O)))");
            this.test_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,4) from RFC 2634: S2(E1(S1(O))) ==> S3(E1(S1(O)))");
            this.test_S2_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,5) from RFC 2634: S3(S2(E1(S1(O)))) ==> S4(E1(S1(O)))");
            this.test_S3_S2_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl, false);
            System.out.println("Testing sample 4.2.1,6) from RFC 2634: S3(S2(E1(S1(O)))) ==> S4(E1(S1(O)))");
            this.test_S3_S2_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl, true);
            bl = false;
            System.out.println("Explicit demos");
            System.out.println("Testing sample 4.2.1,1) from RFC 2634: S1(O) ==> S2(S1(O))");
            this.test_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,2) from RFC 2634: S3(S2(S1(O))) ==> S4(S3(S2(S1(O))))");
            this.test_S3_S2_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,3) from RFC 2634: E1(S1(O)) ==> S2(E1(S1(O)))");
            this.test_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,4) from RFC 2634: S2(E1(S1(O))) ==> S3(E1(S1(O)))");
            this.test_S2_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl);
            System.out.println("Testing sample 4.2.1,5) from RFC 2634: S3(S2(E1(S1(O)))) ==> S4(E1(S1(O)))");
            this.test_S3_S2_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl, false);
            System.out.println("Testing sample 4.2.1,6) from RFC 2634: S3(S2(E1(S1(O)))) ==> S4(E1(S1(O)))");
            this.test_S3_S2_E1_S1_O(session, (Multipart)sMimeMultipart, byArray, bl, true);
            System.out.println("Ready!");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void readMLExpansionHistory(SignedContent signedContent, int n) throws Exception {
        SignerInfo signerInfo = signedContent.getSignerInfos()[0];
        MLExpansionHistory mLExpansionHistory = (MLExpansionHistory)signerInfo.getSignedAttributeValue(MLExpansionHistory.oid);
        if (mLExpansionHistory == null) {
            throw new Exception("Missing MLExpansionHistory attribute");
        }
        int n2 = mLExpansionHistory.countMLDataEntries();
        if (n != n2) {
            throw new Exception("Invalid number (" + n2 + ") of MLData entries. Expected " + n);
        }
        System.out.println(mLExpansionHistory.toString(true));
    }

    public SignedContent processMessageForMLA(Message message, boolean bl, String string) throws ESSException, ESSLayerException {
        ESSLayers eSSLayers = this.mla_.resolve((Part)message, string);
        try {
            return this.mla_.createSignedContent(this.signerPrivateKeyOfMLA_, new Date(), this.signerCertificatesOfMLA_[0], this.signerCertificatesOfMLA_, AlgorithmID.sha1, AlgorithmID.rsaEncryption, this.encryptionCertificatesOfMLA_[0], true, bl, eSSLayers);
        }
        catch (Exception exception) {
            throw new ESSException("Error signing content: " + exception.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            DemoUtil.initSMimeDemos();
            new MLADemo().start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Util.waitKey();
        System.exit(0);
    }

    private byte[] a(DataHandler dataHandler) throws IOException {
        DataSource dataSource = dataHandler.getDataSource();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utils.copyStream((InputStream)dataSource.getInputStream(), (OutputStream)byteArrayOutputStream, null);
        return byteArrayOutputStream.toByteArray();
    }

    private static void a(Message message) throws IOException {
        System.out.println("******************************************************************");
        System.out.println("Message dump: \n");
        try {
            message.writeTo((OutputStream)System.out);
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
        System.out.println("\n******************************************************************");
    }

    public void dumpContent(DataHandler dataHandler) throws MessagingException, IOException {
        Multipart multipart = (Multipart)dataHandler.getContent();
        System.out.println("Content is multipart (" + multipart.getContentType() + ").");
        BodyPart bodyPart = multipart.getBodyPart(0);
        System.out.println("Content of first bodypart  (" + bodyPart.getContentType() + "):");
        System.out.println(bodyPart.getContent());
        BodyPart bodyPart2 = multipart.getBodyPart(1);
        System.out.println("Content of second bodypart  (" + bodyPart2.getContentType() + "):");
        System.out.println(bodyPart2.getContent());
    }

    public DataHandler decrypt(EncryptedContent encryptedContent, PrivateKey privateKey, X509Certificate x509Certificate) throws SMimeException {
        try {
            encryptedContent.decryptSymmetricKey((Key)privateKey, x509Certificate);
            return encryptedContent.getDataHandler();
        }
        catch (Exception exception) {
            throw new SMimeException(exception.toString());
        }
    }

    public SignedContent create_S3_S2_S1_O(Object object, String string, boolean bl, X509Certificate[] x509CertificateArray, PrivateKey privateKey, AlgorithmID algorithmID, AlgorithmID algorithmID2, MLExpansionHistory mLExpansionHistory, boolean bl2, X509Certificate[] x509CertificateArray2, PrivateKey privateKey2, AlgorithmID algorithmID3, AlgorithmID algorithmID4, MLExpansionHistory mLExpansionHistory2, boolean bl3, X509Certificate[] x509CertificateArray3, PrivateKey privateKey3, AlgorithmID algorithmID5, AlgorithmID algorithmID6, MLExpansionHistory mLExpansionHistory3) throws MessagingException {
        SignedContent signedContent = this.create_S1_O(object, string, bl, x509CertificateArray, privateKey, algorithmID, algorithmID2, mLExpansionHistory);
        SignedContent signedContent2 = this.createSignedContent(signedContent, signedContent.getContentType(), bl2, x509CertificateArray2, privateKey2, algorithmID3, algorithmID4, mLExpansionHistory2);
        return this.createSignedContent(signedContent2, signedContent2.getContentType(), bl3, x509CertificateArray3, privateKey3, algorithmID5, algorithmID6, mLExpansionHistory3);
    }

    public SignedContent create_S3_S2_E1_S1_0(Object object, String string, boolean bl, X509Certificate[] x509CertificateArray, PrivateKey privateKey, AlgorithmID algorithmID, AlgorithmID algorithmID2, MLExpansionHistory mLExpansionHistory, X509Certificate x509Certificate, AlgorithmID algorithmID3, AlgorithmID algorithmID4, int n, boolean bl2, X509Certificate[] x509CertificateArray2, PrivateKey privateKey2, AlgorithmID algorithmID5, AlgorithmID algorithmID6, MLExpansionHistory mLExpansionHistory2, boolean bl3, X509Certificate[] x509CertificateArray3, PrivateKey privateKey3, AlgorithmID algorithmID7, AlgorithmID algorithmID8, MLExpansionHistory mLExpansionHistory3) throws MessagingException {
        SignedContent signedContent = this.create_S2_E1_S1_0(object, string, bl, x509CertificateArray, privateKey, algorithmID, algorithmID2, mLExpansionHistory, x509Certificate, algorithmID3, algorithmID4, n, bl2, x509CertificateArray2, privateKey2, algorithmID5, algorithmID6, mLExpansionHistory2);
        return this.createSignedContent(signedContent, signedContent.getContentType(), bl3, x509CertificateArray3, privateKey3, algorithmID7, algorithmID8, mLExpansionHistory3);
    }

    public SignedContent create_S2_E1_S1_0(Object object, String string, boolean bl, X509Certificate[] x509CertificateArray, PrivateKey privateKey, AlgorithmID algorithmID, AlgorithmID algorithmID2, MLExpansionHistory mLExpansionHistory, X509Certificate x509Certificate, AlgorithmID algorithmID3, AlgorithmID algorithmID4, int n, boolean bl2, X509Certificate[] x509CertificateArray2, PrivateKey privateKey2, AlgorithmID algorithmID5, AlgorithmID algorithmID6, MLExpansionHistory mLExpansionHistory2) throws MessagingException {
        EncryptedContent encryptedContent = this.create_E1_S1_O(object, string, bl, x509CertificateArray, privateKey, algorithmID, algorithmID2, mLExpansionHistory, x509Certificate, algorithmID3, algorithmID4, n);
        return this.createSignedContent(encryptedContent, encryptedContent.getContentType(), bl2, x509CertificateArray2, privateKey2, algorithmID5, algorithmID6, mLExpansionHistory2);
    }

    public SignedContent create_S1_O(Object object, String string, boolean bl, X509Certificate[] x509CertificateArray, PrivateKey privateKey, AlgorithmID algorithmID, AlgorithmID algorithmID2, MLExpansionHistory mLExpansionHistory) throws MessagingException {
        return this.createSignedContent(object, string, bl, x509CertificateArray, privateKey, algorithmID, algorithmID2, mLExpansionHistory);
    }

    public EncryptedContent create_E1_S1_O(Object object, String string, boolean bl, X509Certificate[] x509CertificateArray, PrivateKey privateKey, AlgorithmID algorithmID, AlgorithmID algorithmID2, MLExpansionHistory mLExpansionHistory, X509Certificate x509Certificate, AlgorithmID algorithmID3, AlgorithmID algorithmID4, int n) throws MessagingException {
        SignedContent signedContent = this.create_S1_O(object, string, bl, x509CertificateArray, privateKey, algorithmID, algorithmID2, mLExpansionHistory);
        return this.createEncryptedContent(signedContent, signedContent.getContentType(), x509Certificate, algorithmID3, algorithmID4, n);
    }

    public SignedContent createSignedContent(Object object, String string, boolean bl, X509Certificate[] x509CertificateArray, PrivateKey privateKey, AlgorithmID algorithmID, AlgorithmID algorithmID2, MLExpansionHistory mLExpansionHistory) throws MessagingException {
        SignedContent signedContent = new SignedContent(bl);
        signedContent.setContent(object, string);
        signedContent.setCertificates((Certificate[])x509CertificateArray);
        try {
            Attributes attributes = SMimeUtil.makeStandardAttributes();
            if (mLExpansionHistory != null) {
                attributes.addAttribute(new Attribute((AttributeValue)mLExpansionHistory));
            }
            signedContent.addSigner(privateKey, x509CertificateArray[0], algorithmID, algorithmID2, attributes.toArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
        }
        catch (CodingException codingException) {
            throw new MessagingException("Error in attribute encoding: " + codingException.getMessage());
        }
        catch (SMimeException sMimeException) {
            throw new MessagingException("Error adding attributes: " + sMimeException.toString());
        }
        return signedContent;
    }

    public Message createMessage(Session session, String string, String string2) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(string));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string2, (boolean)false));
        mimeMessage.setSentDate(new Date());
        return mimeMessage;
    }

    public static MLExpansionHistory createMLExpansionHistory(X509Certificate x509Certificate, Date date, MLReceiptPolicy mLReceiptPolicy) {
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
        MLData mLData = new MLData(new EntityIdentifier((CertificateIdentifier)issuerAndSerialNumber), date);
        mLData.setMLReceiptPolicy(mLReceiptPolicy);
        return new MLExpansionHistory(mLData);
    }

    public EncryptedContent createEncryptedContent(Object object, String string, X509Certificate x509Certificate, AlgorithmID algorithmID, AlgorithmID algorithmID2, int n) throws MessagingException {
        EncryptedContent encryptedContent = new EncryptedContent();
        encryptedContent.setContent(object, string);
        encryptedContent.addRecipient(x509Certificate, algorithmID);
        try {
            encryptedContent.setEncryptionAlgorithm(algorithmID2, n);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MessagingException("Content encryption algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
        return encryptedContent;
    }

    public MLADemo() {
        this.mlaAddress_ = "\"" + this.mlaName_ + "\" <smimetest@iaik.at>";
        this.recipientAddress_ = "\"" + this.recipientName_ + "\" <smimetest@iaik.at>";
        System.out.println();
        System.out.println("******************************************************************************************");
        System.out.println("*                                      MLADemo                                           *");
        System.out.println("*    (shows the usage of the IAIK-CMS MLA utility for running an ESS mail list agent)    *");
        System.out.println("******************************************************************************************");
        System.out.println();
        try {
            this.keyStoreDatabase_ = new KeyStoreDatabase();
            this.signerCertificatesOfS1_ = CMSKeyStore.getCertificateChain(1, 0);
            this.signerPrivateKeyOfS1_ = CMSKeyStore.getPrivateKey(1, 0);
            this.signerCertificatesOfS2_ = CMSKeyStore.getCertificateChain(1, 1);
            this.signerPrivateKeyOfS2_ = CMSKeyStore.getPrivateKey(1, 1);
            this.signerCertificatesOfS3_ = CMSKeyStore.getCertificateChain(0, 0);
            this.signerPrivateKeyOfS3_ = CMSKeyStore.getPrivateKey(0, 0);
            this.signerCertificatesOfMLA_ = CMSKeyStore.getCertificateChain(0, 1);
            this.signerPrivateKeyOfMLA_ = CMSKeyStore.getPrivateKey(0, 1);
            this.encryptionCertificatesOfMLA_ = CMSKeyStore.getCertificateChain(0, 4);
            this.encryptionPrivateKeyOfMLA_ = CMSKeyStore.getPrivateKey(0, 4);
            this.encryptionCertificatesOfE1_ = CMSKeyStore.getCertificateChain(0, 3);
            this.encryptionPrivateKeyOfE1_ = CMSKeyStore.getPrivateKey(0, 3);
            this.recipientCertificates_ = CMSKeyStore.getCertificateChain(0, 5);
            this.recipientPrivateKey_ = CMSKeyStore.getPrivateKey(0, 5);
            this.keyStoreDatabase_.addKey((Key)this.signerPrivateKeyOfMLA_, (Certificate[])this.signerCertificatesOfMLA_, "RSA_SIGN.1024");
            this.keyStoreDatabase_.addKey((Key)this.encryptionPrivateKeyOfMLA_, (Certificate[])this.encryptionCertificatesOfMLA_, "RSA_CRYPT.1024");
            this.mlaID_ = new EntityIdentifier((CertificateIdentifier)new IssuerAndSerialNumber(this.signerCertificatesOfMLA_[0]));
            this.mla_ = new MLA(this.mlaID_);
            this.mla_.setDebugStream("MLA", (OutputStream)System.out);
            this.mla_.setEncryptionInfo(null, new RecipientInfo[]{new KeyTransRecipientInfo(this.recipientCertificates_[0], AlgorithmID.rsaEncryption)}, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone(), 192);
            this.mla_.setDebugStream("MLA", (OutputStream)System.out);
            this.mla_.setKeyDatabase((KeyDatabase)this.keyStoreDatabase_);
            this.mla_.setStopOnInvalidSignature(true);
            System.out.println("MLA signing cert is: " + this.signerCertificatesOfMLA_[0].getSubjectDN());
            System.out.println("MLA entity identifier is:\n" + this.mlaID_ + "\n");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }
}

