/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;

public abstract class StatementPermission {
    StatementPermission() {
    }

    public abstract void check(LanguageConnectionContext var1, String var2, boolean var3, Activation var4) throws StandardException;

    public abstract PermissionsDescriptor getPermissionDescriptor(String var1, DataDictionary var2) throws StandardException;

    public boolean isCorrectPermission(PermissionsDescriptor permissionsDescriptor) throws StandardException {
        return false;
    }

    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dataDictionary) throws StandardException {
        return null;
    }

    public String getObjectType() {
        return null;
    }

    public void genericCheck(LanguageConnectionContext languageConnectionContext, String string, boolean bl, Activation activation, String string2) throws StandardException {
        TupleDescriptor tupleDescriptor;
        Object object;
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        PermissionsDescriptor permissionsDescriptor = this.getPermissionDescriptor(string, dataDictionary);
        if (!this.isCorrectPermission(permissionsDescriptor)) {
            permissionsDescriptor = this.getPermissionDescriptor("PUBLIC", dataDictionary);
        }
        if (this.isCorrectPermission(permissionsDescriptor)) {
            return;
        }
        boolean bl2 = false;
        String string3 = languageConnectionContext.getCurrentRoleId(activation);
        if (string3 != null) {
            Object object2;
            Object object3;
            object = dataDictionary.getAuthorizationDatabaseOwner();
            tupleDescriptor = dataDictionary.getRoleGrantDescriptor(string3, string, (String)object);
            if (tupleDescriptor == null) {
                tupleDescriptor = dataDictionary.getRoleGrantDescriptor(string3, "PUBLIC", (String)object);
            }
            if (tupleDescriptor == null) {
                languageConnectionContext.setCurrentRole(activation, null);
            } else {
                object3 = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string3, true);
                while (!bl2 && (object2 = object3.next()) != null) {
                    permissionsDescriptor = this.getPermissionDescriptor((String)object2, dataDictionary);
                    if (!this.isCorrectPermission(permissionsDescriptor)) continue;
                    bl2 = true;
                }
            }
            if (bl2) {
                object3 = dataDictionary.getDependencyManager();
                object2 = dataDictionary.getRoleDefinitionDescriptor(string3);
                ContextManager contextManager = languageConnectionContext.getContextManager();
                object3.addDependency(execPreparedStatement, (Provider)object2, contextManager);
                object3.addDependency(activation, (Provider)object2, contextManager);
            }
        }
        if (!bl2) {
            object = this.getPrivilegedObject(dataDictionary);
            if (object == null) {
                throw StandardException.newException("4250E", this.getObjectType());
            }
            tupleDescriptor = object.getSchemaDescriptor();
            if (tupleDescriptor == null) {
                throw StandardException.newException("4250E", "SCHEMA");
            }
            throw StandardException.newException(bl ? "42505" : "42504", string, (Object)string2, (Object)this.getObjectType(), (Object)((SchemaDescriptor)tupleDescriptor).getSchemaName(), (Object)object.getName());
        }
    }
}

