/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Demo;
import iaik.security.ecc.ECCException;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.math.ecgroup.CoordinateTypes;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.security.ecc.util.Utils;
import java.util.Enumeration;

public class ParameterTest
implements Demo {
    public void testAll() throws ECCException {
        ECCParameterFactory eCCParameterFactory = ECCParameterFactory.getInstance();
        Enumeration enumeration = eCCParameterFactory.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("--------------------------------------------------------");
            System.out.println("Checking domain parameter : " + string);
            ECCParameterSpec eCCParameterSpec = eCCParameterFactory.getParameterByName(string);
            System.out.print("Is base point indeed on curve ? ...");
            ECDSAParameter eCDSAParameter = new ECDSAParameter(eCCParameterSpec);
            if (!Utils.isOnCurve(eCDSAParameter.getG())) {
                System.out.println("FAILED !!");
                System.out.println("Check domain parameters, exiting ... ");
                throw new RuntimeException("Parameter test failed");
            }
            System.out.println(" OK");
            System.out.print("Checking G * order = infinity   ...");
            if (Utils.orderCheck(eCDSAParameter.getG(), eCDSAParameter.getR())) {
                System.out.println(" OK");
                System.out.println();
                continue;
            }
            System.out.println("FAILED !!");
            System.out.println("Check domain parameters, exiting ... ");
            throw new RuntimeException("Parameter test failed");
        }
    }

    public boolean runDemo() {
        try {
            System.out.println("Using projective coordinates");
            CoordinateTypes.setDefaultCoordinates(1, 1);
            CoordinateTypes.setDefaultCoordinates(2, 1);
            this.testAll();
            System.out.println("Using affine coordinates");
            CoordinateTypes.setDefaultCoordinates(1, 0);
            CoordinateTypes.setDefaultCoordinates(2, 0);
            this.testAll();
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        ParameterTest parameterTest = new ParameterTest();
        parameterTest.runDemo();
        if (parameterTest.runDemo()) {
            System.out.println("FINISHED");
        } else {
            System.out.println("FAILED");
        }
    }
}

