/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.DialogTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class DeleteFilesDialog
extends JDialog {
    private JCheckBox traceCheckBox;
    private JCheckBox applicationCheckBox;
    private JCheckBox installedAppsCheckBox;

    public DeleteFilesDialog(Dialog dialog) {
        super(dialog, true);
        this.setTitle(this.getMessage("delete.files.dlg.title"));
        this.initComponents();
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel jLabel = new JLabel(this.getMessage("delete.files.dlg.temp_files"));
        jLabel.setIcon(ResourceManager.getIcon("warning32.image"));
        jLabel.setIconTextGap(12);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 68, 24, 12));
        this.applicationCheckBox = new JCheckBox(this.getMessage("delete.files.dlg.applications"));
        this.installedAppsCheckBox = new JCheckBox(this.getMessage("delete.files.dlg.installedapps"));
        boolean bl = Config.getBooleanProperty("deployment.cache.enabled");
        this.applicationCheckBox.setSelected(bl);
        this.applicationCheckBox.setEnabled(bl);
        this.installedAppsCheckBox.setSelected(false);
        this.installedAppsCheckBox.setEnabled(bl);
        String string = "";
        string = bl ? this.getMessage("delete.files.dlg.applications.tooltip.enabled") : this.getMessage("delete.files.dlg.applications.tooltip.disabled");
        this.applicationCheckBox.setToolTipText(string);
        string = "";
        string = bl ? this.getMessage("delete.files.dlg.installedapps.tooltip.enabled") : this.getMessage("delete.files.dlg.installedapps.tooltip.disabled");
        this.installedAppsCheckBox.setToolTipText(string);
        this.traceCheckBox = new JCheckBox(this.getMessage("delete.files.dlg.trace"));
        this.traceCheckBox.setSelected(true);
        this.traceCheckBox.setToolTipText(this.getMessage("delete.files.dlg.trace.tooltip"));
        jPanel2.add(this.traceCheckBox);
        jPanel2.add(this.applicationCheckBox);
        jPanel2.add(this.installedAppsCheckBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(4));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        JButton jButton = new JButton(this.getMessage("common.ok_btn"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteFilesDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        JButton jButton2 = new JButton(this.getMessage("common.cancel_btn"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteFilesDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        jButton2.addActionListener(abstractAction);
        jPanel3.add(jButton);
        jPanel3.add(Box.createHorizontalStrut(6));
        jPanel3.add(jButton2);
        jPanel3.add(Box.createHorizontalStrut(12));
        JButton[] jButtonArray = new JButton[]{jButton, jButton2};
        DialogTemplate.resizeButtons(jButtonArray);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        this.getRootPane().setDefaultButton(jButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        this.setResizable(false);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (this.installedAppsCheckBox.isSelected()) {
            try {
                serializable = new ArrayList<String>();
                ((ArrayList)serializable).add(Environment.getJavawsCommand());
                ((ArrayList)serializable).add("-uninstall");
                ProcessBuilder processBuilder = new ProcessBuilder((List<String>)((Object)serializable));
                Process process = processBuilder.start();
                Trace.println("launching javaws -uninstall", TraceLevel.BASIC);
                process.waitFor();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.applicationCheckBox.isSelected()) {
            try {
                serializable = new ArrayList();
                ((ArrayList)serializable).add(Environment.getJavawsCommand());
                ((ArrayList)serializable).add("-clearcache");
                Trace.println("launching javaws -clearcache", TraceLevel.BASIC);
                ProcessBuilder processBuilder = new ProcessBuilder((List<String>)((Object)serializable));
                Process process = processBuilder.start();
                process.waitFor();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.traceCheckBox.isSelected()) {
            serializable = new File(Config.getLogDirectory());
            this.deleteFiles((File)serializable);
        }
        if (this.applicationCheckBox.isSelected() || this.traceCheckBox.isSelected()) {
            serializable = new File(Config.getUserExtensionDirectory());
            this.deleteFiles((File)serializable);
            serializable = new File(Config.getTempCacheDir());
            this.deleteFiles((File)serializable);
            CredentialManager.removePersistantCredentials();
        }
        this.setVisible(false);
    }

    private void deleteFiles(File file) {
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteFiles(fileArray[i]);
                }
                fileArray[i].delete();
            }
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

