/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.workspace.util.internal;

import it.sogei.rcp.jobs.boundary.IJobCommand;
import it.sogei.rcp.util.UserUtil;
import it.sogei.utilities.log4j.LogUtil;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ImportWsJobCommand
implements IJobCommand {
    private String sourceDir;
    private IStatus status;

    public ImportWsJobCommand(String sourceDir) {
        this.setSourceDir(sourceDir);
        this.status = new Status(1, this.getName(), "Inizio importazione...");
    }

    public IStatus execute(IProgressMonitor arg0) {
        String targetDir = UserUtil.getUserWorkspace();
        LogUtil.log((String)this.getName(), (int)2, (String)("Inizio copia da " + this.sourceDir + " a " + targetDir));
        try {
            this.folderCopy(this.sourceDir, targetDir);
        }
        catch (Exception e) {
            LogUtil.log((String)this.getName(), (int)4, (String)("Errore durante la copia del Workspace: " + e.getMessage()));
            e.printStackTrace();
            this.status = new Status(4, this.getName(), "Si \u00c3\u00a8 verificato un errore ndurante la copia del workspace");
            return this.status;
        }
        arg0.done();
        this.status = new Status(0, this.getName(), "Il workspace \u00c3\u00a8 stato copiato correttamente");
        return this.status;
    }

    public String getName() {
        return "Importa workspce";
    }

    public void setSourceDir(String text) {
        this.sourceDir = text;
    }

    public IStatus getJobState() {
        return this.status;
    }

    private void folderCopy(String sourceIn, String targetIn) throws Exception {
        final Path sourceDir = Paths.get(sourceIn, new String[0]);
        final Path targetDir = Paths.get(targetIn, new String[0]);
        try {
            Files.walkFileTree(sourceDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path target = targetDir.resolve(sourceDir.relativize(dir));
                    try {
                        Files.copy(dir, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (!Files.isDirectory(target, new LinkOption[0])) {
                            throw e;
                        }
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        LogUtil.log((String)"Copia Util", (int)2, (String)("La directory " + target + " gia esiste"));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    LogUtil.log((String)"Copia Util", (int)2, (String)("Copia file " + file));
                    if (!file.getParent().endsWith("logs")) {
                        Path target = targetDir.resolve(sourceDir.relativize(file));
                        Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        LogUtil.log((String)"Copia Util", (int)2, (String)(file + "copiato correttamente"));
                    } else {
                        LogUtil.log((String)"Copia Util", (int)2, (String)"il file si trova nella cartella log - non copiato");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

